/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.restv2.ARestV2Connection;
import com.jaspersoft.studio.server.protocol.restv2.JacksonHelper;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.eclipse.core.runtime.IProgressMonitor;

public class RESTv2ExceptionHandler {
    private IConnection c;
    private Map<String, String> map;

    public RESTv2ExceptionHandler(IConnection c) {
        this.c = c;
    }

    private Map<String, String> getMap(IProgressMonitor monitor) {
        if (this.map == null) {
            this.map = new HashMap<String, String>();
            if (this.c instanceof ARestV2Connection) {
                try {
                    ((ARestV2Connection)this.c).getBundle(this.map, "jasperserver_messages", monitor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.map;
    }

    /*
     * Unable to fully structure code
     */
    public void handleException(Response res, IProgressMonitor monitor) throws ClientProtocolException {
        status = res.getStatus();
        ct = res.getHeaderString("Content-Type");
        switch (status) {
            case 200: {
                return;
            }
            case 400: {
                if (ct == null) ** GOTO lbl21
                if (!ct.equals("application/xml")) ** GOTO lbl11
                this.handleErrorDescriptor(res, monitor, status);
                ** GOTO lbl21
lbl11:
                // 1 sources

                if (!ct.equals("application/json")) ** GOTO lbl14
                this.handleErrorDescriptor(res, monitor, status);
                ** GOTO lbl21
lbl14:
                // 1 sources

                if (!ct.contains("application/collection.errorDescriptor+xml") && !ct.contains("application/collection.errorDescriptor+json")) ** GOTO lbl17
                this.handleErrorDescriptorList(res, monitor, status);
                ** GOTO lbl21
lbl17:
                // 1 sources

                if (ct.contains("application/errorDescriptor+json") || ct.contains("application/errorDescriptor+xml")) {
                    this.handleErrorDescriptor(res, monitor, status);
                } else {
                    this.handleErrorDescriptor(res, monitor, status);
                }
            }
lbl21:
            // 7 sources

            case 401: {
                if (ct != null && ct.startsWith("application/json")) {
                    this.handleErrorDescriptor(res, monitor, status);
                } else {
                    throw new HttpResponseException(status, this.handle401Errors(res));
                }
            }
            case 403: 
            case 404: 
            case 409: 
            case 500: {
                if (ct != null) {
                    if (ct.contains("application/collection.errorDescriptor+xml") || ct.contains("application/collection.errorDescriptor+json")) {
                        this.handleErrorDescriptorList(res, monitor, status);
                        break;
                    }
                    if (ct.contains("xml")) {
                        this.handleErrorDescriptor(res, monitor, status);
                        break;
                    }
                    if (ct.contains("text/html")) {
                        throw new HttpResponseException(status, this.buildErrorMessage(res, status));
                    }
                    if (!ct.contains("application/errorDescriptor+json") && !ct.contains("application/errorDescriptor+xml")) break;
                    this.handleErrorDescriptor(res, monitor, status);
                    break;
                }
                throw new HttpResponseException(status, this.buildErrorMessage(res, status));
            }
        }
        cnt = (String)res.readEntity(String.class);
        if (cnt.length() > 100) {
            cnt = "";
        }
        throw new HttpResponseException(status, String.valueOf(this.buildErrorMessage(res, status)) + cnt);
    }

    private String handle401Errors(Response res) {
        String output = (String)res.readEntity(String.class);
        return output;
    }

    private String buildErrorMessage(Response res, int status) {
        String msg = "" + status;
        String rp = res.getStatusInfo().getReasonPhrase();
        if (!Misc.isNullOrEmpty((String)rp)) {
            msg = String.valueOf(msg) + " Message: " + rp + "\n";
        }
        return msg;
    }

    protected void handleErrorDescriptorList(Response res, IProgressMonitor monitor, int status) throws HttpResponseException {
        List list = (List)res.readEntity((GenericType)new GenericType<List<ErrorDescriptor>>(){});
        if (list != null) {
            String msg = "";
            for (ErrorDescriptor ed : list) {
                msg = String.valueOf(this.buildMessage(monitor, msg, ed)) + "\n";
            }
            throw new HttpResponseException(status, msg);
        }
    }

    protected void handleErrorDescriptor(Response res, IProgressMonitor monitor, int status) throws HttpResponseException {
        String ct = res.getHeaderString("Content-Type");
        res.bufferEntity();
        String sent = (String)res.readEntity(String.class);
        try {
            ErrorDescriptor ed = ct.contains("xml") ? (ErrorDescriptor)JacksonHelper.getXMLMapper().readValue(sent, ErrorDescriptor.class) : (ErrorDescriptor)JacksonHelper.getJSONMapper().readValue(sent, ErrorDescriptor.class);
            String msg = ed.getErrorCode() != null ? String.valueOf(ed.getErrorCode()) + "\n" : "";
            msg = String.valueOf(msg) + this.buildMessage(monitor, "", ed);
            if (ed.getErrorCode() != null && !ed.getErrorCode().contains("{0}") && ed.getParameters() != null) {
                String[] stringArray = ed.getParameters();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    msg = String.valueOf(msg) + "\n" + str;
                    ++n2;
                }
            }
            throw new HttpResponseException(status, msg);
        }
        catch (Throwable e) {
            if (e instanceof HttpResponseException) {
                throw (HttpResponseException)e;
            }
            if (status != 400) {
                throw new RuntimeException(e);
            }
            this.handleErrorDescriptorList(res, monitor, status);
            return;
        }
    }

    public String buildMessage(IProgressMonitor monitor, String msg, ErrorDescriptor ed) {
        if (!msg.isEmpty()) {
            msg = String.valueOf(msg) + "\n";
        }
        if (ed != null) {
            String m;
            msg = ed.getMessage() != null ? (ed.getParameters() != null ? String.valueOf(msg) + MessageFormat.format(ed.getMessage(), ed.getParameters()) : String.valueOf(msg) + ed.getMessage()) : (Misc.isNullOrEmpty((String)(m = this.getMap(monitor).get(ed.getErrorCode()))) ? String.valueOf(msg) + ed.getErrorCode() : String.valueOf(msg) + MessageFormat.format(m, ed.getParameters()));
        }
        return msg;
    }
}

