/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.ReportInputControl;
import com.jaspersoft.jasperserver.dto.resources.AbstractClientJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.AbstractClientReportUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientAdhocDataView;
import com.jaspersoft.jasperserver.dto.resources.ClientAwsDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientBeanDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientCustomDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientDataType;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientJndiJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientListOfValuesItem;
import com.jaspersoft.jasperserver.dto.resources.ClientMondrianConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientMondrianXmlaDefinition;
import com.jaspersoft.jasperserver.dto.resources.ClientOlapUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.resources.ClientQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceable;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableFile;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.jasperserver.dto.resources.ClientSecureMondrianConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientSubDataSourceReference;
import com.jaspersoft.jasperserver.dto.resources.ClientVirtualDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientXmlaConnection;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.model.datasource.filter.DatasourcesAllFilter;
import com.jaspersoft.studio.server.protocol.restv2.ARestV2Connection;
import com.jaspersoft.studio.server.protocol.restv2.DiffFields;
import com.jaspersoft.studio.server.protocol.restv2.WsTypes;
import com.jaspersoft.studio.server.utils.RDUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.sf.jasperreports.eclipse.util.Misc;

public class Rest2Soap {
    public static ResourceDescriptor getRDLookup(ARestV2Connection rc, ClientResourceLookup cr) throws ParseException {
        ResourceDescriptor rd = Rest2Soap.getRD(rc, cr);
        return rd;
    }

    public static ResourceDescriptor getRD(ARestV2Connection rc, ClientResource<?> cr) throws ParseException {
        ResourceDescriptor rd = new ResourceDescriptor();
        Rest2Soap.getRD(rc, cr, rd);
        return rd;
    }

    public static ResourceDescriptor getRDContainer(ARestV2Connection rc, ClientResource<?> cr) throws ParseException {
        ResourceDescriptor rd = new ResourceDescriptor();
        Rest2Soap.getRD(rc, cr, rd);
        if (!RDUtil.getParentFolder(cr.getUri()).endsWith("_files")) {
            rd.setIsReference(true);
            rd.setReferenceUri(cr.getUri());
        }
        return rd;
    }

    public static ResourceDescriptor getDataSource(ARestV2Connection rc, ClientReferenceableDataSource crds) throws ParseException {
        if (crds instanceof ClientReference) {
            ResourceDescriptor rd = new ResourceDescriptor();
            rd.setReferenceUri(crds.getUri());
            rd.setIsReference(true);
            rd.setWsType("reference");
            return rd;
        }
        return Rest2Soap.getRDContainer(rc, (ClientResource)crds);
    }

    public static ResourceDescriptor getReferenceable(ClientReferenceable crds) {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setReferenceUri(crds.getUri());
        rd.setIsReference(true);
        rd.setWsType("reference");
        return rd;
    }

    public static ResourceDescriptor getRD(ARestV2Connection rc, ClientResource<?> cr, ResourceDescriptor rd) throws ParseException {
        rd.getChildren().clear();
        rd.setWsType(WsTypes.INST().toSoapType(cr));
        rd.setIsNew(false);
        rd.setParentFolder(RDUtil.getParentFolder(cr.getUri()));
        rd.setUriString(cr.getUri());
        rd.setLabel(cr.getLabel());
        rd.setDescription(cr.getDescription());
        rd.setName(RDUtil.getID(cr.getUri()));
        rd.setVersion((Integer)Misc.nvl((Object)cr.getVersion(), (Object)0));
        rd.setCreationDate(rc.toTimestamp(cr.getCreationDate()));
        DiffFields.setSoapValue(rd, "updateDate", cr.getUpdateDate());
        rd.setPermissionMask((Integer)Misc.nvl((Object)cr.getPermissionMask(), (Object)0));
        if (cr instanceof ClientDataType) {
            Rest2Soap.getDataType((ClientDataType)cr, rd);
        } else if (cr instanceof ClientAdhocDataView) {
            Rest2Soap.getAdhocDataView(rc, (ClientAdhocDataView)cr, rd);
        } else if (cr instanceof ClientJdbcDataSource) {
            Rest2Soap.getJdbcDataSource((ClientJdbcDataSource)cr, rd);
        } else if (cr instanceof ClientJndiJdbcDataSource) {
            Rest2Soap.getJndiDataSource((ClientJndiJdbcDataSource)cr, rd);
        } else if (cr instanceof ClientAwsDataSource) {
            Rest2Soap.getAWSDataSource((ClientAwsDataSource)cr, rd);
        } else if (cr instanceof ClientVirtualDataSource) {
            Rest2Soap.getVirtualDataSource((ClientVirtualDataSource)cr, rd);
        } else if (cr instanceof ClientCustomDataSource) {
            Rest2Soap.getCustomDataSource((ClientCustomDataSource)cr, rd);
        } else if (cr instanceof ClientBeanDataSource) {
            Rest2Soap.getBeanDataSource((ClientBeanDataSource)cr, rd);
        } else if (cr instanceof ClientOlapUnit) {
            Rest2Soap.getOlapUnit(rc, (ClientOlapUnit)cr, rd);
        } else if (cr instanceof ClientQuery) {
            Rest2Soap.getQuery(rc, (ClientQuery)cr, rd);
        } else if (cr instanceof ClientXmlaConnection) {
            Rest2Soap.getXmlaConnection((ClientXmlaConnection)cr, rd);
        } else if (cr instanceof ClientMondrianConnection) {
            Rest2Soap.getMondrianConnection(rc, (ClientMondrianConnection)cr, rd);
        } else if (cr instanceof ClientSecureMondrianConnection) {
            Rest2Soap.getSecureMondrianConnection(rc, (ClientSecureMondrianConnection)cr, rd);
        } else if (cr instanceof ClientMondrianXmlaDefinition) {
            Rest2Soap.getMondrianXmlaDefinition(rc, (ClientMondrianXmlaDefinition)cr, rd);
        } else if (cr instanceof ClientListOfValues) {
            Rest2Soap.getLOV((ClientListOfValues)cr, rd);
        } else if (cr instanceof AbstractClientReportUnit) {
            Rest2Soap.getReportUnit(rc, (AbstractClientReportUnit)cr, rd);
        } else if (cr instanceof ClientInputControl) {
            Rest2Soap.getInputControl(rc, (ClientInputControl)cr, rd);
        } else if (cr instanceof ClientFile) {
            Rest2Soap.getFile((ClientFile)cr, rd);
        } else {
            rd = (ResourceDescriptor)Misc.nvl((Object)Activator.getExtManager().getRD(rc, cr, rd), (Object)rd);
        }
        return rd;
    }

    private static void getAdhocDataView(ARestV2Connection rc, ClientAdhocDataView cr, ResourceDescriptor rd) throws ParseException {
        if (cr.getDataSource() != null) {
            ResourceDescriptor r = Rest2Soap.getDataSource(rc, cr.getDataSource());
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        }
    }

    private static void getQuery(ARestV2Connection rc, ClientQuery cr, ResourceDescriptor rd) throws ParseException {
        rd.setResourceProperty("PROP_QUERY_LANGUAGE", cr.getLanguage());
        rd.setSql(cr.getValue());
        if (cr.getDataSource() != null) {
            ResourceDescriptor r = Rest2Soap.getDataSource(rc, cr.getDataSource());
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        }
    }

    private static void getFile(ClientFile cr, ResourceDescriptor rd) {
    }

    private static void getLOV(ClientListOfValues cr, ResourceDescriptor rd) {
        ArrayList<ListItem> lovs = new ArrayList<ListItem>();
        if (cr.getItems() != null) {
            for (ClientListOfValuesItem sds : cr.getItems()) {
                lovs.add(new ListItem(sds.getLabel(), sds.getValue()));
            }
        }
        rd.setListOfValues(lovs);
    }

    private static void getMondrianConnection(ARestV2Connection rc, ClientMondrianConnection cr, ResourceDescriptor rd) throws ParseException {
        ResourceDescriptor r;
        if (cr.getDataSource() != null) {
            r = Rest2Soap.getDataSource(rc, cr.getDataSource());
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        }
        if (cr.getSchema() != null) {
            r = Rest2Soap.getRDContainer(rc, (ClientResource)cr.getSchema());
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        }
    }

    private static void getSecureMondrianConnection(ARestV2Connection rc, ClientSecureMondrianConnection cr, ResourceDescriptor rd) throws ParseException {
        ResourceDescriptor r;
        if (cr.getDataSource() != null) {
            r = Rest2Soap.getDataSource(rc, cr.getDataSource());
            rd.getChildren().add(r);
        }
        if (cr.getSchema() != null) {
            r = Rest2Soap.getRDContainer(rc, (ClientResource)cr.getSchema());
            rd.getChildren().add(r);
        }
        if (cr.getAccessGrants() != null) {
            for (ClientReferenceableFile crf : cr.getAccessGrants()) {
                ResourceDescriptor ard = Rest2Soap.getRDContainer(rc, (ClientResource)crf);
                ard.setWsType("accessGrantSchema");
                Rest2Soap.setupReference(rd, ard);
                rd.getChildren().add(ard);
            }
        }
    }

    private static void getMondrianXmlaDefinition(ARestV2Connection rc, ClientMondrianXmlaDefinition cr, ResourceDescriptor rd) throws ParseException {
        rd.setResourceProperty("PROP_XMLA_CATALOG", cr.getCatalog());
        if (cr.getMondrianConnection() != null) {
            ResourceDescriptor r = Rest2Soap.getRDContainer(rc, (ClientResource)cr.getMondrianConnection());
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        }
    }

    private static void getXmlaConnection(ClientXmlaConnection cr, ResourceDescriptor rd) {
        rd.setResourceProperty("PROP_XMLA_URI", Misc.nvl((String)cr.getUrl()));
        rd.setResourceProperty("PROP_XMLA_DATASOURCE", Misc.nvl((String)cr.getDataSource()));
        rd.setResourceProperty("PROP_XMLA_CATALOG", Misc.nvl((String)cr.getCatalog()));
        rd.setResourceProperty("PROP_XMLA_USERNAME", Misc.nvl((String)cr.getUsername()));
        rd.setResourceProperty("PROP_XMLA_PASSWORD", Misc.nvl((String)cr.getPassword()));
    }

    private static void getBeanDataSource(ClientBeanDataSource cr, ResourceDescriptor rd) {
        rd.setBeanName(cr.getBeanName());
        rd.setBeanMethod(cr.getBeanMethod());
    }

    private static void getOlapUnit(ARestV2Connection rc, ClientOlapUnit cr, ResourceDescriptor rd) throws ParseException {
        rd.setSql(cr.getMdxQuery());
        rd.setResourceProperty("PROP_QUERY_LANGUAGE", "mdx");
        if (cr.getOlapConnection() != null) {
            ResourceDescriptor r = Rest2Soap.getRDContainer(rc, (ClientResource)cr.getOlapConnection());
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        }
    }

    private static void getCustomDataSource(ClientCustomDataSource cr, ResourceDescriptor rd) {
        rd.setServiceClass(cr.getServiceClass());
        if (cr.getProperties() != null) {
            ResourceProperty rp = new ResourceProperty("PROP_DATASOURCE_CUSTOM_PROPERTY_MAP");
            ArrayList<ResourceProperty> props = new ArrayList<ResourceProperty>();
            for (ClientProperty cp : cr.getProperties()) {
                props.add(new ResourceProperty(cp.getKey(), cp.getValue()));
            }
            rp.setProperties(props);
            rd.setResourceProperty(rp);
        }
        DiffFields.setSoapValue(rd, "dataSourceName", cr.getDataSourceName());
    }

    public static void getJdbcDataSource(AbstractClientJdbcDataSource<?> cr, ResourceDescriptor rd) {
        rd.setDriverClass(cr.getDriverClass());
        rd.setPassword(cr.getPassword());
        rd.setUsername(cr.getUsername());
        rd.setConnectionUrl(cr.getConnectionUrl());
        DiffFields.setSoapValue(rd, "timezone", cr.getTimezone());
    }

    private static void getJndiDataSource(ClientJndiJdbcDataSource cr, ResourceDescriptor rd) {
        rd.setJndiName(cr.getJndiName());
        DiffFields.setSoapValue(rd, "timezone", cr.getTimezone());
    }

    private static void getAWSDataSource(ClientAwsDataSource cr, ResourceDescriptor rd) {
        Rest2Soap.getJdbcDataSource(cr, rd);
        DiffFields.setSoapValue(rd, "accessKey", cr.getAccessKey());
        DiffFields.setSoapValue(rd, "secretKey", cr.getSecretKey());
        DiffFields.setSoapValue(rd, "roleArn", cr.getRoleArn());
        DiffFields.setSoapValue(rd, "region", cr.getRegion());
        DiffFields.setSoapValue(rd, "dbName", cr.getDbName());
        DiffFields.setSoapValue(rd, "dbInstanceIdentifier", cr.getDbInstanceIdentifier());
        DiffFields.setSoapValue(rd, "dbService", cr.getDbService());
        DiffFields.setSoapValue(rd, "timezone", cr.getTimezone());
    }

    private static void getVirtualDataSource(ClientVirtualDataSource cr, ResourceDescriptor rd) {
        if (cr.getSubDataSources() != null) {
            for (ClientSubDataSourceReference sds : cr.getSubDataSources()) {
                ResourceDescriptor r = new ResourceDescriptor();
                r.setName(sds.getId());
                r.setLabel(sds.getId());
                r.setIsReference(true);
                r.setReferenceUri(sds.getUri());
                r.setWsType("datasource");
                r.setIsNew(true);
                r.setResourceProperty("PROP_DATASOURCE_SUB_DS_ID", sds.getId());
                r.setUriString(sds.getUri());
                Rest2Soap.setupReference(rd, r);
                rd.getChildren().add(r);
            }
        }
    }

    private static void getDataType(ClientDataType cr, ResourceDescriptor rd) {
        if (cr.getType().equals((Object)ClientDataType.TypeOfDataType.text)) {
            rd.setDataType((byte)1);
        } else if (cr.getType().equals((Object)ClientDataType.TypeOfDataType.number)) {
            rd.setDataType((byte)2);
        } else if (cr.getType().equals((Object)ClientDataType.TypeOfDataType.date)) {
            rd.setDataType((byte)3);
        } else if (cr.getType().equals((Object)ClientDataType.TypeOfDataType.datetime)) {
            rd.setDataType((byte)4);
        } else if (cr.getType().equals((Object)ClientDataType.TypeOfDataType.time)) {
            rd.setDataType((byte)5);
        }
        rd.setPattern(cr.getPattern());
        rd.setMaxValue(cr.getMaxValue());
        rd.setStrictMax(cr.isStrictMax());
        rd.setMinValue(cr.getMinValue());
        rd.setStrictMin(cr.isStrictMin());
        DiffFields.setSoapValue(rd, "maxLength", (Integer)Misc.nvl((Object)cr.getMaxLength(), (Object)new Integer(0)));
    }

    private static void getReportUnit(ARestV2Connection rc, AbstractClientReportUnit<?> cr, ResourceDescriptor rd) throws ParseException {
        rd.setResourceProperty("PROP_RU_ALWAYS_PROPMT_CONTROLS", cr.isAlwaysPromptControls());
        rd.setResourceProperty("PROP_RU_INPUTCONTROL_RENDERING_VIEW", cr.getInputControlRenderingView());
        rd.setResourceProperty("PROP_RU_REPORT_RENDERING_VIEW", cr.getReportRenderingView());
        if (cr.getControlsLayout() == AbstractClientReportUnit.ControlsLayoutType.popupScreen) {
            rd.setResourceProperty("PROP_RU_CONTROLS_LAYOUT", 1);
        }
        if (cr.getControlsLayout() == AbstractClientReportUnit.ControlsLayoutType.separatePage) {
            rd.setResourceProperty("PROP_RU_CONTROLS_LAYOUT", 2);
        }
        if (cr.getControlsLayout() == AbstractClientReportUnit.ControlsLayoutType.topOfPage) {
            rd.setResourceProperty("PROP_RU_CONTROLS_LAYOUT", 3);
        }
        if (cr.getControlsLayout() == AbstractClientReportUnit.ControlsLayoutType.inPage) {
            rd.setResourceProperty("PROP_RU_CONTROLS_LAYOUT", 4);
        }
        rd.getChildren().clear();
        if (cr.getDataSource() != null) {
            ResourceDescriptor dataSource = Rest2Soap.getDataSource(rc, cr.getDataSource());
            Rest2Soap.setupReference(rd, dataSource);
            rd.getChildren().add(dataSource);
        }
        if (cr.getQuery() != null) {
            ResourceDescriptor rdContainer = Rest2Soap.getRDContainer(rc, (ClientQuery)cr.getQuery());
            Rest2Soap.setupReference(rd, rdContainer);
            rd.getChildren().add(rdContainer);
        }
        if (cr.getJrxml() != null) {
            ResourceDescriptor mjrxml = Rest2Soap.getRDContainer(rc, (ClientResource)cr.getJrxml());
            mjrxml.setMainReport(true);
            Rest2Soap.setupReference(rd, mjrxml);
            rd.getChildren().add(mjrxml);
        }
        if (cr.getInputControls() != null) {
            for (ClientReferenceableInputControl cric : cr.getInputControls()) {
                ResourceDescriptor r = Rest2Soap.getRDContainer(rc, (ClientResource)cric);
                Rest2Soap.setupReference(rd, r);
                rd.getChildren().add(r);
            }
        }
        if (cr.getFiles() != null) {
            for (String key : cr.getFiles().keySet()) {
                ClientReferenceableFile crf = (ClientReferenceableFile)cr.getFiles().get(key);
                ResourceDescriptor r = Rest2Soap.getRDContainer(rc, (ClientResource)crf);
                r.setName(key);
                Rest2Soap.setupReference(rd, r);
                rd.getChildren().add(r);
            }
        }
        Collections.sort(rd.getChildren(), new Comparator<ResourceDescriptor>(){

            @Override
            public int compare(ResourceDescriptor arg0, ResourceDescriptor arg1) {
                String wsType1;
                if (arg0.getLabel() == arg1.getLabel()) {
                    return 0;
                }
                if (arg0.getLabel() == null) {
                    return -1;
                }
                if (arg1.getLabel() == null) {
                    return 1;
                }
                String wsType0 = arg0.getWsType();
                if (wsType0.equals(wsType1 = arg1.getWsType())) {
                    if (wsType0.equals("jrxml")) {
                        if (arg0.isMainReport()) {
                            return -1;
                        }
                        if (arg1.isMainReport()) {
                            return 1;
                        }
                        return arg0.getLabel().compareToIgnoreCase(arg1.getLabel());
                    }
                    if (wsType0.equals("inputControl")) {
                        return 0;
                    }
                    return arg0.getLabel().compareToIgnoreCase(arg1.getLabel());
                }
                if (DatasourcesAllFilter.getTypes().contains(wsType0)) {
                    return -1;
                }
                if (DatasourcesAllFilter.getTypes().contains(wsType1)) {
                    return 1;
                }
                if (wsType0.equals("jrxml")) {
                    return -1;
                }
                if (wsType1.equals("jrxml")) {
                    return 1;
                }
                if (wsType0.equals("query")) {
                    return -1;
                }
                if (wsType1.equals("query")) {
                    return 1;
                }
                if (wsType0.equals("inputControl")) {
                    return -1;
                }
                if (wsType1.equals("inputControl")) {
                    return 1;
                }
                return wsType0.compareTo(wsType1);
            }
        });
    }

    public static void setupReference(ResourceDescriptor parent, ResourceDescriptor rd) {
        if (rd != null && rd.getParentFolder() != null && !rd.getParentFolder().equals(String.valueOf(parent.getUriString()) + "_files")) {
            rd.setIsReference(true);
        }
    }

    private static void getInputControl(ARestV2Connection rc, ClientInputControl cr, ResourceDescriptor rd) throws ParseException {
        ResourceDescriptor r;
        rd.setMandatory(cr.isMandatory());
        rd.setReadOnly(cr.isReadOnly());
        rd.setVisible(cr.isVisible());
        if (cr.getListOfValues() != null) {
            r = Rest2Soap.getRDContainer(rc, (ClientListOfValues)cr.getListOfValues());
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        }
        if (cr.getQuery() != null) {
            r = Rest2Soap.getRDContainer(rc, (ClientQuery)cr.getQuery());
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        }
        if (cr.getDataType() != null) {
            r = Rest2Soap.getRDContainer(rc, (ClientDataType)cr.getDataType());
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        }
        rd.setControlType(cr.getType());
        rd.setQueryValueColumn(cr.getValueColumn());
        if (cr.getVisibleColumns() != null) {
            rd.setQueryVisibleColumns(cr.getVisibleColumns().toArray(new String[cr.getVisibleColumns().size()]));
        }
    }

    public static ResourceDescriptor getInputControl(ReportInputControl cr, ResourceDescriptor rd) {
        rd.setName(cr.getId());
        rd.setUriString(cr.getUri().replaceFirst("repo:", ""));
        rd.setLabel(cr.getLabel());
        rd.setDescription(cr.getDescription());
        rd.setWsType("inputControl");
        rd.setValue(cr);
        rd.setMasterInputControls(cr.getMasterDependencies());
        rd.setMandatory(cr.getMandatory());
        rd.setReadOnly(cr.getReadOnly());
        rd.setVisible(cr.getVisible());
        String rtype = cr.getType();
        if (rtype.equals("bool")) {
            rd.setControlType((byte)1);
        } else if (rtype.equals("singleValue")) {
            rd.setControlType((byte)2);
        } else if (rtype.equals("singleValueNumber")) {
            rd.setControlType((byte)2);
            ResourceDescriptor r = new ResourceDescriptor();
            r.setWsType("dataType");
            r.setDataType((byte)2);
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        } else if (rtype.equals("singleValueDate")) {
            rd.setControlType((byte)2);
            ResourceDescriptor r = new ResourceDescriptor();
            r.setWsType("dataType");
            r.setDataType((byte)3);
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        } else if (rtype.equals("singleValueText")) {
            rd.setControlType((byte)2);
            ResourceDescriptor r = new ResourceDescriptor();
            r.setWsType("dataType");
            r.setDataType((byte)1);
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        } else if (rtype.equals("singleValueDatetime")) {
            rd.setControlType((byte)2);
            ResourceDescriptor r = new ResourceDescriptor();
            r.setWsType("dataType");
            r.setDataType((byte)4);
            Rest2Soap.setupReference(rd, r);
            rd.getChildren().add(r);
        } else if (rtype.equals("singleSelect")) {
            rd.setControlType((byte)3);
        } else if (rtype.equals("singleSelect")) {
            rd.setControlType((byte)4);
        } else if (rtype.equals("multiValue")) {
            rd.setControlType((byte)5);
        } else if (rtype.equals("multiSelect")) {
            rd.setControlType((byte)6);
        } else if (rtype.equals("multiSelect")) {
            rd.setControlType((byte)7);
        } else if (rtype.equals("multiSelect")) {
            rd.setControlType((byte)8);
        } else if (rtype.equals("singleSelectRadio")) {
            rd.setControlType((byte)9);
        } else if (rtype.equals("multiSelectCheckbox")) {
            rd.setControlType((byte)10);
        } else if (rtype.equals("multiSelectCheckbox")) {
            rd.setControlType((byte)11);
        }
        return rd;
    }
}

