/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.jaspersoft.ireport.jasperserver.ws.FileContent;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import com.jaspersoft.jasperserver.dto.authority.ClientUser;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.jdbcdrivers.JdbcDriverInfo;
import com.jaspersoft.jasperserver.dto.permissions.RepositoryPermission;
import com.jaspersoft.jasperserver.dto.permissions.RepositoryPermissionListWrapper;
import com.jaspersoft.jasperserver.dto.reports.ReportParameter;
import com.jaspersoft.jasperserver.dto.reports.ReportParameters;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.InputControlOption;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.InputControlState;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.ReportInputControl;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.ReportInputControlsListWrapper;
import com.jaspersoft.jasperserver.dto.resources.AbstractClientReportUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableFile;
import com.jaspersoft.jasperserver.dto.resources.ClientReportUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceListWrapper;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.jasperserver.dto.serverinfo.ServerInfo;
import com.jaspersoft.jasperserver.jaxrs.client.dto.importexport.ExportTaskDto;
import com.jaspersoft.jasperserver.jaxrs.client.dto.importexport.StateDto;
import com.jaspersoft.jasperserver.jaxrs.client.dto.reports.AttachmentDescriptor;
import com.jaspersoft.jasperserver.jaxrs.client.dto.reports.ExportDescriptor;
import com.jaspersoft.jasperserver.jaxrs.client.dto.reports.OutputResourceDescriptor;
import com.jaspersoft.jasperserver.jaxrs.client.dto.reports.ReportExecutionDescriptor;
import com.jaspersoft.jasperserver.jaxrs.report.InputControlStateListWrapper;
import com.jaspersoft.jasperserver.jaxrs.report.ReportExecutionRequest;
import com.jaspersoft.studio.server.AFinderUI;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.editor.input.InputControlsManager;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.datasource.filter.DatasourcesAllFilter;
import com.jaspersoft.studio.server.model.datasource.filter.IDatasourceFilter;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.JSSTrustStrategy;
import com.jaspersoft.studio.server.protocol.JdbcDriver;
import com.jaspersoft.studio.server.protocol.ReportExecution;
import com.jaspersoft.studio.server.protocol.Version;
import com.jaspersoft.studio.server.protocol.restv2.ARestV2ConnectionJersey;
import com.jaspersoft.studio.server.protocol.restv2.CASUtil;
import com.jaspersoft.studio.server.protocol.restv2.CertChainValidator;
import com.jaspersoft.studio.server.protocol.restv2.ClientQueryMapperProvider;
import com.jaspersoft.studio.server.protocol.restv2.JSSApacheConnectorFactory;
import com.jaspersoft.studio.server.protocol.restv2.RESTv2ExceptionHandler;
import com.jaspersoft.studio.server.protocol.restv2.Rest2Soap;
import com.jaspersoft.studio.server.protocol.restv2.Soap2Rest;
import com.jaspersoft.studio.server.protocol.restv2.WsTypes;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.utils.Encrypter;
import com.jaspersoft.studio.server.utils.HttpUtils;
import com.jaspersoft.studio.server.utils.ResourceDescriptorUtil;
import com.jaspersoft.studio.server.wizard.exp.ExportOptions;
import com.jaspersoft.studio.server.wizard.imp.ImportOptions;
import com.jaspersoft.studio.server.wizard.permission.PermissionOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.sf.jasperreports.eclipse.util.FileExtension;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.Boundary;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class RestV2ConnectionJersey
extends ARestV2ConnectionJersey {
    private CookieStore cookieStore;

    @Override
    public boolean connect(IProgressMonitor monitor, ServerProfile sp) throws Exception {
        String url;
        monitor.subTask(Messages.RestV2ConnectionJersey_0);
        super.connect(monitor, sp);
        this.eh = new RESTv2ExceptionHandler(this);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)sp.getTimeout());
        if (sp.isChunked()) {
            clientConfig.property("jersey.config.client.chunkedEncodingSize", (Object)1024);
        } else {
            clientConfig.property("jersey.config.client.chunkedEncodingSize", null);
        }
        clientConfig.property("jersey.config.apache.client.preemptiveBasicAuthentication", (Object)true);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").build();
        clientConfig.property("jersey.config.apache.client.requestConfig", (Object)requestConfig);
        SslConfigurator sslConfig = SslConfigurator.newInstance((boolean)true);
        clientConfig.property("jersey.config.apache.client.ssl.sslConfig", (Object)sslConfig);
        SSLContextBuilder builder = SSLContexts.custom();
        KeyStore trustStore = CertChainValidator.getDefaultTrustStore();
        builder.loadTrustMaterial(trustStore, (TrustStrategy)new JSSTrustStrategy(trustStore));
        builder.loadKeyMaterial(CertChainValidator.getDefaultKeyStore(), CertChainValidator.kpass);
        SSLContext sslContext = builder.build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new BrowserCompatHostnameVerifier()){

            protected void prepareSocket(SSLSocket socket) throws IOException {
                super.prepareSocket(socket);
                socket.setEnabledProtocols(new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"});
            }
        };
        Registry ssr = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager cxMgr = new PoolingHttpClientConnectionManager(ssr);
        cxMgr.setMaxTotal(50);
        cxMgr.setDefaultMaxPerRoute(20);
        clientConfig.property("jersey.config.apache.client.connectionManager", (Object)cxMgr);
        this.connector = new JSSApacheConnectorFactory();
        clientConfig.connectorProvider((ConnectorProvider)this.connector);
        HttpUtils.setupProxy(clientConfig, HttpUtils.toSafeUri(sp.getURL()));
        clientConfig.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        clientConfig.property("jersey.config.client.followRedirects", (Object)true);
        clientConfig.register(JacksonFeature.class).register(ClientQueryMapperProvider.class);
        this.client = ClientBuilder.newBuilder().hostnameVerifier((e, k) -> true).withConfig((Configuration)clientConfig).build();
        this.client.register(MultiPartFeature.class);
        this.client.register((Object)new ClientResponseFilter(){

            public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
                if (responseContext.getStatusInfo().getFamily() != Response.Status.Family.REDIRECTION) {
                    return;
                }
                WebTarget tgt = requestContext.getClient().target(responseContext.getLocation());
                requestContext.getEntity();
                requestContext.getPropertyNames();
                Invocation.Builder req = HttpUtils.getRequest(tgt);
                req.headers(requestContext.getHeaders());
                for (String key : requestContext.getPropertyNames()) {
                    req.property(key, requestContext.getProperty(key));
                }
                Response resp = null;
                resp = requestContext.getMediaType() != null && requestContext.getEntity() != null ? req.method(requestContext.getMethod(), Entity.entity((Object)requestContext.getEntity(), (MediaType)requestContext.getMediaType())) : req.method(requestContext.getMethod());
                responseContext.setEntityStream((InputStream)resp.getEntity());
                responseContext.setStatusInfo(resp.getStatusInfo());
                responseContext.setStatus(resp.getStatus());
                ((ClientResponse)responseContext).getHeaders().clear();
                ((ClientResponse)responseContext).headers(resp.getStringHeaders());
            }
        });
        if (sp.isLogging()) {
            this.logger.setLevel(Level.FINEST);
            this.client.register((Object)new LoggingFilter(this.logger, true));
        }
        if (!this.doConnect(monitor, sp, url = ServerProfile.normaliseUrl(sp.getUrl()))) {
            return false;
        }
        this.getServerInfo(monitor);
        try {
            this.getServerProfile().setClientUser(null);
            this.getServerProfile().setClientUser(this.getUser(monitor));
        }
        catch (HttpResponseException e2) {
            if (!(e2.getMessage().contains("Access") || e2.getMessage().contains("Forbidden") || e2.getMessage().contains("resource.not.found"))) {
                throw e2;
            }
        }
        catch (Exception e3) {
            Activator.getDefault().logError(e3);
        }
        return this.serverInfo != null && this.serverInfo.getVersion().compareTo("5.5") >= 0;
    }

    private boolean doConnect(IProgressMonitor monitor, ServerProfile sp, String url) throws Exception {
        String pass = this.encryptPass(monitor, url, this.parent.getPassword(monitor));
        try {
            if (!this.doConnectLogin(monitor, sp, url, pass)) {
                return false;
            }
        }
        catch (Exception e) {
            if (e instanceof HttpResponseException && ((HttpResponseException)((Object)e)).getStatusCode() == 401) {
                throw e;
            }
            try {
                if (!this.doConnectOld(monitor, sp, url, pass)) {
                    return false;
                }
            }
            catch (Exception e1) {
                if (this.logger != null) {
                    this.logger.log(Level.SEVERE, e1.getMessage(), e1);
                }
                throw e;
            }
        }
        finally {
            this.target = this.client.target(String.valueOf(url) + "rest_v2/");
        }
        return true;
    }

    private String encryptPass(IProgressMonitor monitor, String url, String pass) {
        block4: {
            if (pass == null) {
                return null;
            }
            try {
                this.target = this.client.target(String.valueOf(url) + "GetEncryptionKey");
                Invocation.Builder req = HttpUtils.getRequest(this.target, "application/json");
                String key = this.toObj(this.connector.get(req, monitor), String.class, monitor);
                if (key.contains("maxdigits")) {
                    pass = Encrypter.encryptRSA(pass, key);
                }
            }
            catch (Exception e) {
                if (this.logger == null) break block4;
                this.logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        return pass;
    }

    private boolean doConnectOld(IProgressMonitor monitor, ServerProfile sp, String url, String pwd) throws Exception {
        this.target = this.client.target(String.valueOf(url) + "j_spring_security_check");
        this.target = this.target.queryParam("forceDefaultRedirect", new Object[]{"false"});
        if (sp.isUseSSO()) {
            String token = CASUtil.getToken(sp, monitor);
            this.target = this.target.queryParam("ticket", new Object[]{token});
        } else {
            this.target = this.target.queryParam("j_username", new Object[]{sp.getUser()});
            if (pwd != null) {
                this.target = this.target.queryParam("j_password", new Object[]{URLEncoder.encode(pwd, "UTF-8")});
            }
            if (monitor.isCanceled()) {
                return false;
            }
        }
        this.target = this.target.queryParam("orgId", new Object[]{sp.getOrganisation()});
        if (!Misc.isNullOrEmpty((String)sp.getLocale())) {
            this.target = this.target.queryParam("userLocale", new Object[]{Locale.getDefault().toString()});
        }
        if (!Misc.isNullOrEmpty((String)sp.getTimeZone())) {
            this.target = this.target.queryParam("userTimezone", new Object[]{TimeZone.getDefault().getID()});
        }
        Invocation.Builder req = HttpUtils.getRequest(this.target);
        this.toObj(this.connector.get(req, monitor), String.class, monitor);
        return true;
    }

    private boolean doConnectLogin(IProgressMonitor monitor, ServerProfile sp, String url, String pwd) throws Exception {
        this.target = this.client.target(String.valueOf(url) + "rest_v2/" + "login");
        MultivaluedStringMap formData = new MultivaluedStringMap();
        if (sp.isUseSSO()) {
            String token = CASUtil.getToken(sp, monitor);
            formData.add((Object)"ticket", (Object)token);
        } else {
            formData.add((Object)"forceDefaultRedirect", (Object)"false");
            String usr = sp.getUser();
            if (sp.getOrganisation() != null && !Misc.isNullOrEmpty((String)sp.getOrganisation().trim())) {
                usr = String.valueOf(usr) + "|" + sp.getOrganisation();
            }
            formData.add((Object)"j_username", (Object)usr);
            if (pwd != null) {
                formData.add((Object)"j_password", (Object)pwd);
            }
            if (monitor.isCanceled()) {
                return false;
            }
        }
        if (!Misc.isNullOrEmpty((String)sp.getLocale())) {
            formData.add((Object)"userLocale", (Object)Locale.getDefault().toString());
        }
        if (!Misc.isNullOrEmpty((String)sp.getTimeZone())) {
            formData.add((Object)"userTimezone", (Object)TimeZone.getDefault().getID());
        }
        Invocation.Builder req = HttpUtils.getRequest(this.target);
        this.eh.handleException(this.connector.post(req, Entity.form((MultivaluedMap)formData), monitor), monitor);
        return true;
    }

    @Override
    public ServerInfo getServerInfo(IProgressMonitor monitor) throws Exception {
        if (this.serverInfo != null) {
            return this.serverInfo;
        }
        Invocation.Builder req = HttpUtils.getRequest(this.target.path("serverInfo"));
        this.serverInfo = this.toObj(this.connector.get(req, monitor), ServerInfo.class, monitor);
        if (this.serverInfo != null) {
            this.dateFormat = new SimpleDateFormat(this.serverInfo.getDateFormatPattern());
            this.timestampFormat = new SimpleDateFormat(this.serverInfo.getDatetimeFormatPattern());
            if (this.sp.getJrVersion() == null || this.sp.getJrVersion().equals("last")) {
                this.sp.setJrVersion(Version.setJRVersion(this.serverInfo));
            }
        }
        return this.serverInfo;
    }

    @Override
    public List<ResourceDescriptor> list(IProgressMonitor monitor, ResourceDescriptor rd) throws Exception {
        ArrayList<ResourceDescriptor> rds = new ArrayList<ResourceDescriptor>();
        if (rd.getWsType().equals("reportUnit") || rd.getWsType().equals("domainTopic")) {
            rd = this.parent.get(monitor, rd, null);
            return rd.getChildren();
        }
        if (rd.getWsType().equals("adhocDataView")) {
            try {
                return this.getInputControls(String.valueOf(rd.getParentFolder()) + "/" + rd.getName(), monitor);
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 403) {
                    return new ArrayList<ResourceDescriptor>();
                }
                throw e;
            }
        }
        if (rd.getWsType().equals("dashboard")) {
            try {
                return this.getInputControls(String.valueOf(rd.getParentFolder()) + "/" + rd.getName(), monitor);
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 403) {
                    return new ArrayList<ResourceDescriptor>();
                }
                throw e;
            }
        }
        if (rd.getWsType().equals("reportOptions")) {
            try {
                return this.getInputControls(String.valueOf(rd.getParentFolder()) + "/" + rd.getName(), monitor);
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 403) {
                    return new ArrayList<ResourceDescriptor>();
                }
                throw e;
            }
        }
        WebTarget tgt = this.target.path("resources");
        tgt = tgt.queryParam("folderUri", new Object[]{rd.getUriString()});
        tgt = tgt.queryParam("recursive", new Object[]{"false"});
        tgt = tgt.queryParam("sortBy", new Object[]{"label"});
        Invocation.Builder req = HttpUtils.getRequest(tgt = tgt.queryParam("limit", new Object[]{0}));
        ClientResourceListWrapper resources = this.toObj(this.connector.get(req, monitor), ClientResourceListWrapper.class, monitor);
        if (resources != null) {
            boolean isPublic = false;
            for (ClientResourceLookup crl : resources.getResourceLookups()) {
                if (!isPublic) {
                    isPublic = crl.getUri().equals("/public");
                }
                ResourceDescriptor nrd = Rest2Soap.getRDLookup(this, crl);
                rds.add(nrd);
                if (!nrd.getWsType().equals("contentResource")) continue;
                String name = nrd.getUriString().toLowerCase();
                if (FileExtension.isImage((String)name)) {
                    nrd.setWsType("img");
                }
                if (FileExtension.isFont((String)name)) {
                    nrd.setWsType("font");
                    continue;
                }
                if (name.endsWith(".xml")) {
                    nrd.setWsType("xml");
                    continue;
                }
                if (name.endsWith(".jrxml")) {
                    nrd.setWsType("jrxml");
                    continue;
                }
                if (name.endsWith(".jar")) {
                    nrd.setWsType("jar");
                    continue;
                }
                if (name.endsWith(".jrtx")) {
                    nrd.setWsType("jrtx");
                    continue;
                }
                if (name.endsWith(".css")) {
                    nrd.setWsType("css");
                    continue;
                }
                if (name.endsWith(".js")) {
                    nrd.setWsType("contentResource");
                    continue;
                }
                if (name.endsWith(".properties")) {
                    nrd.setWsType("prop");
                    continue;
                }
                if (name.endsWith(".pfx")) {
                    nrd.setWsType("cer");
                    continue;
                }
                if (!name.endsWith(".p12")) continue;
                nrd.setWsType("cer");
            }
            if (rd.getUriString().equals("/") && !isPublic) {
                try {
                    ResourceDescriptor pub = new ResourceDescriptor();
                    pub.setUriString("/public");
                    pub.setWsType("folder");
                    rds.add(this.parent.get(monitor, pub, null));
                }
                catch (Exception e) {
                    this.logger.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
        return rds;
    }

    @Override
    public ResourceDescriptor get(IProgressMonitor monitor, ResourceDescriptor rd, File f) throws Exception {
        if (rd.getUriString() == null && rd.getIsReference() && rd.getReferenceUri() != null) {
            ResourceDescriptor nrd = new ResourceDescriptor();
            nrd.setUriString(rd.getReferenceUri());
            nrd.setWsType(rd.getReferenceType());
            rd = nrd;
        }
        if (rd.getUriString() == null || rd.getUriString().contains("<")) {
            throw new Exception("wrong url");
        }
        String uri = rd.getUriString();
        if (uri.startsWith("repo://")) {
            uri = uri.substring(5);
        }
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        WebTarget tgt = this.target.path("resources" + uri);
        Boolean b = rd.getResourcePropertyValueAsBoolean("expand");
        tgt = b != null && b == false ? tgt.queryParam("expanded", new Object[]{"false"}) : tgt.queryParam("expanded", new Object[]{"true"});
        String rtype = WsTypes.INST().toRestType(rd.getWsType());
        Invocation.Builder req = null;
        req = rtype == null ? HttpUtils.getRequest(tgt, "application/repository.file+json") : HttpUtils.getRequest(tgt, "application/repository." + rtype + "+" + "json");
        ClientResource<?> obj = this.toObj(this.connector.get(req, monitor), WsTypes.INST().getType(rtype), monitor);
        if (obj instanceof ClientResource) {
            ClientResource<?> crl = obj;
            if (rd.getWsType() == null) {
                rd.setWsType(WsTypes.INST().getRestType(crl));
            }
            if (f != null && crl instanceof ClientFile) {
                ClientFile cf = (ClientFile)crl;
                tgt = this.target.path("resources" + uri);
                try {
                    req = HttpUtils.getRequest(tgt, cf.getType().getMimeType()).header("Accept", (Object)cf.getType().getMimeType());
                    this.readFile(this.connector.get(req, monitor), f, monitor);
                }
                catch (HttpResponseException e) {
                    if (e.getStatusCode() == 500) {
                        // empty if block
                    }
                }
            }
            rd = Rest2Soap.getRD(this, crl);
            if (crl instanceof ClientFile) {
                this.setMainReportFlag(monitor, rd, (ClientFile)crl);
            }
            return rd;
        }
        if (obj instanceof String) {
            rd.setData(((String)obj).getBytes());
            rd.setIsReference(false);
            rd.setHasData(true);
            return rd;
        }
        return null;
    }

    private void setMainReportFlag(IProgressMonitor monitor, ResourceDescriptor rd, ClientFile cf) throws IOException, Exception {
        if (monitor.isCanceled()) {
            return;
        }
        if (cf.getType().equals((Object)ClientFile.FileType.jrxml)) {
            String uri = rd.getParentFolder();
            if (rd.getParentFolder().endsWith("_files")) {
                uri = uri.substring(0, uri.length() - "_files".length());
            }
            WebTarget tgt = this.target.path("resources" + uri);
            Invocation.Builder req = HttpUtils.getRequest(tgt = tgt.queryParam("expanded", new Object[]{"false"}), "application/repository.file+json");
            Object obj = this.toObj(this.connector.get(req, monitor), null, monitor);
            if (obj instanceof AbstractClientReportUnit) {
                rd.setMainReport(((AbstractClientReportUnit)obj).getJrxml().getUri().equals(cf.getUri()));
            }
        }
    }

    @Override
    public ResourceDescriptor move(IProgressMonitor monitor, ResourceDescriptor rd, String destFolderURI) throws Exception {
        String wsType = rd.getWsType();
        String rtype = WsTypes.INST().toRestType(wsType);
        WebTarget tgt = this.target.path("resources" + destFolderURI);
        tgt = tgt.queryParam("overwrite", new Object[]{"true"});
        Invocation.Builder req = HttpUtils.getRequest(tgt = tgt.queryParam("createFolders", new Object[]{"true"})).header("Content-Location", (Object)rd.getUriString());
        Response r = this.connector.put(req, Entity.entity((Object)"", (MediaType)this.getMediaType()), monitor);
        ClientResource<?> crl = this.toObj(r, WsTypes.INST().getType(rtype), monitor);
        if (crl != null) {
            rd = new ResourceDescriptor();
            rd.setWsType(wsType);
            rd.setUriString(crl.getUri());
            return this.doGet(monitor, rd, crl);
        }
        return null;
    }

    @Override
    public ResourceDescriptor copy(IProgressMonitor monitor, ResourceDescriptor rd, String destFolderURI) throws Exception {
        if (rd.getParentFolder().equals(destFolderURI)) {
            return rd;
        }
        String wsType = rd.getWsType();
        String rtype = WsTypes.INST().toRestType(wsType);
        WebTarget tgt = this.target.path("resources" + destFolderURI);
        tgt = tgt.queryParam("overwrite", new Object[]{"true"});
        Invocation.Builder req = HttpUtils.getRequest(tgt = tgt.queryParam("createFolders", new Object[]{"true"})).header("Content-Location", (Object)rd.getUriString());
        Response r = this.connector.post(req, Entity.entity((Object)"", (MediaType)this.getMediaType()), monitor);
        ClientResource<?> crl = this.toObj(r, WsTypes.INST().getType(rtype), monitor);
        if (crl != null) {
            rd = new ResourceDescriptor();
            rd.setWsType(wsType);
            rd.setUriString(crl.getUri());
            return this.doGet(monitor, rd, crl);
        }
        return null;
    }

    private void fillFiles(ClientFile cf, IProgressMonitor monitor) throws IOException, Exception {
        if (cf.getContent() == null) {
            WebTarget tgt = this.target.path("resources" + cf.getUri());
            try {
                Invocation.Builder req = HttpUtils.getRequest(tgt, cf.getType().getMimeType()).header("Accept", (Object)cf.getType().getMimeType());
                byte[] bytes = this.readFile(this.connector.get(req, monitor), monitor);
                if (bytes != null) {
                    cf.setContent(new String(Base64.encodeBase64((byte[])bytes)));
                }
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 500) {
                    // empty if block
                }
            }
        }
    }

    @Override
    public ResourceDescriptor addOrModifyResource(IProgressMonitor monitor, ResourceDescriptor rd, File inFile) throws Exception {
        ClientResource<?> clientResource;
        this.prepareResource(monitor, rd);
        String rtype = WsTypes.INST().toRestType(rd.getWsType());
        ClientResource<?> cr = Soap2Rest.getResource(this, rd);
        Response r = null;
        if (cr instanceof ClientReportUnit) {
            ClientReportUnit cru = (ClientReportUnit)cr;
            if (cru.getJrxml() == null) {
                ResourceDescriptor newrd = this.get(monitor, rd, inFile);
                for (ResourceDescriptor resourceDescriptor : newrd.getChildren()) {
                    if (!resourceDescriptor.getWsType().equals("jrxml") || !resourceDescriptor.isMainReport()) continue;
                    rd.getChildren().add(resourceDescriptor);
                }
                cr = Soap2Rest.getResource(this, newrd);
                cru = (ClientReportUnit)cr;
            }
            if (cru.getJrxml() instanceof ClientFile) {
                this.fillFiles((ClientFile)cru.getJrxml(), monitor);
            }
            for (ClientReferenceableFile crf : cru.getFiles().values()) {
                if (!(crf instanceof ClientFile)) continue;
                this.fillFiles((ClientFile)crf, monitor);
            }
        }
        if (rd.getWsType().equals("reportOptions")) {
            ResourceProperty resprop = ResourceDescriptorUtil.getProperty("PROP_RU_URI", rd.getProperties());
            WebTarget tgt = this.target.path("reports" + resprop.getValue() + "/options");
            tgt = tgt.queryParam("label", new Object[]{rd.getLabel()});
            tgt = tgt.queryParam("overwrite", new Object[]{"true"});
            ReportParameters reportParameters = new ReportParameters(new ArrayList());
            Invocation.Builder req = HttpUtils.getRequest(tgt);
            r = this.connector.post(req, Entity.entity((Object)reportParameters, (MediaType)this.getMediaType()), monitor);
            try {
                this.toObj(r, String.class, monitor);
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 409) {
                    rd.setVersion(this.parent.get(monitor, rd, null).getVersion());
                    return this.addOrModifyResource(monitor, rd, inFile);
                }
                throw e;
            }
            return this.doGet(monitor, rd, cr);
        }
        WebTarget tgt = this.target.path("resources" + rd.getUriString());
        tgt = tgt.queryParam("createFolders", new Object[]{"true"});
        tgt = tgt.queryParam("overwrite", new Object[]{"true"});
        Invocation.Builder req = cr instanceof ClientReportUnit ? HttpUtils.getRequest(tgt, "application/json") : HttpUtils.getRequest(tgt);
        r = this.connector.put(req, Entity.entity(cr, (String)("application/repository." + rtype + "+" + "json")), monitor);
        Object var9_14 = null;
        try {
            clientResource = this.toObj(r, WsTypes.INST().getType(rtype), monitor);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 409) {
                rd.setVersion(this.parent.get(monitor, rd, null).getVersion());
                return this.addOrModifyResource(monitor, rd, inFile);
            }
            throw e;
        }
        if (clientResource != null && !monitor.isCanceled()) {
            rd = this.doGet(monitor, rd, clientResource);
        }
        return rd;
    }

    @Override
    public JdbcDriverInfo getJdbcDrivers(IProgressMonitor monitor) throws Exception {
        WebTarget tgt = this.target.path("jdbcDrivers");
        return this.toObj(this.connector.get(HttpUtils.getRequest(tgt), monitor), JdbcDriverInfo.class, monitor);
    }

    @Override
    public void uploadJdbcDrivers(JdbcDriver driver, IProgressMonitor monitor) throws Exception {
        monitor.setTaskName("Uploading drivers");
        if (Misc.isNullOrEmpty(driver.getPaths())) {
            return;
        }
        FormDataMultiPart entity = new FormDataMultiPart();
        entity.type(Boundary.addBoundary((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        entity.field("className", driver.getClassname());
        int i = 0;
        while (i < driver.getPaths().size()) {
            File file = new File(driver.getPaths().get(i));
            if (file.exists()) {
                entity.bodyPart((BodyPart)new FileDataBodyPart("file_" + i, file));
            }
            ++i;
        }
        WebTarget tgt = this.target.path("jdbcDrivers");
        Invocation.Builder req = HttpUtils.getRequest(tgt);
        this.eh.handleException(this.connector.post(req, Entity.entity((Object)entity, (MediaType)entity.getMediaType()), monitor), monitor);
    }

    private void prepareResource(IProgressMonitor monitor, ResourceDescriptor rd) throws Exception {
        if (!rd.getIsNew() && rd.getChildren() != null) {
            for (ResourceDescriptor r : rd.getChildren()) {
                if (!r.getIsNew() && r.isDirty1()) {
                    this.addOrModifyResource(monitor, r, null);
                    r.setDirty(false);
                    continue;
                }
                this.prepareResource(monitor, r);
            }
        }
    }

    private ResourceDescriptor doGet(IProgressMonitor monitor, ResourceDescriptor rd, ClientResource<?> crl) throws Exception, ParseException {
        boolean refresh = false;
        if (WsTypes.INST().isContainerType(crl.getClass())) {
            refresh = true;
        }
        if (monitor.isCanceled()) {
            return rd;
        }
        rd = refresh ? this.parent.get(monitor, rd, null) : Rest2Soap.getRD(this, crl, rd);
        return rd;
    }

    @Override
    public ResourceDescriptor modifyReportUnitResource(IProgressMonitor monitor, ResourceDescriptor runit, ResourceDescriptor rd, File inFile) throws Exception {
        if (rd.getIsReference() && (rd.hasDirtyChildren() || rd.getHasData())) {
            return this.addOrModifyResource(monitor, rd, inFile);
        }
        runit = this.parent.get(monitor, runit, null);
        PublishUtil.setChild(runit, rd);
        return this.addOrModifyResource(monitor, runit, inFile);
    }

    @Override
    public void delete(IProgressMonitor monitor, ResourceDescriptor rd) throws Exception {
        WebTarget tgt = this.target.path("resources" + rd.getUriString());
        try (Response res = this.connector.delete(HttpUtils.getRequest(tgt), monitor);){
            switch (res.getStatus()) {
                case 204: {
                    System.out.println("Deleted");
                    break;
                }
                default: {
                    this.eh.handleException(res, monitor);
                    break;
                }
            }
        }
    }

    @Override
    public ResourceDescriptor delete(IProgressMonitor monitor, ResourceDescriptor rd, ResourceDescriptor runit) throws Exception {
        ResourceDescriptor rdrem = null;
        for (ResourceDescriptor r : runit.getChildren()) {
            if (!r.getUriString().equals(rd.getUriString())) continue;
            rdrem = r;
            break;
        }
        if (rdrem != null) {
            runit.getChildren().remove(rdrem);
            return this.addOrModifyResource(monitor, runit, null);
        }
        return runit;
    }

    private CookieStore getCookieStore() {
        if (this.cookieStore == null) {
            Connector c = ((ClientConfig)this.target.getConfiguration()).getConnector();
            try {
                Method m = c.getClass().getMethod("getCookieStore", new Class[0]);
                if (m != null) {
                    m.setAccessible(true);
                    this.cookieStore = (CookieStore)m.invoke((Object)c, new Object[0]);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        return this.cookieStore;
    }

    @Override
    public ReportExecution runReport(IProgressMonitor monitor, ReportExecution repExec) throws Exception {
        Response r;
        HashMap<String, FileContent> map = new HashMap<String, FileContent>();
        ReportExecutionDescriptor res = null;
        WebTarget tgt = null;
        Invocation.Builder req = null;
        if (repExec.getRequestId() != null && !repExec.getStatus().equals("refresh")) {
            tgt = this.target.path("reportExecutions/" + repExec.getRequestId());
            req = HttpUtils.getRequest(tgt);
            Response r2 = this.connector.get(req, monitor);
            res = this.toObj(r2, ReportExecutionDescriptor.class, monitor);
        } else {
            ReportExecutionRequest rer = new ReportExecutionRequest();
            rer.setReportUnitUri(repExec.getReportURI());
            rer.setAsync(true);
            rer.setFreshData(true);
            rer.setIgnorePagination(false);
            rer.setAllowInlineScripts(true);
            rer.setInteractive(true);
            rer.setAttachmentsPrefix("");
            String format = null;
            for (Argument arg : repExec.getArgs()) {
                if (!arg.getName().equals("RUN_OUTPUT_FORMAT")) continue;
                format = arg.getValue();
                break;
            }
            if (format == null) {
                format = "JRPRINT";
            }
            if (format.equals("JRPRINT")) {
                rer.setPages("1");
            }
            rer.setOutputFormat(format);
            rer.setSaveDataSnapshot(false);
            Map<String, Object> prm = repExec.getPrm();
            if (prm != null && !prm.isEmpty()) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Map.Entry<String, Object> entry : prm.entrySet()) {
                    ReportParameter rprm = new ReportParameter();
                    rprm.setName(entry.getKey());
                    Object item = entry.getValue();
                    ArrayList<String> vals = new ArrayList<String>();
                    if (item instanceof Collection) {
                        Collection c = (Collection)item;
                        for (Object obj : c) {
                            vals.add(this.toRestString(obj));
                        }
                    } else {
                        vals.add(this.toRestString(item));
                    }
                    if (vals.isEmpty()) continue;
                    rprm.setValues(vals);
                    list.add(rprm);
                }
                rer.setParameters(new ReportParameters(list));
            }
            if (rer.getOutputFormat().equals("HTML")) {
                StringBuilder rourl = new StringBuilder("reports" + repExec.getReportURI() + ".html");
                if (rer.getParameters() != null) {
                    String del = "?";
                    for (ReportParameter rp : rer.getParameters().getReportParameters()) {
                        if (rp.getValues().isEmpty()) {
                            rourl.append(del).append(String.valueOf(rp.getName()) + "=");
                        }
                        for (String v : rp.getValues()) {
                            rourl.append(del).append(String.valueOf(rp.getName()) + "=");
                            rourl.append(v);
                            del = "&";
                        }
                        del = "&";
                    }
                }
                repExec.setBaseUrl(this.target.getUri().toASCIIString());
                repExec.setPathUrl(rourl.toString());
                repExec.setReportOutputCookie(this.getCookieStore().getCookies());
                repExec.setStatus("ready");
                return repExec;
            }
            tgt = this.target.path("reportExecutions");
            req = HttpUtils.getRequest(tgt);
            r = this.connector.post(req, Entity.entity((Object)rer, (MediaType)this.getMediaType()), monitor);
            res = this.toObj(r, ReportExecutionDescriptor.class, monitor);
        }
        if (res != null && res.getErrorDescriptor() == null) {
            if (res.getExports() != null) {
                int i = 0;
                for (ExportDescriptor ee : res.getExports()) {
                    if (ee.getStatus().equals("queued")) continue;
                    tgt = this.target.path("reportExecutions/" + res.getRequestId() + "/exports/" + ee.getId() + "/outputResource");
                    req = ee.getOutputResource() != null ? HttpUtils.getRequest(tgt, ee.getOutputResource().getContentType()) : HttpUtils.getRequest(tgt);
                    r = this.connector.get(req, monitor);
                    if (ee.getOutputResource() == null) {
                        OutputResourceDescriptor or = new OutputResourceDescriptor();
                        or.setContentType(r.getHeaderString("Content-Type"));
                        String fname = r.getHeaderString("Content-Disposition");
                        if (fname != null) {
                            int indx = fname.indexOf("attachment; filename=");
                            if (indx >= 0) {
                                fname = fname.substring("attachment; filename=".length() + 1, fname.length() - 1);
                            }
                        } else if (or.getContentType() != null) {
                            int indx = or.getContentType().indexOf(47);
                            if (indx >= 0) {
                                fname = "file." + or.getContentType().substring(indx + 1, or.getContentType().length());
                            }
                        } else {
                            fname = "file";
                        }
                        or.setFileName(fname);
                        ee.setOutputResource(or);
                    }
                    try {
                        byte[] d = this.readFile(r, monitor);
                        this.addFileContent(d, map, ee.getOutputResource(), "attachment-" + i++, "report");
                        if (ee.getAttachments() == null) continue;
                        for (AttachmentDescriptor ror : ee.getAttachments()) {
                            tgt = this.target.path("reportExecutions/" + res.getRequestId() + "/exports/" + ee.getId() + "/attachments/" + ror.getFileName());
                            req = HttpUtils.getRequest(tgt, ror.getContentType());
                            d = this.readFile(this.connector.get(req, monitor), monitor);
                            this.addFileContent(d, map, ror, "attachment-" + i++, ror.getFileName());
                        }
                    }
                    catch (HttpResponseException e) {
                        repExec.setErrorDescriptor(new ErrorDescriptor());
                        repExec.getErrorDescriptor().setMessage(e.getMessage());
                        repExec.getErrorDescriptor().setException((Throwable)e);
                        throw e;
                    }
                }
            } else {
                tgt = this.target.path("reportExecutions/" + res.getRequestId() + "/exports/" + "JRPRINT" + "/outputResource");
                req = HttpUtils.getRequest(tgt, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                byte[] d = this.readFile(this.connector.get(req, monitor), monitor);
                FileContent content = new FileContent();
                content.setData(d);
                content.setMimeType(MediaType.APPLICATION_OCTET_STREAM_TYPE.toString());
                content.setName("attachment-0");
                map.put("jasperPrint", content);
            }
        }
        repExec.setFiles(map);
        repExec.setCurrentPage(res.getCurrentPage());
        repExec.setErrorDescriptor(res.getErrorDescriptor());
        repExec.setRequestId(res.getRequestId());
        repExec.setStatus(res.getStatus());
        repExec.setTotalPages(res.getTotalPages());
        return repExec;
    }

    @Override
    public void cancelReport(IProgressMonitor monitor, ReportExecution repExec) throws Exception {
        WebTarget tgt = this.target.path("reportExecutions/" + repExec.getRequestId() + "/status");
        Invocation.Builder req = HttpUtils.getRequest(tgt);
        this.connector.put(req, Entity.entity((Object)"<status>cancelled</status>", (MediaType)this.getMediaType()), monitor);
    }

    private void addFileContent(byte[] d, Map<String, FileContent> map, AttachmentDescriptor r, String id, String key) {
        if (d != null) {
            FileContent content = new FileContent();
            content.setData(d);
            content.setMimeType(r.getContentType());
            content.setName(Misc.nvl((Object)r.getFileName(), (String)id));
            map.put(key, content);
        }
    }

    private void addFileContent(byte[] d, Map<String, FileContent> map, OutputResourceDescriptor r, String id, String key) {
        if (d != null) {
            FileContent content = new FileContent();
            content.setData(d);
            content.setMimeType(r.getContentType());
            content.setName(Misc.nvl((Object)r.getFileName(), (String)id));
            map.put(key, content);
        }
    }

    @Override
    public List<ResourceDescriptor> listDatasources(IProgressMonitor monitor, IDatasourceFilter f) throws Exception {
        ArrayList<ResourceDescriptor> rds = new ArrayList<ResourceDescriptor>();
        WebTarget tgt = this.target.path("resources");
        if (f == null) {
            f = new DatasourcesAllFilter();
        }
        for (String type : f.getFilterTypes()) {
            tgt = tgt.queryParam("type", new Object[]{WsTypes.INST().toRestType(type)});
        }
        tgt = tgt.queryParam("sortBy", new Object[]{"label"});
        Invocation.Builder req = HttpUtils.getRequest(tgt = tgt.queryParam("limit", new Object[]{0}));
        ClientResourceListWrapper resources = this.toObj(this.connector.get(req, monitor), ClientResourceListWrapper.class, monitor);
        if (resources != null) {
            for (ClientResourceLookup crl : resources.getResourceLookups()) {
                rds.add(Rest2Soap.getRDLookup(this, crl));
            }
        }
        return rds;
    }

    @Override
    public void findResources(IProgressMonitor monitor, AFinderUI callback) throws Exception {
        if (callback.getText() == null) {
            callback.showResults(null);
            return;
        }
        WebTarget tgt = this.target.path("resources");
        tgt = tgt.queryParam("q", new Object[]{callback.getText()});
        for (String type : callback.getTypes()) {
            tgt = tgt.queryParam("type", new Object[]{type});
        }
        if (!callback.isShowHidden()) {
            tgt = tgt.queryParam("showHiddenItems", new Object[]{"false"});
        }
        tgt = tgt.queryParam("sortBy", new Object[]{"label"});
        Invocation.Builder req = HttpUtils.getRequest(tgt = tgt.queryParam("limit", new Object[]{0}));
        ClientResourceListWrapper resources = this.toObj(this.connector.get(req, monitor), ClientResourceListWrapper.class, monitor);
        callback.showResults(resources != null ? resources.getResourceLookups() : null);
    }

    @Override
    public boolean isSupported(Feature f) {
        switch (f) {
            case SEARCHREPOSITORY: 
            case UPDATEDATE: 
            case PERMISSION: 
            case TIMEZONE: 
            case DATASOURCENAME: 
            case INPUTCONTROLS_ORDERING: 
            case MAXLENGHT: 
            case IMPORTMETADATA: 
            case EXPORTMETADATA: {
                return true;
            }
        }
        return super.isSupported(f);
    }

    @Override
    public void getBundle(Map<String, String> map, String name, IProgressMonitor monitor) throws Exception {
        Invocation.Builder req = HttpUtils.getRequest(this.target.path("bundles/" + name), this.getMediaType());
        try {
            GenericType<Map<String, String>> type = new GenericType<Map<String, String>>(){};
            Map<String, String> m = this.toObj(this.connector.get(req, monitor), type, monitor);
            if (m != null) {
                map.putAll(m);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    @Override
    public List<ResourceDescriptor> getInputControls(String uri, IProgressMonitor monitor) throws Exception {
        ArrayList<ResourceDescriptor> rds = new ArrayList<ResourceDescriptor>();
        Invocation.Builder req = HttpUtils.getRequest(this.target.path("reports/" + uri.replaceFirst("/", "") + "/inputControls"));
        try {
            ReportInputControlsListWrapper m = this.toObj(this.connector.get(req, monitor), ReportInputControlsListWrapper.class, monitor);
            if (m != null) {
                for (ReportInputControl ric : m.getInputParameters()) {
                    rds.add(Rest2Soap.getInputControl(ric, new ResourceDescriptor()));
                }
            }
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, e.getMessage(), e);
        }
        return rds;
    }

    @Override
    public void reorderInputControls(String uri, List<ResourceDescriptor> rds, IProgressMonitor monitor) throws Exception {
        Invocation.Builder req = HttpUtils.getRequest(this.target.path("reports" + uri + "/inputControls"));
        Response res = this.connector.get(req, monitor);
        ReportInputControlsListWrapper crl = this.toObj(res, ReportInputControlsListWrapper.class, monitor);
        if (crl != null) {
            ArrayList<ReportInputControl> ics = new ArrayList<ReportInputControl>();
            for (ResourceDescriptor r : rds) {
                String ruri = "repo:" + r.getUriString();
                for (ReportInputControl ric : crl.getInputParameters()) {
                    if (!ruri.equals(ric.getUri())) continue;
                    ics.add(ric);
                }
            }
            ReportInputControlsListWrapper wrapper = new ReportInputControlsListWrapper(ics);
            req = HttpUtils.getRequest(this.target.path("reports" + uri + "/inputControls"));
            Response r = this.connector.put(req, Entity.entity((Object)wrapper, (MediaType)this.getMediaType()), monitor);
            this.toObj(r, ReportInputControlsListWrapper.class, monitor);
        }
    }

    @Override
    public ResourceDescriptor initInputControls(String uri, String type, IProgressMonitor monitor) throws Exception {
        uri = WSClientHelper.getReportUnitUri(uri);
        ResourceDescriptor rdunit = new ResourceDescriptor();
        rdunit.setUriString(uri);
        rdunit.setWsType(type);
        Invocation.Builder req = HttpUtils.getRequest(this.target.path("reports" + uri + "/inputControls"));
        Response r = this.connector.get(req, monitor);
        ReportInputControlsListWrapper crl = this.toObj(r, ReportInputControlsListWrapper.class, monitor);
        if (crl != null) {
            for (ReportInputControl ric : crl.getInputParameters()) {
                rdunit.getChildren().add(Rest2Soap.getInputControl(ric, new ResourceDescriptor()));
            }
            block1: for (ResourceDescriptor rd : rdunit.getChildren()) {
                if (!rd.getWsType().equals("inputControl")) continue;
                for (ReportInputControl ric : crl.getInputParameters()) {
                    InputControlState ics = ric.getState();
                    if (!ics.getId().equals(rd.getName())) continue;
                    this.setInputControlState(rd, ics);
                    continue block1;
                }
            }
        }
        return rdunit;
    }

    public void setInputControlState(ResourceDescriptor rd, InputControlState ics) {
        if (ics.getValue() != null) {
            rd.setValue(ics.getValue());
        } else if (ics.getOptions() != null) {
            if (InputControlsManager.isICQuery(rd)) {
                ArrayList<InputControlQueryDataRow> qvalues = new ArrayList<InputControlQueryDataRow>();
                for (InputControlOption ico : ics.getOptions()) {
                    InputControlQueryDataRow dr = new InputControlQueryDataRow();
                    dr.setValue(ico.getValue());
                    ArrayList<String> cols = new ArrayList<String>();
                    String[] stringArray = ico.getLabel().split("\\s\\|\\s");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        cols.add(s);
                        ++n2;
                    }
                    dr.setColumnValues(cols);
                    dr.setSelected(ico.isSelected());
                    qvalues.add(dr);
                }
                rd.setQueryData(qvalues);
            } else if (InputControlsManager.isICListOfValues(rd)) {
                ArrayList<ListItem> qvalues = new ArrayList<ListItem>();
                for (InputControlOption ico : ics.getOptions()) {
                    ListItem dr = new ListItem();
                    dr.setValue(ico.getValue());
                    dr.setLabel(ico.getLabel());
                    dr.setSelected(ico.isSelected());
                    qvalues.add(dr);
                }
                rd.setListOfValues(qvalues);
            }
        }
    }

    public ReportParameters convertInputControls(List<ResourceDescriptor> ics) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<ReportParameter> lrp = new ArrayList<ReportParameter>();
        for (ResourceDescriptor resourceDescriptor : ics) {
            Map<String, Object> icMap = resourceDescriptor.getIcValues();
            for (Map.Entry<String, Object> entry : icMap.entrySet()) {
                this.setMap(entry.getKey(), map, entry.getValue());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            ReportParameter r = new ReportParameter();
            r.setName((String)entry.getKey());
            r.setValues((List)entry.getValue());
            lrp.add(r);
        }
        return new ReportParameters(lrp);
    }

    @Override
    public List<ResourceDescriptor> cascadeInputControls(ResourceDescriptor runit, List<ResourceDescriptor> ics, IProgressMonitor monitor) throws Exception {
        if (ics.isEmpty()) {
            return ics;
        }
        StringBuilder ctrls = new StringBuilder();
        String del = "";
        for (ResourceDescriptor rd : ics) {
            ctrls.append(del).append(rd.getName());
            del = ";";
        }
        Invocation.Builder req = HttpUtils.getRequest(this.target.path("reports" + runit.getUriString() + "/inputControls/" + ctrls + "/values"));
        Response r = this.connector.post(req, Entity.entity((Object)this.convertInputControls(ics).getRawParameters(), (MediaType)this.getMediaType()), monitor);
        InputControlStateListWrapper crl = this.toObj(r, InputControlStateListWrapper.class, monitor);
        if (crl != null) {
            block1: for (ResourceDescriptor rd : ics) {
                if (!rd.getWsType().equals("inputControl")) continue;
                for (InputControlState state : crl.getInputControlStateList()) {
                    if (!state.getId().equals(rd.getName())) continue;
                    this.setInputControlState(rd, state);
                    continue block1;
                }
            }
        }
        return ics;
    }

    private void setMap(String key, Map<String, List<String>> map, Object value) {
        List<String> vals = map.get(key);
        if (vals == null) {
            vals = new ArrayList<String>();
            map.put(key, vals);
        }
        if (value instanceof Collection) {
            for (Object obj : (Collection)value) {
                String str = this.val2String(obj);
                if (vals.contains(str)) continue;
                vals.add(str);
            }
        } else {
            String str = this.val2String(value);
            if (!vals.contains(str)) {
                vals.add(str);
            }
        }
    }

    private String val2String(Object val) {
        if (val instanceof Date) {
            return this.getDateFormat().format(val);
        }
        if (val instanceof Timestamp) {
            return this.getTimestampFormat().format(val);
        }
        if (val instanceof Time) {
            return this.getTimeFormat().format(val);
        }
        return val.toString();
    }

    @Override
    public StateDto importMetaData(ImportOptions options, IProgressMonitor monitor) throws Exception {
        if (options.getState() != null) {
            WebTarget tgt = this.target.path("import/" + options.getState().getId() + "/state");
            Invocation.Builder req = HttpUtils.getRequest(tgt);
            Response r = this.connector.get(req, monitor);
            StateDto state = this.toObj(r, StateDto.class, monitor);
            options.setState(state);
        } else {
            WebTarget tgt = this.target.path("import");
            tgt = tgt.queryParam("update", new Object[]{options.isUpdate()});
            if (options.isUpdate()) {
                tgt = tgt.queryParam("skipUserUpdate", new Object[]{options.isSkipUserUpdates()});
            }
            tgt = tgt.queryParam("includeAccessEvents", new Object[]{options.isInclAccessEvents()});
            tgt = tgt.queryParam("includeAuditEvents", new Object[]{options.isInclAuditEvents()});
            tgt = tgt.queryParam("includeMonitoringEvents", new Object[]{options.isInclMonitorEvents()});
            tgt = tgt.queryParam("includeServerSettings", new Object[]{options.isInclSrvSettings()});
            File file = new File(options.getFile());
            Invocation.Builder req = HttpUtils.getRequest(tgt);
            Response r = this.connector.post(req, Entity.entity((Object)file, (String)"application/zip"), monitor);
            StateDto state = this.toObj(r, StateDto.class, monitor);
            options.setState(state);
        }
        return options.getState();
    }

    @Override
    public StateDto exportMetaData(ExportOptions options, IProgressMonitor monitor) throws Exception {
        if (options.getState() != null) {
            WebTarget tgt = this.target.path("export/" + options.getState().getId() + "/state");
            Invocation.Builder req = HttpUtils.getRequest(tgt);
            Response r = this.connector.get(req, monitor);
            StateDto state = this.toObj(r, StateDto.class, monitor);
            options.setState(state);
            if (state.getPhase().equals("finished")) {
                tgt = this.target.path("export/" + options.getState().getId() + "/export.zip");
                req = HttpUtils.getRequest(tgt);
                r = this.connector.get(req, monitor);
                monitor.subTask(String.valueOf(Messages.RestV2ConnectionJersey_175) + options.getFile());
                File file = new File(options.getFile());
                this.readFile(r, file, monitor);
            }
        } else {
            WebTarget tgt = this.target.path("export");
            ExportTaskDto taskDTO = new ExportTaskDto();
            List<String> parameters = options.getParameters();
            if (!parameters.isEmpty()) {
                taskDTO.setParameters(parameters);
            }
            if (!options.getRoles().isEmpty()) {
                taskDTO.setRoles(options.getRoles());
            }
            if (!options.getJobs().isEmpty()) {
                taskDTO.setScheduledJobs(options.getJobs());
            }
            if (!options.getUsers().isEmpty()) {
                taskDTO.setUsers(options.getUsers());
            }
            if (!options.getPaths().isEmpty()) {
                taskDTO.setUris(options.getPaths());
            }
            Invocation.Builder req = HttpUtils.getRequest(tgt);
            Response r = this.connector.post(req, Entity.entity((Object)taskDTO, (MediaType)this.getMediaType()), monitor);
            StateDto state = this.toObj(r, StateDto.class, monitor);
            options.setState(state);
        }
        return options.getState();
    }

    @Override
    public List<RepositoryPermission> getPermissions(ResourceDescriptor rd, IProgressMonitor monitor, PermissionOptions options) throws Exception {
        Invocation.Builder req;
        Response r;
        RepositoryPermissionListWrapper state;
        WebTarget tgt = this.target.path("permissions" + rd.getUriString());
        tgt = tgt.queryParam("effectivePermissions", new Object[]{options.isEffectivePermissions()});
        if (options.isResolveAll()) {
            tgt = tgt.queryParam("recipientType", new Object[]{options.isRecipientTypeUser() ? "user" : "role"});
            if (options.getRecipientId() != null) {
                tgt = tgt.queryParam("recipientId", new Object[]{options.getRecipientId()});
            }
        }
        if ((state = this.toObj(r = this.connector.get(req = HttpUtils.getRequest(tgt = tgt.queryParam("resolveAll", new Object[]{options.isResolveAll()})), monitor), RepositoryPermissionListWrapper.class, monitor)) != null) {
            if (!options.isResolveAll()) {
                ArrayList<RepositoryPermission> perms = new ArrayList<RepositoryPermission>();
                for (RepositoryPermission rp : state.getPermissions()) {
                    if (options.isRecipientTypeUser() && rp.getRecipient().startsWith("user:")) {
                        perms.add(rp);
                    }
                    if (options.isRecipientTypeUser() || !rp.getRecipient().startsWith("role:")) continue;
                    perms.add(rp);
                }
                return perms;
            }
            return state.getPermissions();
        }
        return new ArrayList<RepositoryPermission>();
    }

    @Override
    public ClientUser getUser(IProgressMonitor monitor) throws Exception {
        String path = "";
        if (!Misc.isNullOrEmpty((String)this.sp.getOrganisation())) {
            path = String.valueOf(path) + "organizations/" + this.sp.getOrganisation() + "/";
        }
        String usr = this.sp.getUser();
        if (this.sp.isUseSSO()) {
            usr = CASUtil.getSSO(this.sp, monitor).getUser();
        }
        path = String.valueOf(path) + "users/" + usr;
        WebTarget tgt = this.target.path(path);
        Invocation.Builder req = HttpUtils.getRequest(tgt);
        Response r = this.connector.get(req, monitor);
        return this.toObj(r, ClientUser.class, monitor);
    }

    @Override
    public List<RepositoryPermission> setPermissions(ResourceDescriptor rd, List<RepositoryPermission> perms, PermissionOptions options, IProgressMonitor monitor) throws Exception {
        for (RepositoryPermission rp : perms) {
            Response r;
            WebTarget tgt = this.target.path("permissions" + rd.getUriString());
            tgt = tgt.matrixParam("recipient", new Object[]{rp.getRecipient()});
            Invocation.Builder req = HttpUtils.getRequest(tgt);
            if (rp.getMask() == -1) {
                try {
                    r = this.connector.delete(req, monitor);
                    this.toObj(r, String.class, monitor);
                    continue;
                }
                catch (HttpResponseException e) {
                    if (e.getStatusCode() == 404 || e.getStatusCode() == 204) continue;
                    throw e;
                }
            }
            if (rp.getUri() == null || !rd.getUriString().equals(rp.getUri())) continue;
            r = this.connector.put(req, Entity.entity((Object)rp, (MediaType)this.getMediaType()), monitor);
            this.toObj(r, RepositoryPermission.class, monitor);
        }
        return this.getPermissions(rd, monitor, options);
    }

    protected MediaType getMediaType() {
        if (this.serverInfo != null && this.serverInfo.getVersion().compareTo("6.3") >= 0) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        return MediaType.APPLICATION_XML_TYPE;
    }
}

