/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.dto.ClientUnknown;
import com.jaspersoft.jasperserver.dto.resources.ClientAdhocDataView;
import com.jaspersoft.jasperserver.dto.resources.ClientAwsDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientBeanDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientCustomDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientDataType;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientFolder;
import com.jaspersoft.jasperserver.dto.resources.ClientInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientJndiJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientMondrianConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientMondrianXmlaDefinition;
import com.jaspersoft.jasperserver.dto.resources.ClientOlapUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientReportUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.jasperserver.dto.resources.ClientSecureMondrianConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientSemanticLayerDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientVirtualDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientXmlaConnection;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.model.datasource.filter.DatasourcesAllFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jersey.repackaged.com.google.common.collect.BiMap;
import jersey.repackaged.com.google.common.collect.HashBiMap;
import net.sf.jasperreports.eclipse.util.Misc;

public class WsTypes {
    private static WsTypes instance;
    private static final Map<String, String> restMap;
    private static final Map<ClientFile.FileType, String> restFileMap;
    private static final Map<String, String> soapMap;
    private static final Map<String, ClientFile.FileType> soapFileMap;
    private static final BiMap<String, Class<? extends ClientResource<?>>> types;
    private static List<String> tlist;
    private static final Set<String> dsTypes;
    private static final Set<String> fileTypes;
    private static final Set<Class<? extends ClientResource<?>>> containers;

    static {
        restMap = new HashMap<String, String>();
        restFileMap = new HashMap<ClientFile.FileType, String>();
        soapMap = new HashMap<String, String>();
        soapFileMap = new HashMap<String, ClientFile.FileType>();
        types = HashBiMap.create();
        dsTypes = new HashSet<String>();
        fileTypes = new HashSet<String>();
        containers = new HashSet();
        containers.add(ClientQuery.class);
        containers.add(ClientMondrianConnection.class);
        containers.add(ClientSecureMondrianConnection.class);
        containers.add(ClientMondrianXmlaDefinition.class);
        containers.add(ClientReportUnit.class);
        containers.add(ClientAdhocDataView.class);
        containers.add(ClientXmlaConnection.class);
        containers.add(ClientInputControl.class);
        containers.add(ClientOlapUnit.class);
        Activator.getExtManager().initContainers(containers);
    }

    private WsTypes() {
        this.setType(ClientFolder.class);
        this.setType(ClientReportUnit.class);
        this.setType(ClientBeanDataSource.class);
        this.setType(ClientCustomDataSource.class);
        this.setType(ClientDataType.class);
        this.setType(ClientFile.class);
        this.setType(ClientInputControl.class);
        this.setType(ClientJndiJdbcDataSource.class);
        this.setType(ClientListOfValues.class);
        this.setType(ClientMondrianXmlaDefinition.class);
        this.setType(ClientOlapUnit.class);
        this.setType(ClientVirtualDataSource.class);
        this.setType(ClientXmlaConnection.class);
        this.setType(ClientAwsDataSource.class);
        this.setType(ClientJdbcDataSource.class);
        this.setType(ClientQuery.class);
        this.setType(ClientSemanticLayerDataSource.class);
        this.setType(ClientAdhocDataView.class);
        this.setType(ClientMondrianConnection.class);
        this.setType(ClientSecureMondrianConnection.class);
        this.setType(ClientUnknown.class);
        this.setRestType("adhocDataView", "adhocDataView");
        this.setRestType("awsDataSource", "aws");
        this.setRestType("beanDataSource", "bean");
        this.setRestType("customDataSource", "custom");
        this.setRestType("dataType", "dataType");
        this.setRestType("file", "contentResource");
        this.setRestType("folder", "folder");
        this.setRestType("inputControl", "inputControl");
        this.setRestType("jdbcDataSource", "jdbc");
        this.setRestType("jndiJdbcDataSource", "jndi");
        this.setRestType("listOfValues", "lov");
        this.setRestType("mondrianConnection", "olapMondrianCon");
        this.setRestType("mondrianXmlaDefinition", "mondrianXmlaDefinition");
        this.setRestType("olapUnit", "olapUnit");
        this.setRestType("query", "query");
        this.setRestType("reportUnit", "reportUnit");
        this.setRestType("secureMondrianConnection", "secureMondrianConnection");
        this.setRestType("virtualDataSource", "virtual");
        this.setRestType("xmlaConnection", "olapXmlaCon");
        this.setSoapType("accessGrantSchema", "file");
        this.setSoapType("adhocDataView", "adhocDataView");
        this.setSoapType("adhocReport", null);
        this.setSoapType("jar", "file");
        this.setSoapType("contentResource", "file");
        this.setSoapType("dashboardState", "file");
        this.setSoapType("dashboardComponent", "file");
        this.setSoapType("dataType", "dataType");
        this.setSoapType("datasource", null);
        this.setSoapType("aws", "awsDataSource");
        this.setSoapType("bean", "beanDataSource");
        this.setSoapType("custom", "customDataSource");
        this.setSoapType("jdbc", "jdbcDataSource");
        this.setSoapType("jndi", "jndiJdbcDataSource");
        this.setSoapType("virtual", "virtualDataSource");
        this.setSoapType("folder", "folder");
        this.setSoapType("font", "file");
        this.setSoapType("img", "file");
        this.setSoapType("inputControl", "inputControl");
        this.setSoapType("jrxml", "file");
        this.setSoapType("lov", "listOfValues");
        this.setSoapType("olapMondrianSchema", "file");
        this.setSoapType("mondrianXmlaDefinition", "mondrianXmlaDefinition");
        this.setSoapType("olapMondrianCon", "mondrianConnection");
        this.setSoapType("olapXmlaCon", "xmlaConnection");
        this.setSoapType("olapUnit", "olapUnit");
        this.setSoapType("query", "query");
        this.setSoapType("reference", "file");
        this.setSoapType("reportUnit", "reportUnit");
        this.setSoapType("prop", "file");
        this.setSoapType("jrtx", "file");
        this.setSoapType("secureMondrianConnection", "secureMondrianConnection");
        this.setSoapType("unknow", "resourceLookup");
        this.setSoapType("xml", "file");
        this.setSoapType("json", "file");
        this.setSoapType("css", "file");
        this.setSoapType("secure", "file");
        this.setSoapType("cer", "file");
        this.setSoapType("dashboardComponent", "file");
        this.setSoapFileType("accessGrantSchema", ClientFile.FileType.accessGrantSchema);
        this.setSoapFileType("jar", ClientFile.FileType.jar);
        this.setSoapFileType("contentResource", ClientFile.FileType.unspecified);
        this.setSoapFileType("font", ClientFile.FileType.font);
        this.setSoapFileType("img", ClientFile.FileType.img);
        this.setSoapFileType("jrxml", ClientFile.FileType.jrxml);
        this.setSoapFileType("olapMondrianSchema", ClientFile.FileType.olapMondrianSchema);
        this.setSoapFileType("prop", ClientFile.FileType.prop);
        this.setSoapFileType("jrtx", ClientFile.FileType.jrtx);
        this.setSoapFileType("xml", ClientFile.FileType.xml);
        this.setSoapFileType("css", ClientFile.FileType.css);
        this.setSoapFileType("json", ClientFile.FileType.json);
        this.setSoapFileType("secure", ClientFile.FileType.secureFile);
        this.setSoapFileType("cer", ClientFile.FileType.cer);
        this.setSoapFileType("dashboardComponent", ClientFile.FileType.dashboardComponent);
        this.setRestFileType(ClientFile.FileType.accessGrantSchema, "accessGrantSchema");
        this.setRestFileType(ClientFile.FileType.css, "css");
        this.setRestFileType(ClientFile.FileType.csv, "contentResource");
        this.setRestFileType(ClientFile.FileType.dashboardComponent, "dashboardComponent");
        this.setRestFileType(ClientFile.FileType.docx, "contentResource");
        this.setRestFileType(ClientFile.FileType.font, "font");
        this.setRestFileType(ClientFile.FileType.html, "contentResource");
        this.setRestFileType(ClientFile.FileType.img, "img");
        this.setRestFileType(ClientFile.FileType.jar, "jar");
        this.setRestFileType(ClientFile.FileType.jrtx, "jrtx");
        this.setRestFileType(ClientFile.FileType.jrxml, "jrxml");
        this.setRestFileType(ClientFile.FileType.ods, "contentResource");
        this.setRestFileType(ClientFile.FileType.odt, "contentResource");
        this.setRestFileType(ClientFile.FileType.olapMondrianSchema, "olapMondrianSchema");
        this.setRestFileType(ClientFile.FileType.pdf, "contentResource");
        this.setRestFileType(ClientFile.FileType.pptx, "contentResource");
        this.setRestFileType(ClientFile.FileType.prop, "prop");
        this.setRestFileType(ClientFile.FileType.rtf, "contentResource");
        this.setRestFileType(ClientFile.FileType.txt, "contentResource");
        this.setRestFileType(ClientFile.FileType.unspecified, "contentResource");
        this.setRestFileType(ClientFile.FileType.xls, "contentResource");
        this.setRestFileType(ClientFile.FileType.xlsx, "contentResource");
        this.setRestFileType(ClientFile.FileType.xml, "xml");
        this.setRestFileType(ClientFile.FileType.json, "json");
        this.setRestFileType(ClientFile.FileType.secureFile, "secure");
        this.setRestFileType(ClientFile.FileType.cer, "cer");
        Activator.getExtManager().initWsTypes(this);
    }

    public static ClientFile.FileType getFileType(ClientFile.FileType ftype, String ext) {
        ext = ext.toLowerCase();
        switch (ftype) {
            case accessGrantSchema: 
            case olapMondrianSchema: {
                return ftype;
            }
        }
        try {
            return ClientFile.FileType.valueOf((String)ext);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (ext.equals("properties")) {
                return ClientFile.FileType.prop;
            }
            if (ext.equals("xhtml") || ext.equals("htm")) {
                return ClientFile.FileType.html;
            }
            if (ext.equals("ttf") || ext.equals("eot") || ext.equals("woff") || ext.equals("svg")) {
                return ClientFile.FileType.font;
            }
            if (ext.equals("png") || ext.equals("gif") || ext.equals("jpg") || ext.equals("jpeg") || ext.equals("bmp") || ext.equals("tiff")) {
                return ClientFile.FileType.img;
            }
            return ClientFile.FileType.unspecified;
        }
    }

    public static WsTypes INST() {
        if (instance == null) {
            instance = new WsTypes();
        }
        return instance;
    }

    public void setRestType(String stype, String rtype) {
        restMap.put(stype, rtype);
    }

    public void setRestFileType(ClientFile.FileType rtype, String stype) {
        restFileMap.put(rtype, stype);
    }

    public String toSoapFileType(ClientFile.FileType ftype) {
        return restFileMap.get(ftype);
    }

    public String toSoapType(String rtype) {
        return Misc.nvl((Object)restMap.get(rtype), (String)"unknow");
    }

    public String toSoapType(ClientResource<?> cr) {
        if (cr instanceof ClientResourceLookup) {
            return this.toSoapType(((ClientResourceLookup)cr).getResourceType());
        }
        if (cr instanceof ClientFile) {
            return this.toSoapFileType(((ClientFile)cr).getType());
        }
        return this.toSoapType((String)types.inverse().get(cr.getClass()));
    }

    public void setSoapType(String stype, String rtype) {
        soapMap.put(stype, rtype);
    }

    public void setSoapFileType(String stype, ClientFile.FileType rtype) {
        soapFileMap.put(stype, rtype);
    }

    public ClientFile.FileType toRestFileType(String stype) {
        return (ClientFile.FileType)Misc.nvl((Object)soapFileMap.get(stype), (Object)ClientFile.FileType.unspecified);
    }

    public Map<String, ClientFile.FileType> getSoapfileMap() {
        return soapFileMap;
    }

    public String toRestType(String stype) {
        return Misc.nvl((Object)soapMap.get(stype), (String)stype);
    }

    public void setType(Class<? extends ClientResource<?>> type) {
        types.put((Object)WsTypes.getType(type), type);
    }

    public static List<String> getRestTypes() {
        if (tlist == null) {
            tlist = new ArrayList<String>(types.keySet());
        }
        return tlist;
    }

    public Class<? extends ClientResource<?>> getType(String type) {
        return (Class)types.get((Object)type);
    }

    public String getRestType(ClientResource<?> clazz) {
        return (String)types.inverse().get(clazz.getClass());
    }

    private static String getType(Class<? extends ClientResource<?>> clientObjectClass) {
        String clientResourceType = null;
        XmlRootElement xmlRootElement = clientObjectClass.getAnnotation(XmlRootElement.class);
        if (xmlRootElement != null && !"##default".equals(xmlRootElement.name())) {
            clientResourceType = xmlRootElement.name();
        } else {
            XmlType xmlType = clientObjectClass.getAnnotation(XmlType.class);
            if (xmlType != null && !"##default".equals(xmlType.name())) {
                clientResourceType = xmlType.name();
            }
        }
        if (clientResourceType == null) {
            String classSimpleName = clientObjectClass.getSimpleName();
            clientResourceType = classSimpleName.replaceFirst("^.", classSimpleName.substring(0, 1).toLowerCase());
        }
        return clientResourceType;
    }

    public ClientResource<?> createResource(ResourceDescriptor rd) {
        ClientResource cr = null;
        Class clazz = (Class)types.get((Object)this.toRestType(rd.getWsType()));
        try {
            cr = (ClientResource)clazz.newInstance();
            if (cr instanceof ClientFile) {
                ((ClientFile)cr).setType(this.toRestFileType(rd.getWsType()));
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        if (cr == null) {
            cr = new ClientUnknown();
        }
        return cr;
    }

    public Set<String> getDatasources() {
        if (dsTypes.isEmpty()) {
            for (String s : DatasourcesAllFilter.getTypes()) {
                dsTypes.add(WsTypes.INST().toRestType(s));
            }
        }
        return dsTypes;
    }

    public Set<String> getFileTypes() {
        if (fileTypes.isEmpty()) {
            ClientFile.FileType[] fileTypeArray = ClientFile.FileType.values();
            int n = fileTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClientFile.FileType s = fileTypeArray[n2];
                fileTypes.add(s.name());
                ++n2;
            }
        }
        return fileTypes;
    }

    public String[] getDatasourcesArray() {
        return this.getDatasources().toArray(new String[dsTypes.size()]);
    }

    public boolean isContainerType(Class<?> cr) {
        return containers.contains(cr);
    }
}

