/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.property.descriptor.resource.ResourceBundlePropertyDescriptor;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMJrxmlContainer;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.MInputControl;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.MResourceBundle;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.publish.OverwriteEnum;
import com.jaspersoft.studio.server.publish.PublishOptions;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.publish.ResourcePublishMethod;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorDatasource;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.client.HttpResponseException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Publish {
    private JasperReportsConfiguration jrConfig;
    private List<String> resources = new ArrayList<String>();

    public Publish(JasperReportsConfiguration jrConfig) {
        this.jrConfig = jrConfig;
    }

    public IStatus publish(AMJrxmlContainer node, JasperDesign jd, IProgressMonitor monitor) {
        try {
            boolean isNewRU = node instanceof MReportUnit && node.getValue().getIsNew();
            this.publishResources(monitor, jd, node);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (isNewRU) {
                JaspersoftStudioPlugin.getInstance().getUsageManager().audit("PublishedReport", "JasperServer");
            }
            StringBuilder str = new StringBuilder(Messages.Publish_0);
            for (String mres : this.resources) {
                str.append(mres).append("\n");
            }
            UIUtils.showInformation((String)str.toString());
            this.jrConfig.get("PUBLISH2JSS_DATA");
            this.jrConfig.remove("PUBLISH2JSS_DATA");
            if (node instanceof MJrxml) {
                this.postProcessLocal((MJrxml)node);
            } else if (node instanceof MReportUnit) {
                for (INode n : node.getChildren()) {
                    if (!(n instanceof MJrxml)) continue;
                    this.postProcessLocal((MJrxml)n);
                    break;
                }
            }
            ServerManager.selectIfExists(monitor, node);
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private IStatus publishResources(IProgressMonitor monitor, JasperDesign jd, AMJrxmlContainer parent) throws Exception {
        MReportUnit mrunit = null;
        MJrxml jrxml = null;
        if (parent instanceof MReportUnit) {
            mrunit = (MReportUnit)parent;
            jrxml = new MJrxml((ANode)mrunit, PublishUtil.getMainReport(monitor, mrunit, jd, this.jrConfig), 0);
        } else if (parent.getParent() instanceof MReportUnit) {
            jrxml = (MJrxml)parent;
            mrunit = (MReportUnit)parent.getParent();
        } else if (parent.getParent() instanceof MFolder) {
            jrxml = (MJrxml)parent;
        } else {
            return Status.CANCEL_STATUS;
        }
        File file = FileUtils.createTempFile((String)"jrsres", (String)".jrxml");
        String version = ServerManager.getVersion((ANode)Misc.nvl((Object)mrunit, (Object)((Object)jrxml)));
        ResourceDescriptor rdjrxml = jrxml.getValue();
        if (rdjrxml.getParentFolder() != null && !rdjrxml.getParentFolder().endsWith("_files")) {
            rdjrxml.setIsReference(true);
        }
        List rs = (List)this.jrConfig.get("PUBLISH2JSS_DATA", new ArrayList());
        this.updSelectedResources(monitor, rs, version, jd);
        FileUtils.writeFile((File)file, (String)JRXmlWriterHelper.writeReport((JasperReportsContext)this.jrConfig, (JRReport)jd, (String)version));
        jrxml.setFile(file);
        IFile ifile = (IFile)this.jrConfig.get("ifile");
        PublishUtil.savePreferences(ifile, rs);
        if (mrunit != null && !jrxml.getValue().getIsReference()) {
            ResourceDescriptor oldRU = mrunit.getValue();
            ResourceDescriptor r = mrunit.getValue();
            String oldType = r.getWsType();
            try {
                r = mrunit.getWsClient().get(monitor, mrunit.getValue(), null);
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() != 404) {
                    throw e;
                }
            }
            catch (Exception exception) {}
            if (!r.getWsType().equals(oldType)) {
                throw new Exception("This Resource ID is already used by another resource type. Please rename it.");
            }
            mrunit.setValue(r);
            ResourceDescriptor ds = null;
            for (ResourceDescriptor rd : oldRU.getChildren()) {
                if (rd == null || !SelectorDatasource.isDatasource(rd)) continue;
                ds = rd;
                ds.setDirty(false);
                break;
            }
            ResourceDescriptor newDs = null;
            for (ResourceDescriptor rd : r.getChildren()) {
                if (rd == null || !SelectorDatasource.isDatasource(rd)) continue;
                newDs = rd;
                break;
            }
            if (newDs != null) {
                r.getChildren().remove(newDs);
            }
            if (ds != null) {
                r.getChildren().add(0, ds);
            }
            boolean isMain = true;
            for (ResourceDescriptor rd : r.getChildren()) {
                if (rd.getUriString() == null) continue;
                String wsType = rd.getWsType();
                if (!rd.getUriString().equals(rdjrxml.getUriString()) || !wsType.equals("jrxml") && !wsType.equals("reference")) continue;
                isMain = rd.isMainReport();
                break;
            }
            rdjrxml.setMainReport(isMain);
            PublishUtil.setChild(r, rdjrxml);
            for (AMResource res : rs) {
                if (!res.getPublishOptions().getOverwrite(OverwriteEnum.IGNORE).equals((Object)OverwriteEnum.OVERWRITE)) continue;
                ResourceDescriptor rd = res.getValue();
                if (rd.getData() != null && !rd.getParentFolder().endsWith("_files")) {
                    mrunit.getWsClient().addOrModifyResource(monitor, rd, null);
                    continue;
                }
                PublishUtil.setChild(r, rd);
            }
            if (!mrunit.getWsClient().isSupported(Feature.SEARCHREPOSITORY) && !isMain) {
                mrunit.getWsClient().modifyReportUnitResource(monitor, r, rdjrxml, file);
            } else {
                mrunit.getWsClient().addOrModifyResource(monitor, r, file);
            }
            this.resources.add(r.getUriString());
            for (AMResource res : rs) {
                if (!res.getPublishOptions().getOverwrite(OverwriteEnum.IGNORE).equals((Object)OverwriteEnum.OVERWRITE)) continue;
                PublishUtil.savePreferencesNoOverwrite(ifile, res);
                this.resources.add(res.getValue().getUriString());
            }
        } else {
            jrxml.setValue(this.saveResource(monitor, jrxml));
            for (AMResource res : rs) {
                PublishOptions popt = res.getPublishOptions();
                if (popt.getOverwrite(OverwriteEnum.IGNORE).equals((Object)OverwriteEnum.OVERWRITE)) {
                    this.saveResource(monitor, res);
                    PublishUtil.savePreferencesNoOverwrite(ifile, res);
                }
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    protected void updSelectedResources(IProgressMonitor monitor, List<AMResource> files, String version, JasperDesign jd) throws IOException, Exception {
        ArrayList<MJrxml> toSave = new ArrayList<MJrxml>();
        for (AMResource res : files) {
            ResourceDescriptor rd;
            PublishOptions popt = res.getPublishOptions();
            if (popt.getOverwrite(OverwriteEnum.IGNORE).equals((Object)OverwriteEnum.IGNORE)) continue;
            if (popt.getValueSetter() != null) {
                popt.getValueSetter().setup();
            } else if (popt.getjExpression() != null) {
                if (popt.getOverwrite(OverwriteEnum.IGNORE).equals((Object)OverwriteEnum.ONLY_EXPRESSION)) {
                    for (JRDesignExpression exp : popt.getjExpression()) {
                        exp.setText(popt.getExpression());
                    }
                }
                if (popt.getPublishMethod() == ResourcePublishMethod.REWRITEEXPRESSION) {
                    for (JRDesignExpression exp : popt.getjExpression()) {
                        exp.setText(popt.getRepoExpression());
                    }
                } else if (popt.getPublishMethod() == ResourcePublishMethod.LOCAL) {
                    for (JRDesignExpression exp : popt.getjExpression()) {
                        exp.setText(popt.getExpression());
                    }
                }
            } else if (popt.getDataset() != null) {
                String dauri = res.getValue().getUriString();
                if (popt.getPublishMethod() != null) {
                    if (popt.getPublishMethod() == ResourcePublishMethod.REFERENCE) {
                        dauri = popt.getReferencedResource().getUriString();
                    } else if (popt.getPublishMethod() == ResourcePublishMethod.RESOURCE) {
                        if (popt.getReferencedResource() == null) continue;
                        ResourceDescriptor rd2 = res.getValue();
                        dauri = String.valueOf(popt.getReferencedResource().getUriString()) + rd2.getName();
                    }
                }
                popt.getDataset().setProperty("net.sf.jasperreports.data.adapter", "repo:" + dauri);
            }
            if (popt.getPublishMethod() == null) continue;
            if (popt.getPublishMethod() == ResourcePublishMethod.REFERENCE) {
                rd = res.getValue();
                ResourceDescriptor ref = new ResourceDescriptor();
                ref.setName(rd.getName());
                ref.setIsNew(true);
                ref.setLabel(rd.getLabel());
                ref.setDescription(rd.getDescription());
                ref.setIsReference(true);
                ref.setReferenceUri(popt.getReferencedResource().getUriString());
                ref.setParentFolder(rd.getParentFolder());
                ref.setUriString(rd.getUriString());
                ref.setWsType(rd.getWsType());
                res.setValue(ref);
                if (!(res instanceof MResourceBundle)) continue;
                this.setupResourceBundle(jd, res.getValue().getUriString());
                continue;
            }
            if (popt.getPublishMethod() == ResourcePublishMethod.RESOURCE) {
                if (popt.getReferencedResource() == null) continue;
                rd = res.getValue();
                rd.setParentFolder(popt.getReferencedResource().getUriString());
                rd.setUriString(String.valueOf(rd.getParentFolder()) + "/" + rd.getName());
                ResourceDescriptor r = res.getWsClient().addOrModifyResource(monitor, rd, res instanceof AFileResource ? ((AFileResource)res).getFile() : null);
                ResourceDescriptor ref = new ResourceDescriptor();
                ref.setName(rd.getName());
                ref.setIsNew(true);
                ref.setLabel(rd.getLabel());
                ref.setDescription(rd.getDescription());
                ref.setIsReference(true);
                ref.setReferenceUri(r.getUriString());
                ref.setParentFolder(rd.getParentFolder());
                ref.setUriString(r.getUriString());
                ref.setWsType(rd.getWsType());
                res.setValue(ref);
                if (!(res instanceof MResourceBundle)) continue;
                this.setupResourceBundle(jd, res.getValue().getUriString());
                continue;
            }
            if (popt.getPublishMethod() == ResourcePublishMethod.LOCAL && res instanceof MResourceBundle) {
                this.setupResourceBundle(jd, res.getValue().getName());
                continue;
            }
            if (popt.getPublishMethod() == ResourcePublishMethod.REWRITEEXPRESSION || !(res instanceof MJrxml)) continue;
            toSave.add((MJrxml)res);
        }
        for (MJrxml mjrxml : toSave) {
            String rp;
            if (mjrxml.getJd() == null) continue;
            if (mjrxml.getValue().isMainReport()) {
                this.createICProperties(mjrxml.getJd(), files);
            }
            if ((rp = JRXmlWriterHelper.writeReport((JasperReportsContext)this.jrConfig, (JRReport)mjrxml.getJd(), (String)version)) == null) continue;
            mjrxml.getValue().setData(Base64.encodeBase64((byte[])rp.getBytes()));
            FileUtils.writeFile((File)mjrxml.getFile(), (String)rp);
        }
    }

    private void setupResourceBundle(JasperDesign jd, String ruri) {
        String prefix = "";
        if ((ruri = FilenameUtils.separatorsToUnix((String)ruri)).contains("/")) {
            int indx = ruri.lastIndexOf("/");
            prefix = ruri.substring(0, indx);
            ruri = ruri.substring(indx);
        }
        if (ruri.endsWith(".properties")) {
            ruri = ResourceBundlePropertyDescriptor.convertFile2Value((String)ruri);
        }
        jd.setResourceBundle((String.valueOf(prefix) + ruri).replaceAll(".properties$", ""));
    }

    private void createICProperties(JasperDesign jd, List<?> files) {
        for (Object mres : files) {
            JRDesignParameter p;
            MInputControl mic;
            if (!(mres instanceof MInputControl) || (mic = (MInputControl)((Object)mres)).getPublishOptions().getOverwrite(OverwriteEnum.IGNORE).equals((Object)OverwriteEnum.IGNORE) || (p = (JRDesignParameter)jd.getParametersMap().get(mic.getValue().getName())) == null) continue;
            p.getPropertiesMap().setProperty("com.jaspersoft.studio.js.ic.path", mic.getValue().getUriString());
        }
    }

    private ResourceDescriptor saveResource(IProgressMonitor monitor, AMResource mres) throws Exception {
        String uri = mres.getValue().getUriString();
        ResourceDescriptor rd = WSClientHelper.save(monitor, mres);
        if (rd != null) {
            this.resources.add(Misc.nvl((Object)uri, (String)rd.getUriString()));
        }
        return rd;
    }

    private void postProcessLocal(MJrxml node) {
        UIUtils.getDisplay().syncExec(() -> {
            ResourceDescriptor rd;
            JasperDesign rpt = this.jrConfig.getJasperDesign();
            INode n = node.getRoot();
            if (n != null && n instanceof MServerProfile) {
                MServerProfile server = (MServerProfile)n;
                ServerProfile v = server.getValue();
                try {
                    rpt.setProperty("ireport.jasperserver.url", v.getUrl());
                }
                catch (MalformedURLException | URISyntaxException e) {
                    UIUtils.showError((Throwable)e);
                }
                rpt.setProperty("ireport.jasperserver.user", AExporter.encodeUsr(v));
            }
            if ((rd = node.getValue()).getWsType().equals("reportUnit")) {
                for (ResourceDescriptor r : rd.getChildren()) {
                    if (!r.getWsType().equals("jrxml")) continue;
                    rd = r;
                    break;
                }
                this.createICProperties(rpt, node.getChildren());
            }
            rpt.setProperty("ireport.jasperserver.report.resource", rd.getUriString());
            if (node.getParent() instanceof MReportUnit) {
                MReportUnit mrunit = (MReportUnit)node.getParent();
                rpt.setProperty("ireport.jasperserver.reportUnit", mrunit.getValue().getUriString());
            }
            try {
                IFile iFile = (IFile)this.jrConfig.get("ifile");
                AExporter.setServerLocation(node, iFile);
                PublishUtil.savePath(iFile, node);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        });
    }
}

