/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.export.JrxmlExporter;
import com.jaspersoft.studio.server.model.AMJrxmlContainer;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MInputControl;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.preferences.JRSPreferencesPage;
import com.jaspersoft.studio.server.publish.OverwriteEnum;
import com.jaspersoft.studio.server.publish.PublishOptions;
import com.jaspersoft.studio.server.publish.ResourcePublishMethod;
import com.jaspersoft.studio.server.utils.RDUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.validator.IDStringValidator;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class PublishUtil {
    public static final String KEY_PUBLISH2JSS_DATA = "PUBLISH2JSS_DATA";

    public static List<AMResource> getResources(AMResource parent, IProgressMonitor monitor, JasperReportsConfiguration jrConfig) {
        List resources = (List)jrConfig.get(KEY_PUBLISH2JSS_DATA);
        if (resources == null) {
            jrConfig.put(KEY_PUBLISH2JSS_DATA, new ArrayList());
        }
        PublishUtil.loadPreferences(parent, monitor, (IFile)jrConfig.get("ifile"), resources);
        return resources;
    }

    public static ResourceDescriptor getMainReport(IProgressMonitor monitor, MReportUnit mrunit, JasperDesign jd, JasperReportsConfiguration jConfig) {
        MServerProfile sp;
        String jrxmln = jd.getProperty("ireport.jasperserver.report.resource");
        String unit = mrunit.getValue().getUriString();
        if (jrxmln != null && unit != null && jrxmln.startsWith(unit) && jrxmln.length() > unit.length() && jrxmln.substring((String.valueOf(unit) + "_files/").length()).indexOf(47) < 0 && (sp = (MServerProfile)mrunit.getRoot()) != null) {
            ResourceDescriptor rd = new ResourceDescriptor();
            rd.setName(jrxmln.substring((String.valueOf(unit) + "_files/").length()));
            rd.setLabel(IDStringValidator.safeChar((String)rd.getName()));
            String d = jd.getProperty("com.jaspersoft.studio.report.description");
            if (!Misc.isNullOrEmpty((String)d)) {
                rd.setDescription(d);
            }
            rd.setUriString(jrxmln);
            rd.setParentFolder(String.valueOf(unit) + "_files");
            rd.setUriString(String.valueOf(rd.getParentFolder()) + "/" + rd.getName());
            rd.setIsNew(true);
            rd.setWsType("jrxml");
            rd.setIsReference(false);
            rd.setHasData(true);
            try {
                rd = sp.getWsClient(monitor).get(monitor, rd, null);
                rd.setHasData(true);
                return rd;
            }
            catch (Exception exception) {
                rd.setMainReport(true);
                return rd;
            }
        }
        ResourceDescriptor mainr = new ResourceDescriptor();
        mainr.setName(JRSPreferencesPage.getDefaultMainReportName(jConfig));
        mainr.setLabel(JRSPreferencesPage.getDefaultMainReportLabel(jConfig));
        String d = jd.getProperty("com.jaspersoft.studio.report.description");
        if (!Misc.isNullOrEmpty((String)d)) {
            mainr.setDescription(d);
        }
        mainr.setWsType("jrxml");
        mainr.setIsNew(true);
        mainr.setMainReport(true);
        mainr.setIsReference(false);
        mainr.setHasData(true);
        mainr.setParentFolder(String.valueOf(unit) + "_files");
        mainr.setUriString(String.valueOf(mainr.getParentFolder()) + "/" + mainr.getName());
        return mainr;
    }

    public static void initRUnitName(AMJrxmlContainer runit, JasperDesign jd, JasperReportsConfiguration jConf) {
        if (runit == null || jd == null) {
            return;
        }
        String name = PublishUtil.getRUnitNAme(jd, jConf);
        PublishUtil.initResourceName(name, runit.getValue());
        if (Misc.isNullOrEmpty((String)runit.getValue().getDescription())) {
            String d = jd.getProperty("com.jaspersoft.studio.report.description");
            if (!Misc.isNullOrEmpty((String)d)) {
                runit.getValue().setDescription(d);
            }
            if (runit instanceof MReportUnit && !Misc.isNullOrEmpty((String)(d = jd.getProperty("com.jaspersoft.studio.report.unit.description")))) {
                runit.getValue().setDescription(d);
            }
        }
    }

    public static String getRUnitNAme(JasperDesign jd, JasperReportsConfiguration jConf) {
        String name = jd.getName();
        IFile f = (IFile)jConf.get("ifile");
        if (f != null) {
            name = f.getName();
            if (!Misc.isNullOrEmpty((String)f.getFileExtension())) {
                name = name.substring(0, name.length() - f.getFileExtension().length() - 1);
            }
        }
        return name;
    }

    public static void setChild(ResourceDescriptor rd, ResourceDescriptor child) {
        List<ResourceDescriptor> children = rd.getChildren();
        int i = 0;
        while (i < children.size()) {
            ResourceDescriptor r = children.get(i);
            if (r.isMainReport() && child.isMainReport()) {
                child.setName(r.getName());
                child.setLabel(r.getLabel());
                child.setDescription(r.getDescription());
                child.setUriString(r.getUriString());
                children.set(i, child);
                return;
            }
            if (child.getUriString() == null && r.getUriString() == null && child.getWsType().equals(r.getWsType()) || r.getUriString() != null && r.getUriString().equals(child.getUriString())) {
                if (r.isMainReport()) {
                    child.setMainReport(true);
                }
                children.set(i, child);
                return;
            }
            ++i;
        }
        children.add(child);
    }

    public static void initResourceName(String name, ResourceDescriptor rd) {
        if (Misc.isNullOrEmpty((String)rd.getName())) {
            rd.setName(IDStringValidator.safeChar((String)name));
        }
        if (Misc.isNullOrEmpty((String)rd.getLabel())) {
            rd.setLabel(name);
        }
    }

    public static void savePreferences(IFile ifile, List<AMResource> files) throws CoreException {
        Map pmap = ifile.getPersistentProperties();
        for (QualifiedName key : pmap.keySet()) {
            if (key.equals((Object)JrxmlExporter.KEY_REPORT_ISMAIN)) continue;
            ifile.setPersistentProperty(key, null);
        }
        for (AMResource f : files) {
            PublishOptions popt = f.getPublishOptions();
            String prefix = f.getValue().getName();
            OverwriteEnum ovw = popt.getOverwrite();
            if (ovw == null) {
                ovw = OverwriteEnum.IGNORE;
            } else if (!ovw.equals((Object)OverwriteEnum.IGNORE) && ovw.equals((Object)OverwriteEnum.OVERWRITE)) {
                ovw = OverwriteEnum.IGNORE;
            }
            ifile.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", String.valueOf(prefix) + ".overwrite"), ovw.getValue());
            if (ovw.equals((Object)OverwriteEnum.ONLY_EXPRESSION)) {
                ifile.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", String.valueOf(prefix) + ".expression"), popt.getExpression());
                continue;
            }
            ifile.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", String.valueOf(prefix) + ".reference"), popt.getPublishMethod().toString());
            if (popt.getReferencedResource() != null) {
                ifile.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", String.valueOf(prefix) + ".refPATH"), popt.getReferencedResource().getUriString());
                continue;
            }
            ifile.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", String.valueOf(prefix) + ".refPATH"), null);
        }
    }

    public static void savePreferencesNoOverwrite(IFile ifile, AMResource f) throws CoreException {
        if (f instanceof MInputControl) {
            String prefix = f.getValue().getName();
            ifile.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", String.valueOf(prefix) + ".overwrite"), Boolean.toString(false));
        }
    }

    public static void loadPreferences(AMResource parent, IProgressMonitor monitor, IFile ifile, List<AMResource> files) {
        if (parent == null || parent.getValue() == null || parent.getValue().getIsNew()) {
            return;
        }
        for (AMResource f : files) {
            PublishUtil.loadPreferences(monitor, ifile, f);
        }
    }

    public static boolean loadPreferences(IProgressMonitor monitor, IFile ifile, AMResource f) {
        boolean exists = false;
        PublishOptions popt = f.getPublishOptions();
        String prefix = f.getValue().getName();
        try {
            String ovw = ifile.getPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", String.valueOf(prefix) + ".overwrite"));
            if (ovw != null) {
                exists = true;
                popt.setOverwrite(OverwriteEnum.getByValue(ovw));
                if (ovw.equals(OverwriteEnum.ONLY_EXPRESSION.getValue())) {
                    String exp = ifile.getPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", String.valueOf(prefix) + ".expression"));
                    if (exp != null) {
                        popt.setExpression(exp);
                    }
                } else {
                    String ref = ifile.getPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", String.valueOf(prefix) + ".reference"));
                    if (ref != null) {
                        popt.setPublishMethod(ResourcePublishMethod.valueOf(ref));
                        String path = ifile.getPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", String.valueOf(prefix) + ".refPATH"));
                        if (path != null) {
                            ResourceDescriptor rd = new ResourceDescriptor();
                            rd.setParentFolder(RDUtil.getParentFolder(path));
                            rd.setUriString(path);
                            rd.setWsType(f.getValue().getWsType());
                            popt.setReferencedResource(WSClientHelper.getResource(monitor, (ANode)f, rd, FileUtils.createTempFile((String)"tmp", (String)"")));
                        } else {
                            popt.setPublishMethod(ResourcePublishMethod.LOCAL);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            popt.setPublishMethod(ResourcePublishMethod.LOCAL);
            e.printStackTrace();
        }
        return exists;
    }

    public static List<String[]> loadPath(IProgressMonitor monitor, IFile ifile) throws CoreException {
        ArrayList<String[]> paths = new ArrayList<String[]>();
        Map pmap = ifile.getPersistentProperties();
        int substr = "JRSPATH.".length();
        for (Map.Entry entry : pmap.entrySet()) {
            String lname = ((QualifiedName)entry.getKey()).getLocalName();
            if (((QualifiedName)entry.getKey()).getQualifier().equals("com.jaspersoft.studio.server") && lname.startsWith("JRSPATH.")) {
                paths.add(new String[]{lname.substring(substr), (String)entry.getValue()});
            }
            if (!((QualifiedName)entry.getKey()).getQualifier().equals("com.jaspersoft.studio.server") || !lname.startsWith("JRSUSER.")) continue;
            paths.add(new String[]{lname, (String)entry.getValue()});
        }
        return paths;
    }

    public static void savePath(IFile ifile, AMResource mres) throws CoreException {
        ServerProfile sp = mres.getWsClient().getServerProfile();
        try {
            String jrs = sp.getUrl();
            String user = sp.getUser();
            if (!Misc.isNullOrEmpty((String)sp.getOrganisation())) {
                user = String.valueOf(user) + "|" + sp.getOrganisation();
            }
            String uri = mres.getValue().getUriString();
            ifile.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", "JRSPATH." + jrs), uri);
            ifile.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", "JRSUSER." + user), user);
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

