/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.action;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.properties.dialog.RepositoryDialog;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.restv2.WsTypes;
import com.jaspersoft.studio.server.publish.ResourcePublishMethod;
import com.jaspersoft.studio.server.wizard.find.FindResourceJob;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;

public class ResourceExpressionAction
extends Action {
    private AMResource mres;
    private TableViewer tableViewer;

    public ResourceExpressionAction(TableViewer tableViewer) {
        this.setText(Messages.ResourceExpressionAction_0);
        this.tableViewer = tableViewer;
    }

    public boolean calculateEnabled(AMResource mres) {
        this.mres = mres;
        return mres.getPublishOptions().getjExpression() != null && mres.getPublishOptions().getPublishMethod() != ResourcePublishMethod.REWRITEEXPRESSION;
    }

    public void run() {
        MServerProfile msp = ServerManager.getMServerProfileCopy((MServerProfile)this.mres.getRoot());
        if (this.mres.isSupported(Feature.SEARCHREPOSITORY)) {
            ResourceDescriptor rd = FindResourceJob.doFindResource(msp, new String[]{WsTypes.INST().toRestType(this.mres.getValue().getWsType())}, null);
            if (rd != null) {
                this.mres.getPublishOptions().setReferencedResource(rd);
                this.mres.getPublishOptions().setPublishMethod(ResourcePublishMethod.REWRITEEXPRESSION);
            }
        } else {
            RepositoryDialog rd = new RepositoryDialog(UIUtils.getShell(), (INode)msp){

                @Override
                public boolean isResourceCompatible(AMResource r) {
                    return r.getValue().getWsType().equals(ResourceExpressionAction.this.mres.getValue().getWsType());
                }
            };
            if (rd.open() == 0) {
                AMResource rs = rd.getResource();
                this.mres.getPublishOptions().setReferencedResource(rs.getValue());
                this.mres.getPublishOptions().setPublishMethod(ResourcePublishMethod.REWRITEEXPRESSION);
            }
        }
        this.tableViewer.refresh();
    }
}

