/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.wizard.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.datasource.MRDatasource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.properties.dialog.RepositoryDialog;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.restv2.WsTypes;
import com.jaspersoft.studio.server.publish.wizard.page.DatasourceSelectionListener;
import com.jaspersoft.studio.server.wizard.find.FindResourceJob;
import com.jaspersoft.studio.server.wizard.resource.AddResourceWizard;
import com.jaspersoft.studio.server.wizard.resource.ResourceWizard;
import com.jaspersoft.studio.server.wizard.resource.page.selector.ASelector;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorDatasource;
import com.jaspersoft.studio.utils.inputhistory.InputHistoryCache;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DatasourceSelectionComposite
extends Composite {
    protected boolean mandatory = false;
    private AMResource res;
    private ANode pnode;
    private Text textLocalDS;
    private Text textDSFromRepo;
    private Button btnSelectDSFromRepo;
    private Button btnSelectLocalDS;
    private Button rbDSFromRepo;
    private Button rbLocalDS;
    private Button rbNoDS;
    private List<DatasourceSelectionListener> dsListeners;
    private boolean isConfiguringPage;
    private String[] excludeTypes;
    private boolean valid = true;
    private boolean refresh = false;

    public void setExcludeTypes(String[] excludeTypes) {
        this.excludeTypes = excludeTypes;
    }

    public DatasourceSelectionComposite(Composite parent, int style, boolean mandatory, String[] excludeTypes) {
        super(parent, style);
        this.mandatory = mandatory;
        this.excludeTypes = excludeTypes;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.rbDSFromRepo = new Button((Composite)this, 16);
        this.rbDSFromRepo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasourceSelectionComposite.this.setEnabled(SelectorDatasource.SelectionType.REMOTE_DATASOURCE);
            }
        });
        this.rbDSFromRepo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.rbDSFromRepo.setText(Messages.DatasourceSelectionComposite_FromRepository);
        this.textDSFromRepo = new Text((Composite)this, 2048);
        this.textDSFromRepo.setEnabled(false);
        this.textDSFromRepo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textDSFromRepo.addModifyListener(e -> {
            if (!this.refresh) {
                final String uri = this.textDSFromRepo.getText().trim();
                Job job = new Job(Messages.DatasourceSelectionComposite_0){
                    private ResourceDescriptor newrd;

                    protected IStatus run(IProgressMonitor monitor) {
                        IStatus status;
                        block5: {
                            status = Status.OK_STATUS;
                            try {
                                try {
                                    ResourceDescriptor rd = new ResourceDescriptor();
                                    rd.setUriString(uri);
                                    this.newrd = WSClientHelper.getResource(monitor, DatasourceSelectionComposite.this.res.getWsClient(), rd, null);
                                    DatasourceSelectionComposite.this.valid = this.newrd != null && SelectorDatasource.isDatasource(this.newrd);
                                }
                                catch (Exception e) {
                                    DatasourceSelectionComposite.this.valid = false;
                                    e.printStackTrace();
                                    monitor.done();
                                    break block5;
                                }
                            }
                            catch (Throwable throwable) {
                                monitor.done();
                                throw throwable;
                            }
                            monitor.done();
                        }
                        UIUtils.getDisplay().asyncExec(() -> {
                            if (DatasourceSelectionComposite.this.valid) {
                                DatasourceSelectionComposite.this.setResource(DatasourceSelectionComposite.this.res, this.newrd, false);
                            }
                            DatasourceSelectionComposite.this.notifyDatasourceSelectionChanged();
                        });
                        return status;
                    }
                };
                job.setPriority(20);
                job.setSystem(false);
                job.setUser(true);
                job.schedule();
            }
        });
        InputHistoryCache.bindText((Text)this.textDSFromRepo, (String)((Object)((Object)this)).getClass().getName());
        this.btnSelectDSFromRepo = new Button((Composite)this, 8);
        this.btnSelectDSFromRepo.setText("...");
        this.btnSelectDSFromRepo.setEnabled(false);
        this.btnSelectDSFromRepo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasourceSelectionComposite.this.selectDatasourceFromRepository();
            }
        });
        this.rbLocalDS = new Button((Composite)this, 16);
        this.rbLocalDS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasourceSelectionComposite.this.setEnabled(SelectorDatasource.SelectionType.LOCAL_DATASOURCE);
            }
        });
        this.rbLocalDS.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.rbLocalDS.setText(Messages.DatasourceSelectionComposite_LocalDatasource);
        this.textLocalDS = new Text((Composite)this, 2048);
        this.textLocalDS.setEnabled(false);
        this.textLocalDS.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnSelectLocalDS = new Button((Composite)this, 8);
        this.btnSelectLocalDS.setEnabled(false);
        this.btnSelectLocalDS.setText("...");
        this.btnSelectLocalDS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasourceSelectionComposite.this.selectLocalDatasource();
            }
        });
        if (!mandatory) {
            this.rbNoDS = new Button((Composite)this, 16);
            this.rbNoDS.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this.rbNoDS.setSelection(true);
            this.rbNoDS.setText(Messages.DatasourceSelectionComposite_NoDatasource);
            this.rbNoDS.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatasourceSelectionComposite.this.removeDatasource(DatasourceSelectionComposite.this.res);
                    DatasourceSelectionComposite.this.setEnabled(SelectorDatasource.SelectionType.NO_DATASOURCE);
                }
            });
        }
    }

    public void configurePage(ANode parent, AMResource resource) {
        this.isConfiguringPage = true;
        this.pnode = parent;
        this.res = resource;
        ResourceDescriptor r = SelectorDatasource.getDatasource(this.res.getValue(), this.res);
        if (r != null) {
            if (r.getIsReference()) {
                this.setEnabled(SelectorDatasource.SelectionType.REMOTE_DATASOURCE);
            } else {
                this.setEnabled(SelectorDatasource.SelectionType.LOCAL_DATASOURCE);
            }
        } else {
            this.setEnabled(SelectorDatasource.SelectionType.NO_DATASOURCE);
        }
        this.isConfiguringPage = false;
    }

    private void setEnabled(SelectorDatasource.SelectionType type) {
        if (this.refresh) {
            return;
        }
        this.refresh = true;
        this.btnSelectDSFromRepo.setEnabled(false);
        this.textDSFromRepo.setEnabled(false);
        this.textDSFromRepo.setText("");
        this.btnSelectLocalDS.setEnabled(false);
        this.textLocalDS.setEnabled(false);
        this.textLocalDS.setText("");
        this.rbDSFromRepo.setSelection(false);
        this.rbLocalDS.setSelection(false);
        if (this.rbNoDS != null) {
            this.rbNoDS.setSelection(false);
        }
        ResourceDescriptor r = SelectorDatasource.getDatasource(this.res.getValue(), this.res);
        switch (type) {
            case REMOTE_DATASOURCE: {
                this.rbDSFromRepo.setSelection(true);
                this.btnSelectDSFromRepo.setEnabled(true);
                this.textDSFromRepo.setEnabled(true);
                if (!this.isConfiguringPage || r == null) break;
                this.textDSFromRepo.setText(Misc.nvl((String)r.getReferenceUri()));
                break;
            }
            case LOCAL_DATASOURCE: {
                this.rbLocalDS.setSelection(true);
                this.btnSelectLocalDS.setEnabled(true);
                if (!this.isConfiguringPage || r == null) break;
                this.textLocalDS.setText(Misc.nvl((String)r.getName()));
                break;
            }
            case NO_DATASOURCE: {
                if (this.rbNoDS != null) {
                    this.rbNoDS.setSelection(true);
                    break;
                }
                this.setEnabled(SelectorDatasource.SelectionType.REMOTE_DATASOURCE);
                this.refresh = false;
                return;
            }
        }
        this.notifyDatasourceSelectionChanged();
        this.refresh = false;
    }

    private void selectLocalDatasource() {
        ResourceDescriptor runit = this.res.getValue();
        ResourceDescriptor ref = SelectorDatasource.getDatasource(runit, this.res);
        if (ASelector.isReference(ref)) {
            ref = null;
        }
        if (ref == null && this.res.getValue().getWsType().equals(WsTypes.INST().toRestType("domainTopic"))) {
            ref = MRDatasource.createDescriptor(null);
            ref.setName("SemanticLayerDataSource");
            ref.setLabel("SemanticLayerDataSource");
            ref.setWsType("Domain");
        }
        if (ref == null) {
            AddResourceWizard wizard = new AddResourceWizard((ANode)this.res, true);
            wizard.setOnlyDatasource(true);
            WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() != 0) {
                return;
            }
            ref = wizard.getResource().getValue();
            ref.setIsReference(false);
            ref.setParentFolder(String.valueOf(runit.getParentFolder()) + "/" + runit.getName() + "_files");
            ref.setUriString(String.valueOf(ref.getParentFolder()) + "/" + ref.getName());
            SelectorDatasource.replaceDatasource(this.res, ref);
        } else {
            AMResource r = ResourceFactory.getResource(null, ASelector.cloneResource(ref), -1);
            ResourceWizard wizard = new ResourceWizard(this.pnode, r, true, true);
            WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() != 0) {
                return;
            }
            ASelector.copyFields(r.getValue(), ref);
        }
        this.textLocalDS.setText(Misc.nvl((String)ref.getUriString()));
        this.notifyDatasourceSelectionChanged();
    }

    /*
     * Unable to fully structure code
     */
    private void selectDatasourceFromRepository() {
        msp = ServerManager.getMServerProfileCopy((MServerProfile)this.pnode.getRoot());
        if (msp.isSupported(Feature.SEARCHREPOSITORY)) {
            dsArray = WsTypes.INST().getDatasourcesArray();
            if (this.res.getValue().getWsType().equals("domainTopic")) {
                dsArray = new String[]{WsTypes.INST().toRestType("domain")};
            }
            exclude = null;
            if (this.excludeTypes != null && this.excludeTypes.length > 0) {
                exclude = new String[this.excludeTypes.length];
                i = 0;
                while (i < this.excludeTypes.length) {
                    exclude[i] = WsTypes.INST().toRestType(this.excludeTypes[i]);
                    ++i;
                }
            }
            this.btnSelectDSFromRepo.setEnabled(false);
            try {
                rd = FindResourceJob.doFindResource(msp, dsArray, exclude);
                if (rd == null) ** GOTO lbl26
                this.setResource(this.res, rd, true);
            }
            finally {
                this.btnSelectDSFromRepo.setEnabled(true);
            }
        } else {
            rd = new RepositoryDialog(UIUtils.getShell(), (INode)msp){

                @Override
                public boolean isResourceCompatible(AMResource r) {
                    String type = r.getValue().getWsType();
                    if (DatasourceSelectionComposite.this.excludeTypes != null) {
                        String[] stringArray = DatasourceSelectionComposite.this.excludeTypes;
                        int n = DatasourceSelectionComposite.this.excludeTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String t = stringArray[n2];
                            if (type.equals(t)) {
                                return false;
                            }
                            ++n2;
                        }
                    }
                    return SelectorDatasource.isDatasource(r.getValue());
                }
            };
            if (rd.open() == 0 && (rs = rd.getResource()) != null) {
                this.setResource(this.res, rs.getValue(), true);
            }
        }
lbl26:
        // 5 sources

        this.notifyDatasourceSelectionChanged();
    }

    private void setResource(AMResource res, ResourceDescriptor rd, boolean modifyText) {
        ResourceDescriptor runit = res.getValue();
        try {
            rd = WSClientHelper.getResource((IProgressMonitor)new NullProgressMonitor(), this.pnode, rd);
            rd.setIsReference(true);
            rd.setReferenceUri(rd.getUriString());
            rd.setParentFolder(String.valueOf(runit.getParentFolder()) + "/" + runit.getName() + "_files");
            rd.setWsType(rd.getWsType());
            rd.setUriString(String.valueOf(rd.getParentFolder()) + "/" + rd.getName());
            SelectorDatasource.replaceDatasource(res, rd);
            rd.setDirty(false);
            if (modifyText) {
                this.textDSFromRepo.setText(rd.getReferenceUri());
            }
            this.valid = true;
        }
        catch (Exception e1) {
            UIUtils.showError((Throwable)e1);
        }
    }

    private void removeDatasource(AMResource res) {
        ResourceDescriptor rdel = SelectorDatasource.getDatasource(res.getValue(), res);
        if (rdel != null) {
            res.getValue().getChildren().remove(rdel);
        }
    }

    public boolean isDatasourceSelectionValid() {
        return this.rbNoDS != null && this.rbNoDS.getSelection() || !this.textDSFromRepo.getText().trim().isEmpty() && this.valid || !this.textLocalDS.getText().trim().isEmpty();
    }

    public void addDatasourceSelectionListener(DatasourceSelectionListener l) {
        if (this.dsListeners == null) {
            this.dsListeners = new ArrayList<DatasourceSelectionListener>(1);
        }
        this.dsListeners.add(l);
    }

    public void removeDatasourceSelectionListener(DatasourceSelectionListener l) {
        if (this.dsListeners != null) {
            this.dsListeners.remove(l);
        }
    }

    private void notifyDatasourceSelectionChanged() {
        if (this.dsListeners != null) {
            for (DatasourceSelectionListener l : this.dsListeners) {
                l.datasourceSelectionChanged();
            }
        }
    }
}

