/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.wizard.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.publish.wizard.page.DatasourceSelectionComposite;
import com.jaspersoft.studio.server.publish.wizard.page.DatasourceSelectionListener;
import com.jaspersoft.studio.server.utils.IPageCompleteListener;
import com.jaspersoft.studio.server.wizard.resource.page.runit.ReportUnitDatasourceContent;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorDatasource;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorQueryWithNon;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DatasourceSelectionPage
extends JSSHelpWizardPage
implements DatasourceSelectionListener {
    public static final String PAGE_NAME = "ruDatasourceSelectionPage";
    protected JasperReportsConfiguration jConfig;
    private DatasourceSelectionComposite datasourceCmp;
    private boolean refresh = false;
    private SelectorQueryWithNon sQuery;
    private TabFolder tabfolder;

    public DatasourceSelectionPage(JasperReportsConfiguration jConfig) {
        super(PAGE_NAME);
        this.setTitle(Messages.DatasourceSelectionPage_Title);
        this.setDescription(Messages.DatasourceSelectionPage_Description);
        this.jConfig = jConfig;
    }

    protected String getContextName() {
        return "com.jaspersoft.studio.doc.select_server_datasources";
    }

    public void createControl(Composite parent) {
        this.tabfolder = new TabFolder(parent, 0);
        TabItem tb = new TabItem(this.tabfolder, 0);
        tb.setText(Messages.DatasourceSelectionPage_0);
        Composite cmp = new Composite((Composite)this.tabfolder, 0);
        cmp.setLayout((Layout)new GridLayout());
        this.datasourceCmp = new DatasourceSelectionComposite(cmp, 0, false, new String[]{"olapXmlaCon"});
        this.datasourceCmp.setLayoutData(new GridData(1808));
        this.datasourceCmp.addDatasourceSelectionListener(this);
        tb.setControl((Control)cmp);
        this.tabfolder.setSelection(tb);
        tb = new TabItem(this.tabfolder, 0);
        tb.setText(Messages.DatasourceSelectionPage_1);
        cmp = new Composite((Composite)this.tabfolder, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        this.sQuery = new SelectorQueryWithNon();
        this.sQuery.createControls(cmp, null, null);
        this.sQuery.addPageCompleteListener(new IPageCompleteListener(){

            @Override
            public void pageCompleted(boolean completed) {
                DatasourceSelectionPage.this.setPageComplete(DatasourceSelectionPage.this.isPageComplete());
                if (DatasourceSelectionPage.this.sQuery.isPageComplete()) {
                    DatasourceSelectionPage.this.setErrorMessage(null);
                } else {
                    DatasourceSelectionPage.this.setErrorMessage(Messages.DatasourceSelectionPage_2);
                }
            }
        });
        tb.setControl((Control)cmp);
        this.setControl((Control)this.tabfolder);
    }

    public void configurePage(ANode parent, AMResource resource) {
        if (this.tabfolder.getItemCount() > 1) {
            int oldIndx = this.tabfolder.getSelectionIndex();
            this.tabfolder.setSelection(1);
            this.tabfolder.setSelection(oldIndx);
        }
        if (this.refresh) {
            return;
        }
        if (resource instanceof MReportUnit) {
            this.sQuery.setResource(resource.getParent(), resource);
            try {
                ResourceDescriptor oldru = ((MReportUnit)resource).getValue();
                if (SelectorDatasource.getDatasource(oldru, resource) == null) {
                    ResourceDescriptor ru = WSClientHelper.getResource((IProgressMonitor)new NullProgressMonitor(), (ANode)resource, oldru);
                    oldru.getChildren().add(SelectorDatasource.getDatasource(ru, resource));
                }
            }
            catch (Exception exception) {}
        }
        this.datasourceCmp.setExcludeTypes(ReportUnitDatasourceContent.getExcludedTypes(resource));
        this.datasourceCmp.configurePage(parent, resource);
    }

    public boolean isPageComplete() {
        return this.datasourceCmp != null && this.datasourceCmp.isDatasourceSelectionValid() && this.sQuery.isPageComplete();
    }

    @Override
    public void datasourceSelectionChanged() {
        if (this.refresh) {
            return;
        }
        this.refresh = true;
        this.setPageComplete(this.isPageComplete());
        if (this.datasourceCmp.isDatasourceSelectionValid()) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(Messages.DatasourceSelectionPage_3);
        }
        this.refresh = false;
    }
}

