/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.wizard.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.ServerProvider;
import com.jaspersoft.studio.server.action.resource.RefreshResourcesAction;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MContentResource;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.publish.wizard.page.AFilesLocationPage;
import com.jaspersoft.studio.server.utils.ValidationUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.ui.validator.IDStringValidator;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RFileLocationPage
extends AFilesLocationPage {
    private Text ruLabel;
    private Text ruID;
    private Text ruDescription;
    private IFile file;
    protected AFileResource newRes;
    protected AFileResource fileRes;

    public RFileLocationPage(JasperReportsConfiguration jConfig, List<IResource> files) {
        super("serverfilepublish", jConfig, files);
        this.setTitle(Messages.RUnitLocationPage_title);
        this.setDescription(Messages.RFileLocationPage_0);
    }

    @Override
    public List<AMResource> getSelectedNodes() {
        ArrayList<AMResource> fResources = new ArrayList<AMResource>();
        if (this.fileRes != null) {
            ResourceDescriptor rd = this.fileRes.getValue();
            String purl = FilenameUtils.getFullPath((String)rd.getUriString());
            boolean first = true;
            AFileResource fres = this.fileRes;
            for (IResource f : this.files) {
                String ext;
                if (!first) {
                    rd = new ResourceDescriptor();
                }
                String string = ext = f.getFileExtension() != null ? f.getFileExtension().toLowerCase() : "";
                if (f instanceof IFolder) {
                    rd.setWsType("folder");
                } else if (ext.equalsIgnoreCase("xml")) {
                    rd.setWsType("xml");
                } else if (ext.equalsIgnoreCase("jar") || ext.equalsIgnoreCase("zip")) {
                    rd.setWsType("jar");
                } else if (ext.equalsIgnoreCase("jrtx")) {
                    rd.setWsType("jrtx");
                } else if (ext.equalsIgnoreCase("css")) {
                    rd.setWsType("css");
                } else if (ext.equalsIgnoreCase("json")) {
                    rd.setWsType("json");
                } else if (ext.equalsIgnoreCase("properties")) {
                    rd.setWsType("prop");
                } else if (ext.equalsIgnoreCase("ttf") || ext.equalsIgnoreCase("eot") || ext.equalsIgnoreCase("woff")) {
                    rd.setWsType("font");
                } else if (ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("gif") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("bmp") || ext.equalsIgnoreCase("tiff")) {
                    rd.setWsType("img");
                } else if (fres.getParent() instanceof MReportUnit) {
                    rd.setWsType("prop");
                }
                if (!first) {
                    rd.setName(IDStringValidator.safeChar((String)f.getName()));
                    rd.setLabel(f.getName());
                    rd.setUriString(String.valueOf(purl) + rd.getName());
                }
                fres = (AFileResource)ResourceFactory.getResource(fres.getParent(), rd, -1);
                if (f instanceof IFile) {
                    fres.setFile(new File(f.getRawLocationURI()));
                }
                fResources.add(fres);
            }
        }
        return fResources;
    }

    @Override
    protected boolean isPageCompleteLogic() {
        boolean isC;
        TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
        Object firstElement = ts.getFirstElement();
        boolean bl = isC = firstElement instanceof AFileResource || firstElement instanceof MFolder;
        if (isC && firstElement instanceof MFolder) {
            isC = this.getNewRunit().getParent() != null;
        }
        return isC;
    }

    @Override
    public void refreshFile() {
        this.file = (IFile)this.jConfig.get("ifile");
        this.look4SelectedUnit(this.file);
    }

    public AFileResource getSelectedNode() {
        return this.fileRes;
    }

    protected AFileResource getNewRunit() {
        if (this.newRes == null) {
            ResourceDescriptor rd = AFileResource.createDescriptor(null);
            rd.setWsType("contentResource");
            rd.setName(null);
            String n = this.getRunitName();
            PublishUtil.initResourceName(n, rd);
            rd.setLabel(n);
            this.newRes = new MContentResource(null, rd, -1);
            this.newRes.setJasperConfiguration(this.jConfig);
        }
        return this.newRes;
    }

    @Override
    protected void performPageChecks() {
        String errorMsg = null;
        errorMsg = ValidationUtils.validateName(this.ruID.getText());
        if (errorMsg == null) {
            errorMsg = ValidationUtils.validateLabel(this.ruLabel.getText());
        }
        if (errorMsg == null) {
            errorMsg = ValidationUtils.validateDesc(this.ruDescription.getText());
        }
        this.setErrorMessage(errorMsg);
        this.setPageComplete(errorMsg == null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer(composite, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        gd.heightHint = 400;
        gd.horizontalSpan = 2;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider(){

            public Object[] getChildren(Object parentElement) {
                MFolder node;
                if (parentElement instanceof MFolder && RFileLocationPage.this.fileRes != null && RFileLocationPage.this.fileRes.getValue().getIsNew() && (node = (MFolder)((Object)parentElement)).getChildren() != null && !node.getChildren().isEmpty()) {
                    ArrayList<INode> children = new ArrayList<INode>();
                    for (INode n : node.getChildren()) {
                        if (n == RFileLocationPage.this.fileRes) continue;
                        children.add(n);
                    }
                    return children.toArray();
                }
                return super.getChildren(parentElement);
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        Label lblRepoUnitName = new Label(composite, 0);
        lblRepoUnitName.setLayoutData((Object)new GridData(4, 128, false, false));
        lblRepoUnitName.setText(Messages.AResourcePage_name);
        this.ruLabel = new Text(composite, 2048);
        this.ruLabel.setLayoutData((Object)new GridData(768));
        this.ruLabel.addModifyListener(e -> {
            if (this.isRefresh) {
                return;
            }
            this.isRefresh = true;
            String rtext = this.ruLabel.getText();
            String validationError = ValidationUtils.validateLabel(rtext);
            this.setErrorMessage(validationError);
            if (validationError == null) {
                ResourceDescriptor ru = this.getNewRunit().getValue();
                ru.setLabel(rtext);
                if (this.canSuggestID) {
                    this.ruID.setText(rtext);
                    ru.setName(IDStringValidator.safeChar((String)rtext));
                    ru.setUriString(String.valueOf(ru.getParentFolder()) + "/" + ru.getName());
                }
            }
            this.isRefresh = false;
        });
        Label lblRepoUnitID = new Label(composite, 0);
        lblRepoUnitID.setLayoutData((Object)new GridData(4, 128, false, false));
        lblRepoUnitID.setText(Messages.AResourcePage_id);
        this.ruID = new Text(composite, 2048);
        this.ruID.setLayoutData((Object)new GridData(768));
        this.ruID.addModifyListener(e -> {
            if (this.isRefresh) {
                return;
            }
            this.isRefresh = true;
            String rtext = this.ruID.getText();
            String validationError = ValidationUtils.validateName(rtext);
            this.setErrorMessage(validationError);
            if (validationError == null) {
                ResourceDescriptor ru = this.getNewRunit().getValue();
                ru.setName(rtext);
                ru.setUriString(String.valueOf(ru.getParentFolder()) + "/" + ru.getName());
            }
            this.canSuggestID = this.isFillingInput || validationError != null;
            this.isRefresh = false;
        });
        this.ruID.addVerifyListener(e -> {
            String string = e.text = IDStringValidator.safeChar((String)e.text);
        });
        Label lblRepoUnitDescription = new Label(composite, 0);
        GridData descLblGD = new GridData(4, 128, false, false);
        lblRepoUnitDescription.setLayoutData((Object)descLblGD);
        lblRepoUnitDescription.setText(Messages.AResourcePage_description);
        this.ruDescription = new Text(composite, 2050);
        GridData descGD = new GridData(4, 128, true, true);
        descGD.minimumHeight = 50;
        this.ruDescription.setLayoutData((Object)descGD);
        this.ruDescription.addModifyListener(e -> {
            if (this.isRefresh) {
                return;
            }
            String rtext = this.ruDescription.getText();
            ResourceDescriptor ru = this.getNewRunit().getValue();
            ru.setDescription(rtext);
            this.setErrorMessage(ValidationUtils.validateDesc(rtext));
        });
        this.treeViewer.addSelectionChangedListener(event -> {
            TreeSelection ts = (TreeSelection)event.getSelection();
            Object obj = ts.getFirstElement();
            this.handleSelectionChanged(obj);
        });
        this.treeViewer.addDoubleClickListener(event -> {
            TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
            Object el = ts.getFirstElement();
            if (el instanceof MFolder || el instanceof MServerProfile || el instanceof MReportUnit) {
                if (this.treeViewer.getExpandedState(el)) {
                    this.treeViewer.collapseToLevel(el, 1);
                } else {
                    if (this.refreshAction == null) {
                        this.refreshAction = new RefreshResourcesAction(this.treeViewer);
                    }
                    if (this.refreshAction.isEnabled()) {
                        this.refreshAction.run();
                    }
                    this.treeViewer.expandToLevel(el, 1);
                }
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){
            private ServerProvider serverProvider;

            public void treeExpanded(final TreeExpansionEvent event) {
                if (!RFileLocationPage.this.skipEvents) {
                    try {
                        RFileLocationPage.this.getContainer().run(false, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.Publish2ServerWizard_MonitorName, -1);
                                try {
                                    try {
                                        if (serverProvider == null) {
                                            serverProvider = new ServerProvider();
                                        }
                                        serverProvider.handleTreeEvent(event, monitor);
                                    }
                                    catch (Exception e) {
                                        UIUtils.showError((Throwable)e);
                                        monitor.done();
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        UIUtils.showError((Throwable)e.getCause());
                    }
                    catch (InterruptedException e) {
                        UIUtils.showError((Throwable)e.getCause());
                    }
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.fillInput();
    }

    protected String getRunitName() {
        return this.file != null ? this.file.getName() : "reportunit";
    }

    @Override
    protected void handleSelectionChanged(Object obj) {
        AMResource pfolder;
        if (this.isRefresh) {
            return;
        }
        this.isRefresh = true;
        if (obj instanceof MReportUnit) {
            this.fileRes = this.getNewRunit();
            pfolder = (MReportUnit)obj;
            this.fileRes.setParent((ANode)pfolder, -1);
            ResourceDescriptor rd = this.fileRes.getValue();
            rd.setUriString(String.valueOf(pfolder.getValue().getUriString()) + "/" + rd.getName());
        } else if (obj instanceof MFolder) {
            this.fileRes = this.getNewRunit();
            pfolder = (MFolder)((Object)obj);
            this.fileRes.setParent((ANode)pfolder, -1);
            ResourceDescriptor rd = this.fileRes.getValue();
            rd.setUriString(String.valueOf(pfolder.getValue().getUriString()) + "/" + rd.getName());
        } else if (obj instanceof AFileResource) {
            this.fileRes = (AFileResource)((Object)obj);
        } else {
            this.setPageComplete(false);
        }
        if (this.fileRes != null) {
            ResourceDescriptor rd = this.fileRes.getValue();
            this.ruLabel.setText(Misc.nvl((String)rd.getLabel()));
            this.ruID.setText(Misc.nvl((String)rd.getName()));
            this.ruDescription.setText(Misc.nvl((String)rd.getDescription()));
        }
        this.performPageChecks();
        this.isRefresh = false;
    }
}

