/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.wizard.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MDummy;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.ServerProvider;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.action.resource.RefreshResourcesAction;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMJrxmlContainer;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.IInputControlsContainer;
import com.jaspersoft.studio.server.model.MContentResource;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.publish.FindResources;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.utils.ResourceDescriptorUtil;
import com.jaspersoft.studio.server.utils.ValidationUtils;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorDatasource;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.ui.validator.IDStringValidator;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RUnitLocationPage
extends JSSHelpWizardPage {
    private JasperDesign jDesign;
    private TreeViewer treeViewer;
    private Button bnRunit;
    private Text ruLabel;
    private ANode n;
    private RefreshResourcesAction refreshAction;
    private JasperReportsConfiguration jConfig;
    private Text ruID;
    private Text ruDescription;
    private boolean isFillingInput;
    private boolean canSuggestID;
    private AMJrxmlContainer reportUnit;
    private MReportUnit newrunit;
    private MJrxml newjrxml;
    private boolean isRefresh = false;
    private boolean skipEvents = false;

    public RUnitLocationPage(JasperReportsConfiguration jConfig, JasperDesign jDesign, ANode n) {
        super("serverpublish");
        this.setTitle(Messages.RUnitLocationPage_title);
        this.setDescription(Messages.RUnitLocationPage_description);
        this.jDesign = jDesign;
        this.n = n;
        this.jConfig = jConfig;
    }

    public void setValue(JasperDesign jDesign, ANode n) {
        this.jDesign = jDesign;
        this.n = n;
        this.fillInput();
    }

    public AMJrxmlContainer getSelectedNode() {
        TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
        Object obj = ts.getFirstElement();
        if (obj != null) {
            if (obj instanceof MFolder) {
                return this.reportUnit;
            }
            return (AMJrxmlContainer)((Object)obj);
        }
        if (this.n instanceof AMJrxmlContainer) {
            return (AMJrxmlContainer)this.n;
        }
        this.reportUnit.setJasperConfiguration(this.jConfig);
        return this.reportUnit;
    }

    protected String getContextName() {
        return "com.jaspersoft.studio.doc.select_server";
    }

    public boolean isPageComplete() {
        boolean isC;
        boolean bl = isC = super.isPageComplete() && this.getErrorMessage() == null;
        if (isC) {
            isC = this.isPageCompleteLogic();
        }
        return isC;
    }

    protected boolean isPageCompleteLogic() {
        TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
        Object firstElement = ts.getFirstElement();
        boolean isC = firstElement instanceof MJrxml || firstElement instanceof MFolder || firstElement instanceof MReportUnit;
        AMJrxmlContainer runit = this.getReportUnit();
        if (isC && firstElement instanceof MFolder) {
            boolean bl = isC = runit instanceof AMJrxmlContainer && runit.getParent() != null;
            if (!(firstElement instanceof MFolder)) {
                isC = this.bnRunit.getSelection();
            }
        }
        if (isC && (firstElement instanceof MFolder || firstElement instanceof MServerProfile)) {
            String nm = runit.getValue().getName();
            String t = runit.getValue().getWsType();
            for (INode n : ((ANode)firstElement).getChildren()) {
                ResourceDescriptor rd = (ResourceDescriptor)n.getValue();
                if (n == this.newjrxml || n == this.newrunit || rd == null || !rd.getName().equals(nm) || rd.getWsType().equals(t)) continue;
                super.setErrorMessage("A resource of different type already exist for the same name");
                return false;
            }
        }
        return isC;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setPageComplete(this.isPageComplete());
    }

    private void performPageChecks() {
        String errorMsg = null;
        errorMsg = ValidationUtils.validateName(this.ruID.getText());
        if (errorMsg == null) {
            errorMsg = ValidationUtils.validateLabel(this.ruLabel.getText());
        }
        if (errorMsg == null) {
            errorMsg = ValidationUtils.validateDesc(this.ruDescription.getText());
        }
        this.setErrorMessage(errorMsg);
        this.setPageComplete(errorMsg == null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer(composite, 2052);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 400;
        gd.horizontalSpan = 2;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof AMResource) {
                    MFolder node;
                    AMResource mres = (AMResource)((Object)parentElement);
                    if (mres instanceof MReportUnit || mres.isSupported(Feature.INPUTCONTROLS_ORDERING) && mres instanceof IInputControlsContainer) {
                        if (mres.getChildren() != null && !mres.getChildren().isEmpty()) {
                            ArrayList<INode> children = new ArrayList<INode>();
                            if (mres.getChildren().get(0) instanceof MDummy) {
                                try {
                                    return mres.getChildren().toArray();
                                }
                                catch (Exception e) {
                                    UIUtils.showError((Throwable)e);
                                }
                            }
                            for (INode n1 : mres.getChildren()) {
                                if (!(n1 instanceof AMResource) || SelectorDatasource.isDatasource(((AMResource)n1).getValue())) continue;
                                children.add(n1);
                            }
                            return children.toArray();
                        }
                    } else if (mres instanceof MFolder && RUnitLocationPage.this.newrunit.getValue().getIsNew() && (node = (MFolder)mres).getChildren() != null && !node.getChildren().isEmpty()) {
                        ArrayList<INode> children = new ArrayList<INode>();
                        for (INode n1 : node.getChildren()) {
                            if (n1 == RUnitLocationPage.this.newrunit || n1 == RUnitLocationPage.this.newjrxml) continue;
                            children.add(n1);
                        }
                        return children.toArray();
                    }
                }
                return super.getChildren(parentElement);
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.bnRunit = new Button(composite, 32);
        this.bnRunit.setText(Messages.RUnitLocationPage_addreportunit_button);
        gd = new GridData(2);
        gd.horizontalSpan = 2;
        this.bnRunit.setLayoutData((Object)gd);
        this.bnRunit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeSelection ts;
                Object obj;
                boolean selected = RUnitLocationPage.this.bnRunit.getSelection();
                RUnitLocationPage.this.ruLabel.setEnabled(selected);
                RUnitLocationPage.this.ruID.setEnabled(selected);
                RUnitLocationPage.this.ruDescription.setEnabled(selected);
                AMJrxmlContainer aMJrxmlContainer = RUnitLocationPage.this.reportUnit = selected ? RUnitLocationPage.this.getNewRunit() : RUnitLocationPage.this.getNewJrxml();
                if (RUnitLocationPage.this.reportUnit.getParent() == null && (obj = (ts = (TreeSelection)RUnitLocationPage.this.treeViewer.getSelection()).getFirstElement()) instanceof ANode) {
                    RUnitLocationPage.this.reportUnit.setParent((ANode)obj, -1);
                }
                RUnitLocationPage.this.performPageChecks();
                RUnitLocationPage.this.setPageComplete(RUnitLocationPage.this.isPageComplete());
            }
        });
        this.bnRunit.setSelection(true);
        Label lblRepoUnitName = new Label(composite, 0);
        lblRepoUnitName.setLayoutData((Object)new GridData(4, 128, false, false));
        lblRepoUnitName.setText(Messages.RUnitLocationPage_reportunitlabel);
        this.ruLabel = new Text(composite, 2048);
        this.ruLabel.setLayoutData((Object)new GridData(768));
        this.ruLabel.addModifyListener(e -> {
            ANode p;
            if (this.isRefresh) {
                return;
            }
            this.isRefresh = true;
            MReportUnit mru = this.getNewRunit();
            String rtext = this.ruLabel.getText();
            String id = IDStringValidator.safeChar((String)rtext);
            String validationError = ValidationUtils.validateLabel(rtext);
            if (validationError == null && (p = mru.getParent()) != null) {
                for (INode n1 : p.getChildren()) {
                    ResourceDescriptor amr;
                    if (!(n1 instanceof AMResource) || n1 == mru || (amr = ((AMResource)n1).getValue()).getIsNew()) continue;
                    if (amr.getName().equals(id)) {
                        validationError = "This id is already used in this folder";
                        continue;
                    }
                    if (!amr.getLabel().equals(rtext)) continue;
                    validationError = "This label is already used in this folder";
                }
            }
            if (this.canSuggestID) {
                this.ruID.setText(rtext);
            }
            this.setErrorMessage(validationError);
            if (validationError == null) {
                ResourceDescriptor ru = mru.getValue();
                ru.setLabel(rtext);
                if (this.canSuggestID) {
                    ru.setName(IDStringValidator.safeChar((String)rtext));
                    ru.setUriString(String.valueOf(ru.getParentFolder()) + "/" + ru.getName());
                }
                this.setPageComplete(true);
            }
            this.isRefresh = false;
        });
        Label lblRepoUnitID = new Label(composite, 0);
        lblRepoUnitID.setLayoutData((Object)new GridData(4, 128, false, false));
        lblRepoUnitID.setText(Messages.RUnitLocationPage_lblreportunit);
        this.ruID = new Text(composite, 2048);
        this.ruID.setLayoutData((Object)new GridData(768));
        this.ruID.addModifyListener(e -> {
            ANode p;
            if (this.isRefresh) {
                return;
            }
            this.isRefresh = true;
            MReportUnit mru = this.getNewRunit();
            String rtext = this.ruID.getText();
            String validationError = ValidationUtils.validateName(rtext);
            if (validationError == null && (p = mru.getParent()) != null) {
                for (INode n1 : p.getChildren()) {
                    if (!(n1 instanceof AMResource) || n1 == mru || n1 == this.newjrxml || !((AMResource)n1).getValue().getName().equals(rtext)) continue;
                    validationError = "This id is already used in this folder";
                }
            }
            this.setErrorMessage(validationError);
            if (validationError == null) {
                ResourceDescriptor ru = mru.getValue();
                ru.setName(rtext);
                ru.setUriString(String.valueOf(ru.getParentFolder()) + "/" + ru.getName());
            }
            this.canSuggestID = this.isFillingInput || validationError != null;
            this.isRefresh = false;
        });
        this.ruID.addVerifyListener(e -> {
            String string = e.text = IDStringValidator.safeChar((String)e.text);
        });
        Label lblRepoUnitDescription = new Label(composite, 0);
        GridData descLblGD = new GridData(4, 128, false, false);
        lblRepoUnitDescription.setLayoutData((Object)descLblGD);
        lblRepoUnitDescription.setText(Messages.RUnitLocationPage_reportunitdesc_label);
        this.ruDescription = new Text(composite, 2050);
        GridData descGD = new GridData(770);
        descGD.heightHint = 50;
        this.ruDescription.setLayoutData((Object)descGD);
        this.ruDescription.setText("");
        this.ruDescription.addModifyListener(e -> {
            if (this.isRefresh) {
                return;
            }
            String rtext = this.ruDescription.getText();
            ResourceDescriptor ru = this.getNewRunit().getValue();
            ru.setDescription(rtext);
            this.setErrorMessage(ValidationUtils.validateDesc(rtext));
        });
        this.treeViewer.addSelectionChangedListener(event -> {
            TreeSelection ts = (TreeSelection)event.getSelection();
            Object obj = ts.getFirstElement();
            this.handleSelectionChanged(obj);
        });
        this.treeViewer.addDoubleClickListener(event -> {
            TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
            Object el = ts.getFirstElement();
            if (el instanceof MFolder || el instanceof MServerProfile) {
                if (this.treeViewer.getExpandedState(el)) {
                    this.treeViewer.collapseToLevel(el, 1);
                } else {
                    if (this.refreshAction == null) {
                        this.refreshAction = new RefreshResourcesAction(this.treeViewer);
                    }
                    if (this.refreshAction.isEnabled()) {
                        this.refreshAction.run();
                    }
                    this.treeViewer.expandToLevel(el, 1);
                }
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){
            private ServerProvider serverProvider;

            public void treeExpanded(final TreeExpansionEvent event) {
                if (!RUnitLocationPage.this.skipEvents) {
                    UIUtils.getDisplay().asyncExec(() -> {
                        try {
                            RUnitLocationPage.this.getContainer().run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    monitor.beginTask(Messages.Publish2ServerWizard_MonitorName, -1);
                                    try {
                                        try {
                                            if (serverProvider == null) {
                                                serverProvider = new ServerProvider();
                                            }
                                            Object element = event.getElement();
                                            boolean be = (this).RUnitLocationPage.this.reportUnit.getParent() == element;
                                            serverProvider.handleTreeEvent(event, monitor);
                                            if (be) {
                                                MFolder f = (MFolder)((Object)element);
                                                String nm = (this).RUnitLocationPage.this.reportUnit.getValue().getName();
                                                boolean isnew = true;
                                                for (INode n1 : f.getChildren()) {
                                                    if (!(n1 instanceof AMJrxmlContainer) || !((AMJrxmlContainer)n1).getValue().getName().equals(nm)) continue;
                                                    (this).RUnitLocationPage.this.reportUnit = (AMJrxmlContainer)n1;
                                                    isnew = false;
                                                    break;
                                                }
                                                if (isnew) {
                                                    (this).RUnitLocationPage.this.reportUnit.setParent((ANode)f, -1);
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            UIUtils.showError((Throwable)e);
                                            monitor.done();
                                        }
                                    }
                                    finally {
                                        monitor.done();
                                    }
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            UIUtils.showError((Throwable)e.getCause());
                        }
                        catch (InterruptedException e) {
                            UIUtils.showError((Throwable)e.getCause());
                        }
                    });
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.fillInput();
    }

    private MReportUnit getNewRunit() {
        if (this.newrunit == null) {
            ResourceDescriptor rd = MReportUnit.createDescriptor(null);
            rd.setName(null);
            rd.setResourceProperty("PROP_RU_ALWAYS_PROPMT_CONTROLS", true);
            this.newrunit = new MReportUnit(null, rd, -1);
        }
        PublishUtil.initRUnitName(this.newrunit, this.jDesign, this.jConfig);
        return this.newrunit;
    }

    private MJrxml getNewJrxml() {
        if (this.newjrxml == null) {
            ResourceDescriptor rd = MJrxml.createDescriptor(null);
            rd.setName(null);
            this.newjrxml = new MJrxml(null, rd, -1);
        }
        PublishUtil.initRUnitName(this.newjrxml, this.jDesign, this.jConfig);
        return this.newjrxml;
    }

    private AMJrxmlContainer getReportUnit() {
        PublishUtil.initRUnitName(this.reportUnit, this.jDesign, this.jConfig);
        return this.reportUnit;
    }

    protected void handleSelectionChanged(Object obj) {
        if (this.isRefresh) {
            return;
        }
        this.isRefresh = true;
        boolean isFolder = obj instanceof MFolder;
        this.ruLabel.setEnabled(this.bnRunit.getSelection() && isFolder);
        this.ruID.setEnabled(this.bnRunit.getSelection() && isFolder);
        this.ruDescription.setEnabled(this.bnRunit.getSelection() && isFolder);
        this.reportUnit = this.getNewRunit();
        if (obj instanceof MContentResource) {
            try {
                WSClientHelper.refreshResource((MContentResource)((Object)obj), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (obj instanceof MReportUnit) {
            this.reportUnit = this.getNewRunit();
            this.reportUnit = (MReportUnit)obj;
            this.ruLabel.setText(Misc.nvl((String)this.reportUnit.getValue().getLabel()));
            this.ruID.setText(Misc.nvl((String)this.reportUnit.getValue().getName()));
            this.ruDescription.setText(Misc.nvl((String)this.reportUnit.getValue().getDescription()));
        } else if (obj instanceof MFolder) {
            this.newrunit = this.getNewRunit();
            this.newrunit.setParent((ANode)obj, -1);
            this.newjrxml = this.getNewJrxml();
            this.newjrxml.setParent((ANode)obj, -1);
            this.reportUnit = this.bnRunit.getSelection() ? this.newrunit : this.newjrxml;
            ResourceDescriptor nrd = this.reportUnit.getValue();
            nrd.setName(this.ruID.getText());
            nrd.setLabel(this.ruLabel.getText());
            nrd.setDescription(this.ruDescription.getText());
            String uri = ((MFolder)((Object)obj)).getValue().getUriString();
            nrd.setParentFolder(uri);
            nrd.setUriString(String.valueOf(uri) + "/" + nrd.getName());
        } else if (obj instanceof MJrxml) {
            this.reportUnit = this.getNewJrxml();
            this.reportUnit = (MJrxml)((Object)obj);
            this.ruLabel.setText(Misc.nvl((String)this.reportUnit.getValue().getLabel()));
            this.ruID.setText(Misc.nvl((String)this.reportUnit.getValue().getName()));
            this.ruDescription.setText(Misc.nvl((String)this.reportUnit.getValue().getDescription()));
        } else if (obj instanceof AMResource) {
            ANode mparent = ((AMResource)((Object)obj)).getParent();
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)mparent), true);
            this.handleSelectionChanged(mparent);
        } else {
            this.setPageComplete(false);
        }
        this.performPageChecks();
        this.isRefresh = false;
    }

    public void fillInput() {
        UIUtils.getDisplay().asyncExec(() -> {
            this.isFillingInput = true;
            this.initIDLabel();
            if (this.n instanceof MServerProfile) {
                this.look4SelectedUnit((MServerProfile)this.n);
            }
            this.setSelectedNode();
            this.isFillingInput = false;
        });
    }

    private void initIDLabel() {
        if (this.jDesign != null) {
            String rUnitNAme = PublishUtil.getRUnitNAme(this.jDesign, this.jConfig);
            this.ruID.setText(rUnitNAme.replace(" ", ""));
            this.ruLabel.setText(rUnitNAme);
            this.ruDescription.setText(this.newrunit != null ? Misc.nvl((String)this.newrunit.getValue().getDescription()) : "");
        }
    }

    private void setSelectedNode() {
        if (this.n == null || this.treeViewer.getTree().isDisposed()) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            INode root = this.n.getRoot();
            if (root instanceof MServerProfile) {
                root = ((ANode)root.getParent()).getRoot();
            }
            this.treeViewer.setInput((Object)root);
            this.skipEvents = true;
            this.treeViewer.refresh();
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.n), true);
            this.setPageComplete(this.isPageCompleteLogic());
            this.skipEvents = false;
            this.handleSelectionChanged(this.n);
        });
    }

    private void look4SelectedUnit(final MServerProfile mres) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IFile file = (IFile)RUnitLocationPage.this.jConfig.get("ifile");
                    ANode node = FindResources.findReportUnit(mres, monitor, RUnitLocationPage.this.jDesign, file);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (RUnitLocationPage.this.n != mres) {
                        return;
                    }
                    RUnitLocationPage.this.n = node;
                    try {
                        if (RUnitLocationPage.this.n instanceof MReportUnit && !ResourceDescriptorUtil.isReportMain(file)) {
                            MReportUnit mReportUnit = (MReportUnit)RUnitLocationPage.this.n;
                            String res = RUnitLocationPage.this.jDesign.getProperty("ireport.jasperserver.report.resource");
                            if (!Misc.isNullOrEmpty((String)res)) {
                                mReportUnit.setValue(WSClientHelper.getResource(monitor, RUnitLocationPage.this.n, mReportUnit.getValue()));
                                List<ResourceDescriptor> children = mReportUnit.getValue().getChildren();
                                ResourceDescriptor rd = null;
                                for (ResourceDescriptor c : children) {
                                    if (!c.getWsType().equals("jrxml") || !c.getUriString().equals(res)) continue;
                                    rd = c;
                                    break;
                                }
                                if (rd != null) {
                                    RUnitLocationPage.this.n.removeChildren();
                                    AMResource tmpn = null;
                                    for (ResourceDescriptor c : children) {
                                        AMResource mr = ResourceFactory.getResource(RUnitLocationPage.this.n, c, -1);
                                        if (c != rd) continue;
                                        tmpn = mr;
                                    }
                                    RUnitLocationPage.this.n = tmpn;
                                }
                            }
                        }
                    }
                    catch (Exception ce) {
                        ce.printStackTrace();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
    }
}

