/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.utils;

import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.utils.compatibility.StringMatcher;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.JerseyInvocation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import sun.misc.Unsafe;

public class HttpUtils {
    private static Map<Executor, URI> executors = new HashMap<Executor, URI>();
    private static Map<ClientConfig, URI> clientConfigs = new HashMap<ClientConfig, URI>();

    public static URI toSafeUri(URL url) throws URISyntaxException {
        String u = "";
        if (!Misc.isNullOrEmpty((String)url.getProtocol())) {
            u = String.valueOf(u) + url.getProtocol() + "://";
        }
        if (!Misc.isNullOrEmpty((String)url.getUserInfo())) {
            u = String.valueOf(u) + "@" + url.getUserInfo();
        }
        u = String.valueOf(u) + IDN.toASCII(url.getHost());
        if (url.getPort() > 0) {
            u = String.valueOf(u) + ":" + url.getPort();
        }
        if (!Misc.isNullOrEmpty((String)url.getPath())) {
            u = String.valueOf(u) + url.getPath();
        }
        if (!Misc.isNullOrEmpty((String)url.getQuery())) {
            u = String.valueOf(u) + url.getQuery();
        }
        if (!Misc.isNullOrEmpty((String)url.getRef())) {
            u = String.valueOf(u) + url.getRef();
        }
        URI uri = new URI(u);
        HttpUtils.setupUriHost(uri, IDN.toASCII(url.getHost()));
        return uri;
    }

    private static void setupUriHost(URI uri, String host) {
        if (uri.getHost() == null && uri.getAuthority() != null) {
            try {
                String[] s = uri.getAuthority().split(":");
                if (s.length > 0) {
                    Field f = URI.class.getDeclaredField("host");
                    f.setAccessible(true);
                    f.set(uri, s[0]);
                    if (s.length > 1) {
                        f = URI.class.getDeclaredField("port");
                        f.setAccessible(true);
                        f.set(uri, Integer.valueOf(s[1]));
                    }
                }
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static Invocation.Builder getRequest(WebTarget target, MediaType arg) {
        return HttpUtils.getRequest(target, target.request(new MediaType[]{arg}));
    }

    public static Invocation.Builder getRequest(WebTarget target, String arg) {
        return HttpUtils.getRequest(target, target.request(new String[]{arg}));
    }

    public static Invocation.Builder getRequest(WebTarget target) {
        return HttpUtils.getRequest(target, target.request());
    }

    public static Invocation.Builder getRequest(WebTarget target, Invocation.Builder req) {
        try {
            if (target.getUri().getHost() != null && !target.getUri().getHost().contains("_")) {
                return req;
            }
            Field f = JerseyInvocation.Builder.class.getDeclaredField("requestContext");
            f.setAccessible(true);
            ClientRequest cr = (ClientRequest)f.get(req);
            if (cr != null) {
                f = ClientRequest.class.getDeclaredField("requestUri");
                f.setAccessible(true);
                URI uri = (URI)f.get(cr);
                if (uri.getHost() == null) {
                    HttpUtils.setupUriHost(uri, target.getUri().getHost());
                }
            }
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return req;
    }

    public static void patchURIClass() {
        try {
            long lowMaskValue = HttpUtils.lowMask("-_");
            long highMaskValue = HttpUtils.highMask("-_");
            HttpUtils.patchUriField(lowMaskValue, "L_DASH");
            HttpUtils.patchUriField(highMaskValue, "H_DASH");
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static void patchUriField(long maskValue, String fieldName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)unsafeField.get(null);
        Field field = URI.class.getDeclaredField(fieldName);
        Object staticFieldBase = unsafe.staticFieldBase(field);
        long staticFieldOffset = unsafe.staticFieldOffset(field);
        unsafe.putObject(staticFieldBase, staticFieldOffset, maskValue);
    }

    private static long lowMask(String chars) {
        int n = chars.length();
        long m = 0L;
        int i = 0;
        while (i < n) {
            char c = chars.charAt(i);
            if (c < '@') {
                m |= 1L << c;
            }
            ++i;
        }
        return m;
    }

    private static long highMask(String chars) {
        int n = chars.length();
        long m = 0L;
        int i = 0;
        while (i < n) {
            char c = chars.charAt(i);
            if (c >= '@' && c < '\u0080') {
                m |= 1L << c - 64;
            }
            ++i;
        }
        return m;
    }

    public static void setupProxy(ClientConfig clientConfig, URI uri) {
        CredentialsProvider cp = (CredentialsProvider)clientConfig.getProperty("jersey.config.apache.client.credentialsProvider");
        HttpUtils.setupUriHost(uri, null);
        IProxyService proxyService = net.sf.jasperreports.eclipse.util.HttpUtils.proxyService;
        if (proxyService.isProxiesEnabled()) {
            if (uri.getHost().contains("_")) {
                if (proxyService.hasSystemProxies() && proxyService.isSystemProxiesEnabled()) {
                    IProxyData[] proxyDatas;
                    AbstractProxyProvider nativeProxyProvider = null;
                    if (proxyService instanceof ProxyManager) {
                        try {
                            Field f = ProxyManager.class.getDeclaredField("nativeProxyProvider");
                            f.setAccessible(true);
                            nativeProxyProvider = (AbstractProxyProvider)f.get(proxyService);
                        }
                        catch (NoSuchFieldException e) {
                            e.printStackTrace();
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    if (nativeProxyProvider == null) {
                        try {
                            nativeProxyProvider = (AbstractProxyProvider)Class.forName("org.eclipse.core.net.ProxyProvider").newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (Exception e) {
                            UIUtils.showError((Throwable)e);
                        }
                    }
                    if (nativeProxyProvider != null && (proxyDatas = nativeProxyProvider.select(uri)).length > 0) {
                        HttpUtils.setupClientConfig(cp, clientConfig, proxyDatas[0]);
                    }
                } else if (!HttpUtils.isHostFiltered(proxyService, uri)) {
                    IProxyData[] iProxyDataArray = proxyService.getProxyData();
                    int n = iProxyDataArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProxyData d = iProxyDataArray[n2];
                        if (d.getHost() != null && d.getHost().equals(uri.getHost())) {
                            HttpUtils.setupClientConfig(cp, clientConfig, d);
                            break;
                        }
                        ++n2;
                    }
                }
            } else {
                IProxyData[] iProxyDataArray = proxyService.select(uri);
                if (iProxyDataArray.length != 0) {
                    IProxyData d = iProxyDataArray[0];
                    HttpUtils.setupClientConfig(cp, clientConfig, d);
                }
            }
        }
        clientConfigs.put(clientConfig, uri);
    }

    private static void setupClientConfig(CredentialsProvider cp, ClientConfig clientConfig, IProxyData d) {
        Credentials c = net.sf.jasperreports.eclipse.util.HttpUtils.getCredentials((IProxyData)d);
        if (c != null && cp != null) {
            cp.setCredentials(new AuthScope(new HttpHost(d.getHost(), d.getPort())), c);
        }
        clientConfig.property("jersey.config.client.proxy.uri", (Object)(String.valueOf(net.sf.jasperreports.eclipse.util.HttpUtils.getProxyProtocol((IProxyData)d)) + "://" + d.getHost() + ":" + d.getPort()));
    }

    private static boolean isHostFiltered(IProxyService ps, URI uri) {
        String[] filters = ps.getNonProxiedHosts();
        int i = 0;
        while (i < filters.length) {
            String filter = filters[i];
            if (HttpUtils.matchesFilter(uri.getHost(), filter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean matchesFilter(String host, String filter) {
        StringMatcher matcher = new StringMatcher(filter, true, false);
        return matcher.match(host);
    }

    public static Request setRequest(Request req, ServerProfile sp) {
        req.connectTimeout(sp.getTimeout());
        req.socketTimeout(sp.getTimeout());
        if (sp.isChunked()) {
            req.setHeader("Transfer-Encoding", "chunked");
        } else {
            req.removeHeaders("Transfer-Encoding");
        }
        req.setHeader("Accept", "application/json");
        return req;
    }

    public static Request get(String url, ServerProfile sp) throws HttpException, IOException {
        System.out.println(url);
        return HttpUtils.setRequest(Request.Get((String)url), sp);
    }

    public static Request put(String url, ServerProfile sp) throws HttpException, IOException {
        System.out.println(url);
        return HttpUtils.setRequest(Request.Put((String)url), sp);
    }

    public static Request post(String url, ServerProfile sp) throws HttpException, IOException {
        System.out.println(url);
        return HttpUtils.setRequest(Request.Post((String)url), sp);
    }

    public static Request post(String url, Form form, ServerProfile sp) throws HttpException, IOException {
        System.out.println(url);
        return HttpUtils.setRequest(Request.Post((String)url).bodyForm((Iterable)form.build()), sp);
    }

    public static Request delete(String url, ServerProfile sp) throws HttpException, IOException {
        System.out.println(url);
        return HttpUtils.setRequest(Request.Delete((String)url), sp);
    }

    public static IProxyService getProxyService() {
        BundleContext bc = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bc.getServiceReference(IProxyService.class.getName());
        IProxyService service = (IProxyService)bc.getService(serviceReference);
        service.addProxyChangeListener(new IProxyChangeListener(){

            public void proxyInfoChanged(IProxyChangeEvent event) {
                for (Executor executor : executors.keySet()) {
                    net.sf.jasperreports.eclipse.util.HttpUtils.setupProxy((Executor)executor, (URI)executors.get(executor));
                }
                for (ClientConfig clientConfig : clientConfigs.keySet()) {
                    HttpUtils.setupProxy(clientConfig, clientConfigs.get(clientConfig));
                }
            }
        });
        return service;
    }
}

