/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.wizard.ListInstallationPage;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.repository.RepositoryView;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.action.server.EditServerAction;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.MServers;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.wizard.pages.ShowServersPage;
import java.util.List;
import java.util.UUID;
import net.sf.jasperreports.eclipse.util.SecureStorageUtils;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ImportServersWizard
extends Wizard
implements IImportWizard {
    ListInstallationPage page0 = new ListInstallationPage();
    ShowServersPage page1 = new ShowServersPage();

    public void addPages() {
        this.addPage((IWizardPage)this.page0);
        this.addPage((IWizardPage)this.page1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private RepositoryView getRepositoryView() {
        return (RepositoryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.jaspersoft.studio.Repository");
    }

    public boolean performFinish() {
        RepositoryView view = this.getRepositoryView();
        TreeViewer treeViewer = null;
        MServers serversNode = null;
        if (view != null) {
            treeViewer = view.getTreeViewer();
            MRoot root = (MRoot)treeViewer.getInput();
            List lst = root.getChildren();
            for (INode n : lst) {
                if (!(n instanceof MServers)) continue;
                serversNode = (MServers)n;
                break;
            }
        }
        List<ServerProfile> servers = this.page1.getSelectedServers();
        for (ServerProfile srv : servers) {
            srv.setPass(this.getPasswordValue(srv.getPass()));
            MServerProfile mservprof = new MServerProfile(null, srv);
            if (serversNode == null) {
                ServerManager.addServerProfile(mservprof);
                continue;
            }
            MServerProfile newprofile = new MServerProfile(serversNode, mservprof.getValue());
            newprofile.setWsClient(null);
            ServerManager.addServerProfile(newprofile);
            EditServerAction.fillServerProfile(newprofile, treeViewer);
        }
        return true;
    }

    private String getPasswordValue(String passwordFieldTxt) {
        return JaspersoftStudioPlugin.shouldUseSecureStorage() ? this.getSecretStorageKey(passwordFieldTxt) : passwordFieldTxt;
    }

    private String getSecretStorageKey(String pass) {
        try {
            UUID uuidKey = UUID.randomUUID();
            SecureStorageUtils.saveToDefaultSecurePreferences((String)"com.jaspersoft.studio.jrserver", (String)uuidKey.toString(), (String)pass);
            return uuidKey.toString();
        }
        catch (StorageException e) {
            Activator.getDefault().logError(Messages.Common_ErrSecurePrefStorage, e);
            return pass;
        }
    }
}

