/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard;

import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.wizard.ServerProfileWizardDialog;
import com.jaspersoft.studio.server.wizard.pages.ServerProfilePage;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;

public class ServerProfileWizard
extends Wizard {
    private ServerProfilePage page0;
    private MServerProfile serverProfile;

    public ServerProfileWizard(MServerProfile sprofile) {
        this.setWindowTitle(Messages.ServerProfileWizard_0);
        this.serverProfile = sprofile;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page0 = new ServerProfilePage(this.serverProfile);
        this.addPage((IWizardPage)this.page0);
    }

    public MServerProfile getServerProfile() {
        return this.serverProfile;
    }

    public boolean performFinish() {
        this.page0.performFinishInvoked();
        return true;
    }

    public void bindTestButton(ServerProfileWizardDialog c) {
        c.addTestListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerProfileWizard.this.handleConnect(true);
            }
        });
    }

    private void handleConnect(final boolean onlycheck) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ServerProfileWizard.this.connect(onlycheck, monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getTargetException());
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e);
        }
    }

    private void connectionOK() {
        UIUtils.getDisplay().asyncExec(() -> {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ServerProfileWizard_1, (String)Messages.ServerProfileWizard_2);
            this.page0.connectionOK();
        });
    }

    private IStatus connect(boolean onlycheck, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                this.page0.connect();
                monitor.beginTask(Messages.ServerProfileWizard_3, -1);
                if (onlycheck) {
                    if (WSClientHelper.checkConnection(this.serverProfile, monitor)) {
                        this.connectionOK();
                    }
                } else {
                    WSClientHelper.connectGetData(this.serverProfile, monitor);
                }
                UIUtils.getDisplay().syncExec(() -> this.page0.showServerInfo());
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

