/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.exp;

import com.jaspersoft.jasperserver.jaxrs.client.dto.importexport.StateDto;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.restv2.ARestV2Connection;
import com.jaspersoft.studio.server.wizard.exp.ExportMetadataPage;
import com.jaspersoft.studio.server.wizard.exp.ExportOptions;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ExportMetadataWizard
extends Wizard {
    private ExportMetadataPage page0;
    private StructuredSelection selection;

    public ExportMetadataWizard(StructuredSelection selection) {
        this.setWindowTitle(Messages.FindResourceWizard_0);
        this.setNeedsProgressMonitor(true);
        this.selection = selection;
    }

    public void addPages() {
        this.page0 = new ExportMetadataPage();
        this.addPage((IWizardPage)this.page0);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block14: {
                        monitor.beginTask(Messages.ExportMetadataWizard_0, -1);
                        try {
                            IConnection conn = null;
                            Object firstElement = ExportMetadataWizard.this.selection.getFirstElement();
                            if (firstElement == null) break block14;
                            if (firstElement instanceof MServerProfile) {
                                conn = ((MServerProfile)((Object)firstElement)).getWsClient();
                            } else if (firstElement instanceof AMResource) {
                                conn = ((AMResource)((Object)firstElement)).getWsClient();
                            }
                            if (conn == null) break block14;
                            ExportOptions opt = ExportMetadataWizard.this.page0.getValue();
                            if (new File(opt.getFile()).exists() && !UIUtils.showConfirmation((String)"Confirmation", (String)String.format("File %s already exists.\nPlease confirm you want we overwrite it.", opt.getFile()))) {
                                return;
                            }
                            try {
                                for (Object obj : ExportMetadataWizard.this.selection.toList()) {
                                    if (obj instanceof MServerProfile) {
                                        opt.getPaths().add("/");
                                        continue;
                                    }
                                    if (!(obj instanceof AMResource)) continue;
                                    String uri = ((AMResource)((Object)obj)).getValue().getUriString();
                                    opt.getPaths().add(uri);
                                }
                                while (opt.getState() == null || opt.getState().getPhase().equals("inprogress")) {
                                    StateDto state = conn.exportMetaData(opt, monitor);
                                    monitor.setTaskName(state.getMessage());
                                    if (monitor.isCanceled()) break;
                                }
                                if (opt.getState() == null) break block14;
                                if (opt.getState().getErrorDescriptor() != null) {
                                    UIUtils.showInformation((String)((ARestV2Connection)conn).getEh().buildMessage(monitor, "", opt.getState().getErrorDescriptor()));
                                    break block14;
                                }
                                UIUtils.showInformation((String)opt.getState().getMessage());
                            }
                            catch (Exception e) {
                                UIUtils.showError((Throwable)e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
            return false;
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e);
            return false;
        }
        return true;
    }
}

