/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.pages;

import com.jaspersoft.jasperserver.dto.authority.ClientRole;
import com.jaspersoft.jasperserver.dto.serverinfo.ServerInfo;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.dialog.VersionCombo;
import com.jaspersoft.studio.editor.context.EditorContextUtil;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.model.server.UseProtocol;
import com.jaspersoft.studio.server.preferences.CASListFieldEditor;
import com.jaspersoft.studio.server.preferences.SSOServer;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.JSSTrustStrategy;
import com.jaspersoft.studio.server.protocol.JdbcDriver;
import com.jaspersoft.studio.server.protocol.Version;
import com.jaspersoft.studio.server.protocol.restv2.CertChainValidator;
import com.jaspersoft.studio.server.wizard.ServerProfileWizardDialog;
import com.jaspersoft.studio.server.wizard.pages.CertificatesDialog;
import com.jaspersoft.studio.server.wizard.pages.UsernameValidator;
import com.jaspersoft.studio.swt.widgets.ClasspathComponent;
import com.jaspersoft.studio.swt.widgets.WLocale;
import com.jaspersoft.studio.swt.widgets.WSecretText;
import com.jaspersoft.studio.swt.widgets.WTimeZone;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.WizardEndingStateListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.ui.validator.EmptyStringValidator;
import net.sf.jasperreports.eclipse.ui.validator.NotEmptyIFolderValidator;
import net.sf.jasperreports.eclipse.ui.validator.URLValidator;
import net.sf.jasperreports.eclipse.util.CastorHelper;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.exolab.castor.mapping.Mapping;

public class ServerProfilePage
extends WizardPage
implements WizardEndingStateListener {
    private MServerProfile sprofile;
    private WSecretText tpass;
    private Text tuser;
    private Text ttimeout;
    private Text lpath;
    private Button bchunked;
    private Combo bmime;
    private Button bdaterange;
    private Combo cUseProtocol;
    private Button bSyncDA;
    private Button blpath;
    private VersionCombo cversion;
    private DataBindingContext dbc;
    private Text txtInfo;
    private WLocale loc;
    private WTimeZone tz;
    private Combo bSSO;
    private Combo ccas;
    private boolean refreshing = false;
    private List<SSOServer> ssoservers = new ArrayList<SSOServer>();
    private Composite cmpUP;
    private Composite cmpCAS;
    private StackLayout stackLayout;
    private Composite cmpCredential;
    private CTabItem drvtab;
    private CTabFolder tabFolder;
    private Button bUpld;
    private Label cstatus;
    private Cursor pushCursor = new Cursor((Device)UIUtils.getDisplay(), 21);
    private JdbcDriver driver = new JdbcDriver();
    private Button bLogging;
    private Composite cmpAsk;
    private Text tuserA;
    private Label ssLabel;
    private Proxy proxy;
    private UsernameValidator userValidator;

    public ServerProfilePage(MServerProfile sprofile) {
        super("serverprofilepage");
        this.setTitle(Messages.ServerProfilePage_1);
        this.setDescription(Messages.ServerProfilePage_2);
        this.sprofile = sprofile;
    }

    public void createControl(Composite parent) {
        this.dbc = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        new Label(composite, 0).setText(Messages.ServerProfilePage_3);
        Text tname = new Text(composite, 2048);
        tname.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        new Label(composite, 258).setLayoutData((Object)gd);
        Composite urlCmp = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        urlCmp.setLayout((Layout)layout);
        new Label(urlCmp, 0).setText(Messages.ServerProfilePage_4);
        this.ssLabel = new Label(urlCmp, 0);
        this.ssLabel.setImage(Activator.getDefault().getImage("icons/lock.png"));
        this.ssLabel.setToolTipText(Messages.ServerProfilePage_48);
        gd = new GridData();
        gd.widthHint = 24;
        this.ssLabel.setLayoutData((Object)gd);
        Text turl = new Text(composite, 2048);
        turl.setLayoutData((Object)new GridData(768));
        turl.addModifyListener(e -> this.closeConnection());
        new Label(composite, 131072);
        this.cstatus = new Label(composite, 131072);
        gd = new GridData(896);
        gd.widthHint = 200;
        this.cstatus.setLayoutData((Object)gd);
        Group gr = new Group(composite, 0);
        gr.setText(Messages.ServerProfilePage_8);
        gr.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gr.setLayoutData((Object)gd);
        new Label((Composite)gr, 0).setText(Messages.ServerProfilePage_9);
        Text torg = new Text((Composite)gr, 2048);
        torg.setLayoutData((Object)new GridData(768));
        torg.addModifyListener(e -> this.closeConnection());
        this.createCredentials(gr);
        Section expcmp = new Section(composite, 4);
        UIUtil.setBold((Control)expcmp);
        expcmp.setText(Messages.ServerProfilePage_advancedsettings);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        expcmp.setLayoutData((Object)gd);
        expcmp.setExpanded(false);
        this.tabFolder = new CTabFolder((Composite)expcmp, 1024);
        expcmp.setClient((Control)this.tabFolder);
        CTabItem bptab = new CTabItem(this.tabFolder, 0);
        bptab.setText(Messages.ServerProfilePage_0);
        bptab.setControl((Control)this.createAdvancedSettings((Composite)this.tabFolder));
        bptab = new CTabItem(this.tabFolder, 0);
        bptab.setText(Messages.ServerProfilePage_5);
        bptab.setControl((Control)this.createInfo((Composite)this.tabFolder));
        this.createJdbcDrivers(this.tabFolder);
        this.tabFolder.setSelection(0);
        expcmp.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                UIUtils.relayoutDialog((Shell)ServerProfilePage.this.getShell(), (int)0, (int)-1);
            }
        });
        ServerProfile value = this.sprofile.getValue();
        try {
            this.refreshing = true;
            this.proxy = new Proxy(value);
            this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)tname), PojoProperties.value((String)"name").observe((Object)value), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new EmptyStringValidator(){

                public IStatus validate(String value) {
                    IStatus s = super.validate(value);
                    if (s.equals(Status.OK_STATUS) && !ServerManager.isUniqueName(ServerProfilePage.this.sprofile, value)) {
                        return ValidationStatus.warning((String)Messages.ServerProfilePage_13);
                    }
                    return s;
                }
            }), null);
            this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)turl), PojoProperties.value((String)"url").observe((Object)this.proxy), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new URLValidator(){

                public IStatus validate(String value) {
                    IStatus status = super.validate(Misc.nvl((Object)value, (String)"").trim());
                    ((ServerProfileWizardDialog)ServerProfilePage.this.getContainer()).setTestButtonEnabled(status.isOK());
                    return status;
                }
            }), null);
            this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.lpath), PojoProperties.value((String)"projectPath").observe((Object)this.proxy), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new NotEmptyIFolderValidator()), null);
            this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)torg), PojoProperties.value((String)"organisation").observe((Object)value));
            this.userValidator = new UsernameValidator(!value.isUseSSO() && !value.isAskPass());
            this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tuser), PojoProperties.value((String)"user").observe((Object)value), new UpdateValueStrategy().setAfterConvertValidator((IValidator)this.userValidator), null);
            this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tuserA), PojoProperties.value((String)"user").observe((Object)value), new UpdateValueStrategy().setAfterConvertValidator((IValidator)this.userValidator), null);
            this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tpass), PojoProperties.value((String)"pass").observe((Object)value));
            this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.ttimeout), PojoProperties.value((String)"timeout").observe((Object)value));
            this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.bchunked), PojoProperties.value((String)"chunked").observe((Object)value));
            this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.bmime), PojoProperties.value((String)"mime").observe((Object)this.proxy));
            this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.loc.getCombo()), PojoProperties.value((String)"locale").observe((Object)value));
            this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.tz.getCombo()), PojoProperties.value((String)"timeZone").observe((Object)value));
            this.dbc.bindValue((IObservableValue)WidgetProperties.singleSelectionIndex().observe((Widget)this.bSSO), PojoProperties.value((String)"sso").observe((Object)this.proxy));
            this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.bdaterange), PojoProperties.value((String)"supportsDateRanges").observe((Object)value));
            this.dbc.bindValue((IObservableValue)WidgetProperties.singleSelectionIndex().observe((Widget)this.cUseProtocol), PojoProperties.value((String)"useProtocol").observe((Object)this.proxy));
            this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.bSyncDA), PojoProperties.value((String)"syncDA").observe((Object)value));
            this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.bLogging), PojoProperties.value((String)"logging").observe((Object)value));
            this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.cversion.getControl()), PojoProperties.value((String)"jrVersion").observe((Object)this.proxy));
            this.tpass.loadSecret("com.jaspersoft.studio.jrserver", Misc.nvl((String)this.sprofile.getValue().getPass()));
        }
        finally {
            this.refreshing = false;
        }
        this.showServerInfo();
    }

    protected void createCredentials(Group gr) {
        SSOServer srv;
        this.cmpCredential = new Composite((Composite)gr, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.cmpCredential.setLayoutData((Object)gd);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginWidth = 0;
        this.cmpCredential.setLayout((Layout)this.stackLayout);
        this.cmpUP = new Composite(this.cmpCredential, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.cmpUP.setLayout((Layout)layout);
        new Label(this.cmpUP, 0).setText(Messages.ServerProfilePage_10);
        this.tuser = new Text(this.cmpUP, 2048);
        this.tuser.setLayoutData((Object)new GridData(768));
        this.tuser.setTextLimit(100);
        this.tuser.addModifyListener(e -> this.closeConnection());
        new Label(this.cmpUP, 0).setText(Messages.ServerProfilePage_11);
        this.tpass = new WSecretText(this.cmpUP, 0x400800);
        this.tpass.setLayoutData((Object)new GridData(768));
        this.cmpCAS = new Composite(this.cmpCredential, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.cmpCAS.setLayout((Layout)layout);
        new Label(this.cmpCAS, 0).setText(Messages.ServerProfilePage_23);
        this.ccas = new Combo(this.cmpCAS, 2060);
        String v = null;
        v = JasperReportsConfiguration.getDefaultInstance().getPrefStore().getString("com.jaspersoft.studio.server.sso");
        String[] stringArray = v.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.isEmpty()) {
                try {
                    srv = (SSOServer)CastorHelper.read((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)line)), (Mapping)CASListFieldEditor.mapping);
                    this.ssoservers.add(srv);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            ++n2;
        }
        final ServerProfile value = this.sprofile.getValue();
        String[] items = new String[this.ssoservers.size()];
        int sel = 0;
        int i = 0;
        while (i < this.ssoservers.size()) {
            srv = this.ssoservers.get(i);
            items[i] = srv.getUrl();
            if (srv.getUuid().equals(value.getSsoUuid())) {
                sel = i;
            }
            ++i;
        }
        this.ccas.setItems(items);
        this.ccas.select(sel);
        if (sel >= 0 && sel < this.ssoservers.size()) {
            value.setSsoUuid(this.ssoservers.get(sel).getUuid());
        }
        this.ccas.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int ind = ServerProfilePage.this.ccas.getSelectionIndex();
                if (ind >= 0 && ind < ServerProfilePage.this.ssoservers.size()) {
                    value.setSsoUuid(ServerProfilePage.this.ssoservers.get(ind).getUuid());
                }
            }
        });
        this.cmpAsk = new Composite(this.cmpCredential, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.cmpAsk.setLayout((Layout)layout);
        new Label(this.cmpAsk, 0).setText(Messages.ServerProfilePage_10);
        this.tuserA = new Text(this.cmpAsk, 2048);
        this.tuserA.setLayoutData((Object)new GridData(768));
        this.tuserA.setTextLimit(100);
        this.tuserA.addModifyListener(e -> this.closeConnection());
        this.stackLayout.topControl = value.isUseSSO() ? this.cmpCAS : (value.isAskPass() ? this.cmpAsk : this.cmpUP);
    }

    private Composite createAdvancedSettings(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(3, false));
        Label lbl = new Label(cmp, 0);
        lbl.setText(Messages.ServerProfilePage_36);
        this.bSSO = new Combo(cmp, 8);
        this.bSSO.setItems(new String[]{Messages.ServerProfilePage_38, Messages.ServerProfilePage_45, Messages.ServerProfilePage_46});
        this.bSSO.setText(Messages.ServerProfilePage_18);
        this.bSSO.setToolTipText(Messages.ServerProfilePage_20);
        this.bSSO.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (ServerProfilePage.this.bSSO.getSelectionIndex()) {
                    case 0: {
                        ServerProfilePage.this.userValidator.setAllowNull(false);
                        ServerProfilePage.this.stackLayout.topControl = ServerProfilePage.this.cmpUP;
                        ServerProfilePage.this.cUseProtocol.setEnabled(true);
                        break;
                    }
                    case 1: {
                        ServerProfilePage.this.userValidator.setAllowNull(true);
                        ServerProfilePage.this.stackLayout.topControl = ServerProfilePage.this.cmpAsk;
                        ServerProfilePage.this.cUseProtocol.setEnabled(true);
                        break;
                    }
                    case 2: {
                        ServerProfilePage.this.userValidator.setAllowNull(true);
                        ServerProfilePage.this.stackLayout.topControl = ServerProfilePage.this.cmpCAS;
                        ServerProfilePage.this.cUseProtocol.select(0);
                        ServerProfilePage.this.cUseProtocol.setEnabled(false);
                    }
                }
                ServerProfilePage.this.cmpCredential.layout();
                ServerProfilePage.this.closeConnection();
                UIUtils.getDisplay().asyncExec(() -> ServerProfilePage.this.dbc.updateTargets());
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.bSSO.setLayoutData((Object)gd);
        lbl = new Label(cmp, 0);
        lbl.setText(Messages.ServerProfilePage_jrversion);
        this.cversion = new VersionCombo(cmp);
        this.cversion.getControl().setItem(0, Messages.ServerProfilePage_25);
        this.cversion.setVersion("last");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.cversion.getControl().setLayoutData((Object)gd);
        String tt = Messages.ServerProfilePage_24;
        lbl.setToolTipText(tt);
        this.cversion.getControl().setToolTipText(tt);
        this.bdaterange = new Button(cmp, 32);
        this.bdaterange.setText(Messages.ServerProfilePage_daterangeexpression);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.bdaterange.setLayoutData((Object)gd);
        tt = Messages.ServerProfilePage_28;
        this.bdaterange.setToolTipText(tt);
        this.bSyncDA = new Button(cmp, 32);
        this.bSyncDA.setText(Messages.ServerProfilePage_14);
        this.bSyncDA.setToolTipText(Messages.ServerProfilePage_15);
        lbl = new Label(cmp, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        lbl.setLayoutData((Object)gd);
        lbl = new Label(cmp, 0);
        lbl.setText(Messages.ServerProfilePage_connectiontimeout);
        this.ttimeout = new Text(cmp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        this.ttimeout.setLayoutData((Object)gd);
        tt = Messages.ServerProfilePage_26;
        lbl.setToolTipText(tt);
        this.ttimeout.setToolTipText(tt);
        this.bchunked = new Button(cmp, 32);
        this.bchunked.setText(Messages.ServerProfilePage_chunkedrequest);
        tt = Messages.ServerProfilePage_27;
        this.bchunked.setToolTipText(tt);
        String ttip = Messages.ServerProfilePage_7;
        lbl = new Label(cmp, 0);
        lbl.setText(Messages.ServerProfilePage_12);
        lbl.setToolTipText(ttip);
        this.bmime = new Combo(cmp, 8);
        this.bmime.setItems(new String[]{"MIME", "DIME"});
        this.bmime.setToolTipText(ttip);
        this.bLogging = new Button(cmp, 32);
        this.bLogging.setText(Messages.ServerProfilePage_34);
        this.bLogging.setToolTipText(Messages.ServerProfilePage_35);
        lbl = new Label(cmp, 0);
        lbl.setText("Use Protocol");
        this.cUseProtocol = new Combo(cmp, 8);
        this.cUseProtocol.setItems(new String[]{"REST Only", "SOAP Only", "REST, if fails then SOAP"});
        tt = Messages.ServerProfilePage_29;
        this.cUseProtocol.setToolTipText(tt);
        lbl = new Label(cmp, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        lbl.setLayoutData((Object)gd);
        ttip = Messages.ServerProfilePage_16;
        lbl = new Label(cmp, 0);
        lbl.setText(Messages.ServerProfilePage_17);
        lbl.setToolTipText(ttip);
        Composite c = new Composite(cmp, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        c.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        c.setLayoutData((Object)gd);
        this.lpath = new Text(c, 2056);
        this.lpath.setLayoutData((Object)new GridData(768));
        this.lpath.setToolTipText(ttip);
        this.blpath = new Button(c, 8);
        this.blpath.setText("...");
        this.blpath.setToolTipText(ttip);
        this.blpath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection2;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                ServerProfile sp = ServerProfilePage.this.sprofile.getValue();
                String ppath = sp.getProjectPath();
                if (!Misc.isNullOrEmpty((String)ppath)) {
                    IResource r = root.findMember(ppath);
                    if (r instanceof IContainer) {
                        root = (IContainer)r;
                    } else if (r == null) {
                        IProject c = null;
                        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject p = iProjectArray[n2];
                            if (p.isOpen()) {
                                String prjName = "/" + p.getName();
                                if (ppath.equals(prjName)) {
                                    c = p;
                                    break;
                                }
                                if (ppath.startsWith(prjName = String.valueOf(prjName) + "/")) {
                                    IFolder f = p.getFolder(ppath.substring(prjName.length()));
                                    if (f.exists()) {
                                        c = f;
                                        break;
                                    }
                                    c = p;
                                    break;
                                }
                            }
                            ++n2;
                        }
                        if (c == null) {
                            ppath = null;
                        } else {
                            root = c;
                        }
                    } else {
                        ppath = null;
                    }
                }
                if (Misc.isNullOrEmpty((String)ppath)) {
                    try {
                        IProject prj = FileUtils.getProject((IProgressMonitor)new NullProgressMonitor());
                        if (prj != null) {
                            root = prj.getFolder(String.valueOf(sp.getName().replace(" ", "")) + "-" + System.currentTimeMillis());
                        }
                    }
                    catch (CoreException e1) {
                        UIUtils.showError((Throwable)e1);
                    }
                }
                ContainerSelectionDialog csd = new ContainerSelectionDialog(ServerProfilePage.this.getShell(), (IContainer)root, true, null);
                csd.setValidator(selection -> {
                    if (selection instanceof Path) {
                        Path spi = (Path)selection;
                        String s0 = spi.segment(0);
                        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject p = iProjectArray[n2];
                            if (p.isOpen() && s0.equals(p.getName())) {
                                return null;
                            }
                            ++n2;
                        }
                        return Messages.ServerProfilePage_37;
                    }
                    return null;
                });
                csd.showClosedProjects(false);
                if (csd.open() == 0 && (selection2 = csd.getResult()) != null && selection2.length > 0 && selection2[0] instanceof Path) {
                    Path path = (Path)selection2[0];
                    String p = path.toPortableString();
                    ServerProfilePage.this.sprofile.setProjectPath(p);
                    IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(p);
                    if (r instanceof Folder) {
                        try {
                            ((Folder)r).setPersistentProperty(EditorContextUtil.EC_KEY, "jrs");
                        }
                        catch (CoreException e1) {
                            e1.printStackTrace();
                        }
                    }
                    try {
                        ServerProfilePage.this.refreshing = true;
                        ServerProfilePage.this.dbc.updateTargets();
                    }
                    finally {
                        ServerProfilePage.this.refreshing = false;
                    }
                }
            }
        });
        lbl = new Label(cmp, 0);
        lbl.setText(Messages.ServerProfilePage_21);
        this.loc = new WLocale(cmp, 2048);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.loc.setLayoutData((Object)gd);
        tt = Messages.ServerProfilePage_30;
        lbl.setToolTipText(tt);
        this.loc.setToolTipText(tt);
        lbl = new Label(cmp, 0);
        lbl.setText(Messages.ServerProfilePage_22);
        this.tz = new WTimeZone(cmp, 2048);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.tz.setLayoutData((Object)gd);
        tt = Messages.ServerProfilePage_31;
        lbl.setToolTipText(tt);
        this.loc.setToolTipText(tt);
        return cmp;
    }

    private Composite createInfo(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout());
        this.txtInfo = new Text(cmp, 586);
        this.txtInfo.setLayoutData((Object)new GridData(1808));
        this.txtInfo.setBackground(cmp.getBackground());
        return cmp;
    }

    public void showServerInfo() {
        try {
            this.txtInfo.setText(this.sprofile.getConnectionInfo());
            IConnection c = this.sprofile.getWsClient();
            if (c != null) {
                ServerInfo si = c.getServerInfo(null);
                this.bdaterange.setEnabled(!Version.isDateRangeSupported(si));
                this.cstatus.setText(Messages.ServerProfilePage_32);
            } else {
                this.cstatus.setText(Messages.ServerProfilePage_33);
            }
            this.cUseProtocol.setEnabled(this.bSSO.getSelectionIndex() != 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.pushCursor.dispose();
        super.dispose();
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.jaspersoft.studio.doc.jaspersoftserver");
    }

    public void performFinishInvoked() {
        if (JaspersoftStudioPlugin.shouldUseSecureStorage()) {
            this.tpass.persistSecret();
            this.sprofile.getValue().setPass(this.tpass.getUUIDKey());
        }
    }

    public void performCancelInvoked() {
    }

    public void connect() {
        UIUtils.getDisplay().asyncExec(() -> {
            if (this.drvtab != null) {
                this.drvtab.dispose();
            }
            if (this.sprofile != null && this.sprofile.getWsClient() != null && this.sprofile.getWsClient().getServerProfile() != null) {
                this.sprofile.getWsClient().getServerProfile().setClientUser(null);
            }
        });
    }

    public void connectionOK() {
        UIUtils.getDisplay().asyncExec(() -> {
            if (this.drvtab != null) {
                this.drvtab.dispose();
            }
            this.createJdbcDrivers(this.tabFolder);
            this.proxy.getUrl();
        });
    }

    private void createJdbcDrivers(CTabFolder tabFolder) {
        if (this.sprofile.getWsClient() == null || !this.sprofile.getWsClient().isSupported(Feature.EXPORTMETADATA) || this.sprofile.getWsClient().getServerProfile() == null || this.sprofile.getWsClient().getServerProfile().getClientUser() == null) {
            return;
        }
        boolean hasPermission = false;
        for (ClientRole r : this.sprofile.getWsClient().getServerProfile().getClientUser().getRoleSet()) {
            if (!r.getName().equals("ROLE_SUPERUSER")) continue;
            hasPermission = true;
            break;
        }
        if (!hasPermission) {
            return;
        }
        this.drvtab = new CTabItem(tabFolder, 0);
        this.drvtab.setText(Messages.ServerProfilePage_39);
        Composite cmp = new Composite((Composite)tabFolder, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(cmp, 64);
        lbl.setText(Messages.ServerProfilePage_40);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        new Label(cmp, 0).setText(Messages.ServerProfilePage_41);
        final Text dname = new Text(cmp, 2048);
        dname.setLayoutData((Object)new GridData(768));
        dname.setText(Misc.nvl((String)this.driver.getClassname()));
        final ClasspathComponent cpath = new ClasspathComponent(cmp){

            protected void handleClasspathChanged() {
                ServerProfilePage.this.driver.setPaths(this.getClasspaths());
                ServerProfilePage.this.bUpld.setEnabled(!Misc.isNullOrEmpty((Collection)this.getClasspaths()) && !Misc.isNullOrEmpty((String)dname.getText()));
            }
        };
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        cpath.getControl().setLayoutData((Object)gd);
        if (!Misc.isNullOrEmpty(this.driver.getPaths())) {
            cpath.setClasspaths(this.driver.getPaths());
        }
        this.bUpld = new Button(cmp, 8);
        this.bUpld.setText(Messages.ServerProfilePage_42);
        gd = new GridData(64);
        gd.horizontalSpan = 2;
        this.bUpld.setLayoutData((Object)gd);
        this.bUpld.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ServerProfilePage.this.getContainer().run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(Messages.ServerProfilePage_43, -1);
                            (this).ServerProfilePage.this.driver.setClassname(dname.getText());
                            (this).ServerProfilePage.this.driver.setPaths(cpath.getClasspaths());
                            try {
                                (this).ServerProfilePage.this.sprofile.getWsClient().uploadJdbcDrivers((this).ServerProfilePage.this.driver, monitor);
                                UIUtils.showInformation((String)Messages.ServerProfilePage_44);
                            }
                            catch (Exception e) {
                                UIUtils.showError((Throwable)e);
                            }
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e1) {
                    UIUtils.showError((Throwable)e1.getCause());
                }
            }
        });
        this.bUpld.setEnabled(!Misc.isNullOrEmpty((Collection)cpath.getClasspaths()) && !Misc.isNullOrEmpty((String)dname.getText()));
        dname.addModifyListener(e -> {
            this.driver.setClassname(dname.getText());
            this.bUpld.setEnabled(!Misc.isNullOrEmpty((Collection)cpath.getClasspaths()) && !Misc.isNullOrEmpty((String)dname.getText()));
        });
        this.drvtab.setControl((Control)cmp);
    }

    protected void closeConnection() {
        if (this.refreshing) {
            return;
        }
        this.sprofile.setWsClient(null);
        if (this.drvtab != null) {
            this.drvtab.dispose();
        }
        this.showServerInfo();
        this.proxy.getUrl();
    }

    public class Proxy {
        private ServerProfile sp;
        private MouseAdapter mlistener = new MouseAdapter(){
            private long time1;
            private ProgressMonitorDialog pmd;
            private boolean shown;

            public void mouseUp(MouseEvent e) {
                if ((long)e.time - this.time1 <= 1000L) {
                    return;
                }
                this.time1 = e.time;
                ((Proxy)Proxy.this).ServerProfilePage.this.ssLabel.removeMouseListener((MouseListener)Proxy.this.mlistener);
                try {
                    try {
                        SSLContextBuilder builder = SSLContexts.custom();
                        KeyStore trustStore = CertChainValidator.getDefaultTrustStore();
                        builder.loadTrustMaterial(trustStore, (TrustStrategy)new JSSTrustStrategy(trustStore){

                            @Override
                            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                ServerProfilePage.this.getContainer().getShell().getDisplay().syncExec(() -> {
                                    if (!shown) {
                                        new CertificatesDialog(UIUtils.getShell(), "", chain[0], chain).open();
                                        shown = true;
                                    }
                                });
                                return true;
                            }
                        });
                        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)new DefaultHostnameVerifier());
                        URL targetURL = Proxy.this.sp.getURL();
                        final Executor exec = Executor.newInstance((HttpClient)HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build());
                        HttpUtils.setupProxy((Executor)exec, (URI)targetURL.toURI());
                        HttpHost pr = HttpUtils.getUnauthProxy((Executor)exec, (URI)targetURL.toURI());
                        final Request req = Request.Get((String)targetURL.toString());
                        if (pr != null) {
                            req.viaProxy(pr);
                        }
                        if (this.pmd != null) {
                            this.pmd.getProgressMonitor().setCanceled(true);
                        }
                        this.shown = false;
                        this.pmd = new ProgressMonitorDialog(ServerProfilePage.this.getContainer().getShell());
                        this.pmd.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask("Connecting", -1);
                                Future future = Async.newInstance().use(exec).execute(req, (FutureCallback)new FutureCallback<Content>(){

                                    public void failed(Exception ex) {
                                        UIUtils.showError((Throwable)ex);
                                    }

                                    public void completed(Content content) {
                                    }

                                    public void cancelled() {
                                    }
                                });
                                while (!future.isDone() && !future.isCancelled()) {
                                    try {
                                        Thread.sleep(5L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        return;
                                    }
                                    if (!monitor.isCanceled()) continue;
                                    future.cancel(true);
                                    return;
                                }
                            }
                        });
                    }
                    catch (SSLHandshakeException sSLHandshakeException) {
                        ((Proxy)Proxy.this).ServerProfilePage.this.ssLabel.addMouseListener((MouseListener)Proxy.this.mlistener);
                        return;
                    }
                    catch (Exception ex) {
                        UIUtils.showError((Throwable)ex);
                        ((Proxy)Proxy.this).ServerProfilePage.this.ssLabel.addMouseListener((MouseListener)Proxy.this.mlistener);
                    }
                }
                finally {
                    ((Proxy)Proxy.this).ServerProfilePage.this.ssLabel.addMouseListener((MouseListener)Proxy.this.mlistener);
                }
            }
        };

        public Proxy(ServerProfile sp) {
            this.sp = sp;
        }

        public void setUrl(String url) {
            this.sp.setUrl(Misc.nvl((String)url).trim());
        }

        public String getUrl() {
            UIUtils.getDisplay().asyncExec(() -> {
                try {
                    if (this.sp.getUrl() != null && this.sp.getUrl().trim().startsWith("https://")) {
                        final Cursor cursor = new Cursor((Device)ServerProfilePage.this.ssLabel.getDisplay(), 21);
                        ServerProfilePage.this.ssLabel.addMouseListener((MouseListener)this.mlistener);
                        ServerProfilePage.this.ssLabel.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                cursor.dispose();
                            }
                        });
                        this.setSslIcon();
                        ServerProfilePage.this.ssLabel.setCursor(cursor);
                        ServerProfilePage.this.ssLabel.getParent().getParent().layout(true);
                        return;
                    }
                }
                catch (MalformedURLException | URISyntaxException exception) {}
                ServerProfilePage.this.ssLabel.removeMouseListener((MouseListener)this.mlistener);
                ServerProfilePage.this.ssLabel.setImage(null);
                ServerProfilePage.this.ssLabel.setCursor(null);
                ServerProfilePage.this.ssLabel.getParent().getParent().layout(true);
            });
            return this.sp.getUrlString();
        }

        private void setSslIcon() {
            if (ServerProfilePage.this.sprofile.getWsClient() == null) {
                ServerProfilePage.this.ssLabel.setImage(Activator.getDefault().getImage("icons/lock.png"));
            } else {
                ServerProfilePage.this.ssLabel.setImage(Activator.getDefault().getImage("icons/lock-green.png"));
            }
        }

        public void setJrVersion(String v) {
            this.sp.setJrVersion(VersionCombo.getJrVersion((String)v));
        }

        public String getJrVersion() {
            return VersionCombo.getLabelVersion((String)this.sp.getJrVersion());
        }

        public void setProjectPath(String projectPath) {
            ServerProfilePage.this.sprofile.setProjectPath(projectPath);
        }

        public String getProjectPath() {
            return this.sp.getProjectPath();
        }

        public void setMime(String v) {
            this.sp.setMime(v.equals("MIME"));
        }

        public String getMime() {
            return this.sp.isMime() ? "MIME" : "DIME";
        }

        public int getUseProtocol() {
            if (this.sp.getUseProtocolEnum().equals((Object)UseProtocol.REST_ONLY)) {
                return 0;
            }
            if (this.sp.getUseProtocolEnum().equals((Object)UseProtocol.SOAP_ONLY)) {
                return 1;
            }
            if (this.sp.getUseProtocolEnum().equals((Object)UseProtocol.REST_SOAP)) {
                return 2;
            }
            return 0;
        }

        public void setUseProtocol(int indx) {
            switch (indx) {
                case 0: {
                    this.sp.setUseProtocolEnum(UseProtocol.REST_ONLY);
                    break;
                }
                case 1: {
                    this.sp.setUseProtocolEnum(UseProtocol.SOAP_ONLY);
                    break;
                }
                case 2: {
                    this.sp.setUseProtocolEnum(UseProtocol.REST_SOAP);
                }
            }
        }

        public int getSso() {
            if (this.sp.isUseSSO()) {
                return 2;
            }
            if (this.sp.isAskPass()) {
                return 1;
            }
            return 0;
        }

        public void setSso(int indx) {
            switch (indx) {
                case 0: {
                    this.sp.setUseSSO(false);
                    this.sp.setAskPass(false);
                    break;
                }
                case 1: {
                    this.sp.setAskPass(true);
                    this.sp.setUseSSO(false);
                    this.sp.setPass(null);
                    break;
                }
                case 2: {
                    this.sp.setAskPass(false);
                    this.sp.setUseSSO(true);
                    this.sp.setPass(null);
                }
            }
        }
    }
}

