/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.pages;

import com.jaspersoft.studio.data.adapter.IReportDescriptor;
import com.jaspersoft.studio.data.wizard.ListInstallationPage;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.preferences.CASListFieldEditor;
import com.jaspersoft.studio.server.preferences.SSOServer;
import com.jaspersoft.studio.server.utils.Encrypter;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.jasperreports.eclipse.util.CastorHelper;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.exolab.castor.mapping.Mapping;

public class ShowServersPage
extends JSSHelpWizardPage {
    private static final String CONTEX_HELP_ID = "com.jaspersoft.studio.doc.wizard_import_select_serverconnection";
    protected IReportDescriptor selectedInstallation;
    private List<Button> selectedElements;
    private Composite content;
    private Label noElementLabel = null;
    private List<SSOServer> ssoServers = new ArrayList<SSOServer>();

    public ShowServersPage() {
        super("IReportDatasourceList");
        this.selectedElements = new ArrayList<Button>();
        this.setTitle(Messages.ShowServersPage_title);
        this.setDescription(Messages.ShowServersPage_description);
    }

    protected List<ServerProfile> createCheckBoxData(Properties prop) {
        ArrayList<ServerProfile> result = new ArrayList<ServerProfile>();
        Integer connectionIndex = 0;
        Encrypter enc = new Encrypter("54fj245vn3vfdsmce4mg0jvs");
        String connectionString = prop.getProperty("server." + connectionIndex + ".url");
        while (connectionString != null) {
            ServerProfile srv = new ServerProfile();
            if (connectionString.endsWith("/services/repository")) {
                connectionString = connectionString.substring(0, connectionString.lastIndexOf("services/repository"));
            }
            srv.setUrl(connectionString);
            String name = prop.getProperty("server." + connectionIndex + ".name");
            srv.setName(name);
            String username = prop.getProperty("server." + connectionIndex + ".username");
            srv.setUser(username);
            srv.setSupportsDateRanges(true);
            String password = prop.getProperty("server." + connectionIndex + ".password.enc");
            password = enc.decrypt(password);
            srv.setPass(password);
            result.add(srv);
            connectionIndex = connectionIndex + 1;
            connectionString = prop.getProperty("server." + connectionIndex + ".url");
        }
        return result;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Properties prop;
            this.selectedInstallation = ((ListInstallationPage)this.getPreviousPage()).getSelection();
            for (Button button : this.selectedElements) {
                button.dispose();
            }
            this.selectedElements.clear();
            if (this.noElementLabel != null) {
                this.noElementLabel.dispose();
            }
            if ((prop = this.selectedInstallation.getServerConnection()) != null) {
                this.ssoServers = ShowServersPage.getCASServers(prop.getProperty("com.jaspersoft.studio.server.sso"));
                List<ServerProfile> checkBoxData = this.createCheckBoxData(prop);
                for (ServerProfile srv : checkBoxData) {
                    Button checkButton = new Button(this.content, 32);
                    try {
                        checkButton.setText(String.valueOf(srv.getName()) + " (" + srv.getUrl() + ")");
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    checkButton.setData((Object)srv);
                    this.selectedElements.add(checkButton);
                }
            }
            if (this.selectedElements.isEmpty()) {
                this.noElementLabel = new Label(this.content, 0);
                this.noElementLabel.setText(Messages.ShowServersPage_noElementsLabel);
            }
            this.content.layout();
            ((ScrolledComposite)this.content.getParent()).setMinSize(this.content.computeSize(-1, -1));
        }
    }

    public static List<SSOServer> getCASServers(String casProp) {
        ArrayList<SSOServer> servers = new ArrayList<SSOServer>();
        if (casProp != null) {
            String[] stringArray = casProp.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.isEmpty()) {
                    try {
                        SSOServer srv = (SSOServer)CastorHelper.read((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)line)), (Mapping)CASListFieldEditor.getMapping());
                        servers.add(srv);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return servers;
    }

    public List<SSOServer> getSSOToImport() {
        return this.ssoServers;
    }

    public List<ServerProfile> getSelectedServers() {
        ArrayList<ServerProfile> result = new ArrayList<ServerProfile>();
        for (Button element : this.selectedElements) {
            if (!element.getSelection()) continue;
            result.add((ServerProfile)element.getData());
        }
        return result;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Label titleLabel = new Label(mainComposite, 0);
        titleLabel.setText(Messages.ShowServersPage_label);
        ScrolledComposite scrollComp = new ScrolledComposite(mainComposite, 768);
        scrollComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).create());
        scrollComp.setLayoutData((Object)new GridData(4, 4, true, true));
        scrollComp.setLayout((Layout)new GridLayout(1, false));
        scrollComp.setExpandHorizontal(true);
        scrollComp.setExpandVertical(true);
        this.content = new Composite((Composite)scrollComp, 0);
        scrollComp.setContent((Control)this.content);
        this.content.setLayout((Layout)new GridLayout(1, false));
        this.content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)mainComposite);
    }

    protected String getContextName() {
        return CONTEX_HELP_ID;
    }
}

