/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.IInputControlsContainer;
import com.jaspersoft.studio.server.wizard.resource.EditResourcePage;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ResourceWizard
extends Wizard {
    private boolean skipFirstPage = false;
    private boolean nested = false;
    private ResourceFactory rfactory = new ResourceFactory();
    private ANode parent;
    private AMResource resource;

    public void setNested(boolean nested) {
        this.nested = nested;
    }

    public ResourceWizard(ANode parent, AMResource resource, boolean skipFirstPage, boolean nested) {
        this(parent, resource, skipFirstPage);
        this.setNested(nested);
    }

    public ResourceWizard(ANode parent, AMResource resource, boolean skipFirstPage) {
        this(parent, resource);
        this.skipFirstPage = skipFirstPage;
    }

    public ResourceWizard(ANode parent, AMResource resource) {
        this.setWindowTitle(Messages.ResourceWizard_windowtitle);
        this.setNeedsProgressMonitor(true);
        this.resource = resource;
        this.parent = parent;
    }

    public IWizardPage getStartingPage() {
        IWizardPage[] pages = this.getPages();
        if (this.skipFirstPage && pages.length > 1) {
            return pages[1];
        }
        if (pages.length == 1 && pages[0] instanceof EditResourcePage) {
            ((EditResourcePage)pages[0]).setFirstPage(1);
        }
        return super.getStartingPage();
    }

    public void addPages() {
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = this.rfactory.getResourcePage(this.parent, this.resource);
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage p = iWizardPageArray[n2];
            this.addPage(p);
            ++n2;
        }
    }

    public boolean performFinish() {
        if (this.nested) {
            return true;
        }
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Saving", -1);
                    try {
                        try {
                            ResourceDescriptor rd = ResourceWizard.this.resource.getValue();
                            rd.fixResourceMap();
                            WSClientHelper.saveResource(ResourceWizard.this.resource, monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
            return false;
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        if (this.nested) {
            return true;
        }
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Canceling", -1);
                    try {
                        try {
                            if (ResourceWizard.this.resource.getParent() instanceof IInputControlsContainer) {
                                WSClientHelper.refreshContainer((AMResource)ResourceWizard.this.resource.getParent(), monitor);
                            } else {
                                WSClientHelper.refreshResource(ResourceWizard.this.resource, monitor);
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e);
        }
        return true;
    }
}

