/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.restv2.DiffFields;
import com.jaspersoft.studio.server.wizard.resource.APageContent;
import com.jaspersoft.studio.utils.GridDataUtil;
import com.jaspersoft.studio.utils.UIUtil;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.text.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.text.StringToNumberConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DataTypePageContent
extends APageContent {
    private IValidator tLengValidator = new IValidator(){

        public IStatus validate(Object value) {
            String stringValue = (String)value;
            try {
                if (new Integer(stringValue) < 0) {
                    return ValidationStatus.error((String)Messages.DataTypePageContent_7);
                }
                return Status.OK_STATUS;
            }
            catch (NumberFormatException numberFormatException) {
                return ValidationStatus.error((String)Messages.DataTypePageContent_8);
            }
        }
    };
    private ShiftProxy proxy = new ShiftProxy();
    private Text tlenght;
    private Label lenghtLbl;
    private UpdateValueStrategy minUVSaGet;
    private UpdateValueStrategy minUV;
    private UpdateValueStrategy maxUVSaGet;
    private UpdateValueStrategy maxUV;
    private Text tpattern;
    private ISWTObservableValue observeDataTypeComboSelection;
    private Button bmax;
    private Text tmax;
    private Text tmin;
    private Button bmin;
    private Combo ttype;

    public DataTypePageContent(ANode parent, AMResource resource, DataBindingContext bindingContext) {
        super(parent, resource, bindingContext);
    }

    public DataTypePageContent(ANode parent, AMResource resource) {
        super(parent, resource);
    }

    @Override
    public String getPageName() {
        return "com.jaspersoft.studio.server.page.datatype";
    }

    @Override
    public String getName() {
        return Messages.RDDataTypePage_datatype;
    }

    @Override
    public Control createContent(Composite parent) {
        final Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        UIUtil.createLabel((Composite)container, (String)Messages.RDDataTypePage_datatype);
        this.ttype = new Combo(container, 2056);
        this.ttype.setItems(new String[]{Messages.RDDataTypePage_text, Messages.RDDataTypePage_number, Messages.RDDataTypePage_date, Messages.RDDataTypePage_datetime, Messages.RDDataTypePage_time});
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.ttype.setLayoutData((Object)gd);
        final Label tpatternLbl = UIUtil.createLabel((Composite)container, (String)Messages.RDDataTypePage_pattern);
        this.tpattern = new Text(container, 2048);
        this.tpattern.setLayoutData((Object)new GridData(768));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.tpattern.setLayoutData((Object)gd);
        if (this.res.isSupported(Feature.MAXLENGHT)) {
            this.lenghtLbl = UIUtil.createLabel((Composite)container, (String)Messages.DataTypePageContent_0);
            this.tlenght = new Text(container, 133120);
            gd = new GridData();
            gd.widthHint = 100;
            gd.horizontalSpan = 2;
            this.tlenght.setLayoutData((Object)gd);
        }
        final Label tminLbl = UIUtil.createLabel((Composite)container, (String)Messages.RDDataTypePage_minvalue);
        this.tmin = new Text(container, 2048);
        gd = new GridData();
        gd.widthHint = 200;
        this.tmin.setLayoutData((Object)gd);
        this.bmin = new Button(container, 32);
        this.bmin.setText(Messages.RDDataTypePage_strictmin);
        final Label tmaxLbl = UIUtil.createLabel((Composite)container, (String)Messages.RDDataTypePage_maxvalue);
        this.tmax = new Text(container, 2048);
        gd = new GridData();
        gd.widthHint = 200;
        this.tmax.setLayoutData((Object)gd);
        this.bmax = new Button(container, 32);
        this.bmax.setText(Messages.RDDataTypePage_strictmax);
        this.observeDataTypeComboSelection = WidgetProperties.singleSelectionIndex().observe((Widget)this.ttype);
        this.observeDataTypeComboSelection.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (event.diff != null) {
                    Object newValue = event.diff.getNewValue();
                    boolean isText = false;
                    if (newValue instanceof Integer && newValue.equals(0)) {
                        isText = true;
                    }
                    DataTypePageContent.this.toggleControlStatus((Control)DataTypePageContent.this.tpattern, isText);
                    if (DataTypePageContent.this.lenghtLbl != null) {
                        DataTypePageContent.this.toggleControlStatus((Control)DataTypePageContent.this.lenghtLbl, isText);
                    }
                    if (DataTypePageContent.this.tlenght != null) {
                        DataTypePageContent.this.toggleControlStatus((Control)DataTypePageContent.this.tlenght, isText);
                    }
                    DataTypePageContent.this.toggleControlStatus((Control)tpatternLbl, isText);
                    DataTypePageContent.this.toggleControlStatus((Control)tmaxLbl, !isText);
                    DataTypePageContent.this.toggleControlStatus((Control)DataTypePageContent.this.tmax, !isText);
                    DataTypePageContent.this.toggleControlStatus((Control)tminLbl, !isText);
                    DataTypePageContent.this.toggleControlStatus((Control)DataTypePageContent.this.tmin, !isText);
                    DataTypePageContent.this.toggleControlStatus((Control)DataTypePageContent.this.bmax, !isText);
                    DataTypePageContent.this.toggleControlStatus((Control)DataTypePageContent.this.bmin, !isText);
                    container.layout();
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DataTypePageContent.this.bindingContext.updateTargets();
                            DataTypePageContent.this.bindingContext.updateModels();
                        }
                    });
                    DataTypePageContent.this.setProtocolSpecific();
                }
            }
        });
        this.rebind();
        return container;
    }

    @Override
    protected void rebind() {
        final ResourceDescriptor rd = this.res.getValue();
        final IConnection con = this.getWsClient();
        if (this.tlenght != null) {
            com.ibm.icu.text.NumberFormat numberFormat = com.ibm.icu.text.NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(false);
            StringToNumberConverter targetToModelConverter = StringToNumberConverter.toInteger((Format)numberFormat, (boolean)true);
            NumberToStringConverter modelToTargetConverter = NumberToStringConverter.fromInteger((Format)numberFormat, (boolean)true);
            Binding b = this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tlenght), PojoProperties.value((String)"maxLenght").observe((Object)this.getProxy(rd)), new UpdateValueStrategy().setAfterGetValidator(this.tLengValidator).setConverter((IConverter)targetToModelConverter), new UpdateValueStrategy().setConverter((IConverter)modelToTargetConverter));
            ControlDecorationSupport.create((ValidationStatusProvider)b, (int)16512);
        }
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tpattern), PojoProperties.value((String)"pattern").observe((Object)rd));
        if (this.tmin != null) {
            IValidator minMaxValidator = new IValidator(){

                public IStatus validate(Object value) {
                    String stringValue = (String)value;
                    String format = "";
                    try {
                        if (!Misc.isNullOrEmpty((String)stringValue)) {
                            switch (DataTypePageContent.this.getProxy(rd).getDataType()) {
                                case 1: {
                                    format = Messages.DataTypePageContent_3;
                                    NumberFormat.getNumberInstance().parse(stringValue);
                                    break;
                                }
                                case 2: {
                                    format = con.getServerInfo().getDateFormatPattern();
                                    con.getDateFormat().parseObject(stringValue);
                                    break;
                                }
                                case 3: {
                                    format = con.getServerInfo().getDatetimeFormatPattern();
                                    con.getTimestampFormat().parseObject(stringValue);
                                    break;
                                }
                                case 4: {
                                    format = "h:mm:ss";
                                    con.getTimeFormat().parseObject(stringValue);
                                }
                            }
                        }
                        return Status.OK_STATUS;
                    }
                    catch (ParseException parseException) {
                        return ValidationStatus.error((String)(String.valueOf(Messages.DataTypePageContent_4) + format.replace("'", "")));
                    }
                }
            };
            this.minUVSaGet = new UpdateValueStrategy().setAfterGetValidator(minMaxValidator);
            this.minUV = new UpdateValueStrategy();
            this.maxUVSaGet = new UpdateValueStrategy().setAfterGetValidator(minMaxValidator);
            this.maxUV = new UpdateValueStrategy();
            this.setProtocolSpecific();
        }
        Binding b = this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tmin), PojoProperties.value((String)"minValue").observe((Object)rd), this.minUVSaGet, this.minUV);
        ControlDecorationSupport.create((ValidationStatusProvider)b, (int)16512);
        b = this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tmax), PojoProperties.value((String)"maxValue").observe((Object)rd), this.maxUVSaGet, this.maxUV);
        ControlDecorationSupport.create((ValidationStatusProvider)b, (int)16512);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.bmin), PojoProperties.value((String)"strictMin").observe((Object)rd));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.bmax), PojoProperties.value((String)"strictMax").observe((Object)rd));
        this.bindingContext.bindValue((IObservableValue)this.observeDataTypeComboSelection, PojoProperties.value((String)"dataType").observe((Object)this.getProxy(rd)));
    }

    private void setProtocolSpecific() {
        ResourceDescriptor rd = this.res.getValue();
        IConnection con = this.getWsClient();
        if (!con.isSupported(Feature.SEARCHREPOSITORY)) {
            if (this.tlenght != null) {
                this.tlenght.setEnabled(false);
            }
            if (this.tpattern != null) {
                this.tpattern.setEnabled(false);
            }
            if (this.tmin != null) {
                this.tmin.setEnabled(false);
            }
            if (this.tmax != null) {
                this.tmax.setEnabled(false);
            }
            if (this.bmin != null) {
                this.bmin.setEnabled(false);
            }
            if (this.bmax != null) {
                this.bmax.setEnabled(false);
            }
            if (!rd.getIsNew()) {
                this.ttype.setEnabled(false);
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataTypePageContent.this.page.setDescription(Messages.DataTypePageContent_2);
                    }
                });
            }
        }
    }

    private void toggleControlStatus(Control control, boolean enable) {
        control.setEnabled(enable);
        control.setVisible(enable);
        GridDataUtil.gridDataExclude((Control)control, (!enable ? 1 : 0) != 0);
    }

    private ShiftProxy getProxy(ResourceDescriptor rd) {
        this.proxy.setResourceDescriptor(rd);
        return this.proxy;
    }

    @Override
    public String getHelpContext() {
        return "com.jaspersoft.studio.doc.editDataType";
    }

    class ShiftProxy {
        private ResourceDescriptor rd;
        private final int shift = 1;

        ShiftProxy() {
        }

        public void setResourceDescriptor(ResourceDescriptor rd) {
            this.rd = rd;
        }

        public void setDataType(int type) {
            this.rd.setDataType((byte)(type + 1));
        }

        public int getDataType() {
            return this.rd.getDataType() - 1;
        }

        public Integer getMaxLenght() {
            return (Integer)Misc.nvl((Object)DiffFields.getSoapValueInteger(this.rd, "maxLength"), (Object)new Integer(0));
        }

        public void setMaxLenght(Integer v) {
            DiffFields.setSoapValue(this.rd, "maxLength", (Integer)Misc.nvl((Object)v, (Object)new Integer(0)));
        }
    }
}

