/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.utils.IPageCompleteListener;
import com.jaspersoft.studio.server.wizard.resource.APageContent;
import com.jaspersoft.studio.server.wizard.resource.page.QueryVisibleColumnsTable;
import com.jaspersoft.studio.server.wizard.resource.page.selector.ASelector;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorDataType;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorLov;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorQuery;
import com.jaspersoft.studio.utils.UIUtil;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class InputControlPageContent
extends APageContent
implements IPageCompleteListener {
    private boolean reset = false;
    private ASelector cSelector;
    private SelectorDataType sDataType;
    private SelectorLov sLov;
    private SelectorQuery sQuery;
    private Composite stackComposite;
    private Composite cvalue;
    private Group clov;
    private Group csinglevalue;
    private TabFolder cquery;
    private ShiftMapProxy proxy = new ShiftMapProxy();
    private QueryVisibleColumnsTable qvct;
    private Button bmand;
    private Button bread;
    private Button bvisible;
    private Combo ctype;
    private Text tvalue;
    private StackLayout stackLayout;

    public InputControlPageContent(ANode parent, AMResource resource, DataBindingContext bindingContext) {
        super(parent, resource, bindingContext);
    }

    public InputControlPageContent(ANode parent, AMResource resource) {
        super(parent, resource);
    }

    @Override
    public String getPageName() {
        return "com.jaspersoft.studio.server.page.ice";
    }

    @Override
    public String getName() {
        return Messages.RDInputControlPage_inputcontroltableitem;
    }

    @Override
    public Control createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0);
        Composite cmp = new Composite(composite, 0);
        cmp.setLayoutData((Object)new GridData(768));
        cmp.setLayout((Layout)new RowLayout());
        cmp.setBackground(parent.getBackground());
        this.bmand = new Button(cmp, 32);
        this.bmand.setText(Messages.RDInputControlPage_mandatory);
        this.bread = new Button(cmp, 32);
        this.bread.setText(Messages.RDInputControlPage_readonly);
        this.bvisible = new Button(cmp, 32);
        this.bvisible.setText(Messages.RDInputControlPage_visible);
        UIUtil.createLabel((Composite)composite, (String)Messages.RDInputControlPage_type);
        this.ctype = new Combo(composite, 2056);
        this.ctype.setItems(new String[]{Messages.InputControlPageContent_boolean, Messages.InputControlPageContent_singleValue, Messages.RDInputControlPage_singlselectlistofvalues, Messages.RDInputControlPage_singleselectlovradio, Messages.RDInputControlPage_multiselectlov, Messages.RDInputControlPage_multiselectlovradio, Messages.RDInputControlPage_singlselectquery, Messages.RDInputControlPage_singleselectqueryradio, Messages.RDInputControlPage_multiselectquery, Messages.RDInputControlPage_multiselectquerycheckbox});
        this.stackComposite = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.stackComposite.setLayoutData((Object)gd);
        this.cvalue = new Composite(this.stackComposite, 0);
        this.createSingleValue(this.stackComposite);
        this.createLOV(this.stackComposite);
        this.createQuery(this.stackComposite);
        this.ctype.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputControlPageContent.this.handleTypeChanged(InputControlPageContent.this.ctype, InputControlPageContent.this.stackLayout);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.rebind();
        this.reset = true;
        return composite;
    }

    @Override
    protected void rebind() {
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.singleSelectionIndex().observe((Widget)this.ctype), PojoProperties.value((String)"controlType").observe((Object)this.getProxy(this.res.getValue())));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.bmand), PojoProperties.value((String)"mandatory").observe((Object)this.res.getValue()));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.bread), PojoProperties.value((String)"readOnly").observe((Object)this.res.getValue()));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.bvisible), PojoProperties.value((String)"visible").observe((Object)this.res.getValue()));
        if (this.tvalue != null) {
            this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tvalue), PojoProperties.value((String)"queryValueColumn").observe((Object)this.res.getValue()));
        }
        this.handleTypeChanged(this.ctype, this.stackLayout);
    }

    protected void handleTypeChanged(Combo ctype, StackLayout stackLayout) {
        ASelector newSelector = null;
        int s = ctype.getSelectionIndex();
        if (this.cSelector != null) {
            this.cSelector.removePageCompleteListener(this);
        }
        if (s < 1) {
            stackLayout.topControl = this.cvalue;
            this.res.getValue().getChildren().clear();
            this.setPageComplete(true);
        } else {
            if (s < 2) {
                stackLayout.topControl = this.csinglevalue;
                newSelector = this.sDataType;
            } else if (s < 6) {
                stackLayout.topControl = this.clov;
                newSelector = this.sLov;
            } else {
                stackLayout.topControl = this.cquery;
                newSelector = this.sQuery;
            }
            newSelector.addPageCompleteListener(this);
            this.setPageComplete(newSelector.isPageComplete());
        }
        if (newSelector != this.cSelector) {
            if (newSelector != null && this.reset) {
                this.cleanResource();
                newSelector.resetResource();
            }
            this.cSelector = newSelector;
        }
        this.stackComposite.layout();
    }

    private void cleanResource() {
        ResourceDescriptor r = this.res.getValue();
        r.getChildren().clear();
    }

    @Override
    public void pageCompleted(boolean completed) {
        if (this.cSelector != null) {
            this.setPageComplete(this.cSelector.isPageComplete());
        }
    }

    protected void createSingleValue(Composite composite) {
        this.csinglevalue = new Group(composite, 0);
        this.csinglevalue.setText(Messages.RDInputControlPage_datatype);
        this.csinglevalue.setLayout((Layout)new GridLayout(3, false));
        this.sDataType = new SelectorDataType();
        this.sDataType.createControls((Composite)this.csinglevalue, this.pnode, this.res);
    }

    protected void createLOV(Composite composite) {
        this.clov = new Group(composite, 0);
        this.clov.setText(Messages.RDInputControlPage_lov);
        this.clov.setLayout((Layout)new GridLayout(3, false));
        this.sLov = new SelectorLov();
        this.sLov.createControls((Composite)this.clov, this.pnode, this.res);
    }

    protected void createQuery(Composite composite) {
        this.cquery = new TabFolder(composite, 0);
        TabItem item = new TabItem(this.cquery, 0);
        item.setText(Messages.RDInputControlPage_queryresource);
        Composite cmp = new Composite((Composite)this.cquery, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        item.setControl((Control)cmp);
        this.sQuery = new SelectorQuery();
        this.sQuery.createControls(cmp, this.pnode, this.res);
        item = new TabItem(this.cquery, 0);
        item.setText(Messages.RDInputControlPage_valueandvisiblecolumns);
        cmp = new Composite((Composite)this.cquery, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        item.setControl((Control)cmp);
        UIUtil.createLabel((Composite)cmp, (String)Messages.RDInputControlPage_valuecolumn);
        this.tvalue = new Text(cmp, 2048);
        this.tvalue.setLayoutData((Object)new GridData(768));
        cmp = new Composite(cmp, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        cmp.setLayoutData((Object)gd);
        this.qvct = new QueryVisibleColumnsTable(cmp, this.res.getValue(), this, this.sQuery);
        this.tvalue.addModifyListener(e -> this.pageCompleted(this.sQuery.isPageComplete()));
    }

    @Override
    public void dispose() {
        if (this.cSelector != null) {
            this.cSelector.removePageCompleteListener(this);
        }
        super.dispose();
    }

    private ShiftMapProxy getProxy(ResourceDescriptor rd) {
        this.proxy.setResourceDescriptor(rd);
        return this.proxy;
    }

    @Override
    public String getHelpContext() {
        return "com.jaspersoft.studio.doc.editInputControl";
    }

    class ShiftMapProxy {
        private ResourceDescriptor rd;
        private final int[] shift = new int[]{1, 2, 3, 8, 6, 10, 4, 9, 7, 11};

        ShiftMapProxy() {
        }

        public void setResourceDescriptor(ResourceDescriptor rd) {
            this.rd = rd;
        }

        public void setControlType(int type) {
            this.rd.setControlType((byte)this.shift[type]);
        }

        public int getControlType() {
            int i = 0;
            while (i < this.shift.length) {
                if (this.shift[i] == this.rd.getControlType()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

