/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.preferences.editor.table.TableLabelProvider;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.wizard.resource.APageContent;
import com.jaspersoft.studio.server.wizard.resource.StringValueDialog;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorQuery;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class QueryVisibleColumnsTable {
    private ResourceDescriptor rd;
    private APageContent page;
    private SelectorQuery sQuery;
    private TableViewer tableViewer;

    public QueryVisibleColumnsTable(Composite composite, ResourceDescriptor rd, APageContent page, SelectorQuery sQuery) {
        this.rd = rd;
        this.page = page;
        this.sQuery = sQuery;
        this.createControls(composite);
    }

    public void setValues() {
        List lst = (List)this.tableViewer.getInput();
        this.rd.setQueryVisibleColumns(lst.toArray(new String[lst.size()]));
        this.page.setPageComplete(this.sQuery.isPageComplete());
    }

    private void createControls(Composite composite) {
        this.buildTable(composite);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        NewButton bnew = new NewButton(){

            protected void afterElementAdded(Object selement) {
                QueryVisibleColumnsTable.this.setValues();
                super.afterElementAdded(selement);
            }
        };
        bnew.createNewButtons(bGroup, this.tableViewer, (input, pos) -> {
            StringValueDialog d = new StringValueDialog(composite.getShell(), Messages.QueryVisibleColumnsTable_0);
            if (d.open() == 0) {
                return d.getValue();
            }
            return null;
        });
        EditButton bedit = new EditButton();
        bedit.createEditButtons(bGroup, this.tableViewer, (input, pos) -> {
            StringValueDialog d = new StringValueDialog(composite.getShell(), (String)input.get(pos));
            if (d.open() == 0) {
                input.set(pos, d.getValue());
                this.setValues();
            }
        });
        bedit.editOnDoubleClick();
        DeleteButton bdel = new DeleteButton(){

            protected void afterElementDeleted(Object selement) {
                QueryVisibleColumnsTable.this.setValues();
                super.afterElementDeleted(selement);
            }
        };
        bdel.createDeleteButton(bGroup, this.tableViewer);
        ListOrderButtons border = new ListOrderButtons();
        border.createOrderButtons(bGroup, this.tableViewer);
        border.addChangeListener(event -> this.setValues());
        this.tableViewer.setInput(new ArrayList<String>(Arrays.asList(this.rd.getQueryVisibleColumns())));
    }

    private void buildTable(Composite composite) {
        Table table = new Table(composite, 67588);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.attachContentProvider(this.tableViewer);
        this.attachLabelProvider(this.tableViewer);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[]{new TableColumn(table, 0)};
        column[0].setText(Messages.QueryVisibleColumnsTable_1);
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
    }

    private void attachContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
    }
}

