/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page.datasource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.wizard.resource.APageContent;
import com.jaspersoft.studio.server.wizard.resource.page.datasource.ImportDataSourceInfoFromDA;
import com.jaspersoft.studio.server.wizard.resource.page.datasource.TimeZoneProperty;
import com.jaspersoft.studio.swt.widgets.ClasspathComponent;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.SecretsUtil;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DatasourceJDBCPageContent
extends APageContent {
    private Text tdriver;
    private Text turl;
    private Text tuser;
    private Text tpass;
    private ClasspathComponent cpath;

    public DatasourceJDBCPageContent(ANode parent, AMResource resource, DataBindingContext bindingContext) {
        super(parent, resource, bindingContext);
    }

    public DatasourceJDBCPageContent(ANode parent, AMResource resource) {
        super(parent, resource);
    }

    @Override
    public String getPageName() {
        return "com.jaspersoft.studio.server.page.datasource.jdbc";
    }

    @Override
    public String getName() {
        return Messages.RDDatasourceJDBCPage_DatasourceTabItem;
    }

    @Override
    public Control createContent(Composite parent) {
        return this.createContent(parent, true, true);
    }

    public Control createContent(Composite parent, boolean rebind, boolean importButton) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        UIUtil.createLabel((Composite)composite, (String)Messages.RDDatasourceJDBCPage_Driver);
        this.tdriver = new Text(composite, 2048);
        this.tdriver.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel((Composite)composite, (String)Messages.RDDatasourceJDBCPage_URL);
        this.turl = new Text(composite, 2048);
        this.turl.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel((Composite)composite, (String)Messages.RDDatasourceJDBCPage_User);
        this.tuser = new Text(composite, 2048);
        this.tuser.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel((Composite)composite, (String)Messages.RDDatasourceJDBCPage_Password);
        this.tpass = new Text(composite, 0x400800);
        this.tpass.setLayoutData((Object)new GridData(768));
        TimeZoneProperty.addTimeZone(this.res, composite);
        if (importButton) {
            this.createImportButton(composite, this.tdriver, this.turl, this.tuser, this.tpass);
        }
        if (rebind) {
            this.rebind();
        }
        return composite;
    }

    @Override
    protected void rebind() {
        ResourceDescriptor rd = this.res.getValue();
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tdriver), PojoProperties.value((String)"driverClass").observe((Object)rd));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.turl), PojoProperties.value((String)"connectionUrl").observe((Object)rd));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tuser), PojoProperties.value((String)"username").observe((Object)rd));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tpass), PojoProperties.value((String)"password").observe((Object)rd));
        if (this.cpath != null && this.res.getValue() != null && this.res.getValue() instanceof List) {
            this.cpath.setClasspaths((List)((Object)this.res.getValue()));
        }
    }

    protected void createImportButton(Composite composite, final Text tdriver, final Text turl, final Text tuser, final Text tpass) {
        Button importDA = new Button(composite, 0);
        importDA.setText(Messages.RDDatasourceJDBCPage_ImportButton);
        importDA.setToolTipText(Messages.RDDatasourceJDBCPage_ImportButtonTooltip);
        importDA.setLayoutData((Object)new GridData(131072, 128, true, false, 2, 1));
        importDA.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDataSourceInfoFromDA<JdbcDataAdapter> dialog = new ImportDataSourceInfoFromDA<JdbcDataAdapter>(UIUtils.getShell(), "JDBC", JdbcDataAdapter.class);
                if (dialog.open() == 0) {
                    JdbcDataAdapter da = dialog.getSelectedDataAdapter();
                    if (da != null) {
                        tdriver.setText(da.getDriver());
                        turl.setText(da.getUrl());
                        tuser.setText(da.getUsername());
                        tpass.setText(DatasourceJDBCPageContent.this.getDecodedPassword(da.getPassword()));
                    } else {
                        tdriver.setText("");
                        turl.setText("");
                        tuser.setText("");
                        tpass.setText("");
                    }
                }
            }
        });
    }

    private String getDecodedPassword(String encodedPasswd) {
        JasperReportsConfiguration jrconfig = this.res.getJasperConfiguration();
        if (jrconfig == null) {
            jrconfig = JasperReportsConfiguration.getDefaultInstance();
        }
        SecretsUtil secretsUtil = SecretsUtil.getInstance((JasperReportsContext)jrconfig);
        return secretsUtil.getSecret("net.sf.jasperreports.data.adapter", encodedPasswd);
    }

    @Override
    public String getHelpContext() {
        return "com.jaspersoft.studio.doc.adapter_JDBC";
    }
}

