/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page.datasource;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.server.messages.Messages;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ImportDataSourceInfoFromDA<T extends DataAdapter>
extends PersistentLocationDialog {
    private static final String _DA = "_DA";
    private T selectedDA;
    private String daKind;
    private Class<T> daClass;

    public ImportDataSourceInfoFromDA(Shell parentShell, String daKind, Class<T> daClass) {
        super(parentShell);
        this.daKind = daKind;
        this.daClass = daClass;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ImportDataSourceInfoFromDA_DialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout());
        Label lblInfo = new Label(container, 0);
        lblInfo.setLayoutData((Object)new GridData(768));
        lblInfo.setText(MessageFormat.format(Messages.ImportDataSourceInfoFromDA_InfoLabel, this.daKind));
        final Combo combo = new Combo(container, 8);
        combo.setLayoutData((Object)new GridData(768));
        this.addAdapters(DataAdapterManager.getPreferencesStorage(), combo);
        List das = DataAdapterManager.getProjectStorages();
        for (ADataAdapterStorage d : das) {
            this.addAdapters(d, combo);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDataSourceInfoFromDA.this.selectedDA = (DataAdapter)combo.getData(String.valueOf(combo.getSelectionIndex()) + ImportDataSourceInfoFromDA._DA);
            }
        });
        if (combo.getItemCount() > 0) {
            combo.select(0);
            this.selectedDA = (DataAdapter)combo.getData("0_DA");
        }
        return container;
    }

    private void addAdapters(ADataAdapterStorage das, Combo combo) {
        Collection dataAdapterDescriptors = das.getDataAdapterDescriptors();
        for (DataAdapterDescriptor da : dataAdapterDescriptors) {
            DataAdapter dataAdapter = da.getDataAdapter();
            if (!this.daClass.isInstance(dataAdapter)) continue;
            combo.add(das.getLabel(da));
            combo.setData(String.valueOf(combo.getItemCount() - 1) + _DA, (Object)dataAdapter);
        }
    }

    public T getSelectedDataAdapter() {
        return this.selectedDA;
    }
}

