/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page.selector;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.datasource.filter.DatasourcesAllFilter;
import com.jaspersoft.studio.server.model.datasource.filter.IDatasourceFilter;
import com.jaspersoft.studio.server.publish.wizard.page.DatasourceSelectionComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class SelectorDatasource {
    private static IDatasourceFilter datasourceFilter = new DatasourcesAllFilter();

    public DatasourceSelectionComposite createDatasource(TabFolder tabFolder, ANode parent, AMResource res, boolean mandatory) {
        TabItem item = new TabItem(tabFolder, 0);
        item.setText(Messages.SelectorDatasource_TabTitle);
        DatasourceSelectionComposite dsSelectionCmp = this.createDatasource(tabFolder, parent, res, mandatory);
        item.setControl((Control)dsSelectionCmp);
        return dsSelectionCmp;
    }

    public DatasourceSelectionComposite createDatasource(Composite parent, ANode pnode, AMResource res, boolean mandatory, String[] excludeTypes) {
        DatasourceSelectionComposite dsSelectionCmp = new DatasourceSelectionComposite(parent, 0, mandatory, excludeTypes);
        dsSelectionCmp.configurePage(pnode, res);
        return dsSelectionCmp;
    }

    public static void replaceDatasource(AMResource res, ResourceDescriptor rd) {
        int index;
        ResourceDescriptor rdel = SelectorDatasource.getDatasource(res.getValue(), res);
        if (rdel != null && (index = res.getValue().getChildren().indexOf(rdel)) >= 0) {
            res.getValue().getChildren().remove(index);
        }
        res.getValue().getChildren().add(0, rd);
    }

    public static ResourceDescriptor getDatasource(ResourceDescriptor ru, AMResource res) {
        for (ResourceDescriptor obj : ru.getChildren()) {
            if (obj == null) continue;
            ResourceDescriptor r = obj;
            ResourceDescriptor tmp = SelectorDatasource.checkReference(r, res);
            if (tmp != null) {
                r = tmp;
            } else if (ru.getChildren().indexOf(r) == 0 && r.getIsReference()) {
                return r;
            }
            if (r == null || !SelectorDatasource.isDatasource(r)) continue;
            return r;
        }
        return null;
    }

    protected static ResourceDescriptor checkReference(ResourceDescriptor r, AMResource res) {
        if (r.getWsType().equals("reference")) {
            try {
                if (r.getReferenceType() != null) {
                    return r;
                }
                return WSClientHelper.getReference((IProgressMonitor)new NullProgressMonitor(), (ANode)res, r);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(r.getReferenceUri()) + "   " + r.getReferenceType());
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isDatasource(ResourceDescriptor r) {
        return datasourceFilter.isDatasource(r);
    }

    public static enum SelectionType {
        REMOTE_DATASOURCE,
        LOCAL_DATASOURCE,
        NO_DATASOURCE;

    }
}

