/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.operations.ExportOperation;

public class ExportAction
extends WorkbenchWindowAction {
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    private static final String settingsKey = "ExportAction.lastLocation";

    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setText(Policy.bind("ExportAction.exportTo"));
        dialog.setFilterPath(this.getLastLocation());
        String directory = dialog.open();
        if (directory == null) {
            return;
        }
        this.saveLocation(directory);
        new ExportOperation(this.getTargetPart(), this.getSelectedResources(), directory).run();
    }

    @Override
    protected String getImageId() {
        return "Menu Export";
    }

    private String getLastLocation() {
        String lastLocation = null;
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 1) {
            lastLocation = this.settings.get("ExportAction.lastLocation." + resources[0].getFullPath());
        }
        if (lastLocation == null) {
            lastLocation = this.settings.get(settingsKey);
        }
        return lastLocation;
    }

    private void saveLocation(String directory) {
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 1) {
            this.settings.put("ExportAction.lastLocation." + resources[0].getFullPath(), directory);
        }
        this.settings.put(settingsKey, directory);
    }
}

