/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.operations.ShowAnnotationOperation;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardAnnotatePage;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;

public class ShowAnnotationAction
extends WorkbenchWindowAction {
    @Override
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            ISVNRemoteFile svnResource = this.getSingleSelectedSVNRemoteFile();
            this.execute(svnResource);
        }
    }

    public void execute(ISVNRemoteFile svnResource) throws InvocationTargetException, InterruptedException {
        if (svnResource == null) {
            return;
        }
        SvnWizardAnnotatePage annotatePage = new SvnWizardAnnotatePage(svnResource);
        SvnWizard wizard = new SvnWizard(annotatePage);
        SvnWizardDialog dialog = new SvnWizardDialog(this.getShell(), (IWizard)wizard);
        wizard.setParentDialog((Dialog)dialog);
        if (dialog.open() == 1) {
            return;
        }
        ShowAnnotationOperation showAnnotationOperation = new ShowAnnotationOperation(this.getTargetPart(), svnResource, annotatePage.getFromRevision(), annotatePage.getToRevision(), annotatePage.isIncludeMergedRevisions(), annotatePage.isIgnoreMimeType());
        showAnnotationOperation.run();
    }

    @Override
    protected boolean isEnabled() throws TeamException {
        ISVNRemoteFile resource = this.getSingleSelectedSVNRemoteFile();
        return resource != null;
    }

    protected ISVNRemoteFile getSingleSelectedSVNRemoteFile() {
        ISVNRemoteFile[] svnResources;
        if (this.getSelectedRemoteFiles().length > 0 && (svnResources = this.getSelectedRemoteFiles()).length == 1) {
            return svnResources[0];
        }
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 1 && resources[0].getType() == 1) {
            try {
                return (ISVNRemoteFile)SVNWorkspaceRoot.getBaseResourceFor((IResource)resources[0]);
            }
            catch (SVNException sVNException) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected String getImageId() {
        return "Menu Annotate";
    }
}

