/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.operations.SwitchOperation;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardSwitchPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchAction
extends WorkbenchWindowAction {
    private IResource[] selectedResources;
    private boolean canRunAsJob = true;

    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            IResource[] resources = this.getSelectedResources();
            String pageName = resources.length > 1 ? "SwitchDialogWithConflictHandling.multiple" : "SwitchDialogWithConflictHandling";
            SvnWizardSwitchPage switchPage = new SvnWizardSwitchPage(pageName, resources);
            SvnWizard wizard = new SvnWizard(switchPage);
            SvnWizardDialog dialog = new SvnWizardDialog(this.getShell(), (IWizard)wizard);
            wizard.setParentDialog((Dialog)dialog);
            if (dialog.open() == 0) {
                SVNUrl[] svnUrls = switchPage.getUrls();
                SVNRevision svnRevision = switchPage.getRevision();
                SwitchOperation switchOperation = new SwitchOperation(this.getTargetPart(), resources, svnUrls, svnRevision);
                switchOperation.setDepth(switchPage.getDepth());
                switchOperation.setSetDepth(switchPage.isSetDepth());
                switchOperation.setIgnoreExternals(switchPage.isIgnoreExternals());
                switchOperation.setForce(switchPage.isForce());
                switchOperation.setIgnoreAncestry(switchPage.isIgnoreAncestry());
                switchOperation.setCanRunAsJob(this.canRunAsJob);
                switchOperation.setConflictResolver(switchPage.getConflictResolver());
                switchOperation.run();
            }
        }
    }

    @Override
    protected String getErrorTitle() {
        return Policy.bind("SwitchAction.switch");
    }

    @Override
    protected IResource[] getSelectedResources() {
        if (this.selectedResources != null) {
            return this.selectedResources;
        }
        return super.getSelectedResources();
    }

    @Override
    protected boolean isEnabledForManagedResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isEnabledForMultipleResources() {
        try {
            ISVNRepositoryLocation repository = null;
            IResource[] selectedResources = this.getSelectedResources();
            int i = 0;
            while (true) {
                if (i >= selectedResources.length) {
                    return true;
                }
                ISVNRepositoryLocation compareToRepository = null;
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)selectedResources[i]);
                if (svnResource == null) return false;
                if (!svnResource.isManaged()) {
                    return false;
                }
                LocalResourceStatus status = svnResource.getStatusFromCache();
                if (status != null) {
                    compareToRepository = status.getRepository();
                }
                if (compareToRepository == null) {
                    return false;
                }
                if (repository != null && !compareToRepository.equals(repository)) {
                    return false;
                }
                repository = compareToRepository;
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected String getImageId() {
        return "Menu Switch";
    }

    public void setSelectedResources(IResource[] selectedResources) {
        this.selectedResources = selectedResources;
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }
}

