/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.compare.IPropertyProvider;

public class PropertyCompareInput
extends CompareEditorInput {
    private IPropertyProvider left;
    private IPropertyProvider right;
    private boolean recursive;

    public PropertyCompareInput(IPropertyProvider left, IPropertyProvider right, boolean recursive) {
        super(new CompareConfiguration());
        this.left = left;
        this.right = right;
        this.recursive = recursive;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.initLabels();
        if (monitor != null) {
            monitor.subTask(String.valueOf(Policy.bind("PropertyCompareInput.0")) + this.left.getLabel());
        }
        this.left.getProperties(this.recursive);
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        if (monitor != null) {
            monitor.subTask(String.valueOf(Policy.bind("PropertyCompareInput.0")) + this.right.getLabel());
        }
        this.right.getProperties(this.recursive);
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        return new Differencer().findDifferences(false, monitor, null, null, (Object)this.left, (Object)this.right);
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        this.setTitle(Policy.bind("PropertyCompareInput.2"));
        cc.setLeftEditable(this.left.isEditable());
        cc.setRightEditable(this.right.isEditable());
        cc.setLeftLabel(this.left.getLabel());
        cc.setRightLabel(this.right.getLabel());
    }
}

