/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffContainer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.RemoteResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.internal.Utilities;
import org.tigris.subversion.subclipse.ui.history.HistoryTableProvider;
import org.tigris.subversion.subclipse.ui.internal.Utils;
import org.tigris.subversion.subclipse.ui.operations.UpdateOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNCompareRevisionsInput
extends CompareEditorInput
implements ISaveableWorkbenchPart {
    private IFile resource;
    private ILogEntry[] logEntries;
    private TableViewer viewer;
    private Action getContentsAction;
    private Action getRevisionAction;
    private Shell shell;
    private HistoryTableProvider historyTableProvider;

    public SVNCompareRevisionsInput(IFile resource, ILogEntry[] logEntries) {
        super(new CompareConfiguration());
        this.resource = resource;
        this.logEntries = logEntries;
        this.updateCurrentEdition();
        this.initializeActions();
    }

    public Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        c.setLayoutData((Object)new GridData(1808));
        this.historyTableProvider.setSortColumn(this.viewer, 0);
        this.historyTableProvider.setSortColumn(this.viewer, 0);
        return c;
    }

    public Viewer createDiffViewer(Composite parent) {
        this.shell = parent.getShell();
        this.viewer = this.getHistoryTableProvider().createTable(parent);
        Table table = this.viewer.getTable();
        table.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Policy.bind("SVNCompareRevisionsInput.structureCompare"));
        this.viewer.setContentProvider((IContentProvider)new VersionCompareContentProvider());
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mm) {
                mm.add((IAction)SVNCompareRevisionsInput.this.getContentsAction);
                mm.add((IAction)SVNCompareRevisionsInput.this.getRevisionAction);
            }
        });
        table.setMenu(mm.createContextMenu((Control)table));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    SVNCompareRevisionsInput.this.getContentsAction.setEnabled(false);
                    SVNCompareRevisionsInput.this.getRevisionAction.setEnabled(false);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                SVNCompareRevisionsInput.this.getContentsAction.setEnabled(ss.size() == 1);
                SVNCompareRevisionsInput.this.getRevisionAction.setEnabled(ss.size() == 1);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)table, "org.tigris.subversion.subclipse.ui.compare_revision_view_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getContentsAction, "org.tigris.subversion.subclipse.ui.get_file_contents_action_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.tigris.subversion.subclipse.ui.get_file_revision_action_context");
        this.viewer.resetFilters();
        return this.viewer;
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        String resourceName = this.resource.getName();
        this.setTitle(Policy.bind("SVNCompareRevisionsInput.compareResourceAndVersions", new Object[]{resourceName}));
        cc.setLeftEditable(true);
        cc.setRightEditable(true);
        String leftLabel = Policy.bind("SVNCompareRevisionsInput.workspace", new Object[]{resourceName});
        cc.setLeftLabel(leftLabel);
        String rightLabel = Policy.bind("SVNCompareRevisionsInput.repository", new Object[]{resourceName});
        cc.setRightLabel(rightLabel);
    }

    private void initializeActions() {
        this.getContentsAction = new Action(Policy.bind("HistoryView.getContentsAction"), null){

            public void run() {
                try {
                    new ProgressMonitorDialog(SVNCompareRevisionsInput.this.shell).run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                            IStructuredSelection selection = (IStructuredSelection)SVNCompareRevisionsInput.this.viewer.getSelection();
                            if (selection.size() != 1) {
                                return;
                            }
                            VersionCompareDiffNode node = (VersionCompareDiffNode)((Object)selection.getFirstElement());
                            ResourceEditionNode right = (ResourceEditionNode)node.getRight();
                            ISVNRemoteResource edition = right.getRemoteResource();
                            try {
                                try {
                                    monitor.beginTask(null, 100);
                                    InputStream in = edition.getStorage((IProgressMonitor)new SubProgressMonitor(monitor, 50)).getContents();
                                    SVNCompareRevisionsInput.this.resource.setContents(in, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                }
                                catch (TeamException e) {
                                    throw new InvocationTargetException(e);
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException e) {
                    SVNCompareRevisionsInput.this.handle(e);
                }
                SVNCompareRevisionsInput.this.updateCurrentEdition();
                SVNCompareRevisionsInput.this.viewer.refresh();
            }
        };
        this.getRevisionAction = new Action(Policy.bind("HistoryView.getRevisionAction"), null){

            public void run() {
                try {
                    new ProgressMonitorDialog(SVNCompareRevisionsInput.this.shell).run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                        protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IStructuredSelection selection = (IStructuredSelection)SVNCompareRevisionsInput.this.viewer.getSelection();
                            if (selection.size() != 1) {
                                return;
                            }
                            VersionCompareDiffNode node = (VersionCompareDiffNode)((Object)selection.getFirstElement());
                            ResourceEditionNode right = (ResourceEditionNode)node.getRight();
                            ISVNRemoteFile edition = (ISVNRemoteFile)right.getRemoteResource();
                            new UpdateOperation(null, (IResource)SVNCompareRevisionsInput.this.resource, (SVNRevision)edition.getLastChangedRevision()).run(monitor);
                            SVNCompareRevisionsInput.this.getHistoryTableProvider().setRemoteResource((ISVNRemoteResource)edition);
                            SVNCompareRevisionsInput.this.viewer.refresh();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException e) {
                    SVNCompareRevisionsInput.this.handle(e);
                }
            }
        };
    }

    protected Object prepareInput(IProgressMonitor monitor) {
        this.initLabels();
        DiffNode diffRoot = new DiffNode(0);
        String localCharset = Utilities.getCharset((IResource)this.resource);
        int i = 0;
        while (i < this.logEntries.length) {
            TypedBufferedContent left = new TypedBufferedContent(this.resource);
            ResourceRevisionNode right = new ResourceRevisionNode(this.logEntries[i]);
            try {
                right.setCharset(localCharset);
            }
            catch (CoreException coreException) {}
            diffRoot.add((IDiffElement)new VersionCompareDiffNode((ITypedElement)left, right));
            ++i;
        }
        return diffRoot;
    }

    private void updateCurrentEdition() {
        try {
            this.getHistoryTableProvider().setRemoteResource((ISVNRemoteResource)((ISVNRemoteFile)SVNWorkspaceRoot.getBaseResourceFor((IResource)this.resource)));
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e));
        }
    }

    private void handle(Exception e) {
        this.setMessage(SVNUIPlugin.openError(this.shell, null, null, e, 12).getMessage());
    }

    public HistoryTableProvider getHistoryTableProvider() {
        if (this.historyTableProvider == null) {
            this.historyTableProvider = new HistoryTableProvider();
        }
        return this.historyTableProvider;
    }

    public void replaceLocalWithCurrentlySelectedRevision() throws CoreException {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        VersionCompareDiffNode node = (VersionCompareDiffNode)((Object)selection.getFirstElement());
        ResourceRevisionNode right = (ResourceRevisionNode)node.getRight();
        TypedBufferedContent left = (TypedBufferedContent)node.getLeft();
        left.setContent(Utils.readBytes(right.getContents()));
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveChanges(monitor);
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createContents(parent);
    }

    public void dispose() {
    }

    public IWorkbenchPartSite getSite() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public boolean canRunAsJob() {
        return true;
    }

    class ResourceRevisionNode
    extends ResourceEditionNode {
        ILogEntry entry;

        public ResourceRevisionNode(ILogEntry entry) {
            super(entry.getRemoteResource());
            this.entry = entry;
            if (entry.getRemoteResource() instanceof RemoteResource) {
                ((RemoteResource)entry.getRemoteResource()).setPegRevision(SVNRevision.HEAD);
            }
        }

        public ILogEntry getLogEntry() {
            return this.entry;
        }

        @Override
        public String getName() {
            IFile resource = SVNCompareRevisionsInput.this.resource;
            try {
                ISVNRemoteFile currentEdition = (ISVNRemoteFile)SVNWorkspaceRoot.getBaseResourceFor((IResource)resource);
                if (currentEdition == null || !currentEdition.getLastChangedRevision().equals((Object)this.entry.getRevision())) {
                    return this.entry.getRevision().toString();
                }
                Policy.bind("currentRevision", this.entry.getRevision().toString());
            }
            catch (TeamException e) {
                SVNCompareRevisionsInput.this.handle((Exception)((Object)e));
            }
            return super.getName();
        }
    }

    class TypedBufferedContent
    extends ResourceNode {
        public TypedBufferedContent(IFile resource) {
            super((IResource)resource);
        }

        protected InputStream createStream() throws CoreException {
            return ((IFile)this.getResource()).getContents();
        }

        public void setContent(byte[] contents) {
            if (contents == null) {
                contents = new byte[]{};
            }
            final ByteArrayInputStream is = new ByteArrayInputStream(contents);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        IFile file = SVNCompareRevisionsInput.this.resource;
                        if (!file.exists()) {
                            file.create(is, false, monitor);
                        } else {
                            file.setContents(is, false, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(SVNCompareRevisionsInput.this.shell).run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                SVNUIPlugin.openError(SVNUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), Policy.bind("TeamFile.saveChanges", SVNCompareRevisionsInput.this.resource.getName()), null, e);
            }
            catch (InterruptedException interruptedException) {}
            this.fireContentChanged();
        }

        public ITypedElement replace(ITypedElement child, ITypedElement other) {
            return null;
        }
    }

    class VersionCompareContentProvider
    implements IStructuredContentProvider {
        VersionCompareContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DiffContainer) {
                return ((DiffContainer)inputElement).getChildren();
            }
            return null;
        }
    }

    class VersionCompareDiffNode
    extends DiffNode
    implements IAdaptable {
        public VersionCompareDiffNode(ITypedElement left, ITypedElement right) {
            super(left, right);
        }

        public String getName() {
            return this.getRight().getName();
        }

        public Object getAdapter(Class adapter) {
            if (adapter == ILogEntry.class) {
                return ((ResourceRevisionNode)this.getRight()).getLogEntry();
            }
            return null;
        }
    }
}

