/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.tigris.subversion.subclipse.core.util.StringMatcher;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class MergeFileAssociation
implements Comparable {
    private String fileType;
    private int type;
    private String mergeProgram;
    private String parameters;
    public static final int BUILT_IN = 0;
    public static final int DEFAULT_EXTERNAL = 1;
    public static final int CUSTOM_EXTERNAL = 2;
    public static final String PREF_MERGE_FILE_ASSOCIATIONS_NODE = "mergeFileAssociations";

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getMergeProgram() {
        return this.mergeProgram;
    }

    public void setMergeProgram(String mergeProgram) {
        this.mergeProgram = mergeProgram;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public static Preferences getParentPreferences() {
        return SVNUIPlugin.getPlugin().getInstancePreferences().node(PREF_MERGE_FILE_ASSOCIATIONS_NODE);
    }

    public boolean matches(String fileName) {
        StringMatcher stringMatcher = new StringMatcher(this.getFileType(), false, false);
        return stringMatcher.match(fileName);
    }

    public int compareTo(Object object) {
        if (!(object instanceof MergeFileAssociation)) {
            this.toString().compareTo(object.toString());
        }
        MergeFileAssociation compareTo = (MergeFileAssociation)object;
        return this.fileType.compareTo(compareTo.getFileType());
    }

    public boolean equals(Object object) {
        if (!(object instanceof MergeFileAssociation)) {
            return false;
        }
        MergeFileAssociation compareTo = (MergeFileAssociation)object;
        return this.fileType.equals(compareTo.getFileType());
    }

    public int hashCode() {
        return this.fileType.hashCode();
    }

    public boolean remove() {
        Preferences node = MergeFileAssociation.getParentPreferences().node(this.getFileType());
        if (node != null) {
            try {
                node.removeNode();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        return false;
    }
}

