/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.DateSelectionDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.dialogs.SvnDialog;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class HistorySearchDialog
extends SvnDialog {
    private ISVNRemoteResource remoteResource;
    private Text selectedResourceText;
    private Text userText;
    private Combo commentCombo;
    private Text startDateText;
    private Text endDateText;
    private Button regExpButton;
    private Button searchAllButton;
    private Button fetchButton;
    private Text startRevisionText;
    private Button startLogButton;
    private Text endRevisionText;
    private Button endLogButton;
    private String user;
    private String comment;
    private Date startDate;
    private Date endDate;
    private SVNRevision.Number startRevision;
    private SVNRevision.Number endRevision;
    private boolean searchAll = true;
    private boolean regExp;
    private boolean autoFetchLogs;
    private String oldStartRevision;
    private String oldEndRevision;
    private boolean revisionsChanged;
    private List previousComments;

    public HistorySearchDialog(Shell shell, ISVNRemoteResource remoteResource) {
        super(shell, "HistorySearchDialog");
        this.remoteResource = remoteResource;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("HistorySearchDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.search_history_dialog_context");
        Composite top = new Composite(composite, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        top.setLayout((Layout)topLayout);
        top.setLayoutData((Object)new GridData(768));
        Label resourceLabel = new Label(top, 0);
        resourceLabel.setText(Policy.bind("HistorySearchDialog.resource"));
        this.selectedResourceText = new Text(top, 2048);
        this.selectedResourceText.setText(this.remoteResource.getUrl().toString());
        this.selectedResourceText.setEditable(false);
        GridData gdSelectedResourceText = new GridData(768);
        this.selectedResourceText.setLayoutData((Object)gdSelectedResourceText);
        this.regExpButton = new Button(top, 32);
        this.regExpButton.setText(Policy.bind("HistorySearchDialog.regExp"));
        GridData gdRegExpButton = new GridData(768);
        gdRegExpButton.horizontalSpan = 2;
        this.regExpButton.setLayoutData((Object)gdRegExpButton);
        this.regExpButton.setSelection(this.regExp);
        Group search = new Group(composite, 0);
        search.setText(Policy.bind("HistorySearchDialog.searchTitle"));
        GridLayout searchLayout = new GridLayout();
        searchLayout.numColumns = 2;
        search.setLayout((Layout)searchLayout);
        search.setLayoutData((Object)new GridData(1808));
        Label userLabel = new Label((Composite)search, 0);
        userLabel.setText(Policy.bind("HistorySearchDialog.user"));
        this.userText = new Text((Composite)search, 2048);
        this.userText.setLayoutData((Object)new GridData(768));
        if (this.user != null) {
            this.userText.setText(this.user);
        }
        Label commentLabel = new Label((Composite)search, 0);
        commentLabel.setText(Policy.bind("HistorySearchDialog.comment"));
        this.commentCombo = new Combo((Composite)search, 4);
        this.commentCombo.setLayoutData((Object)new GridData(768));
        this.fillCommentCombo(this.commentCombo);
        this.fetchButton = new Button((Composite)search, 32);
        GridData gdFetchButton = new GridData(768);
        gdFetchButton.horizontalSpan = 2;
        this.fetchButton.setLayoutData((Object)gdFetchButton);
        this.fetchButton.setText(Policy.bind("HistorySearchDialog.fetchLogIfNeeded"));
        this.fetchButton.setSelection(this.autoFetchLogs);
        this.searchAllButton = new Button((Composite)search, 32);
        GridData gdSearchAllButton = new GridData(768);
        gdSearchAllButton.horizontalSpan = 2;
        this.searchAllButton.setLayoutData((Object)gdSearchAllButton);
        this.searchAllButton.setText(Policy.bind("HistorySearchDialog.searchAllLogs"));
        this.searchAllButton.setSelection(this.searchAll);
        final Label dateLabel = new Label((Composite)search, 0);
        dateLabel.setText(Policy.bind("HistorySearchDialog.date"));
        dateLabel.setEnabled(!this.searchAll);
        Composite dateComp = new Composite((Composite)search, 0);
        GridLayout dateCompLayout = new GridLayout();
        dateCompLayout.numColumns = 5;
        dateCompLayout.marginHeight = 0;
        dateCompLayout.marginWidth = 0;
        dateComp.setLayout((Layout)dateCompLayout);
        dateComp.setLayoutData((Object)new GridData(768));
        this.startDateText = new Text(dateComp, 2048);
        this.startDateText.setLayoutData((Object)new GridData(768));
        if (this.startDate == null && this.startRevision == null && this.endRevision == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            this.startDate = calendar.getTime();
        }
        if (this.startDate != null) {
            this.startDateText.setText(this.formatDate(this.startDate));
            this.startDateText.setData((Object)this.startDate);
        }
        this.startDateText.setEnabled(!this.searchAll);
        final Button selectStartDateButton = new Button(dateComp, 0);
        selectStartDateButton.setText(Policy.bind("HistorySearchDialog.startDateButton"));
        selectStartDateButton.setEnabled(!this.searchAll);
        final Label midDataLabel = new Label(dateComp, 0);
        midDataLabel.setText(Policy.bind("HistorySearchDialog.midDate"));
        midDataLabel.setEnabled(!this.searchAll);
        this.endDateText = new Text(dateComp, 2048);
        this.endDateText.setLayoutData((Object)new GridData(768));
        if (this.endDate == null && this.startRevision == null && this.endRevision == null) {
            this.endDate = Calendar.getInstance().getTime();
        }
        if (this.endDate != null) {
            this.endDateText.setText(this.formatDate(this.endDate));
            this.endDateText.setData((Object)this.endDate);
        }
        this.endDateText.setEnabled(!this.searchAll);
        final Button selectEndDateButton = new Button(dateComp, 0);
        selectEndDateButton.setText(Policy.bind("HistorySearchDialog.endDateButton"));
        selectEndDateButton.setEnabled(!this.searchAll);
        final Label revisionLabel = new Label((Composite)search, 0);
        revisionLabel.setText(Policy.bind("HistorySearchDialog.revision"));
        revisionLabel.setEnabled(!this.searchAll);
        Composite revisionComp = new Composite((Composite)search, 0);
        GridLayout revisionCompLayout = new GridLayout();
        revisionCompLayout.numColumns = 5;
        revisionCompLayout.marginHeight = 0;
        revisionCompLayout.marginWidth = 0;
        revisionComp.setLayout((Layout)revisionCompLayout);
        revisionComp.setLayoutData((Object)new GridData(768));
        this.startRevisionText = new Text(revisionComp, 2048);
        this.startRevisionText.setLayoutData((Object)new GridData(768));
        if (this.startRevision != null) {
            this.startRevisionText.setText(this.startRevision.toString());
        }
        this.startRevisionText.setEnabled(!this.searchAll);
        this.startLogButton = new Button(revisionComp, 8);
        this.startLogButton.setText(Policy.bind("HistorySearchDialog.startRevisionButton"));
        this.startLogButton.setEnabled(!this.searchAll);
        final Label endRevisionLabel = new Label(revisionComp, 0);
        endRevisionLabel.setText(Policy.bind("HistorySearchDialog.endRevision"));
        endRevisionLabel.setEnabled(!this.searchAll);
        this.endRevisionText = new Text(revisionComp, 2048);
        this.endRevisionText.setLayoutData((Object)new GridData(768));
        if (this.endRevision != null) {
            this.endRevisionText.setText(this.endRevision.toString());
        }
        this.endRevisionText.setEnabled(!this.searchAll);
        this.endLogButton = new Button(revisionComp, 8);
        this.endLogButton.setText(Policy.bind("HistorySearchDialog.endRevisionButton"));
        this.endLogButton.setEnabled(!this.searchAll);
        this.searchAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HistorySearchDialog.this.searchAllButton.getSelection()) {
                    dateLabel.setEnabled(false);
                    midDataLabel.setEnabled(false);
                    selectStartDateButton.setEnabled(false);
                    selectEndDateButton.setEnabled(false);
                    HistorySearchDialog.this.startDateText.setEnabled(false);
                    HistorySearchDialog.this.endDateText.setEnabled(false);
                    revisionLabel.setEnabled(false);
                    HistorySearchDialog.this.startRevisionText.setEnabled(false);
                    HistorySearchDialog.this.startLogButton.setEnabled(false);
                    endRevisionLabel.setEnabled(false);
                    HistorySearchDialog.this.endRevisionText.setEnabled(false);
                    HistorySearchDialog.this.endLogButton.setEnabled(false);
                } else {
                    dateLabel.setEnabled(true);
                    midDataLabel.setEnabled(true);
                    selectStartDateButton.setEnabled(true);
                    selectEndDateButton.setEnabled(true);
                    HistorySearchDialog.this.startDateText.setEnabled(true);
                    HistorySearchDialog.this.endDateText.setEnabled(true);
                    revisionLabel.setEnabled(true);
                    HistorySearchDialog.this.startRevisionText.setEnabled(true);
                    HistorySearchDialog.this.startLogButton.setEnabled(true);
                    endRevisionLabel.setEnabled(true);
                    HistorySearchDialog.this.endRevisionText.setEnabled(true);
                    HistorySearchDialog.this.endLogButton.setEnabled(true);
                }
            }
        });
        selectStartDateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String start = null;
                if (HistorySearchDialog.this.startDateText.getText().trim().length() == 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(2, -1);
                    Date date = calendar.getTime();
                    start = HistorySearchDialog.this.formatDate(date);
                } else {
                    start = HistorySearchDialog.this.startDateText.getText();
                    if (HistorySearchDialog.this.parseDate(start) == null) {
                        return;
                    }
                }
                DateSelectionDialog dsd = new DateSelectionDialog(HistorySearchDialog.this.getShell(), start);
                if (dsd.open() == 0) {
                    Date endDate;
                    Date startDate = dsd.getDate();
                    HistorySearchDialog.this.startDateText.setText(HistorySearchDialog.this.formatDate(startDate));
                    HistorySearchDialog.this.startDateText.setData((Object)startDate);
                    if (HistorySearchDialog.this.endDateText.getText().trim().length() > 0 && !startDate.before(endDate = (Date)HistorySearchDialog.this.endDateText.getData())) {
                        HistorySearchDialog.this.endDateText.setText(HistorySearchDialog.this.formatDate(startDate));
                        HistorySearchDialog.this.endDateText.setData((Object)startDate);
                    }
                }
            }
        });
        selectEndDateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String end = null;
                if (HistorySearchDialog.this.endDateText.getText().trim().length() == 0) {
                    Date date = Calendar.getInstance().getTime();
                    end = HistorySearchDialog.this.formatDate(date);
                } else {
                    end = HistorySearchDialog.this.endDateText.getText();
                    if (HistorySearchDialog.this.parseDate(end) == null) {
                        return;
                    }
                }
                DateSelectionDialog dsd = new DateSelectionDialog(HistorySearchDialog.this.getShell(), end);
                if (dsd.open() == 0) {
                    Date startDate;
                    Date endDate = dsd.getDate();
                    HistorySearchDialog.this.endDateText.setText(HistorySearchDialog.this.formatDate(endDate));
                    HistorySearchDialog.this.endDateText.setData((Object)endDate);
                    if (HistorySearchDialog.this.startDateText.getText().trim().length() > 0 && !endDate.after(startDate = (Date)HistorySearchDialog.this.startDateText.getData())) {
                        HistorySearchDialog.this.startDateText.setText(HistorySearchDialog.this.formatDate(endDate));
                        HistorySearchDialog.this.startDateText.setData((Object)endDate);
                    }
                }
            }
        });
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == HistorySearchDialog.this.startLogButton) {
                    HistorySearchDialog.this.showLog(HistorySearchDialog.this.startRevisionText);
                } else {
                    HistorySearchDialog.this.showLog(HistorySearchDialog.this.endRevisionText);
                }
            }
        };
        this.startLogButton.addSelectionListener((SelectionListener)selectionListener);
        this.endLogButton.addSelectionListener((SelectionListener)selectionListener);
        this.userText.setFocus();
        this.userText.setSelection(0, this.userText.getText().length());
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.userText.addFocusListener((FocusListener)focusListener);
        this.startDateText.addFocusListener((FocusListener)focusListener);
        this.endDateText.addFocusListener((FocusListener)focusListener);
        this.oldStartRevision = this.startRevisionText.getText();
        this.oldEndRevision = this.endRevisionText.getText();
        return composite;
    }

    private void showLog(Text revisionText) {
        HistoryDialog dialog = new HistoryDialog(this.getShell(), this.remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
    }

    public void setRemoteResource(ISVNRemoteResource remoteResource) {
        this.remoteResource = remoteResource;
    }

    public String getUser() {
        return this.user;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public SVNRevision.Number getStartRevision() {
        return this.startRevision;
    }

    public SVNRevision.Number getEndRevision() {
        return this.endRevision;
    }

    public boolean getRegExp() {
        return this.regExp;
    }

    public boolean getAutoFetchLogs() {
        return this.autoFetchLogs;
    }

    public boolean getSearchAllLogs() {
        return this.searchAll;
    }

    @Override
    protected void okPressed() {
        if (this.searchAllButton.getSelection()) {
            this.startDate = null;
            this.endDate = null;
            this.startRevision = null;
            this.endRevision = null;
        } else {
            Date tempStartDate = null;
            Date tempEndDate = null;
            if (this.startDateText.getText().trim().length() == 0) {
                this.startDate = null;
            } else {
                tempStartDate = this.parseDate(this.startDateText.getText());
                if (tempStartDate == null) {
                    return;
                }
            }
            if (this.endDateText.getText().trim().length() == 0) {
                this.endDate = null;
            } else {
                tempEndDate = this.parseDate(this.endDateText.getText());
                if (tempEndDate == null) {
                    return;
                }
            }
            if (tempStartDate != null && tempEndDate != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(tempEndDate);
                calendar.set(11, calendar.getActualMaximum(11));
                calendar.set(12, calendar.getActualMaximum(12));
                calendar.set(13, calendar.getActualMaximum(13));
                tempEndDate = calendar.getTime();
                if (!tempEndDate.after(tempStartDate)) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("HistorySearchDialog.dateSequenceErrorTitle"), (String)Policy.bind("HistorySearchDialog.dateSequenceErrorMessage"));
                    return;
                }
            }
            this.endDate = tempEndDate;
            this.startDate = tempStartDate;
            if (this.startRevisionText.getText().trim().length() > 0) {
                try {
                    this.startRevision = (SVNRevision.Number)SVNRevision.getRevision((String)this.startRevisionText.getText().trim());
                }
                catch (ParseException parseException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("HistorySearchDialog.revisionParseErrorTitle"), (String)Policy.bind("HistorySearchDialog.revisionParseErrorMessage"));
                    return;
                }
            } else {
                this.startRevision = null;
            }
            if (this.endRevisionText.getText().trim().length() > 0) {
                try {
                    this.endRevision = (SVNRevision.Number)SVNRevision.getRevision((String)this.endRevisionText.getText().trim());
                }
                catch (ParseException parseException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("HistorySearchDialog.revisionParseErrorTitle"), (String)Policy.bind("HistorySearchDialog.revisionParseErrorMessage"));
                    return;
                }
            } else {
                this.endRevision = null;
            }
            if (this.startRevision != null && this.endRevision != null && this.startRevision.getNumber() > this.endRevision.getNumber()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("HistorySearchDialog.revisionSequenceErrorTitle"), (String)Policy.bind("HistorySearchDialog.revisionSequenceErrorMessage"));
                return;
            }
        }
        this.user = this.userText.getText().trim().length() > 0 ? this.userText.getText() : null;
        this.comment = this.commentCombo.getText().trim().length() > 0 ? this.commentCombo.getText() : null;
        this.autoFetchLogs = this.fetchButton.getSelection();
        this.searchAll = this.searchAllButton.getSelection();
        this.regExp = this.regExpButton.getSelection();
        if (this.comment != null && this.comment.trim().length() > 0) {
            this.previousComments.add(this.comment);
        }
        this.revisionsChanged = !this.startRevisionText.getText().trim().equals(this.oldStartRevision) || !this.endRevisionText.getText().trim().equals(this.oldEndRevision);
        super.okPressed();
    }

    private String formatDate(Date date) {
        return DateFormat.getDateInstance(3).format(date);
    }

    private Date parseDate(String date) {
        try {
            return DateFormat.getDateInstance(3).parse(date);
        }
        catch (ParseException parseException) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("HistorySearchDialog.dateParseErrorTitle"), (String)Policy.bind("HistorySearchDialog.dateParseErrorMessage"));
            return null;
        }
    }

    private void fillCommentCombo(Combo combo) {
        if (this.previousComments == null) {
            this.previousComments = new ArrayList();
        }
        int i = this.previousComments.size() - 1;
        while (i >= 0) {
            combo.add((String)this.previousComments.get(i));
            --i;
        }
        combo.select(0);
    }

    public void setStartRevision(SVNRevision.Number startRevision) {
        this.startRevision = startRevision;
    }

    public void setEndRevision(SVNRevision.Number endRevision) {
        this.endRevision = endRevision;
    }

    public void setSearchAll(boolean searchAll) {
        this.searchAll = searchAll;
    }

    public boolean isRevisionsChanged() {
        return this.revisionsChanged;
    }
}

