/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class Utils {
    public static void schedule(Job job, IWorkbenchSite site) {
        IWorkbenchSiteProgressService siteProgress;
        if (site != null && (siteProgress = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            siteProgress.schedule(job, 0L, true);
            return;
        }
        job.schedule();
    }

    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                int c;
                while ((c = in.read()) != -1) {
                    bos.write(c);
                }
            }
            catch (IOException iOException) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException2) {}
                }
                try {
                    bos.close();
                }
                catch (IOException iOException3) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                bos.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        try {
            bos.close();
        }
        catch (IOException iOException) {}
        return bos.toByteArray();
    }

    public static void handle(final Throwable exception) {
        Utils.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object error = null;
                Throwable t = exception;
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                error = t instanceof CoreException ? ((CoreException)t).getStatus() : (t instanceof TeamException ? ((TeamException)t).getStatus() : new Status(4, "org.tigris.subversion.subclipse.ui", 1, Policy.bind("simpleInternal"), t));
                Shell shell = new Shell(Display.getDefault());
                if (error.getSeverity() == 1) {
                    MessageDialog.openInformation((Shell)shell, (String)Policy.bind("information"), (String)error.getMessage());
                } else {
                    ErrorDialog.openError((Shell)shell, (String)Policy.bind("exception"), null, (IStatus)error);
                }
                shell.dispose();
                if (!(t instanceof TeamException)) {
                    SVNUIPlugin.log(error.getSeverity(), error.getMessage(), t);
                }
            }
        });
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void log(IStatus status) {
        SVNUIPlugin.getPlugin().getLog().log(status);
    }

    public static void log(CoreException e) {
        IStatus status = e.getStatus();
        Utils.log(status.getSeverity(), status.getMessage(), e);
    }

    public static void log(int severity, String message, Throwable e) {
        Utils.log((IStatus)new Status(severity, "org.tigris.subversion.subclipse.ui", 0, message, e));
    }

    public static void handleError(Shell shell, Exception exception, String title, String message) {
        IStatus status = null;
        boolean log = false;
        boolean dialog = false;
        Throwable t = exception;
        if (exception instanceof TeamException) {
            status = ((TeamException)((Object)exception)).getStatus();
            log = false;
            dialog = true;
        } else if (exception instanceof InvocationTargetException) {
            t = ((InvocationTargetException)exception).getTargetException();
            if (t instanceof TeamException) {
                status = ((TeamException)t).getStatus();
                log = false;
                dialog = true;
            } else if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
                log = true;
                dialog = true;
            } else {
                if (t instanceof InterruptedException) {
                    return;
                }
                status = new Status(4, "org.tigris.subversion.subclipse.ui", 1, Policy.bind("TeamAction.internal"), t);
                log = true;
                dialog = true;
            }
        }
        if (status == null) {
            return;
        }
        if (!status.isOK()) {
            IStatus[] children;
            IStatus toShow = status;
            if (status.isMultiStatus() && (children = status.getChildren()).length == 1) {
                toShow = children[0];
            }
            if (title == null) {
                title = status.getMessage();
            }
            if (message == null) {
                message = status.getMessage();
            }
            if (dialog && shell != null) {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)toShow);
            }
            if (log || shell == null) {
                SVNUIPlugin.log(toShow.getSeverity(), message, t);
            }
        }
    }
}

