/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.CheckoutCommand;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutAsProjectOperation
extends SVNOperation {
    private ISVNRemoteFolder[] remoteFolders;
    private IProject[] localFolders;
    private IPath projectRoot;
    private SVNRevision svnRevision = SVNRevision.HEAD;
    private int depth = 5;
    private boolean ignoreExternals = false;
    private boolean force = true;
    private List<IProject> createProjectList = new ArrayList<IProject>();
    private List<IProject> manageProjectList = new ArrayList<IProject>();
    private IWorkingSet[] workingSets;

    public CheckoutAsProjectOperation(IWorkbenchPart part, ISVNRemoteFolder[] remoteFolders, IProject[] localFolders) {
        this(part, remoteFolders, localFolders, null);
    }

    public CheckoutAsProjectOperation(IWorkbenchPart part, ISVNRemoteFolder[] remoteFolders, IProject[] localFolders, IPath projectRoot) {
        super(part);
        this.remoteFolders = remoteFolders;
        this.localFolders = localFolders;
        this.projectRoot = projectRoot;
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        this.workingSets = workingSets;
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("CheckoutAsProjectOperation.taskName");
    }

    protected ISchedulingRule getSchedulingRule(SVNTeamProvider provider) {
        IResourceRuleFactory ruleFactory = provider.getRuleFactory();
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < this.localFolders.length) {
            rules.add(ruleFactory.modifyRule((IResource)this.localFolders[i].getProject()));
            ++i;
        }
        return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
    }

    private void createProject(IProject project) throws SVNException {
        block10: {
            try {
                IProject newProject;
                if (this.projectRoot == null) {
                    project.create(null);
                    project.open(null);
                    newProject = project;
                } else {
                    IProjectDescription description;
                    String path = this.projectRoot.toString();
                    if (!path.endsWith("/")) {
                        path = String.valueOf(path) + "/";
                    }
                    try {
                        description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(path) + project.getName() + "/.project"));
                    }
                    catch (CoreException coreException) {
                        description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
                        description.setLocation((IPath)new Path(String.valueOf(path) + project.getName()));
                    }
                    IProject customProject = ResourcesPlugin.getWorkspace().getRoot().getProject(project.getName());
                    customProject.create(description, null);
                    customProject.open(null);
                    newProject = customProject;
                }
                if (this.workingSets == null || this.workingSets.length <= 0) break block10;
                IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
                Class[] parameterTypes = new Class[]{IAdaptable.class, IWorkingSet[].class};
                Method addToWorkingSets = null;
                try {
                    addToWorkingSets = manager.getClass().getMethod("addToWorkingSets", parameterTypes);
                    if (addToWorkingSets != null) {
                        addToWorkingSets.invoke((Object)manager, newProject, this.workingSets);
                    }
                }
                catch (Exception exception) {}
            }
            catch (CoreException e1) {
                throw new SVNException("Cannot create project to checkout to", (Throwable)e1);
            }
        }
    }

    @Override
    public void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(null, this.remoteFolders.length * 1000);
        int i = 0;
        while (i < this.remoteFolders.length) {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
            monitor.setTaskName(Policy.bind("CheckoutAsProjectOperation.0", this.remoteFolders[i].getName()));
            IProject[] local = new IProject[]{this.localFolders[i]};
            ISVNRemoteFolder[] remote = new ISVNRemoteFolder[]{this.remoteFolders[i]};
            this.execute(remote, local, (IProgressMonitor)subMonitor);
            if (monitor.isCanceled()) break;
            ++i;
        }
        for (IProject project : this.createProjectList) {
            this.createProject(project);
        }
        for (IProject project : this.manageProjectList) {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
            monitor.setTaskName(Policy.bind("SVNProvider.Creating_project_1", project.getName()));
            this.refreshProject(project, (IProgressMonitor)subMonitor);
        }
    }

    protected boolean execute(ISVNRemoteFolder[] remote, IProject[] local, IProgressMonitor monitor) throws SVNException, InterruptedException {
        try {
            CheckoutCommand command = this.projectRoot == null ? new CheckoutCommand(remote, local) : new CheckoutCommand(remote, local, this.projectRoot);
            command.setSvnRevision(this.svnRevision);
            command.setDepth(this.depth);
            command.setIgnoreExternals(this.ignoreExternals);
            command.setForce(this.force);
            command.setRefreshProjects(false);
            command.run(monitor);
            List commandCreateProjectList = command.getCreateProjectList();
            for (IProject project : commandCreateProjectList) {
                this.createProjectList.add(project);
            }
            List commandManageProjectList = command.getManageProjectList();
            for (IProject project : commandManageProjectList) {
                this.manageProjectList.add(project);
            }
        }
        catch (SVNException e) {
            if (e.operationInterrupted()) {
                this.showCancelledMessage();
            } else {
                this.collectStatus(e.getStatus());
            }
            return false;
        }
        return true;
    }

    public void setSvnRevision(SVNRevision svnRevision) {
        this.svnRevision = svnRevision;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    private void refreshProject(IProject project, IProgressMonitor monitor) throws SVNException {
        if (monitor != null) {
            monitor.beginTask("", 100);
        }
        try {
            try {
                RepositoryProvider.map((IProject)project, (String)SVNProviderPlugin.getTypeId());
                RepositoryProvider.getProvider((IProject)project, (String)SVNProviderPlugin.getTypeId());
                project.refreshLocal(2, monitor);
            }
            catch (Exception e) {
                throw new SVNException("Cannot map the project with svn provider", (Throwable)e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

