/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.repository;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.subclipse.ui.util.DetailsDialogWithProjects;

public class RemoveRootAction
extends SelectionListenerAction {
    private IStructuredSelection selection;
    private Shell shell;

    public RemoveRootAction(Shell shell) {
        super(Policy.bind("RemoteRootAction.label"));
        this.shell = shell;
    }

    protected ISVNRepositoryLocation[] getSelectedRemoteRoots() {
        ArrayList<Object> resources = null;
        if (this.selection != null && !this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object next = SVNAction.getAdapter(elements.next(), ISVNRepositoryLocation.class);
                if (!(next instanceof ISVNRepositoryLocation)) continue;
                resources.add(next);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            ISVNRepositoryLocation[] result = new ISVNRepositoryLocation[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new ISVNRepositoryLocation[0];
    }

    protected String getErrorTitle() {
        return Policy.bind("RemoveRootAction.removeRoot_3");
    }

    public void run() {
        ISVNRepositoryLocation[] roots = this.getSelectedRemoteRoots();
        if (roots.length == 0) {
            return;
        }
        SVNProviderPlugin provider = SVNProviderPlugin.getPlugin();
        int i = 0;
        while (i < roots.length) {
            try {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                final ArrayList<IProject> shared = new ArrayList<IProject>();
                int j = 0;
                while (j < projects.length) {
                    RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)projects[j], (String)SVNProviderPlugin.getTypeId());
                    if (teamProvider != null) {
                        try {
                            SVNTeamProvider svnProvider = (SVNTeamProvider)teamProvider;
                            if (svnProvider.getSVNWorkspaceRoot().getRepository().equals(roots[i])) {
                                shared.add(projects[j]);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++j;
                }
                if (!shared.isEmpty()) {
                    final String location = roots[i].getLocation();
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DetailsDialogWithProjects dialog = new DetailsDialogWithProjects(RemoveRootAction.this.shell, Policy.bind("RemoteRootAction.Unable_to_Discard_Location_1"), Policy.bind("RemoteRootAction.Projects_in_the_local_workspace_are_shared_with__2", location), Policy.bind("RemoteRootAction.The_projects_that_are_shared_with_the_above_repository_are__4"), shared.toArray(new IProject[shared.size()]), false, SVNUIPlugin.getStandardDisplay().getSystemImage(1));
                            dialog.open();
                        }
                    });
                } else {
                    provider.getRepositories().disposeRepository(roots[i]);
                }
            }
            catch (SVNException e) {
                SVNUIPlugin.openError(this.shell, null, null, e);
                SVNUIPlugin.log((TeamException)((Object)e));
            }
            ++i;
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        ISVNRepositoryLocation[] roots = this.getSelectedRemoteRoots();
        return roots.length > 0;
    }
}

