/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.settings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class CommentProperties {
    private int minimumLogMessageSize;
    private int logWidthMarker;
    private String logTemplate;
    private int minimumLockMessageSize;
    private static final List<String> commentPropertiesFilterList = new ArrayList<String>();

    static {
        commentPropertiesFilterList.add("tsvn:logminsize");
        commentPropertiesFilterList.add("tsvn:lockmsgminsize");
        commentPropertiesFilterList.add("tsvn:logwidthmarker");
        commentPropertiesFilterList.add("tsvn:logtemplate");
    }

    public String getLogTemplate() {
        return this.logTemplate;
    }

    public void setLogTemplate(String logTemplate) {
        this.logTemplate = logTemplate;
    }

    public int getLogWidthMarker() {
        return this.logWidthMarker;
    }

    public void setLogWidthMarker(int logWidthMarker) {
        this.logWidthMarker = logWidthMarker;
    }

    public int getMinimumLogMessageSize() {
        return this.minimumLogMessageSize;
    }

    public void setMinimumLogMessageSize(int minimumLogMessageSize) {
        this.minimumLogMessageSize = minimumLogMessageSize;
    }

    public int getMinimumLockMessageSize() {
        return this.minimumLockMessageSize;
    }

    public void setMinimumLockMessageSize(int minimumLockMessageSize) {
        this.minimumLockMessageSize = minimumLockMessageSize;
    }

    public static CommentProperties getCommentProperties(IResource resource) throws SVNException {
        ISVNProperty[] commentProperties;
        CommentProperties properties = null;
        IResource parent = resource;
        ISVNLocalResource svnResource = null;
        while (parent != null) {
            svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)parent);
            if (parent instanceof IProject || svnResource.exists() && svnResource.isManaged() && !svnResource.getStatusFromCache().isDeleted()) break;
            parent = parent.getParent();
        }
        if (svnResource == null || !svnResource.exists() || !svnResource.isManaged() || svnResource.getStatusFromCache().isDeleted()) {
            return null;
        }
        properties = new CommentProperties();
        ISVNProperty[] iSVNPropertyArray = commentProperties = svnResource.getPropertiesIncludingInherited(false, true, commentPropertiesFilterList);
        int n = commentProperties.length;
        int n2 = 0;
        while (n2 < n) {
            int minSize;
            ISVNProperty commentProperty = iSVNPropertyArray[n2];
            if (commentProperty.getName().equals("tsvn:logminsize")) {
                minSize = 0;
                try {
                    minSize = Integer.parseInt(commentProperty.getValue());
                }
                catch (Exception exception) {}
                properties.setMinimumLogMessageSize(minSize);
            } else if (commentProperty.getName().equals("tsvn:lockmsgminsize")) {
                minSize = 0;
                try {
                    minSize = Integer.parseInt(commentProperty.getValue());
                }
                catch (Exception exception) {}
                properties.setMinimumLockMessageSize(minSize);
            } else if (commentProperty.getName().equals("tsvn:logwidthmarker")) {
                int width = 0;
                try {
                    width = Integer.parseInt(commentProperty.getValue());
                }
                catch (Exception exception) {}
                properties.setLogWidthMarker(width);
            } else if (commentProperty.getName().equals("tsvn:logtemplate")) {
                properties.setLogTemplate(commentProperty.getValue());
            }
            ++n2;
        }
        return properties;
    }
}

