/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardMarkResolvedPage;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class ResolveSynchronizeOperation
extends SVNSynchronizeOperation {
    boolean propertyConflicts = false;
    boolean textConflicts = false;
    boolean treeConflicts = false;
    private boolean canceled;
    private int selectedResolution;
    public static final int PROGRESS_DIALOG = 1;
    public static final int PROGRESS_BUSYCURSOR = 2;

    public ResolveSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    @Override
    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    @Override
    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        boolean folderSelected = false;
        this.propertyConflicts = false;
        this.textConflicts = false;
        this.treeConflicts = false;
        this.canceled = false;
        final IResource[] resources = set.getResources();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IContainer) {
                folderSelected = true;
                break;
            }
            if (!(this.propertyConflicts && this.textConflicts && this.treeConflicts)) {
                ISVNLocalResource resource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]);
                try {
                    LocalResourceStatus status = resource.getStatus();
                    if (status != null && status.isPropConflicted()) {
                        this.propertyConflicts = true;
                    }
                    if (status != null && status.isTextConflicted()) {
                        this.textConflicts = true;
                    }
                    if (status != null && status.hasTreeConflict()) {
                        this.treeConflicts = true;
                    }
                }
                catch (SVNException e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
            }
            ++i;
        }
        if (folderSelected) {
            this.selectedResolution = 6;
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ResolveSynchronizeOperation.this.propertyConflicts && !ResolveSynchronizeOperation.this.textConflicts) {
                        String message = resources.length > 1 ? Policy.bind("ResolveAction.confirmMultiple") : Policy.bind("ResolveAction.confirm", resources[0].getName());
                        if (!MessageDialog.openConfirm((Shell)ResolveSynchronizeOperation.this.getShell(), (String)Policy.bind("ResolveOperation.taskName"), (String)message)) {
                            ResolveSynchronizeOperation.this.canceled = true;
                            return;
                        }
                        ResolveSynchronizeOperation.this.selectedResolution = 6;
                    } else {
                        SvnWizardMarkResolvedPage markResolvedPage = new SvnWizardMarkResolvedPage(resources);
                        markResolvedPage.setPropertyConflicts(ResolveSynchronizeOperation.this.propertyConflicts);
                        markResolvedPage.setTreeConflicts(ResolveSynchronizeOperation.this.treeConflicts);
                        SvnWizard wizard = new SvnWizard(markResolvedPage);
                        SvnWizardDialog dialog = new SvnWizardDialog(ResolveSynchronizeOperation.this.getShell(), (IWizard)wizard);
                        wizard.setParentDialog((Dialog)dialog);
                        if (dialog.open() == 1) {
                            ResolveSynchronizeOperation.this.canceled = true;
                            return;
                        }
                        ResolveSynchronizeOperation.this.selectedResolution = markResolvedPage.getResolution();
                    }
                }
            });
        }
        if (this.canceled) {
            return;
        }
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                ISVNRepositoryLocation repository = null;
                ISVNClientAdapter svnClient = null;
                try {
                    try {
                        int i = 0;
                        while (i < resources.length) {
                            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]);
                            repository = svnResource.getRepository();
                            svnClient = repository.getSVNClient();
                            svnClient.resolve(resources[i].getLocation().toFile(), ResolveSynchronizeOperation.this.selectedResolution);
                            repository.returnSVNClient(svnClient);
                            repository = null;
                            svnClient = null;
                            resources[i].getParent().refreshLocal(2, monitor);
                            ++i;
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (SVNClientException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    if (repository != null) {
                        repository.returnSVNClient(svnClient);
                    }
                }
            }
        }, false, 2);
    }

    protected final void run(final IRunnableWithProgress runnable, boolean cancelable, int progressKind) throws InvocationTargetException, InterruptedException {
        final Exception[] exceptions = new Exception[1];
        final IRunnableWithProgress innerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SVNUIPlugin.getPlugin().getRepositoryManager().run(runnable, monitor);
            }
        };
        switch (progressKind) {
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            innerRunnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException e) {
                            exceptions[0] = e;
                        }
                    }
                });
                break;
            }
            default: {
                new ProgressMonitorDialog(this.getShell()).run(true, cancelable, innerRunnable);
            }
        }
        if (exceptions[0] != null) {
            if (exceptions[0] instanceof InvocationTargetException) {
                throw (InvocationTargetException)exceptions[0];
            }
            throw (InterruptedException)exceptions[0];
        }
    }
}

