/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.ISVNRepositorySourceProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizard;
import org.tigris.subversion.subclipse.ui.wizards.CloudForgeComposite;
import org.tigris.subversion.subclipse.ui.wizards.ConfigurationWizardRepositorySourceProviderPage;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ConfigurationWizardMainPage
extends SVNWizardPage {
    private boolean showCredentials = SVNProviderPlugin.getPlugin().getSVNClientManager().getSvnClientInterface().equals("commandline");
    private static final String COMMANDLINE_CLIENT = "commandline";
    private Combo userCombo;
    private Text passwordText;
    private Combo urlCombo;
    private static final int COMBO_HISTORY_LENGTH = 5;
    private Properties properties = null;
    private static final String STORE_USERNAME_ID = "ConfigurationWizardMainPage.STORE_USERNAME_ID";
    private static final String STORE_URL_ID = "ConfigurationWizardMainPage.STORE_URL_ID";
    private IDialogSettings settings;

    public ConfigurationWizardMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        l.remove(newEntry);
        l.add(0, newEntry);
        if (l.size() > 5) {
            l.remove(5);
        }
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    public IDialogSettings getDialogSettings() {
        return this.settings;
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        GridData data;
        Composite composite = this.createComposite(parent, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.sharing_new_repository_page_context");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ConfigurationWizardMainPage.this.validateFields();
            }
        };
        Group g = this.createGroup(composite, Policy.bind("ConfigurationWizardMainPage.Location_1"));
        ConfigurationWizardMainPage.createLabel((Composite)g, Policy.bind("ConfigurationWizardMainPage.url"));
        this.urlCombo = this.createEditableCombo((Composite)g);
        this.urlCombo.addListener(13, listener);
        this.urlCombo.addListener(24, listener);
        ISVNRepositorySourceProvider[] repositorySourceProviders = null;
        try {
            repositorySourceProviders = SVNUIPlugin.getRepositorySourceProviders();
        }
        catch (Exception exception) {}
        if (repositorySourceProviders == null || repositorySourceProviders.length == 0) {
            new Label((Composite)g, 0);
            Label repositoryProviderLabel = new Label((Composite)g, 64);
            data = new GridData(768);
            data.widthHint = 200;
            repositoryProviderLabel.setLayoutData((Object)data);
            repositoryProviderLabel.setText("Tired of typing in long URL's?  Your repository provider might provide a plug-in that would allow you to select your repository from a list.");
            new Label((Composite)g, 0);
            Hyperlink repositoryProviderLink = new Hyperlink((Composite)g, 0);
            repositoryProviderLink.setUnderlined(true);
            repositoryProviderLink.setForeground(Display.getDefault().getSystemColor(9));
            repositoryProviderLink.setText("Click here to see the list of available providers.");
            repositoryProviderLink.setToolTipText("http://subclipse.tigris.org/wiki/RepositoryProviders");
            repositoryProviderLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent evt) {
                    ConfigurationWizardRepositorySourceProviderPage.showAvailableProviders();
                }
            });
        }
        if (this.showCredentials) {
            g = this.createGroup(composite, Policy.bind("ConfigurationWizardMainPage.Authentication_2"));
            ConfigurationWizardMainPage.createLabel((Composite)g, Policy.bind("ConfigurationWizardMainPage.userName"));
            this.userCombo = this.createEditableCombo((Composite)g);
            this.userCombo.addListener(13, listener);
            this.userCombo.addListener(24, listener);
            ConfigurationWizardMainPage.createLabel((Composite)g, Policy.bind("ConfigurationWizardMainPage.password"));
            this.passwordText = ConfigurationWizardMainPage.createTextField((Composite)g);
            this.passwordText.setEchoChar('*');
        }
        CloudForgeComposite cloudForgeComposite = new CloudForgeComposite(composite, 0);
        data = new GridData(1048);
        data.horizontalSpan = 2;
        cloudForgeComposite.setLayoutData(data);
        this.initializeValues();
        this.validateFields();
        this.urlCombo.setFocus();
        this.setControl((Control)composite);
    }

    protected Combo createEditableCombo(Composite parent) {
        Combo combo = new Combo(parent, 0);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        return group;
    }

    public boolean finish(IProgressMonitor monitor) {
        Properties result = new Properties();
        if (this.showCredentials) {
            result.setProperty("user", this.userCombo.getText());
            result.setProperty("password", this.passwordText.getText());
        }
        result.setProperty("url", this.urlCombo.getText());
        this.properties = result;
        this.saveWidgetValues();
        return true;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void initializeValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] userNames;
            String[] hostNames = settings.getArray(STORE_URL_ID);
            if (hostNames != null) {
                int i = 0;
                while (i < hostNames.length) {
                    this.urlCombo.add(hostNames[i]);
                    ++i;
                }
            }
            if (this.showCredentials && (userNames = settings.getArray(STORE_USERNAME_ID)) != null) {
                int i = 0;
                while (i < userNames.length) {
                    this.userCombo.add(userNames[i]);
                    ++i;
                }
            }
        }
        if (this.properties != null) {
            String host;
            if (this.showCredentials) {
                String password;
                String user = this.properties.getProperty("user");
                if (user != null) {
                    this.userCombo.setText(user);
                }
                if ((password = this.properties.getProperty("password")) != null) {
                    this.passwordText.setText(password);
                }
            }
            if ((host = this.properties.getProperty("url")) != null) {
                this.urlCombo.setText(host);
            }
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] hostNames;
            if (this.showCredentials) {
                String[] userNames = settings.getArray(STORE_USERNAME_ID);
                if (userNames == null) {
                    userNames = new String[]{};
                }
                userNames = this.addToHistory(userNames, this.userCombo.getText());
                settings.put(STORE_USERNAME_ID, userNames);
            }
            if ((hostNames = settings.getArray(STORE_URL_ID)) == null) {
                hostNames = new String[]{};
            }
            hostNames = this.addToHistory(hostNames, this.urlCombo.getText());
            settings.put(STORE_URL_ID, hostNames);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private void validateFields() {
        String url = this.urlCombo.getText();
        if (url.length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        try {
            new SVNUrl(url);
        }
        catch (MalformedURLException e) {
            this.setErrorMessage(Policy.bind("ConfigurationWizardMainPage.invalidUrl", e.getMessage()));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.urlCombo.setFocus();
        }
    }

    public boolean canFlipToNextPage() {
        if (this.getWizard() instanceof CheckoutWizard) {
            CheckoutWizard wizard = (CheckoutWizard)this.getWizard();
            return this.isPageComplete() && wizard.getNextPage((IWizardPage)this, false) != null;
        }
        return super.canFlipToNextPage();
    }
}

