/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.text.ParseException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.RemoteResource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SvnWizardAnnotatePage
extends SvnWizardDialogPage {
    private ISVNRemoteFile svnResource;
    private Button includeMergedRevisionsButton;
    private Button ignoreMimeTypeButton;
    private Text fromRevisionText;
    private Button selectFromRevisionButton;
    private Button toHeadButton;
    private Button toRevisionButton;
    private Text toRevisionText;
    private Button selectToRevisionButton;
    private boolean includeMergedRevisions;
    private boolean ignoreMimeType;
    private SVNRevision fromRevision;
    private SVNRevision toRevision;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();

    public SvnWizardAnnotatePage(ISVNRemoteFile svnResource) {
        super("AnnotateDialog", Policy.bind("AnnotateDialog.title"));
        this.svnResource = svnResource;
    }

    @Override
    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }

    @Override
    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.includeMergedRevisionsButton = new Button(composite, 32);
        this.includeMergedRevisionsButton.setText(Policy.bind("AnnotateDialog.includeMerged"));
        this.includeMergedRevisionsButton.setSelection(this.settings.getBoolean("AnnotateDialog.includeMerged"));
        this.includeMergedRevisionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SvnWizardAnnotatePage.this.settings.put("AnnotateDialog.includeMerged", SvnWizardAnnotatePage.this.includeMergedRevisionsButton.getSelection());
            }
        });
        this.ignoreMimeTypeButton = new Button(composite, 32);
        this.ignoreMimeTypeButton.setText(Policy.bind("AnnotateDialog.ignoreMimeType"));
        Group fromGroup = new Group(composite, 0);
        fromGroup.setText(Policy.bind("AnnotateDialog.from"));
        GridLayout fromLayout = new GridLayout();
        fromLayout.numColumns = 3;
        fromGroup.setLayout((Layout)fromLayout);
        fromGroup.setLayoutData((Object)new GridData(1808));
        Label fromRevisionLabel = new Label((Composite)fromGroup, 0);
        fromRevisionLabel.setText(Policy.bind("AnnotateDialog.revision"));
        this.fromRevisionText = new Text((Composite)fromGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.fromRevisionText.setLayoutData((Object)data);
        this.fromRevisionText.setText("1");
        this.selectFromRevisionButton = new Button((Composite)fromGroup, 8);
        this.selectFromRevisionButton.setText(Policy.bind("AnnotateDialog.showLog"));
        Group toGroup = new Group(composite, 0);
        toGroup.setText(Policy.bind("AnnotateDialog.to"));
        GridLayout toLayout = new GridLayout();
        toLayout.numColumns = 5;
        toGroup.setLayout((Layout)toLayout);
        toGroup.setLayoutData((Object)new GridData(1808));
        this.toHeadButton = new Button((Composite)toGroup, 16);
        this.toHeadButton.setText(Policy.bind("AnnotateDialog.head"));
        this.toRevisionButton = new Button((Composite)toGroup, 16);
        this.toRevisionButton.setText(Policy.bind("AnnotateDialog.toRevision"));
        this.toRevisionText = new Text((Composite)toGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.toRevisionText.setLayoutData((Object)data);
        this.toRevisionText.setEnabled(false);
        if (this.toRevision == null && this.svnResource instanceof RemoteResource && ((RemoteResource)this.svnResource).getPegRevision() != null) {
            this.toRevision = ((RemoteResource)this.svnResource).getPegRevision();
        }
        if (this.toRevision == null) {
            this.toHeadButton.setSelection(true);
        } else {
            this.toRevisionText.setText(this.toRevision.toString());
            this.toRevisionButton.setSelection(true);
            this.toRevisionText.setEnabled(true);
        }
        this.selectToRevisionButton = new Button((Composite)toGroup, 8);
        this.selectToRevisionButton.setText(Policy.bind("AnnotateDialog.showToLog"));
        SelectionListener selectionListener = this.getSelectionListener();
        this.selectFromRevisionButton.addSelectionListener(selectionListener);
        this.toHeadButton.addSelectionListener(selectionListener);
        this.toRevisionButton.addSelectionListener(selectionListener);
        this.selectToRevisionButton.addSelectionListener(selectionListener);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SvnWizardAnnotatePage.this.setPageComplete(SvnWizardAnnotatePage.this.canFinish());
            }
        };
        this.fromRevisionText.addModifyListener(modifyListener);
        this.toRevisionText.addModifyListener(modifyListener);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.fromRevisionText.addFocusListener((FocusListener)focusListener);
        this.toRevisionText.addFocusListener((FocusListener)focusListener);
    }

    @Override
    public String getWindowTitle() {
        return Policy.bind("AnnotateDialog.title");
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performFinish() {
        this.includeMergedRevisions = this.includeMergedRevisionsButton.getSelection();
        this.ignoreMimeType = this.ignoreMimeTypeButton.getSelection();
        try {
            this.fromRevision = SVNRevision.getRevision((String)this.fromRevisionText.getText().trim());
        }
        catch (ParseException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("AnnotateDialog.title"), (String)e.getMessage());
            return false;
        }
        if (this.toHeadButton.getSelection()) {
            this.toRevision = SVNRevision.HEAD;
        } else {
            try {
                this.toRevision = SVNRevision.getRevision((String)this.toRevisionText.getText().trim());
            }
            catch (ParseException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("AnnotateDialog.title"), (String)e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public void saveSettings() {
    }

    @Override
    public void setMessage() {
        this.setMessage(Policy.bind("AnnotateDialog.message", this.svnResource.getName()));
    }

    public SVNRevision getFromRevision() {
        return this.fromRevision;
    }

    public SVNRevision getToRevision() {
        return this.toRevision;
    }

    public void setToRevision(SVNRevision toRevision) {
        this.toRevision = toRevision;
    }

    public boolean isIncludeMergedRevisions() {
        return this.includeMergedRevisions;
    }

    public boolean isIgnoreMimeType() {
        return this.ignoreMimeType;
    }

    private boolean canFinish() {
        this.setErrorMessage(null);
        if (this.fromRevisionText.getText().trim().length() == 0) {
            return false;
        }
        if (!this.validateRevision(this.fromRevisionText.getText().trim())) {
            this.setErrorMessage(Policy.bind("AnnotateDialog.invalidFromRevision"));
            return false;
        }
        if (this.toRevisionButton.getSelection() && this.toRevisionText.getText().trim().length() == 0) {
            return false;
        }
        if (this.toRevisionButton.getSelection() && !this.validateRevision(this.toRevisionText.getText().trim())) {
            this.setErrorMessage(Policy.bind("AnnotateDialog.invalidToRevision"));
            return false;
        }
        return true;
    }

    private boolean validateRevision(String revision) {
        try {
            SVNRevision.getRevision((String)revision);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    private SelectionListener getSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == SvnWizardAnnotatePage.this.selectFromRevisionButton) {
                    SvnWizardAnnotatePage.this.showLog(SvnWizardAnnotatePage.this.fromRevisionText);
                } else if (e.getSource() == SvnWizardAnnotatePage.this.toHeadButton || e.getSource() == SvnWizardAnnotatePage.this.toRevisionButton) {
                    SvnWizardAnnotatePage.this.toRevisionText.setEnabled(SvnWizardAnnotatePage.this.toRevisionButton.getSelection());
                    SvnWizardAnnotatePage.this.selectToRevisionButton.setEnabled(SvnWizardAnnotatePage.this.toRevisionButton.getSelection());
                    if (SvnWizardAnnotatePage.this.toRevisionButton.getSelection()) {
                        SvnWizardAnnotatePage.this.toRevisionText.setFocus();
                    }
                } else if (e.getSource() == SvnWizardAnnotatePage.this.selectToRevisionButton) {
                    SvnWizardAnnotatePage.this.showLog(SvnWizardAnnotatePage.this.toRevisionText);
                }
                SvnWizardAnnotatePage.this.setPageComplete(SvnWizardAnnotatePage.this.canFinish());
            }
        };
        return selectionListener;
    }

    private void showLog(Text text) {
        HistoryDialog dialog = new HistoryDialog(this.getShell(), (ISVNRemoteResource)this.svnResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        if (text == this.fromRevisionText || text == null && this.fromRevisionText.getText().trim().length() == 0) {
            this.fromRevisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
            this.fromRevisionText.setEnabled(true);
        }
        if (text == this.toRevisionText) {
            this.toRevisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
            this.toRevisionButton.setSelection(true);
            this.toHeadButton.setSelection(false);
            this.toRevisionText.setEnabled(true);
        }
    }
}

