/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;
import org.tigris.subversion.subclipse.ui.dialogs.BranchTagPropertyUpdateDialog;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.settings.CommentProperties;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.util.UrlCombo;
import org.tigris.subversion.subclipse.ui.wizards.IClosableWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnWizardBranchTagPage
extends SvnWizardDialogPage {
    private static final int REVISION_WIDTH_HINT = 40;
    private IResource resource;
    private ISVNRemoteResource remoteResource;
    private ISVNLocalResource svnResource;
    private UrlCombo toUrlCombo;
    private Button makeParentsButton;
    private Button serverButton;
    private Button revisionButton;
    private Text revisionText;
    private Button logButton;
    private Button workingCopyButton;
    private CommitCommentArea commitCommentArea;
    private SVNRevision revision;
    private SVNUrl url;
    private SVNUrl toUrl;
    private boolean createOnServer;
    private boolean specificRevision;
    private boolean makeParents;
    private String comment;
    private Text issueText;
    private String issue;
    private CommentProperties commentProperties;
    private ProjectProperties projectProperties;
    private long revisionNumber = 0L;
    private Alias newAlias;
    private Button switchAfterBranchTagCheckBox;
    private boolean switchAfterBranchTag;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();

    public SvnWizardBranchTagPage(IResource resource) {
        super("BranchTagDialog", Policy.bind("BranchTagDialog.title"));
        try {
            this.commentProperties = CommentProperties.getCommentProperties(resource);
            this.projectProperties = ProjectProperties.getProjectProperties(resource);
        }
        catch (SVNException sVNException) {}
        this.commitCommentArea = new CommitCommentArea(null, null, Policy.bind("BranchTagDialog.enterComment"), this.commentProperties);
        if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0) {
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SvnWizardBranchTagPage.this.setPageComplete(SvnWizardBranchTagPage.this.canFinish());
                }
            };
            this.commitCommentArea.setModifyListener(modifyListener);
        }
        this.resource = resource;
    }

    public SvnWizardBranchTagPage(ISVNRemoteResource remoteResource) {
        super("BranchTagDialog", Policy.bind("BranchTagDialog.title"));
        this.commitCommentArea = new CommitCommentArea(null, null, Policy.bind("BranchTagDialog.enterComment"), this.commentProperties);
        this.remoteResource = remoteResource;
    }

    @Override
    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite top = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        top.setLayout((Layout)gridLayout);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        Group repositoryGroup = new Group(top, 0);
        repositoryGroup.setText(Policy.bind("BranchTagDialog.repository"));
        repositoryGroup.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, false);
        repositoryGroup.setLayoutData((Object)data);
        Label fromUrlLabel = new Label((Composite)repositoryGroup, 0);
        if (this.resource == null) {
            fromUrlLabel.setText(Policy.bind("BranchTagDialog.fromUrl"));
        } else {
            fromUrlLabel.setText(Policy.bind("BranchTagDialog.url"));
        }
        Text urlText = new Text((Composite)repositoryGroup, 2048);
        data = new GridData(768);
        urlText.setLayoutData((Object)data);
        if (this.resource == null) {
            this.url = this.remoteResource.getUrl();
            urlText.setText(this.url.toString());
        } else {
            this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
            try {
                this.url = this.svnResource.getStatus().getUrl();
                if (this.url != null) {
                    urlText.setText(this.svnResource.getStatus().getUrlString());
                }
            }
            catch (SVNException sVNException) {}
        }
        urlText.setEditable(false);
        Label toUrlLabel = new Label((Composite)repositoryGroup, 0);
        toUrlLabel.setText(Policy.bind("BranchTagDialog.toUrl"));
        Composite urlComposite = new Composite((Composite)repositoryGroup, 0);
        GridLayout urlLayout = new GridLayout();
        urlLayout.numColumns = 2;
        urlLayout.marginWidth = 0;
        urlLayout.marginHeight = 0;
        urlComposite.setLayout((Layout)urlLayout);
        data = new GridData(4, 4, true, false);
        urlComposite.setLayoutData((Object)data);
        this.toUrlCombo = new UrlCombo(urlComposite, 0);
        this.toUrlCombo.init(this.resource == null ? "repositoryBrowser" : this.resource.getProject().getName());
        this.toUrlCombo.setLayoutData(new GridData(768));
        this.toUrlCombo.setText(urlText.getText());
        Button browseButton = new Button(urlComposite, 8);
        browseButton.setText(Policy.bind("SwitchDialog.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog = new ChooseUrlDialog(SvnWizardBranchTagPage.this.getShell(), SvnWizardBranchTagPage.this.resource);
                if (dialog.open() == 0 && dialog.getUrl() != null) {
                    SvnWizardBranchTagPage.this.toUrlCombo.setText(dialog.getUrl());
                }
            }
        });
        this.makeParentsButton = new Button(urlComposite, 32);
        this.makeParentsButton.setText(Policy.bind("BranchTagDialog.makeParents"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.makeParentsButton.setLayoutData((Object)data);
        this.makeParentsButton.setSelection(this.settings.getBoolean("BranchTagDialog.makeParents"));
        this.makeParentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvnWizardBranchTagPage.this.settings.put("BranchTagDialog.makeParents", SvnWizardBranchTagPage.this.makeParentsButton.getSelection());
            }
        });
        Group serverComposite = new Group(top, 0);
        serverComposite.setText(Policy.bind("BranchTagDialog.createCopy"));
        GridLayout serverLayout = new GridLayout();
        serverLayout.numColumns = 3;
        serverComposite.setLayout((Layout)serverLayout);
        data = new GridData(4, 4, true, false);
        serverComposite.setLayoutData((Object)data);
        this.serverButton = new Button((Composite)serverComposite, 16);
        this.serverButton.setText(Policy.bind("BranchTagDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.serverButton.setLayoutData((Object)data);
        this.revisionButton = new Button((Composite)serverComposite, 16);
        this.revisionButton.setText(Policy.bind("BranchTagDialog.revision"));
        this.revisionText = new Text((Composite)serverComposite, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        if (this.revisionNumber == 0L) {
            this.revisionText.setEnabled(false);
        } else {
            this.revisionText.setText("" + this.revisionNumber);
        }
        this.revisionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SvnWizardBranchTagPage.this.setPageComplete(SvnWizardBranchTagPage.this.canFinish());
            }
        });
        this.logButton = new Button((Composite)serverComposite, 8);
        this.logButton.setText(Policy.bind("MergeDialog.showLog"));
        if (this.revisionNumber == 0L) {
            this.logButton.setEnabled(false);
        }
        this.logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvnWizardBranchTagPage.this.showLog();
            }
        });
        this.workingCopyButton = new Button((Composite)serverComposite, 16);
        this.workingCopyButton.setText(Policy.bind("BranchTagDialog.working"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.workingCopyButton.setLayoutData((Object)data);
        if (this.resource == null) {
            this.workingCopyButton.setVisible(false);
        }
        if (this.revisionNumber == 0L) {
            this.serverButton.setSelection(true);
        } else {
            this.revisionButton.setSelection(true);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvnWizardBranchTagPage.this.revisionText.setEnabled(SvnWizardBranchTagPage.this.revisionButton.getSelection());
                SvnWizardBranchTagPage.this.logButton.setEnabled(SvnWizardBranchTagPage.this.revisionButton.getSelection());
                if (SvnWizardBranchTagPage.this.revisionButton.getSelection()) {
                    SvnWizardBranchTagPage.this.revisionText.setFocus();
                }
                SvnWizardBranchTagPage.this.setPageComplete(SvnWizardBranchTagPage.this.canFinish());
            }
        };
        this.serverButton.addSelectionListener((SelectionListener)selectionListener);
        this.revisionButton.addSelectionListener((SelectionListener)selectionListener);
        this.workingCopyButton.addSelectionListener((SelectionListener)selectionListener);
        if (this.projectProperties != null && this.projectProperties.getMessage() != null) {
            this.addBugtrackingArea(top);
        }
        this.commitCommentArea.createArea(composite);
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested" && SvnWizardBranchTagPage.this.canFinish()) {
                    IClosableWizard wizard = (IClosableWizard)SvnWizardBranchTagPage.this.getWizard();
                    wizard.finishAndClose();
                }
            }
        });
        this.toUrlCombo.getCombo().setFocus();
        if (this.resource != null) {
            this.switchAfterBranchTagCheckBox = new Button(composite, 32);
            this.switchAfterBranchTagCheckBox.setText(Policy.bind("BranchTagDialog.switchAfterTagBranch"));
        }
        this.setPageComplete(this.canFinish());
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.revisionText.addFocusListener(focusListener);
        if (this.issueText != null) {
            this.issueText.addFocusListener(focusListener);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.branch_tag_dialog_context");
    }

    protected void showLog() {
        ISVNRemoteResource remoteResource = null;
        if (this.resource == null) {
            remoteResource = this.remoteResource;
        } else {
            try {
                remoteResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource).getRepository().getRemoteFile(this.url);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
                return;
            }
        }
        if (remoteResource == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + this.toUrlCombo.getText()));
            return;
        }
        HistoryDialog dialog = new HistoryDialog(this.getShell(), remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        this.setPageComplete(this.canFinish());
    }

    private void addBugtrackingArea(Composite composite) {
        Composite bugtrackingComposite = new Composite(composite, 0);
        GridLayout bugtrackingLayout = new GridLayout();
        bugtrackingLayout.numColumns = 2;
        bugtrackingComposite.setLayout((Layout)bugtrackingLayout);
        Label label = new Label(bugtrackingComposite, 0);
        label.setText(this.projectProperties.getLabel());
        this.issueText = new Text(bugtrackingComposite, 2048);
        GridData data = new GridData();
        data.widthHint = 150;
        this.issueText.setLayoutData((Object)data);
    }

    @Override
    public String getWindowTitle() {
        return Policy.bind("BranchTagDialog.title");
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performFinish() {
        if (this.projectProperties != null) {
            String issueError;
            this.issue = this.issueText.getText().trim();
            if (this.projectProperties.isWarnIfNoIssue() && this.issueText.getText().trim().length() == 0 && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)Policy.bind("BranchTagDialog.0", this.projectProperties.getLabel()))) {
                this.issueText.setFocus();
                return false;
            }
            if (this.issueText.getText().trim().length() > 0 && (issueError = this.projectProperties.validateIssue(this.issueText.getText().trim())) != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)issueError);
                this.issueText.selectAll();
                this.issueText.setFocus();
                return false;
            }
        }
        this.toUrlCombo.saveUrl();
        this.createOnServer = !this.workingCopyButton.getSelection();
        this.specificRevision = this.revisionButton.getSelection();
        this.makeParents = this.makeParentsButton.getSelection();
        if (this.switchAfterBranchTagCheckBox != null) {
            this.switchAfterBranchTag = this.switchAfterBranchTagCheckBox.getSelection();
        }
        this.comment = this.commitCommentArea.getComment(true);
        if (this.serverButton.getSelection()) {
            this.revision = SVNRevision.HEAD;
        }
        try {
            this.toUrl = new SVNUrl(this.toUrlCombo.getText());
            if (this.revisionButton.getSelection()) {
                this.revision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)e.getMessage());
            return false;
        }
        if (this.resource != null) {
            this.updateTagsProperty(this.toUrl);
        }
        return true;
    }

    @Override
    public void saveSettings() {
    }

    @Override
    public void setMessage() {
        this.setMessage(Policy.bind("BranchTagDialog.message"));
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    private boolean canFinish() {
        if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0 && this.commitCommentArea.getCommentLength() < this.commentProperties.getMinimumLogMessageSize()) {
            return false;
        }
        return !this.revisionButton.getSelection() || this.revisionText.getText().trim().length() != 0;
    }

    private void updateTagsProperty(SVNUrl toUrl) {
        ISVNClientAdapter svnClient;
        block7: {
            svnClient = null;
            ISVNProperty property = null;
            property = this.svnResource.getSvnProperty("subclipse:tags");
            if (property != null) break block7;
            this.svnResource.getRepository().returnSVNClient(svnClient);
            return;
        }
        try {
            try {
                this.newAlias = new Alias();
                this.newAlias.setBranch(toUrl.toString().toUpperCase().indexOf("TAGS") == -1);
                String relativePath = toUrl.toString().substring(this.svnResource.getRepository().getUrl().toString().length());
                this.newAlias.setRelativePath(relativePath);
                SVNRevision revision = null;
                if (this.revisionButton.getSelection()) {
                    revision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
                } else {
                    svnClient = this.svnResource.getRepository().getSVNClient();
                    ISVNInfo svnInfo = svnClient.getInfo(this.url);
                    revision = SVNRevision.getRevision((String)svnInfo.getRevision().toString());
                }
                this.newAlias.setRevision(Integer.parseInt(revision.toString()));
                this.newAlias.setName(toUrl.getLastPathSegment());
                BranchTagPropertyUpdateDialog dialog = new BranchTagPropertyUpdateDialog(this.getShell(), this.resource, this.newAlias, "BranchTagPropertyUpdateDialog");
                this.newAlias = dialog.open() == 0 ? dialog.getNewAlias() : null;
            }
            catch (Exception exception) {
                this.svnResource.getRepository().returnSVNClient(svnClient);
            }
        }
        catch (Throwable throwable) {
            this.svnResource.getRepository().returnSVNClient(svnClient);
            throw throwable;
        }
        this.svnResource.getRepository().returnSVNClient(svnClient);
    }

    public String getComment() {
        if (this.projectProperties != null && this.issue != null && this.issue.length() > 0) {
            if (this.projectProperties.isAppend()) {
                return String.valueOf(this.comment) + "\n" + this.projectProperties.getResolvedMessage(this.issue) + "\n";
            }
            return String.valueOf(this.projectProperties.getResolvedMessage(this.issue)) + "\n" + this.comment;
        }
        return this.comment;
    }

    public boolean isCreateOnServer() {
        return this.createOnServer;
    }

    public boolean isSpecificRevision() {
        return this.specificRevision;
    }

    public boolean isMakeParents() {
        return this.makeParents;
    }

    public SVNUrl getToUrl() {
        return this.toUrl;
    }

    public SVNUrl getUrl() {
        return this.url;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public Alias getNewAlias() {
        return this.newAlias;
    }

    public boolean switchAfterTagBranch() {
        return this.switchAfterBranchTag;
    }

    @Override
    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }
}

