/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.internal;

import com.jaspersoft.studio.properties.Activator;
import com.jaspersoft.studio.properties.internal.InputType;
import com.jaspersoft.studio.properties.messages.Messages;
import com.jaspersoft.studio.properties.view.AbstractSectionDescriptor;
import com.jaspersoft.studio.properties.view.ISection;
import com.jaspersoft.studio.properties.view.ITypeMapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IFilter;

public class SectionDescriptor
extends AbstractSectionDescriptor {
    private static final String ATT_ID = "id";
    private static final String ATT_TARGET_TAB = "tab";
    private static final String ATT_AFTER_SECTION = "afterSection";
    private static final String ATT_CLASS = "class";
    private static final String ATT_SECTION_FILTER = "filter";
    private static final String ATT_SECTION_ENABLES_FOR = "enablesFor";
    private static final String ATT_INPUT_TYPE = "type";
    private static final String ATT_EXCLUDE_SUBTYPES = "excludeSubtypes";
    private static final String ELEMENT_INPUT = "input";
    private String id;
    private String targetTab;
    private String afterSection;
    private ArrayList<InputType> inputTypes;
    private IFilter filter;
    private int enablesFor = -1;
    private IConfigurationElement configurationElement;

    protected SectionDescriptor(IConfigurationElement configurationElement, ITypeMapper typeMapper) {
        super(typeMapper);
        String enablesForStr;
        int enablesForTest;
        this.configurationElement = configurationElement;
        this.id = this.getConfigurationElement().getAttribute(ATT_ID);
        this.targetTab = this.getConfigurationElement().getAttribute(ATT_TARGET_TAB);
        this.afterSection = this.getConfigurationElement().getAttribute(ATT_AFTER_SECTION);
        if (this.getConfigurationElement().getAttribute(ATT_SECTION_ENABLES_FOR) != null && (enablesForTest = Integer.parseInt(enablesForStr = this.getConfigurationElement().getAttribute(ATT_SECTION_ENABLES_FOR))) > 0) {
            this.enablesFor = enablesForTest;
        }
        if (this.id == null || this.targetTab == null) {
            this.handleSectionError(null);
        }
    }

    private void handleSectionError(CoreException exception) {
        String pluginId = this.getConfigurationElement().getDeclaringExtension().getNamespaceIdentifier();
        String message = Messages.SectionDescriptor_Section_error;
        message = exception == null ? MessageFormat.format(Messages.SectionDescriptor_Section_error, pluginId) : MessageFormat.format(Messages.SectionDescriptor_class_not_found_error, pluginId);
        Status status = new Status(4, pluginId, 2, message, (Throwable)exception);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IFilter getFilter() {
        if (this.filter == null) {
            try {
                if (this.getConfigurationElement().getAttribute(ATT_SECTION_FILTER) != null) {
                    this.filter = (IFilter)this.configurationElement.createExecutableExtension(ATT_SECTION_FILTER);
                }
            }
            catch (CoreException exception) {
                this.handleSectionError(exception);
            }
        }
        return this.filter;
    }

    @Override
    public int getEnablesFor() {
        return this.enablesFor;
    }

    @Override
    public String getTargetTab() {
        return this.targetTab;
    }

    @Override
    public String getAfterSection() {
        if (this.afterSection == null) {
            return super.getAfterSection();
        }
        return this.afterSection;
    }

    @Override
    public ISection getSectionClass() {
        ISection section = null;
        try {
            section = (ISection)this.getConfigurationElement().createExecutableExtension(ATT_CLASS);
        }
        catch (CoreException exception) {
            this.handleSectionError(exception);
        }
        return section;
    }

    @Override
    public List<InputType> getInputTypes() {
        if (this.inputTypes == null) {
            this.inputTypes = new ArrayList();
            IConfigurationElement[] elements = this.getConfigurationElement().getChildren(ELEMENT_INPUT);
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                String type = element.getAttribute(ATT_INPUT_TYPE);
                String attExcludeSubtype = element.getAttribute(ATT_EXCLUDE_SUBTYPES);
                boolean excludeSubtype = attExcludeSubtype != null ? Boolean.parseBoolean(attExcludeSubtype) : false;
                this.inputTypes.add(new InputType(type, excludeSubtype));
                ++i;
            }
        }
        return this.inputTypes;
    }

    public String toString() {
        return this.getId();
    }

    private IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }
}

