/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.internal;

import com.jaspersoft.studio.properties.Activator;
import com.jaspersoft.studio.properties.internal.SectionDescriptor;
import com.jaspersoft.studio.properties.internal.TabDescriptor;
import com.jaspersoft.studio.properties.internal.TabListContentProvider;
import com.jaspersoft.studio.properties.messages.Messages;
import com.jaspersoft.studio.properties.view.AbstractTabDescriptor;
import com.jaspersoft.studio.properties.view.IActionProvider;
import com.jaspersoft.studio.properties.view.ISectionDescriptor;
import com.jaspersoft.studio.properties.view.ISectionDescriptorProvider;
import com.jaspersoft.studio.properties.view.ITabDescriptor;
import com.jaspersoft.studio.properties.view.ITabDescriptorProvider;
import com.jaspersoft.studio.properties.view.ITypeMapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.IWorkbenchPart;

public class TabbedPropertyRegistry {
    private static final String NO_TAB_ERROR = Messages.TabbedPropertyRegistry_Non_existing_tab;
    private static final String CONTRIBUTOR_ERROR = Messages.TabbedPropertyRegistry_contributor_error;
    private static final String TAB_ERROR = Messages.TabDescriptor_Tab_unknown_category;
    private static final String EXTPT_CONTRIBUTOR = "propertyContributor";
    private static final String EXTPT_TABS = "propertyTabs";
    private static final String EXTPT_SECTIONS = "propertySections";
    private static final String ELEMENT_TAB = "propertyTab";
    private static final String ELEMENT_SECTION = "propertySection";
    private static final String ELEMENT_PROPERTY_CATEGORY = "propertyCategory";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_CONTRIBUTOR_ID = "contributorId";
    private static final String ATT_TYPE_MAPPER = "typeMapper";
    private static final String ATT_LABEL_PROVIDER = "labelProvider";
    private static final String ATT_ACTION_PROVIDER = "actionProvider";
    private static final String ATT_SECTION_DESCRIPTOR_PROVIDER = "sectionDescriptorProvider";
    private static final String ATT_TAB_DESCRIPTOR_PROVIDER = "tabDescriptorProvider";
    private static final String TOP = "top";
    protected String contributorId;
    protected IConfigurationElement contributorConfigurationElement;
    protected List<String> propertyCategories;
    protected ILabelProvider labelProvider;
    protected IActionProvider actionProvider;
    protected ITypeMapper typeMapper;
    protected ISectionDescriptorProvider sectionDescriptorProvider;
    protected ITabDescriptorProvider tabDescriptorProvider;
    protected ITabDescriptor[] tabDescriptors;
    protected static final AbstractTabDescriptor[] EMPTY_DESCRIPTOR_ARRAY = new TabDescriptor[0];

    protected TabbedPropertyRegistry(String id) {
        this.contributorId = id;
        this.propertyCategories = new ArrayList<String>();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_CONTRIBUTOR);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement configurationElement = extensions[i];
            String contributor = configurationElement.getAttribute(ATT_CONTRIBUTOR_ID);
            if (contributor != null && id.equals(contributor)) {
                this.contributorConfigurationElement = configurationElement;
                try {
                    if (configurationElement.getAttribute(ATT_LABEL_PROVIDER) != null) {
                        this.labelProvider = (ILabelProvider)configurationElement.createExecutableExtension(ATT_LABEL_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_ACTION_PROVIDER) != null) {
                        this.actionProvider = (IActionProvider)configurationElement.createExecutableExtension(ATT_ACTION_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_TYPE_MAPPER) != null) {
                        this.typeMapper = (ITypeMapper)configurationElement.createExecutableExtension(ATT_TYPE_MAPPER);
                    }
                    if (configurationElement.getAttribute(ATT_SECTION_DESCRIPTOR_PROVIDER) != null) {
                        this.sectionDescriptorProvider = (ISectionDescriptorProvider)configurationElement.createExecutableExtension(ATT_SECTION_DESCRIPTOR_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_TAB_DESCRIPTOR_PROVIDER) != null) {
                        this.tabDescriptorProvider = (ITabDescriptorProvider)configurationElement.createExecutableExtension(ATT_TAB_DESCRIPTOR_PROVIDER);
                    }
                }
                catch (CoreException exception) {
                    this.handleConfigurationError(id, exception);
                }
                this.addPropertyCategories(configurationElement);
            }
            ++i;
        }
        if (this.propertyCategories == null || this.contributorId == null || this.contributorConfigurationElement == null) {
            this.handleConfigurationError(id, null);
            this.contributorId = null;
        }
    }

    private void addPropertyCategories(IConfigurationElement configurationElement) {
        IConfigurationElement[] elements = configurationElement.getChildren(ELEMENT_PROPERTY_CATEGORY);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            this.propertyCategories.add(element.getAttribute(ATT_CATEGORY));
            ++i;
        }
    }

    private void handleConfigurationError(String id, CoreException exception) {
        String message = MessageFormat.format(CONTRIBUTOR_ERROR, id);
        Status status = new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 4, message, (Throwable)exception);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected ISectionDescriptor[] readSectionDescriptors() {
        ArrayList<SectionDescriptor> result = new ArrayList<SectionDescriptor>();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_SECTIONS);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            IConfigurationElement[] sections = extension.getChildren(ELEMENT_SECTION);
            int j = 0;
            while (j < sections.length) {
                IConfigurationElement section = sections[j];
                SectionDescriptor descriptor = new SectionDescriptor(section, this.typeMapper);
                result.add(descriptor);
                ++j;
            }
            ++i;
        }
        return result.toArray(new ISectionDescriptor[result.size()]);
    }

    protected IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        if (this.contributorId == null) {
            return new IConfigurationElement[0];
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(Activator.getDefault().getBundle().getSymbolicName(), extensionPointId);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        ArrayList<IConfigurationElement> unordered = new ArrayList<IConfigurationElement>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            String contributor;
            IConfigurationElement extension = extensions[i];
            if (extension.getName().equals(extensionPointId) && this.contributorId.equals(contributor = extension.getAttribute(ATT_CONTRIBUTOR_ID))) {
                unordered.add(extension);
            }
            ++i;
        }
        return unordered.toArray(new IConfigurationElement[unordered.size()]);
    }

    private int getIndex(Object[] array, Object target) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        ITabDescriptor[] allDescriptors = null;
        allDescriptors = this.tabDescriptorProvider == null ? this.getAllTabDescriptors() : this.tabDescriptorProvider.getTabDescriptors(part, selection);
        ITabDescriptor[] result = this.filterTabDescriptors(allDescriptors, part, selection);
        return result;
    }

    protected ITabDescriptor[] filterTabDescriptors(ITabDescriptor[] descriptors, IWorkbenchPart part, ISelection selection) {
        ArrayList<ITabDescriptor> result = new ArrayList<ITabDescriptor>();
        int i = 0;
        while (i < descriptors.length) {
            ITabDescriptor descriptor = this.adaptDescriptorFor(descriptors[i], part, selection);
            if (!descriptor.getSectionDescriptors().isEmpty()) {
                result.add(descriptor);
            }
            ++i;
        }
        if (result.size() == 0) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        return result.toArray(new ITabDescriptor[result.size()]);
    }

    protected ITabDescriptor adaptDescriptorFor(ITabDescriptor target, IWorkbenchPart part, ISelection selection) {
        ArrayList<ISectionDescriptor> filteredSectionDescriptors = new ArrayList<ISectionDescriptor>();
        List<ISectionDescriptor> descriptors = target.getSectionDescriptors();
        for (ISectionDescriptor descriptor : descriptors) {
            if (!descriptor.appliesTo(part, selection)) continue;
            filteredSectionDescriptors.add(descriptor);
        }
        AbstractTabDescriptor result = (AbstractTabDescriptor)((AbstractTabDescriptor)target).clone();
        result.setSectionDescriptors(filteredSectionDescriptors);
        return result;
    }

    protected ITabDescriptor[] getAllTabDescriptors() {
        if (this.tabDescriptors == null) {
            List<ITabDescriptor> temp = this.readTabDescriptors();
            this.populateWithSectionDescriptors(temp);
            temp = this.sortTabDescriptorsByCategory(temp);
            temp = this.sortTabDescriptorsByAfterTab(temp);
            this.tabDescriptors = temp.toArray(new TabDescriptor[temp.size()]);
        }
        return this.tabDescriptors;
    }

    protected List<ITabDescriptor> readTabDescriptors() {
        ArrayList<ITabDescriptor> result = new ArrayList<ITabDescriptor>();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_TABS);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            IConfigurationElement[] tabs = extension.getChildren(ELEMENT_TAB);
            int j = 0;
            while (j < tabs.length) {
                IConfigurationElement tab = tabs[j];
                TabDescriptor descriptor = new TabDescriptor(tab);
                if (this.getIndex(this.propertyCategories.toArray(), descriptor.getCategory()) == -1) {
                    this.handleTabError(tab, descriptor.getCategory() == null ? "" : descriptor.getCategory());
                } else {
                    result.add(descriptor);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    protected void populateWithSectionDescriptors(List<ITabDescriptor> aTabDescriptors) {
        ISectionDescriptor[] sections = null;
        sections = this.sectionDescriptorProvider != null ? this.sectionDescriptorProvider.getSectionDescriptors() : this.readSectionDescriptors();
        int i = 0;
        while (i < sections.length) {
            ISectionDescriptor section = sections[i];
            this.appendToTabDescriptor(section, aTabDescriptors);
            ++i;
        }
    }

    protected void appendToTabDescriptor(ISectionDescriptor section, List<ITabDescriptor> aTabDescriptors) {
        for (ITabDescriptor tab : aTabDescriptors) {
            if (!((TabDescriptor)tab).append(section)) continue;
            return;
        }
        String message = MessageFormat.format(NO_TAB_ERROR, section.getId(), section.getTargetTab());
        Status status = new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 1, message, null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected List<ITabDescriptor> sortTabDescriptorsByCategory(List<ITabDescriptor> descriptors) {
        Collections.sort(descriptors, new Comparator<ITabDescriptor>(){

            @Override
            public int compare(ITabDescriptor arg0, ITabDescriptor arg1) {
                TabDescriptor one = (TabDescriptor)arg0;
                TabDescriptor two = (TabDescriptor)arg1;
                String categoryOne = one.getCategory();
                String categoryTwo = two.getCategory();
                int categoryOnePosition = TabbedPropertyRegistry.this.getIndex(TabbedPropertyRegistry.this.propertyCategories.toArray(), categoryOne);
                int categoryTwoPosition = TabbedPropertyRegistry.this.getIndex(TabbedPropertyRegistry.this.propertyCategories.toArray(), categoryTwo);
                return categoryOnePosition - categoryTwoPosition;
            }
        });
        return descriptors;
    }

    protected List<ITabDescriptor> sortTabDescriptorsByAfterTab(List<ITabDescriptor> tabs) {
        if (tabs.size() == 0 || this.propertyCategories == null) {
            return tabs;
        }
        ArrayList<ITabDescriptor> sorted = new ArrayList<ITabDescriptor>();
        int categoryIndex = 0;
        int i = 0;
        while (i < this.propertyCategories.size()) {
            ArrayList<ITabDescriptor> categoryList = new ArrayList<ITabDescriptor>();
            String category = this.propertyCategories.get(i);
            int topOfCategory = categoryIndex;
            int endOfCategory = categoryIndex;
            while (endOfCategory < tabs.size() && ((TabDescriptor)tabs.get(endOfCategory)).getCategory().equals(category)) {
                ++endOfCategory;
            }
            int j = topOfCategory;
            while (j < endOfCategory) {
                TabDescriptor tab = (TabDescriptor)tabs.get(j);
                if (tab.getAfterTab().equals(TOP)) {
                    categoryList.add(0, tabs.get(j));
                } else {
                    categoryList.add(tabs.get(j));
                }
                ++j;
            }
            Collections.sort(categoryList, new Comparator<ITabDescriptor>(){

                @Override
                public int compare(ITabDescriptor arg0, ITabDescriptor arg1) {
                    TabDescriptor one = (TabDescriptor)arg0;
                    TabDescriptor two = (TabDescriptor)arg1;
                    if (two.getAfterTab().equals(one.getId())) {
                        return -1;
                    }
                    if (one.getAfterTab().equals(two.getId())) {
                        return 1;
                    }
                    return 0;
                }
            });
            j = 0;
            while (j < categoryList.size()) {
                sorted.add((ITabDescriptor)categoryList.get(j));
                ++j;
            }
            categoryIndex = endOfCategory;
            ++i;
        }
        return sorted;
    }

    public ITypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public IStructuredContentProvider getTabListContentProvider() {
        return new TabListContentProvider(this);
    }

    private void handleTabError(IConfigurationElement configurationElement, String category) {
        String pluginId = configurationElement.getDeclaringExtension().getNamespaceIdentifier();
        String message = MessageFormat.format(TAB_ERROR, pluginId, category);
        Status status = new Status(4, pluginId, 3, message, null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        if (this.tabDescriptors != null) {
            int i = 0;
            while (i < this.tabDescriptors.length) {
                if (this.tabDescriptors[i] instanceof TabDescriptor) {
                    ((TabDescriptor)this.tabDescriptors[i]).dispose();
                }
                ++i;
            }
        }
    }
}

