/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.internal;

import com.jaspersoft.studio.properties.internal.IHighlightPropertyWidget;
import com.jaspersoft.studio.properties.internal.IWidgetsProviderSection;
import com.jaspersoft.studio.properties.internal.ManualyOpenedAutocomplete;
import com.jaspersoft.studio.properties.internal.PropertiesContainer;
import com.jaspersoft.studio.properties.internal.PropertyContainer;
import com.jaspersoft.studio.properties.internal.PropertyContentProposal;
import com.jaspersoft.studio.properties.internal.WidgetDescriptor;
import com.jaspersoft.studio.properties.messages.Messages;
import com.jaspersoft.studio.properties.view.ISection;
import com.jaspersoft.studio.properties.view.TabContents;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetWidgetFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.wb.swt.SWTResourceManager;

public class TabbedPropertySearch
extends Composite {
    private Text textArea;
    private TabbedPropertySheetPage page;
    private TabbedPropertySheetWidgetFactory factory;
    private Object lastSelectedElement = null;
    private PropertiesContainer cachedProperties = null;
    private static final Color arrowColor = SWTResourceManager.getColor((int)0, (int)0, (int)0);
    private ManualyOpenedAutocomplete autocomplete;
    protected static final int ARROW_WIDTH = 7;
    protected static final int ARROW_HEIGHT = 4;
    private Layout searchLayout = new Layout(){

        protected void layout(Composite parent, boolean flushCache) {
            Control[] children = parent.getChildren();
            Rectangle carea = parent.getClientArea();
            Control textControl = children[0];
            Point textSize = textControl.computeSize(carea.width, (int)Math.round((double)carea.height * 0.7));
            int textControl_y = (carea.height - textSize.y) / 2;
            textControl.setBounds(0, textControl_y, carea.width - 15, textSize.y);
            Control text = children[1];
            text.setBounds(carea.width - 15, textControl_y, 15, textSize.y);
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point textSize = children[0].computeSize(wHint, -1);
            return new Point(Math.max(textSize.x + 15, 50), textSize.y);
        }
    };
    private IContentProposalListener proposalListener = new IContentProposalListener(){

        public void proposalAccepted(IContentProposal proposal) {
            if (proposal instanceof PropertyContentProposal) {
                PropertyContentProposal propertyProposal = (PropertyContentProposal)proposal;
                TabbedPropertySearch.this.selectElement(propertyProposal.getPropertyId(), propertyProposal.getSectionType());
            }
        }
    };

    public TabbedPropertySearch(Composite parent, TabbedPropertySheetPage page) {
        super(parent, 524288);
        this.page = page;
        this.factory = page.getWidgetFactory();
        this.factory.getColors().initializeSectionToolBarColors();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TabbedPropertySearch.this.drawTitleBackground(e);
            }
        });
        this.setLayoutData(new GridData(1808));
        this.createTextArea(this);
        this.createFakeButton(this);
        this.setLayout(this.searchLayout);
    }

    private void createTextArea(Composite containerComp) {
        this.textArea = new Text(containerComp, 0);
        this.textArea.setForeground(this.factory.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.textArea.setText(Messages.TabbedPropertySearch_searchPropertyLabel);
        this.textArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorConstants.black);
                Point textSize = TabbedPropertySearch.this.textArea.getSize();
                e.gc.drawLine(0, 0, textSize.x, 0);
                e.gc.drawLine(0, 0, 0, textSize.y);
                e.gc.drawLine(0, textSize.y - 1, textSize.x, textSize.y - 1);
            }
        });
        this.textArea.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (TabbedPropertySearch.this.textArea.getText().equals(Messages.TabbedPropertySearch_searchPropertyLabel)) {
                    TabbedPropertySearch.this.textArea.setText("");
                }
                TabbedPropertySearch.this.updateAutocompleteContent();
            }

            public void focusLost(FocusEvent e) {
                if (TabbedPropertySearch.this.textArea.getText().isEmpty()) {
                    TabbedPropertySearch.this.textArea.setText(Messages.TabbedPropertySearch_searchPropertyLabel);
                }
            }
        });
        this.textArea.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 8 && TabbedPropertySearch.this.textArea.getText().isEmpty() && !TabbedPropertySearch.this.autocomplete.isProposalOpened()) {
                    TabbedPropertySearch.this.autocomplete.openProposalPopup();
                }
                if (e.keyCode == 0x1000002 && !TabbedPropertySearch.this.autocomplete.isProposalOpened()) {
                    TabbedPropertySearch.this.autocomplete.openProposalPopup();
                }
                if (e.keyCode == 13 && !TabbedPropertySearch.this.autocomplete.isProposalOpened() && TabbedPropertySearch.this.cachedProperties != null) {
                    String searchedString = TabbedPropertySearch.this.textArea.getText().toLowerCase();
                    int i = 0;
                    while (i < TabbedPropertySearch.this.cachedProperties.getSize()) {
                        PropertyContainer actualContainer = TabbedPropertySearch.this.cachedProperties.getPrperties()[i];
                        String actualString = actualContainer.getName().toLowerCase();
                        if (actualString.equals(searchedString)) {
                            TabbedPropertySearch.this.checkSelection(actualContainer.getId());
                            return;
                        }
                        ++i;
                    }
                }
            }
        });
    }

    private void createFakeButton(Composite containerComp) {
        final Canvas openIcon = new Canvas(containerComp, 0);
        openIcon.setBackground(SWTResourceManager.getColor((int)255, (int)255, (int)255));
        openIcon.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Color oldBackground = e.gc.getBackground();
                Rectangle bounds = openIcon.getBounds();
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setBackground(arrowColor);
                e.gc.setAntialias(1);
                int y = bounds.height / 2;
                int x = bounds.width / 2;
                int y1 = y - 2;
                int y2 = y + 2;
                int x3 = x;
                int x1 = x - 3;
                int x2 = x + 3;
                e.gc.fillPolygon(new int[]{x1, y1, x2, y1, x3, y2});
                e.gc.setAntialias(-1);
                e.gc.setBackground(ColorConstants.black);
                e.gc.drawLine(0, 0, bounds.width, 0);
                e.gc.drawLine(0, bounds.height - 1, bounds.width, bounds.height - 1);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height);
                e.gc.setBackground(oldBackground);
            }
        });
        openIcon.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TabbedPropertySearch.this.textArea.setText("");
                TabbedPropertySearch.this.updateAutocompleteContent();
                if (TabbedPropertySearch.this.autocomplete.isProposalOpened()) {
                    TabbedPropertySearch.this.autocomplete.closeProposalPopup();
                } else {
                    TabbedPropertySearch.this.autocomplete.openProposalPopup();
                }
            }
        });
    }

    private void updateAutocompleteContent() {
        if (this.autocomplete == null) {
            PropertiesContainer properties = this.getAllProperties();
            this.autocomplete = new ManualyOpenedAutocomplete((Control)this.textArea, (IControlContentAdapter)new TextContentAdapter(), properties);
            this.autocomplete.addProposalSelectedListener(this.proposalListener);
        } else {
            Object actualSelectedElement = this.getSelectedElement();
            if (this.lastSelectedElement == null || actualSelectedElement != null && !actualSelectedElement.getClass().equals(this.lastSelectedElement.getClass())) {
                PropertiesContainer properties = this.getAllProperties();
                this.autocomplete.setProposals(properties);
            }
        }
    }

    private PropertiesContainer getAllProperties() {
        if (this.lastSelectedElement == null || this.cachedProperties == null) {
            this.cachedProperties = this.createElements();
            this.lastSelectedElement = this.getSelectedElement();
        } else {
            Object actualSelectedElement = this.getSelectedElement();
            if (actualSelectedElement == null) {
                this.cachedProperties = new PropertiesContainer();
                this.lastSelectedElement = null;
            } else if (!actualSelectedElement.getClass().equals(this.lastSelectedElement.getClass())) {
                this.cachedProperties = this.createElements();
                this.lastSelectedElement = actualSelectedElement;
            }
        }
        this.textArea.setText("");
        return this.cachedProperties;
    }

    private Object getSelectedElement() {
        return this.page.getSelectedObject();
    }

    private PropertiesContainer createElements() {
        ArrayList<PropertyContainer> listToOrder = new ArrayList<PropertyContainer>();
        List<TabContents> lst = this.page.getCurrentTabs();
        for (TabContents actualContents : lst) {
            ISection[] iSectionArray = actualContents.getSections();
            int n = iSectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISection section = iSectionArray[n2];
                if (section instanceof IWidgetsProviderSection) {
                    IWidgetsProviderSection attributesSection = (IWidgetsProviderSection)((Object)section);
                    List<Object> providedProperties = attributesSection.getHandledProperties();
                    for (Object property : providedProperties) {
                        WidgetDescriptor desc = attributesSection.getPropertyInfo(property);
                        listToOrder.add(new PropertyContainer(desc.getName(), property, attributesSection.getClass()));
                    }
                }
                ++n2;
            }
        }
        Collections.sort(listToOrder);
        return new PropertiesContainer(listToOrder.toArray(new PropertyContainer[listToOrder.size()]));
    }

    private void checkSelection(Object id) {
        if (id != null) {
            TabbedPropertySearch.selectElement(id, this.page);
        }
    }

    public void dispose() {
        super.dispose();
        arrowColor.dispose();
    }

    public static void selectElement(Object id, TabbedPropertySheetPage page) {
        List<TabContents> lst = page.getCurrentTabs();
        for (TabContents actualContents : lst) {
            ISection[] iSectionArray = actualContents.getSections();
            int n = iSectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWidgetsProviderSection actualSection;
                ISection section = iSectionArray[n2];
                if (section instanceof IWidgetsProviderSection && (actualSection = (IWidgetsProviderSection)((Object)section)).getHandledProperties().contains(id)) {
                    page.setSelection(actualContents);
                    actualSection.expandForProperty(id);
                    IHighlightPropertyWidget widget = actualSection.getWidgetForProperty(id);
                    if (widget != null) {
                        Control highLightedControl = widget.getControlToBorder();
                        if (highLightedControl != null) {
                            highLightedControl.forceFocus();
                        }
                        widget.highLightWidget(2000L);
                    }
                    return;
                }
                ++n2;
            }
        }
    }

    private void selectElement(Object id, Class<?> sectionType) {
        if (sectionType == null) {
            this.checkSelection(id);
            return;
        }
        List<TabContents> lst = this.page.getCurrentTabs();
        for (TabContents actualContents : lst) {
            ISection[] iSectionArray = actualContents.getSections();
            int n = iSectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWidgetsProviderSection actualSection;
                ISection section = iSectionArray[n2];
                if (section instanceof IWidgetsProviderSection && (actualSection = (IWidgetsProviderSection)((Object)section)).getClass().equals(sectionType) && actualSection.getHandledProperties().contains(id)) {
                    this.page.setSelection(actualContents);
                    actualSection.expandForProperty(id);
                    IHighlightPropertyWidget widget = actualSection.getWidgetForProperty(id);
                    if (widget != null) {
                        widget.highLightWidget(2000L);
                    }
                    return;
                }
                ++n2;
            }
        }
    }

    public static Color getColor(String key) {
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        return currentTheme.getColorRegistry().get(key);
    }

    protected void drawTitleBackground(PaintEvent e) {
        if (this.factory.getColors() == null) {
            return;
        }
        Rectangle bounds = this.getClientArea();
        Color bg = this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color gbg = this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        Color themedColor = TabbedPropertySearch.getColor("org.eclipse.ui.workbench.INFORMATION_BACKGROUND");
        if (themedColor != null && themedColor.getRed() < 100 && themedColor.getGreen() < 100 && themedColor.getBlue() < 100) {
            bg = themedColor;
            gbg = TabbedPropertySearch.getColor("org.eclipse.ui.workbench.INFORMATION_FOREGROUND");
        }
        GC gc = e.gc;
        gc.setForeground(bg);
        gc.setBackground(gbg);
        gc.fillGradientRectangle(bounds.x, bounds.y, bounds.width, bounds.height, true);
        gc.setForeground(this.factory.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        gc.drawLine(bounds.x, bounds.height - 2, bounds.x + bounds.width - 1, bounds.height - 2);
        gc.setForeground(this.factory.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
        gc.drawLine(bounds.x, bounds.height - 1, bounds.x + bounds.width - 1, bounds.height - 1);
    }
}

