/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.internal;

import com.jaspersoft.studio.properties.internal.TabbedPropertyList;
import com.jaspersoft.studio.properties.view.ITabDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;

public class TabbedPropertyViewer
extends StructuredViewer {
    protected TabbedPropertyList list;
    protected List<ITabDescriptor> elements;
    protected IWorkbenchPart part;

    public TabbedPropertyViewer(TabbedPropertyList list) {
        this.list = list;
        this.hookControl((Control)list.getControl());
        this.elements = new ArrayList<ITabDescriptor>();
    }

    public ITabDescriptor getElementAt(int index) {
        if (index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.list.getSelectionIndex();
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List<ITabDescriptor> getSelectionFromWidget() {
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return Collections.emptyList();
        }
        ArrayList<ITabDescriptor> result = new ArrayList<ITabDescriptor>(1);
        result.add(this.getElementAt(index));
        return result;
    }

    protected void internalRefresh(Object element) {
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        if (l == null || l.size() == 0) {
            this.list.deselectAll();
        } else {
            Object object = l.get(0);
            int index = -1;
            int i = 0;
            while (i < this.elements.size()) {
                if (this.elements.get(i) == object) {
                    index = i;
                }
                ++i;
            }
            Assert.isTrue((index != -1 ? 1 : 0) != 0, (String)"Could not set the selected tab in the tabbed property viewer");
            this.list.select(index);
        }
    }

    public void setSelectionToWidget(String id, int defaultIndex) {
        if (this.elements.size() > 0) {
            int index = -1;
            int i = 0;
            while (i < this.elements.size()) {
                if (this.elements.get(i).getId().equals(id)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                index = defaultIndex;
            }
            Assert.isTrue((index >= 0 && index <= this.elements.size() ? 1 : 0) != 0, (String)"Could not set the selected tab in the tabbed property viewer");
            this.list.select(index);
        }
    }

    public void forceChangeSelectionToWidget(ITabDescriptor tab) {
        int index = -1;
        int i = 0;
        while (i < this.elements.size()) {
            if (this.elements.get(i).getId().equals(tab.getId())) {
                index = i;
            }
            ++i;
        }
        Assert.isTrue((index != -1 ? 1 : 0) != 0, (String)"Could not set the selected tab in the tabbed property viewer");
        this.list.select(index);
    }

    public Control getControl() {
        return this.list.getControl();
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.elements.clear();
        Object[] children = this.getSortedChildren(this.getRoot());
        this.list.removeAll();
        int i = 0;
        while (i < children.length) {
            this.elements.add((ITabDescriptor)children[i]);
            this.mapElement(children[i], (Widget)this.list.getControl());
            ++i;
        }
        this.list.setElements(children);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        this.part = part;
        this.setInput(selection);
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this.part;
    }

    public List<ITabDescriptor> getElements() {
        return this.elements;
    }

    protected void updateSelection(ISelection selection) {
        TabbedPropertyViewer.super.updateSelection(selection);
    }
}

