/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.layout;

import com.jaspersoft.studio.properties.Activator;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DynamicColumnLayout
extends Layout {
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    public int topMargin = 5;
    public int leftMargin = 5;
    public int bottomMargin = 5;
    public int rightMargin = 5;
    private TabbedPropertySheetPage page;
    public int landscapeColumnsSize = 350;
    protected boolean forceSingleColumn = false;

    public DynamicColumnLayout(TabbedPropertySheetPage page) {
        Assert.isNotNull((Object)((Object)page));
        this.page = page;
        final IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        this.forceSingleColumn = prefStore.getBoolean("com.jaspersoft.studio.properties.preferences.PropertiesPreferencePage.single_column");
        prefStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (DynamicColumnLayout.this.page.getTabbedPropertyComposite().isDisposed()) {
                    prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
                } else if (event.getProperty().equals("com.jaspersoft.studio.properties.preferences.PropertiesPreferencePage.single_column")) {
                    DynamicColumnLayout.this.forceSingleColumn = prefStore.getBoolean("com.jaspersoft.studio.properties.preferences.PropertiesPreferencePage.single_column");
                    DynamicColumnLayout.this.page.getTabbedPropertyComposite().layout(true, true);
                }
            }
        });
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return this.computeSize(composite, wHint, hHint);
    }

    private Point computeSize(Composite parent, int wHint, int hHint) {
        Control[] children = parent.getChildren();
        int cwidth = 0;
        int cheight = 0;
        Point[] sizes = new Point[children.length];
        int ncolumns = this.calculateColumnsNumber();
        int i = 0;
        while (i < children.length) {
            sizes[i] = this.computeControlSize(children[i], -1);
            cwidth = Math.max(cwidth, sizes[i].x);
            cheight += sizes[i].y;
            ++i;
        }
        int perColHeight = this.computeColumnHeight(ncolumns, sizes, cheight, this.verticalSpacing);
        int colHeight = 0;
        int[] heights = new int[ncolumns];
        int ncol = 0;
        boolean fillIn = false;
        int i2 = 0;
        while (i2 < sizes.length) {
            int childHeight = sizes[i2].y;
            if (i2 > 0 && colHeight + childHeight > perColHeight) {
                heights[ncol] = colHeight;
                if (++ncol == ncolumns || fillIn) {
                    fillIn = true;
                    ncol = this.findShortestColumn(heights);
                }
                colHeight = heights[ncol];
            }
            if (colHeight > 0) {
                colHeight += this.verticalSpacing;
            }
            colHeight += childHeight;
            ++i2;
        }
        heights[ncol] = Math.max(heights[ncol], colHeight);
        Point size = new Point(0, 0);
        int i3 = 0;
        while (i3 < ncolumns) {
            size.y = Math.max(size.y, heights[i3]);
            ++i3;
        }
        size.x = cwidth * ncolumns + (ncolumns - 1) * this.horizontalSpacing;
        size.x += this.leftMargin + this.rightMargin;
        size.y += this.topMargin + this.bottomMargin;
        return size;
    }

    private Point computeControlSize(Control c, int suggestedWidth) {
        return c.computeSize(suggestedWidth, -1);
    }

    private int findShortestColumn(int[] heights) {
        int result = 0;
        int height = Integer.MAX_VALUE;
        int i = 0;
        while (i < heights.length) {
            if (height > heights[i]) {
                height = heights[i];
                result = i;
            }
            ++i;
        }
        return result;
    }

    protected int calculateColumnsNumber() {
        if (this.forceSingleColumn) {
            return 1;
        }
        Rectangle layoutArea = this.page.getTabbedPropertyComposite().getPropertiesArea();
        if (layoutArea.height >= layoutArea.width || layoutArea.width < this.landscapeColumnsSize) {
            return 1;
        }
        return layoutArea.width / this.landscapeColumnsSize;
    }

    protected void layout(Composite parent, boolean flushCache) {
        Control[] children = parent.getChildren();
        Rectangle carea = parent.getClientArea();
        int cwidth = 0;
        int cheight = 0;
        Point[] sizes = new Point[children.length];
        int ncolumns = this.calculateColumnsNumber();
        int i = 0;
        while (i < children.length) {
            sizes[i] = this.computeControlSize(children[i], -1);
            cwidth = Math.max(cwidth, sizes[i].x);
            cheight += sizes[i].y;
            ++i;
        }
        int realWidth = (carea.width - this.leftMargin - this.rightMargin + this.horizontalSpacing) / ncolumns - this.horizontalSpacing;
        int fillWidth = Math.max(cwidth, realWidth);
        int perColHeight = this.computeColumnHeight(ncolumns, sizes, cheight, this.verticalSpacing);
        int colHeight = 0;
        int[] heights = new int[ncolumns];
        int ncol = 0;
        int x = this.leftMargin;
        boolean fillIn = false;
        int i2 = 0;
        while (i2 < sizes.length) {
            Control child = children[i2];
            Point csize = sizes[i2];
            int childWidth = fillWidth;
            if (i2 > 0 && colHeight + csize.y > perColHeight) {
                heights[ncol] = colHeight;
                if (fillIn || ncol == ncolumns - 1) {
                    fillIn = true;
                    ncol = this.findShortestColumn(heights);
                    x = this.leftMargin + ncol * (fillWidth + this.horizontalSpacing);
                } else {
                    ++ncol;
                    x += fillWidth + this.horizontalSpacing;
                }
                colHeight = heights[ncol];
            }
            if (colHeight > 0) {
                colHeight += this.verticalSpacing;
            }
            child.setBounds(x, this.topMargin + colHeight, childWidth, csize.y);
            colHeight += csize.y;
            ++i2;
        }
    }

    private int computeColumnHeight(int ncolumns, Point[] sizes, int totalHeight, int verticalMargin) {
        int averageHeight = (totalHeight + sizes.length * verticalMargin) / ncolumns;
        int requiredHeight = DynamicColumnLayout.computeActualHeight(ncolumns, sizes, averageHeight, verticalMargin);
        if (averageHeight == requiredHeight) {
            return requiredHeight;
        }
        int i = 0;
        while (i < 10) {
            int candidateHeight = DynamicColumnLayout.computeActualHeight(ncolumns, sizes, requiredHeight - 1, verticalMargin);
            if (candidateHeight >= requiredHeight) {
                return requiredHeight;
            }
            requiredHeight = candidateHeight;
            ++i;
        }
        return requiredHeight;
    }

    private static int computeActualHeight(int ncolumns, Point[] sizes, int candidateHeight, int verticalMargin) {
        int colHeight = 0;
        int maxHeight = 0;
        int column = 1;
        int i = 0;
        while (i < sizes.length) {
            int childHeight = sizes[i].y;
            if (i > 0 && column < ncolumns && colHeight + childHeight + verticalMargin > candidateHeight) {
                maxHeight = Math.max(colHeight, maxHeight);
                ++column;
                colHeight = 0;
            }
            if (colHeight > 0) {
                colHeight += verticalMargin;
            }
            colHeight += childHeight;
            ++i;
        }
        maxHeight = Math.max(colHeight, maxHeight);
        return maxHeight;
    }
}

