/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.view;

import com.jaspersoft.studio.properties.Activator;
import com.jaspersoft.studio.properties.view.ISection;
import com.jaspersoft.studio.properties.view.ISectionDescriptor;
import com.jaspersoft.studio.properties.view.ITabDescriptor;
import com.jaspersoft.studio.properties.view.TabContents;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class AbstractTabDescriptor
implements ITabDescriptor,
Cloneable {
    private List<ISectionDescriptor> sectionDescriptors = new ArrayList<ISectionDescriptor>(5);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            Status status = new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 666, exception.getMessage(), (Throwable)exception);
            Activator.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    @Override
    public TabContents createTab() {
        ArrayList<ISection> sections = new ArrayList<ISection>(this.getSectionDescriptors().size());
        for (ISectionDescriptor descriptor : this.getSectionDescriptors()) {
            ISection section = descriptor.getSectionClass();
            sections.add(section);
        }
        TabContents tab = new TabContents();
        tab.setSections(sections.toArray(new ISection[sections.size()]));
        return tab;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() == object.getClass()) {
            AbstractTabDescriptor descriptor = (AbstractTabDescriptor)object;
            if (this.getCategory().equals(descriptor.getCategory()) && this.getId().equals(descriptor.getId()) && this.getSectionDescriptors().size() == descriptor.getSectionDescriptors().size()) {
                Iterator<ISectionDescriptor> i = this.getSectionDescriptors().iterator();
                Iterator<ISectionDescriptor> j = descriptor.getSectionDescriptors().iterator();
                while (i.hasNext()) {
                    ISectionDescriptor source = i.next();
                    ISectionDescriptor target = j.next();
                    if (source.getId().equals(target.getId())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String getAfterTab() {
        return "top";
    }

    @Override
    public ImageDescriptor getImage() {
        return null;
    }

    @Override
    public List<ISectionDescriptor> getSectionDescriptors() {
        return this.sectionDescriptors;
    }

    @Override
    public String getText() {
        return this.getLabel();
    }

    public int hashCode() {
        int hashCode = this.getCategory().hashCode();
        hashCode ^= this.getId().hashCode();
        for (ISectionDescriptor section : this.getSectionDescriptors()) {
            hashCode ^= section.getId().hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean isIndented() {
        return false;
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    public void setSectionDescriptors(List<ISectionDescriptor> sectionDescriptors) {
        this.sectionDescriptors = sectionDescriptors;
    }
}

