/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyExtentOperation;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyExtentSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class DependencyExtentQuery
implements ISearchQuery {
    private ISearchResult fSearchResult;
    private IProject fProject;
    private String fImportID;

    public DependencyExtentQuery(IProject project, String importID) {
        this.fProject = project;
        this.fImportID = importID;
    }

    public IStatus run(IProgressMonitor monitor) {
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.getSearchResult();
        result.removeAll();
        DependencyExtentOperation op = new DependencyExtentOperation(this.fProject, this.fImportID, (ISearchResult)result);
        op.execute(monitor);
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return PDEUIMessages.DependencyExtentQuery_label + " " + this.fImportID;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fSearchResult == null) {
            this.fSearchResult = new DependencyExtentSearchResult(this);
        }
        return this.fSearchResult;
    }

    public IPackageFragmentRoot[] getDirectRoots() {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        try {
            IPackageFragmentRoot[] roots = JavaCore.create((IProject)this.fProject).getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1 || roots[i].isArchive() && !roots[i].isExternal()) {
                    result.add(roots[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }
}

