/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.creation;

import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CompileDialog
extends PersistentLocationDialog {
    private StyledText textArea;
    private Process process;
    private List<String> messageQueue = new ArrayList<String>();
    private boolean compilationEnded = false;
    private Runnable readProcessOutputThread = new Runnable(){

        @Override
        public void run() {
            String newLine = System.getProperty("line.separator");
            CompileDialog.this.pushMessage(String.valueOf(Messages.CompileDialog_startCompilation) + newLine);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(CompileDialog.this.process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(CompileDialog.this.process.getErrorStream()));
            String s = null;
            try {
                while ((s = stdInput.readLine()) != null) {
                    CompileDialog.this.pushMessage(String.valueOf(s) + newLine);
                }
            }
            catch (Exception ex) {
                CompileDialog.this.pushMessage(ex.getMessage());
            }
            try {
                while ((s = stdError.readLine()) != null) {
                    CompileDialog.this.pushMessage(String.valueOf(s) + newLine);
                }
            }
            catch (Exception ex) {
                CompileDialog.this.pushMessage(ex.getMessage());
            }
            CompileDialog.this.pushMessage(Messages.CompileDialog_endCompilation);
            CompileDialog.this.compilationEnded = true;
        }
    };
    private Runnable checkForMessages = new Runnable(){

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };

    public CompileDialog(Shell parentShell, Process process) {
        super(parentShell);
        this.process = process;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CompileDialog_dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.textArea = new StyledText(container, 2824);
        this.textArea.setBackground(container.getBackground());
        this.textArea.setEditable(false);
        GridData textData = new GridData(1808);
        textData.widthHint = 500;
        textData.heightHint = 200;
        this.textArea.setLayoutData((Object)textData);
        return container;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        new Thread(this.readProcessOutputThread).start();
        new Thread(this.checkForMessages).start();
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.getButton(0).setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushMessage(String message) {
        List<String> list = this.messageQueue;
        synchronized (list) {
            this.messageQueue.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String popMessage() {
        List<String> list = this.messageQueue;
        synchronized (list) {
            if (this.messageQueue.size() > 0) {
                return this.messageQueue.remove(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMessages() {
        List<String> list = this.messageQueue;
        synchronized (list) {
            return !this.messageQueue.isEmpty();
        }
    }
}

