/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.creation;

import com.ibm.icu.text.MessageFormat;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import com.jaspersoft.studio.preferences.util.PreferencesUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleExecuter {
    private static final String MINIMUM_JAVA_VERSION = "1.7";
    public static final String BUILD_FILE_NAME = "build.js";
    private static final String CONSOLE_NAME = "Custom Visualization Component Console";
    private List<IFile> filesToCompile;
    private String[] command;
    private Job readOutputJob = new Job("Compiling job"){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean checkJavaVersion(MessageConsoleStream outputStream, IProgressMonitor monitor) {
            String javaCommand = ConsoleExecuter.this.getJavaCommand();
            String[] checkVersionCommand = new String[]{javaCommand, "-version"};
            try {
                Process process = Runtime.getRuntime().exec(checkVersionCommand);
                outputStream.println(Messages.ConsoleExecuter_checkVersionStart);
                outputStream.println(String.valueOf(javaCommand) + " -version");
                BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String s = null;
                boolean versionFound = false;
                try {
                    while (true) {
                        int end;
                        if ((s = stdError.readLine()) == null) {
                            if (versionFound) return false;
                            outputStream.println("Unable to discover your java version");
                            return false;
                        }
                        String line = s.toLowerCase().trim();
                        if (!line.startsWith("java version") && !line.startsWith("openjdk version")) continue;
                        versionFound = true;
                        int start = line.indexOf("\"") + 1;
                        String version = line.substring(start, end = line.lastIndexOf("\"")).replaceAll("_", ".");
                        if (this.versionCompare(version, ConsoleExecuter.MINIMUM_JAVA_VERSION) >= 0) {
                            outputStream.println(Messages.ConsoleExecuter_checkSuccess);
                            return true;
                        }
                        outputStream.println(MessageFormat.format((String)Messages.ConsoleExecuter_checkWrongVersion1, (Object[])new Object[]{version}));
                        outputStream.println(Messages.ConsoleExecuter_checkWrongVersion2);
                        outputStream.println(MessageFormat.format((String)Messages.ConsoleExecuter_checkWrongVersion3, (Object[])new Object[]{"com.jaspersoft.studio.components.customvisualization.javapath"}));
                    }
                }
                catch (Exception ex) {
                    outputStream.println(ex.getMessage());
                    return false;
                }
            }
            catch (IOException e) {
                outputStream.println(MessageFormat.format((String)Messages.ConsoleExecuter_checkBadCommand1, (Object[])new Object[]{String.valueOf(javaCommand) + " -version"}));
                String aaa = Messages.ConsoleExecuter_checkBadCommand2;
                outputStream.println(MessageFormat.format((String)aaa, (Object[])new Object[]{"com.jaspersoft.studio.components.customvisualization.javapath"}));
                e.printStackTrace();
            }
            return false;
        }

        private String[] versionPadding(String[] currentNumber, int newSize) {
            Assert.isTrue((currentNumber.length < newSize ? 1 : 0) != 0);
            String[] equalLenghtVals2 = new String[newSize];
            int i = 0;
            while (i < newSize) {
                equalLenghtVals2[i] = i < currentNumber.length ? currentNumber[i] : "0";
                ++i;
            }
            return equalLenghtVals2;
        }

        public Integer versionCompare(String str1, String str2) {
            String[] vals1 = str1.split("\\.");
            String[] vals2 = str2.split("\\.");
            if (vals2.length < vals1.length) {
                vals2 = this.versionPadding(vals2, vals1.length);
            } else if (vals2.length > vals1.length) {
                vals1 = this.versionPadding(vals1, vals2.length);
            }
            int i = 0;
            while (i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i])) {
                ++i;
            }
            if (i < vals1.length && i < vals2.length) {
                int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
                return Integer.signum(diff);
            }
            return Integer.signum(vals1.length - vals2.length);
        }

        protected IStatus run(IProgressMonitor monitor) {
            MessageConsole console = ConsoleExecuter.this.getCleanConsole();
            MessageConsoleStream outputStream = console.newMessageStream();
            for (IFile fileToCompile : ConsoleExecuter.this.filesToCompile) {
                block13: {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!fileToCompile.exists()) break block13;
                    try {
                        block14: {
                            File oldFile;
                            monitor.beginTask("Compiling " + fileToCompile.getName(), 10);
                            if (!this.checkJavaVersion(outputStream, monitor)) break block14;
                            File projectFolder = fileToCompile.getParent().getLocation().toFile();
                            String filename = ConsoleExecuter.this.getOutputFilename(projectFolder);
                            if (filename != null && (oldFile = new File(projectFolder, filename)).exists() && oldFile.delete()) {
                                fileToCompile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                            }
                            Process process = Runtime.getRuntime().exec(ConsoleExecuter.this.command, null, projectFolder);
                            outputStream.println(Messages.CompileDialog_startCompilation);
                            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            String s = null;
                            int work = 0;
                            try {
                                while ((s = stdInput.readLine()) != null) {
                                    outputStream.println(s);
                                    monitor.worked(++work);
                                }
                            }
                            catch (Exception ex) {
                                outputStream.println(ex.getMessage());
                            }
                            try {
                                while ((s = stdError.readLine()) != null) {
                                    outputStream.println(s);
                                    monitor.worked(++work);
                                }
                            }
                            catch (Exception ex) {
                                outputStream.println(ex.getMessage());
                            }
                            outputStream.println(Messages.CompileDialog_endCompilation);
                            fileToCompile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        }
                        monitor.done();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        outputStream.println(ex.getMessage());
                    }
                    continue;
                }
                outputStream.println(Messages.BuildComponentHandler_errorMessage);
            }
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    };

    private IWorkbenchPage getActivePage() {
        IWorkbench w = PlatformUI.getWorkbench();
        IWorkbenchWindow aww = w.getActiveWorkbenchWindow();
        if (aww == null && w.getWorkbenchWindowCount() > 0) {
            aww = w.getWorkbenchWindows()[0];
            return aww.getActivePage();
        }
        return null;
    }

    private String getOutputFilename(File projectFolder) {
        BufferedReader br = null;
        String result = null;
        try {
            String sCurrentLine;
            br = new BufferedReader(new FileReader(new File(projectFolder, BUILD_FILE_NAME)));
            while ((sCurrentLine = br.readLine()) != null && result == null) {
                int secondQuote;
                String trimmed = sCurrentLine.trim();
                if (!trimmed.toLowerCase().startsWith("out:")) continue;
                String fileName = trimmed.substring(4);
                int firstQuote = fileName.indexOf("\"");
                if (firstQuote != -1 && (secondQuote = fileName.indexOf("\"", firstQuote + 1)) != -1) {
                    result = fileName.substring(firstQuote + 1, secondQuote);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {}
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private String getJavaCommand() {
        String javaPath = PreferencesUtils.getJasperReportsProperty((String)"com.jaspersoft.studio.components.customvisualization.javapath");
        if (javaPath != null && !javaPath.trim().isEmpty()) {
            if (!javaPath.endsWith(File.pathSeparator)) {
                javaPath = String.valueOf(javaPath) + File.separator;
            }
            return String.valueOf(javaPath) + "java";
        }
        boolean isRCP = JaspersoftStudioPlugin.isRCP();
        if (isRCP && (javaPath = System.getProperties().getProperty("java.home")) != null && !javaPath.trim().isEmpty()) {
            javaPath = String.valueOf(javaPath) + File.separator + "bin" + File.separator + "java";
            return javaPath;
        }
        return "java";
    }

    public ConsoleExecuter(List<IFile> filesToCompile) {
        this.filesToCompile = filesToCompile;
        File compiler = this.fetchResource("com/jaspersoft/studio/components/customvisualization/creation/resources/compiler.jar", "compiler.jar");
        File rhino = this.fetchResource("com/jaspersoft/studio/components/customvisualization/creation/resources/js.jar", "js.jar");
        File rJs = this.fetchResource("com/jaspersoft/studio/components/customvisualization/creation/resources/r.js", "r.js");
        this.command = new String[]{this.getJavaCommand(), "-classpath", String.valueOf(rhino.toString()) + File.pathSeparator + compiler.toString(), "org.mozilla.javascript.tools.shell.Main", rJs.toString(), "-o", BUILD_FILE_NAME};
        this.readOutputJob.setPriority(20);
        this.readOutputJob.schedule();
    }

    private MessageConsole getCleanConsole() {
        final MessageConsole myConsole = ConsoleExecuter.findConsole(CONSOLE_NAME);
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String id = "org.eclipse.ui.console.ConsoleView";
                    IWorkbenchPage activePage = ConsoleExecuter.this.getActivePage();
                    if (activePage != null) {
                        IConsoleView view = (IConsoleView)activePage.showView(id);
                        view.display((IConsole)myConsole);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        myConsole.clearConsole();
        return myConsole;
    }

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private File fetchResource(String path, String fileName) {
        try {
            URL url = this.getClass().getClassLoader().getResource(path);
            InputStream is = url.openStream();
            String tempDir = System.getProperty("java.io.tmpdir");
            File tempFile = new File(tempDir, fileName);
            if (!tempFile.exists()) {
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = is.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, read);
                }
                outputStream.close();
            }
            return tempFile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

