/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.creation.wizard;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.customvisualization.CustomVisualizationActivator;
import com.jaspersoft.studio.components.customvisualization.creation.ModuleDefinition;
import com.jaspersoft.studio.components.customvisualization.creation.ModuleManager;
import com.jaspersoft.studio.components.customvisualization.creation.VelocityLibrary;
import com.jaspersoft.studio.components.customvisualization.creation.VelocityShimLibrary;
import com.jaspersoft.studio.components.customvisualization.creation.wizard.CustomVisualizationComponentLicensePage;
import com.jaspersoft.studio.components.customvisualization.creation.wizard.CustomVisualizationComponentListPage;
import com.jaspersoft.studio.components.customvisualization.creation.wizard.CustomVisualizationComponentSummaryPage;
import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import com.jaspersoft.studio.components.customvisualization.ui.ComponentDescriptor;
import com.jaspersoft.studio.components.customvisualization.ui.ComponentPropertyDescriptor;
import com.jaspersoft.studio.components.customvisualization.ui.ComponentSectionDescriptor;
import com.jaspersoft.studio.utils.VelocityUtils;
import com.jaspersoft.studio.wizards.JSSWizard;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CustomVisualizationComponentWizard
extends JSSWizard
implements INewWizard {
    protected static final String SELECTED_MODULE_KEY = "selectedModule";
    private VelocityEngine ve = VelocityUtils.getConfiguredVelocityEngine();
    private static final String BUILD_FILE = "com/jaspersoft/studio/components/customvisualization/creation/resources/build.vm";
    private CustomVisualizationComponentListPage page0;
    private CustomVisualizationComponentSummaryPage page1;
    private CustomVisualizationComponentLicensePage page2;

    public CustomVisualizationComponentWizard() {
        this.setWindowTitle(Messages.CustomVisualizationComponentWizard_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.page0 = new CustomVisualizationComponentListPage();
        this.addPage((IWizardPage)this.page0);
        this.page1 = new CustomVisualizationComponentSummaryPage();
        this.addPage((IWizardPage)this.page1);
        this.page2 = new CustomVisualizationComponentLicensePage();
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        final String projectName = this.page0.getProjectName();
        final ModuleDefinition selected = this.page0.getSelectedModule();
        final String mName = this.page0.getModule();
        final String oldModule = selected.getModuleName();
        try {
            selected.setModuleName(mName);
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block10: {
                        monitor.beginTask("Creating CVC Component Project", -1);
                        try {
                            boolean result = CustomVisualizationComponentWizard.this.createProject(projectName, monitor);
                            if (!result) break block10;
                            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                            IProject project = root.getProject(projectName);
                            File dest = new File(root.getRawLocation().toFile(), projectName);
                            ArrayList<VelocityLibrary> libraries = new ArrayList<VelocityLibrary>();
                            ArrayList<VelocityShimLibrary> shimLibraries = new ArrayList<VelocityShimLibrary>();
                            try {
                                String outputScriptName = String.valueOf(projectName) + ".min.js";
                                CustomVisualizationComponentWizard.this.addModule(selected, shimLibraries, libraries, dest);
                                for (ModuleDefinition requiredLibrary : selected.getRequiredLibraries()) {
                                    CustomVisualizationComponentWizard.this.addModule(requiredLibrary, shimLibraries, libraries, dest);
                                }
                                String cssFileName = CustomVisualizationComponentWizard.this.generateCSS(project, monitor, selected);
                                String renderFileName = CustomVisualizationComponentWizard.this.generateRender(project, monitor, selected);
                                libraries.add(new VelocityLibrary(mName, CustomVisualizationComponentWizard.this.removeJsExtension(renderFileName)));
                                String buildFile = CustomVisualizationComponentWizard.this.generateBuildFile(libraries, shimLibraries, mName, outputScriptName);
                                CustomVisualizationComponentWizard.createFile("build.js", (IContainer)project, buildFile, monitor);
                                try {
                                    CustomVisualizationComponentWizard.this.createUIFiles(monitor, project, mName, cssFileName, selected.getLibraryURL());
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                CustomVisualizationComponentWizard.this.createSample(selected, outputScriptName, cssFileName, project, monitor);
                                try {
                                    project.refreshLocal(2, monitor);
                                    project.build(6, monitor);
                                    project.refreshLocal(2, monitor);
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (FileNotFoundException ex) {
                                UIUtils.getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageDialog.openError((Shell)UIUtils.getShell(), (String)Messages.CustomVisualizationComponentWizard_errorTitle, (String)ex.getMessage());
                                    }
                                });
                            }
                        }
                        finally {
                            monitor.done();
                            selected.setModuleName(oldModule);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e);
        }
        return true;
    }

    protected void createUIFiles(IProgressMonitor monitor, IProject project, String mName, String cssFName, String jsFName) throws IOException {
        if (this.page0.isCreateUI()) {
            String uiIconPath = this.page0.getUiIconPath();
            String thName = null;
            if (Misc.isNullOrEmpty((String)uiIconPath)) {
                URL img = CustomVisualizationActivator.getDefault().getBundle().getResource("icons/blank_a4.png");
                thName = FilenameUtils.getName((String)img.toString());
                CustomVisualizationComponentWizard.createFile(thName, (IContainer)project, img.openStream(), monitor);
            } else {
                File f = new File(uiIconPath);
                thName = f.getName();
                CustomVisualizationComponentWizard.createFile(thName, (IContainer)project, f.toURI().toURL().openStream(), monitor);
            }
            ComponentDescriptor cd = new ComponentDescriptor();
            cd.setLabel(this.page0.getUiLabel());
            cd.setDescription(this.page0.getUiDescription());
            cd.setThumbnail(thName);
            cd.setModule(mName);
            ArrayList<ComponentSectionDescriptor> sections = new ArrayList<ComponentSectionDescriptor>();
            ComponentSectionDescriptor csd = new ComponentSectionDescriptor();
            csd.setExpandable(false);
            csd.setName("Script");
            ArrayList<ComponentPropertyDescriptor> props = new ArrayList<ComponentPropertyDescriptor>();
            ComponentPropertyDescriptor cpd = new ComponentPropertyDescriptor();
            cpd.setType("TEXT");
            cpd.setName("module");
            cpd.setLabel("Module");
            cpd.setDescription("Module name");
            cpd.setDefaultValue(mName);
            cpd.setReadOnly(true);
            cpd.setMandatory(true);
            props.add(cpd);
            if (cssFName != null) {
                cpd = new ComponentPropertyDescriptor();
                cpd.setType("PATH");
                cpd.setName("css");
                cpd.setLabel("CSS Path");
                cpd.setDescription("CSS Path");
                cpd.setDefaultValue(cssFName);
                cpd.setReadOnly(false);
                cpd.setMandatory(true);
                props.add(cpd);
            }
            cpd = new ComponentPropertyDescriptor();
            cpd.setType("PATH");
            cpd.setName("script");
            cpd.setLabel("Script Path");
            cpd.setDescription("Script path");
            cpd.setDefaultValue(new File(jsFName).getName());
            cpd.setReadOnly(false);
            cpd.setMandatory(true);
            props.add(cpd);
            csd.setProperties(props);
            sections.add(csd);
            cd.setSections(sections);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            CustomVisualizationComponentWizard.createFile(String.valueOf(mName) + ".json", (IContainer)project, mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)cd), monitor);
        }
    }

    private void createSample(ModuleDefinition selectedModule, String scriptName, String cssName, IProject project, IProgressMonitor monitor) {
        if (!selectedModule.getSampleResources().isEmpty()) {
            try {
                if (!ProjectUtil.hasJRNature((IProgressMonitor)monitor, (IProject)project)) {
                    ProjectUtil.createJRProject((IProgressMonitor)monitor, (IProject)project);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (String resourcePath : selectedModule.getSampleResources()) {
                InputStream resource = selectedModule.getResource(resourcePath);
                if (resource == null) continue;
                String resourceName = this.getResourceName(resourcePath);
                if (resourceName.toLowerCase().endsWith(".jrxml")) {
                    String jrxmlContent = this.generateJRXML(resourcePath, scriptName, cssName, selectedModule.getModuleName());
                    CustomVisualizationComponentWizard.createFile(String.valueOf(selectedModule.getModuleName()) + "_sample.jrxml", (IContainer)project, jrxmlContent, monitor);
                    continue;
                }
                CustomVisualizationComponentWizard.createFile(resourceName, (IContainer)project, resource, monitor);
            }
        }
    }

    private String generateJRXML(String jrxmlPath, String scriptName, String cssName, String moduleName) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("scriptname", (Object)scriptName);
        functionContext.put("cssname", (Object)cssName);
        functionContext.put("modulename", (Object)moduleName);
        Template functionTemplate = this.ve.getTemplate(jrxmlPath);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    private String getResourceName(String resourcePath) {
        int slash = resourcePath.lastIndexOf("/");
        if (slash == -1) {
            return resourcePath;
        }
        return resourcePath.substring(slash + 1);
    }

    private String removeJsExtension(String source) {
        if (source.toLowerCase().endsWith(".js")) {
            return source.substring(0, source.length() - 3);
        }
        return source;
    }

    private void addModule(ModuleDefinition module, List<VelocityShimLibrary> shimmedList, List<VelocityLibrary> librariesList, File projectFolder) throws FileNotFoundException {
        String fileName = module.getLibraryFilename();
        if (fileName != null) {
            File resourceFile = ModuleManager.getLibraryFile(module);
            if (resourceFile != null && resourceFile.exists()) {
                File workspaceCopy = new File(projectFolder, fileName);
                try {
                    FileUtils.copyFile((File)resourceFile, (File)workspaceCopy);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                librariesList.add(new VelocityLibrary(module.getVariableName(), this.removeJsExtension(fileName)));
                if (module.isNeedShim()) {
                    String dependencies = "";
                    int i = 0;
                    while (i < module.getShimDependencies().size()) {
                        dependencies = String.valueOf(dependencies) + "'" + module.getShimDependencies().get(i) + "'";
                        if (i < module.getShimDependencies().size() - 1) {
                            dependencies = String.valueOf(dependencies) + ",";
                        }
                        ++i;
                    }
                    VelocityShimLibrary shimLibrary = new VelocityShimLibrary(module.getVariableName(), module.getShimExportName(), dependencies);
                    shimmedList.add(shimLibrary);
                }
            } else {
                String errorMessage = MessageFormat.format(Messages.CustomVisualizationComponentWizard_errorDescription, module.getLibraryURL());
                throw new FileNotFoundException(errorMessage);
            }
        }
    }

    private String generateCSS(IProject container, IProgressMonitor monitor, ModuleDefinition module) {
        String cssContent = module.getCssResource();
        if (cssContent != null) {
            String cssName = String.valueOf(container.getName()) + ".css";
            CustomVisualizationComponentWizard.createFile(cssName, (IContainer)container, cssContent, monitor);
            return cssName;
        }
        return null;
    }

    private String generateRender(IProject container, IProgressMonitor monitor, ModuleDefinition library) {
        String renderContentPath = library.getRenderResourcePath();
        if (renderContentPath != null) {
            String mergedTemplate = this.generateJsResource(renderContentPath, library.getModuleName());
            String renderFileName = String.valueOf(container.getName()) + ".js";
            CustomVisualizationComponentWizard.createFile(renderFileName, (IContainer)container, mergedTemplate, monitor);
            return renderFileName;
        }
        return null;
    }

    private String generateJsResource(String contentPath, String moduleName) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("modulename", (Object)moduleName);
        StringWriter fsw = new StringWriter();
        VelocityEngine ve = VelocityUtils.getConfiguredVelocityEngine();
        Template t = ve.getTemplate(contentPath);
        t.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    private String generateBuildFile(List<VelocityLibrary> libraries, List<VelocityShimLibrary> shimLibraries, String moduleName, String outputName) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("libraries", libraries);
        functionContext.put("hasShim", (Object)(shimLibraries.size() > 0 ? 1 : 0));
        functionContext.put("shimlibraries", shimLibraries);
        functionContext.put("modulename", (Object)moduleName);
        functionContext.put("outputname", (Object)outputName);
        Template functionTemplate = this.ve.getTemplate(BUILD_FILE);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    protected static IFile createFile(String name, IContainer container, String content, IProgressMonitor progressMonitor) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(container.getDefaultCharset(true)));
            return CustomVisualizationComponentWizard.createFile(name, container, stream, progressMonitor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static IFile createFile(String name, IContainer container, InputStream stream, IProgressMonitor progressMonitor) {
        IFile file = container.getFile((IPath)new Path(name));
        try {
            if (file.exists()) {
                file.setContents(stream, true, true, progressMonitor);
            } else {
                file.create(stream, true, progressMonitor);
            }
            stream.close();
        }
        catch (Exception e) {
            JaspersoftStudioPlugin.getInstance().logError((Throwable)e);
        }
        progressMonitor.worked(1);
        return file;
    }

    private boolean createProject(String projectName, IProgressMonitor monitor) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            if (!project.exists()) {
                project.create(monitor);
                project.open(monitor);
                ProjectUtil.addNature((IProject)project, (String)"com.jasspersoft.studio.cvc.nature", (IProgressMonitor)monitor);
                project.refreshLocal(2, monitor);
                IProjectDescription description = project.getDescription();
                description.setName(Messages.CustomVisualizationComponentWizard_projectDescription);
                project.setDescription(description, monitor);
                return true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean canFinish() {
        if (!this.page0.hasLibraryPage()) {
            return this.page0.isPageComplete();
        }
        return super.canFinish();
    }
}

