/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.properties;

import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import com.jaspersoft.studio.components.customvisualization.properties.CVItemDialog;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.jface.dialogs.EditableDatasetBaseComposite;
import com.jaspersoft.studio.model.dataset.ComponentElementDatasetAdapter;
import com.jaspersoft.studio.model.dataset.ComponentElementDatasetRunAdapter;
import com.jaspersoft.studio.model.dataset.IEditableDataset;
import com.jaspersoft.studio.model.dataset.IEditableDatasetRun;
import com.jaspersoft.studio.property.dataset.DatasetRunSelectionListener;
import com.jaspersoft.studio.swt.widgets.NumberedLabelProvider;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class CVItemDataDialog
extends PersistentLocationDialog {
    private TabFolder tabfolder;
    private JRDesignElementDataset dataset;
    private JasperReportsConfiguration jconfig;
    private ExpressionContext defaultExpressionContext;
    private StandardItemData itemData;
    private EditableDatasetBaseComposite compositeDatasetInfo;
    private Button useDatasetBtn;
    private TableViewer itemsTV;
    private NumberedLabelProvider lblProv;
    private Button btnAddItem;
    private Button btnModifyItem;
    private Button btnRemoveItem;

    public CVItemDataDialog(Shell parentShell, ItemData itemData, JasperReportsConfiguration jconfig) {
        super(parentShell);
        this.itemData = (StandardItemData)itemData;
        if (this.itemData == null) {
            this.itemData = new StandardItemData();
        }
        this.dataset = (JRDesignElementDataset)this.itemData.getDataset();
        if (this.dataset == null) {
            this.dataset = new JRDesignElementDataset();
        }
        this.jconfig = jconfig;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.tabfolder = new TabFolder(container, 0);
        GridData tabfolderGD = new GridData(4, 4, true, true);
        tabfolderGD.heightHint = 150;
        this.tabfolder.setLayoutData((Object)tabfolderGD);
        this.createDatasetTab(this.tabfolder);
        this.createElementsTab(this.tabfolder);
        return container;
    }

    private void createDatasetTab(TabFolder parentTFolder) {
        TabItem datasetTab = new TabItem(parentTFolder, 0);
        Composite container = new Composite((Composite)parentTFolder, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        datasetTab.setControl((Control)container);
        datasetTab.setText(Messages.CVItemDataDialog_DatasetTab);
        this.useDatasetBtn = new Button(container, 32);
        this.useDatasetBtn.setText(Messages.CVItemDataDialog_UseDatasetBtn);
        this.useDatasetBtn.setLayoutData((Object)new GridData(4, 4, true, false));
        this.useDatasetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVItemDataDialog.this.toggleDatasetUsage(CVItemDataDialog.this.useDatasetBtn.getSelection());
            }
        });
        this.compositeDatasetInfo = new EditableDatasetBaseComposite((IEditableDataset)new ComponentElementDatasetAdapter(this.dataset, this.jconfig), container, 0){

            protected IEditableDatasetRun getEditableDatesetRun() {
                return new ComponentElementDatasetRunAdapter(this.getEditableDataset());
            }
        };
        this.compositeDatasetInfo.addDatasetRunSelectionListener(new DatasetRunSelectionListener(){

            public void selectionChanged() {
                ExpressionContext contextFromDSRun = CVItemDataDialog.this.getExpressionContextFromDSRun();
                CVItemDataDialog.this.compositeDatasetInfo.setExpressionContext(contextFromDSRun);
            }
        });
        this.compositeDatasetInfo.setExpressionContext(this.getExpressionContextFromDSRun());
        this.compositeDatasetInfo.setDefaultExpressionContext(this.defaultExpressionContext);
        this.compositeDatasetInfo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.useDatasetBtn.setSelection(this.itemData.getDataset() != null);
        this.toggleDatasetUsage(this.itemData.getDataset() != null);
    }

    private void createElementsTab(TabFolder parentTFolder) {
        TabItem elementsTab = new TabItem(parentTFolder, 0);
        Composite container = new Composite((Composite)parentTFolder, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        elementsTab.setControl((Control)container);
        elementsTab.setText(Messages.CVItemDataDialog_ItemsTab);
        this.itemsTV = new TableViewer(container, 2564);
        this.itemsTV.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.lblProv = new NumberedLabelProvider(Messages.CVItemDataDialog_LblProviderPrefix);
        this.itemsTV.setLabelProvider((IBaseLabelProvider)this.lblProv);
        this.itemsTV.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.itemsTV.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CVItemDataDialog.this.modifyItemBtnPressed();
            }
        });
        this.btnAddItem = new Button(container, 8);
        this.btnAddItem.setText(Messages.CVItemDataDialog_Add);
        this.btnAddItem.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnAddItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVItemDataDialog.this.addNewItemBtnPressed();
            }
        });
        this.btnModifyItem = new Button(container, 8);
        this.btnModifyItem.setText(Messages.CVItemDataDialog_Edit);
        this.btnModifyItem.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnModifyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVItemDataDialog.this.modifyItemBtnPressed();
            }
        });
        this.btnRemoveItem = new Button(container, 8);
        this.btnRemoveItem.setText(Messages.CVItemDataDialog_Remove);
        this.btnRemoveItem.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnRemoveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVItemDataDialog.this.removeItemBtnPressed();
            }
        });
        this.refreshItemsViewer();
    }

    private void addNewItemBtnPressed() {
        CVItemDialog d = new CVItemDialog(UIUtils.getShell(), null);
        d.setExpressionContext(this.getExpressionContextFromDSRun());
        if (d.open() == 0) {
            Item CVItem = d.getCVItem();
            this.itemData.addItem(CVItem);
            this.refreshItemsViewer();
        }
    }

    private void modifyItemBtnPressed() {
        Item i = this.getCurrentSelectedItem();
        if (i != null) {
            CVItemDialog d = new CVItemDialog(UIUtils.getShell(), (Item)((StandardItem)i.clone()));
            d.setExpressionContext(this.getExpressionContextFromDSRun());
            if (d.open() == 0) {
                Item CVItem = d.getCVItem();
                int indexOf = this.itemData.getItems().indexOf(i);
                this.itemData.getItems().remove(indexOf);
                this.itemData.getItems().add(indexOf, CVItem);
                this.refreshItemsViewer();
            }
        }
    }

    private void removeItemBtnPressed() {
        Item i = this.getCurrentSelectedItem();
        if (i != null) {
            this.itemData.getItems().remove(i);
            this.refreshItemsViewer();
        }
    }

    private Item getCurrentSelectedItem() {
        Object selEl = ((IStructuredSelection)this.itemsTV.getSelection()).getFirstElement();
        if (selEl instanceof Item) {
            return (Item)selEl;
        }
        return null;
    }

    private void refreshItemsViewer() {
        this.lblProv.resetIndex();
        this.itemsTV.setInput((Object)this.itemData.getItems());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CVItemDataDialog_Title);
        UIUtils.resizeAndCenterShell((Shell)newShell, (int)600, (int)600);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    public void setDefaultExpressionContext(ExpressionContext expContext) {
        this.defaultExpressionContext = expContext;
    }

    private ExpressionContext getExpressionContextFromDSRun() {
        if (this.dataset != null) {
            JRDesignDataset ds = ModelUtils.getDesignDatasetForDatasetRun((JasperDesign)this.jconfig.getJasperDesign(), (JRDatasetRun)this.dataset.getDatasetRun());
            return new ExpressionContext(ds, this.jconfig);
        }
        return null;
    }

    public ItemData getCVItemData() {
        this.itemData.setDataset((JRElementDataset)this.dataset);
        return this.itemData;
    }

    private void toggleDatasetUsage(boolean selection) {
        if (selection) {
            this.dataset = new JRDesignElementDataset();
            ((GridData)this.compositeDatasetInfo.getLayoutData()).exclude = false;
            this.compositeDatasetInfo.setVisible(true);
            this.compositeDatasetInfo.setEnabled(true);
        } else {
            this.compositeDatasetInfo.setEnabled(false);
            this.compositeDatasetInfo.setVisible(false);
            ((GridData)this.compositeDatasetInfo.getLayoutData()).exclude = true;
            this.dataset = null;
        }
        this.compositeDatasetInfo.getParent().layout();
    }
}

